#ifndef _KVI_KVS_TREENODE_INSTRUCTIONBLOCK_H_
#define _KVI_KVS_TREENODE_INSTRUCTIONBLOCK_H_
//=============================================================================
//
//   File : kvi_kvs_treenode_instructionblock.h
//   Creation date : Thu 09 Oct 2003 01:44:31 by Szymon Stefanek
//
//   This file is part of the KVIrc IRC client distribution
//   Copyright (C) 2003-2008 Szymon Stefanek <pragma at kvirc dot net>
//
//   This program is FREE software. You can redistribute it and/or
//   modify it under the terms of the GNU General Public License
//   as published by the Free Software Foundation; either version 2
//   of the License, or (at your opinion) any later version.
//
//   This program is distributed in the HOPE that it will be USEFUL,
//   but WITHOUT ANY WARRANTY; without even the implied warranty of
//   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
//   See the GNU General Public License for more details.
//
//   You should have received a copy of the GNU General Public License
//   along with this program. If not, write to the Free Software Foundation,
//   Inc. ,59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//
//=============================================================================

#include "kvi_settings.h"
#include "kvi_qstring.h"
#include "kvi_pointerlist.h"

#include "kvi_kvs_treenode_instruction.h"

class KviKvsRunTimeContext;


class KVIRC_API KviKvsTreeNodeInstructionBlock : public KviKvsTreeNodeInstruction
{
public:
	KviKvsTreeNodeInstructionBlock(const QChar * pLocation);
	~KviKvsTreeNodeInstructionBlock();
protected:
	KviPointerList<KviKvsTreeNodeInstruction> * m_pInstructionList;
public:
	unsigned int instructionCount(){ return m_pInstructionList->count(); };
	void addInstruction(KviKvsTreeNodeInstruction * i);
	KviKvsTreeNodeInstruction * releaseFirst();
	virtual void contextDescription(QString &szBuffer);
	virtual void dump(const char * prefix);
	
	virtual bool execute(KviKvsRunTimeContext * c);
	
};


#endif //!_KVI_KVS_TREENODE_INSTRUCTIONBLOCK_H_
