/***************************************************************************
*   Copyright (C) 2004 by Christoph Thielecke                             *
*   crissi99@gmx.de                                                       *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
*                                                                         *
*   This program is distributed in the hope that it will be useful,       *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
*   GNU General Public License for more details.                          *
*                                                                         *
*   You should have received a copy of the GNU General Public License     *
*   along with this program; if not, write to the                         *
*   Free Software Foundation, Inc.,                                       *
*   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
***************************************************************************/
//BEGIN INCLUDES
#include "networkinterface.h"
#include <iostream>
#include <qfile.h>
#include <qtextstream.h>
#include <kmessagebox.h>
#include <klocale.h>
#include <kglobal.h>
#include <kstddirs.h>
#include <qnetwork.h>
#include <qurloperator.h>
#include <kmessagebox.h>
//END INCLUDES

NetworkInterface::NetworkInterface( KVpncConfig* config,QApplication *app, QObject *parent, const char *name ) : QObject( parent, name )
{

	this->app = app;
	interfaceTest = false;
	retrieveAllNetworkInterfaces = false;
	retrieveInterfaceIP = false;
	retrieveInterfaceAddress = false;
	retrieveDefaultInterface = false;
	retrieveGatewayOfDefaultInterface=false;
	retrieveGatewayOfInterface=false;
	QPtrList<QString>*InterfaceList = new QPtrList<QString>();
	InterfaceList->setAutoDelete( TRUE ); // the list owns the objects
	QString InterfaceIP = "";
	QString InterfaceAddress = "";
	IPforInterface = "";
	tmpInterface = "";
	interfaceExists = false;
	defaultinterface="default";
	readOutput=false;
	env = new QStringList();
	*env << "LC_ALL=C" << "LANG=C";
	this->config = config;
}

NetworkInterface::~NetworkInterface()
{
	//delete proc;
	if (defaultinterface == "default")
		defaultinterface == "";
}

bool NetworkInterface::interfaceExist( QString Interface )
{
	if ( !Interface.isEmpty() )
	{

		proc = new QProcess (this);
		proc->addArgument( config->pathToIfconfig );
		proc->addArgument( Interface );

		connect( proc, SIGNAL( readyReadStdout() ), this, SLOT( readFromStdout() ) );
		connect( proc, SIGNAL( readyReadStderr() ), this, SLOT( readFromStderr() ) );
		connect( proc, SIGNAL( processExited () ), this, SLOT( processHasFinished() ) );

		interfaceTest = true;

		if ( !proc->start() )
		{
			config->appendLogEntry(i18n("unable to start proc (%1)!").arg("ifconfig"), KVpncConfig::error);
		}
	}
	while ( interfaceTest == true && proc->isRunning() )
		app->processEvents();

	disconnect( proc, SIGNAL( readyReadStdout() ), this, SLOT( readFromStdout() ) );
	disconnect( proc, SIGNAL( readyReadStderr() ), this, SLOT( readFromStderr() ) );
	disconnect( proc, SIGNAL( processExited () ), this, SLOT( processHasFinished() ) );
	//delete proc;
	return interfaceExists;
}

QStringList NetworkInterface::getAllNetworkInterfaces()
{

	proc = new QProcess(this);
	proc->addArgument( config->pathToIfconfig );

	retrieveAllNetworkInterfaces = true;

	connect( proc, SIGNAL( readyReadStdout() ), this, SLOT( readFromStdout() ) );
	connect( proc, SIGNAL( readyReadStderr() ), this, SLOT( readFromStderr() ) );
	connect( proc, SIGNAL( processExited () ), this, SLOT( processHasFinished() ) );

	if ( !proc->start() )
	{
		config->appendLogEntry(i18n("unable to start proc (%1)!").arg("ifconfig"), KVpncConfig::error);
	}

	while ( retrieveAllNetworkInterfaces && proc->isRunning() )
		app->processEvents();


	disconnect( proc, SIGNAL( readyReadStdout() ), this, SLOT( readFromStdout() ) );
	disconnect( proc, SIGNAL( readyReadStderr() ), this, SLOT( readFromStderr() ) );
	disconnect( proc, SIGNAL( processExited () ), this, SLOT( processHasFinished() ) );
	//delete proc;
	return InterfaceList;
}

QString NetworkInterface::getInterfaceIP( QString Interface )
{
	if ( !Interface.isEmpty() )
	{
		tmpfile = new KTempFile();

		QString tmpPath = locateLocal ( "data", "kvpnc/" );
		QString GetInterfaceIpScript = tmpPath + "get_interface_ip_"+Interface+".sh";

		QFile file ( GetInterfaceIpScript );
		QTextStream stream( &file );
		if ( file.open( IO_WriteOnly ) )
		{
			stream << "# generated by kvpnc. Do not edit it." << "\n";
			stream << "\n";
			stream << config->pathToIfconfig +" | grep -A1 "+Interface+" | tail -n1| awk {'print $2'} | sed -e \"s/.*://\" > "+ tmpfile->name()+"\n";
			file.close();
		}


		proc = new QProcess(this);
		proc->addArgument( "/bin/sh" );
		proc->addArgument(GetInterfaceIpScript);

		retrieveInterfaceIP=true;
		readOutput=true;

		// 	connect( proc, SIGNAL( readyReadStdout() ), this, SLOT( readFromStdout() ) );
		// 	connect( proc, SIGNAL( readyReadStderr() ), this, SLOT( readFromStderr() ) );
		connect( proc, SIGNAL( processExited () ), this, SLOT( processHasFinished() ) );

		if ( !proc->start(env) )
		{
			config->appendLogEntry(i18n("unable to start proc (%1)!").arg(i18n("script for getting IP address from interface")), KVpncConfig::error);
		}
	}
	while ( retrieveInterfaceIP && proc->isRunning() )
		app->processEvents();

	while ( readOutput)
		app->processEvents();

	// 	disconnect( proc, SIGNAL( readyReadStdout() ), this, SLOT( readFromStdout() ) );
	// 	disconnect( proc, SIGNAL( readyReadStderr() ), this, SLOT( readFromStderr() ) );
	//disconnect( proc, SIGNAL( processExited () ), this, SLOT( processHasFinished() ) );
	//delete proc;
	return InterfaceIP;
}

QString NetworkInterface::getInterfaceAddress( QString IPforInterface )
{
	// TODO fixme
	if ( !IPforInterface.isEmpty() )
	{
		this->IPforInterface = IPforInterface;
		QStringList devlist = getAllNetworkInterfaces();
		tmpfile = new KTempFile();
		QString tmpPath = locateLocal ( "data", "kvpnc/" );
		QString GetIpForInterfaceScript = tmpPath + "get_interface_for_ip_"+IPforInterface+".sh";

		QFile file ( GetIpForInterfaceScript );
		QTextStream stream( &file );
		if ( file.open( IO_WriteOnly ) )
		{
			stream << "# generated by kvpnc. Do not edit it." << "\n";
			stream << "\n";
			stream << config->pathToIfconfig +" | grep -B1 "+IPforInterface+" | head -n1 |awk {'print $1'} > "+ tmpfile->name()+"\n";
			file.close();
		}


		proc = new QProcess(this);
		proc->addArgument( "/bin/sh" );
		proc->addArgument(GetIpForInterfaceScript);
		retrieveInterfaceAddress=true;
		readOutput=true;

		//connect( proc, SIGNAL( readyReadStdout() ), this, SLOT( readFromStdout() ) );
		///	connect( proc, SIGNAL( readyReadStderr() ), this, SLOT( readFromStderr() ) );
		connect( proc, SIGNAL( processExited () ), this, SLOT( processHasFinished() ) );


		if ( !proc->start(env) )
		{
			config->appendLogEntry(i18n("unable to start proc (%1)!").arg(i18n("script for get interface from IP address")), KVpncConfig::error);
		}
	}
	while ( retrieveInterfaceAddress == true && proc->isRunning() )
		app->processEvents();

	while ( readOutput)
		app->processEvents();

	// 		disconnect( proc, SIGNAL( readyReadStdout() ), this, SLOT( readFromStdout() ) );
	// 		disconnect( proc, SIGNAL( readyReadStderr() ), this, SLOT( readFromStderr() ) );
	disconnect( proc, SIGNAL( processExited () ), this, SLOT( processHasFinished() ) );
	//delete proc;
	return InterfaceAddress;

}

QString NetworkInterface::getDefaultInterface()
{
	
	tmpfile = new KTempFile();
	
	QString tmpPath = locateLocal ( "data", "kvpnc/" );

	QString GetDefaultInterfaceScript = tmpPath+ "get_defaultinterface.sh";

	QFile file ( GetDefaultInterfaceScript );
	QTextStream stream( &file );
	if ( file.open( IO_WriteOnly ) )
	{
		stream << "# generated by kvpnc. Do not edit it." << "\n";
		stream << "\n";
		stream << config->pathToRoute +" -n | grep UG | grep '0.0.0.0*.*.*.' | awk {'print $8'} > "+ tmpfile->name()+"\n";
		file.close();
	}

	retrieveDefaultInterface = true;
	readOutput=true;

	proc = new QProcess(this);
	proc->addArgument( "/bin/sh" );
	proc->addArgument(GetDefaultInterfaceScript);


	// 	connect( proc, SIGNAL( readyReadStdout() ), this, SLOT( readFromStdout() ) );
	// 	connect( proc, SIGNAL( readyReadStderr() ), this, SLOT( readFromStderr() ) );
	connect( proc, SIGNAL( processExited () ), this, SLOT( processHasFinished() ) );

	if ( !proc->start(env) )
	{
		config->appendLogEntry(i18n("unable to start proc (%1)!").arg(i18n("script for getting interface to which default route points")), KVpncConfig::error);
		//KMessageBox::information( 0,i18n("unable to start process (%1)!").arg(QString("route "+i18n("defaultinterface")+")")),i18n("Start Failed"));
		return "none";
	}
	else
	{
		//std::cout << "getDefaultInterface() started." << std::endl;
		while ( proc->isRunning() || readOutput)
		{
			app->processEvents();
		}
		
		// 		disconnect( proc, SIGNAL( readyReadStdout() ), this, SLOT( readFromStdout() ) );
		// 		disconnect( proc, SIGNAL( readyReadStderr() ), this, SLOT( readFromStderr() ) );
		disconnect( proc, SIGNAL( processExited () ), this, SLOT( processHasFinished() ) );
		//		delete proc;

		defaultinterface=defaultinterface.stripWhiteSpace();

		// special case: 2 or more default routes gives multiple line of interfaces
		if (defaultinterface !="" && defaultinterface.find('\n') > -1 )
		{
	
			config->appendLogEntry(i18n("2 or more default routes found! This is wrong and must be fixed."), KVpncConfig::error);

			// try to fix that
			tmpfile->unlink();
			tmpfile = new KTempFile();
			//QString firstdefaultinterface=defaultinterface.left(defaultinterface.find("\n")+1).stripWhiteSpace(); // eth0\neth1 -> eth0
			QString firstdefaultinterface=defaultinterface.section('\n',0,0); // eth0 eth1 -> eth0
			//config->appendLogEntry(QString("firstdefaultinterface: "+firstdefaultinterface), KVpncConfig::debug);
			QString firstgateway=getGatewayOfDefaultInterface(firstdefaultinterface);
			config->appendLogEntry(QString("firstgateway: "+firstgateway), KVpncConfig::debug);
			QString tmpPath = locateLocal ( "data", "kvpnc/" );
			QString FixDefaultRouteScript = tmpPath+"fixdefaultroutescript.sh";
			file.setName ( FixDefaultRouteScript );
			stream.setDevice( &file );
			if ( file.open( IO_WriteOnly ) )
			{
				stream << "# generated by kvpnc. Do not edit it." << "\n";
				stream << "\n";

				// FIXME we stupidly try to remove default route 4 times: works wrong if more than 4 default routes exist (nearly 0%)
				stream << config->pathToRoute +" del default 2>/dev/null\n";
				stream << config->pathToRoute +" del default 2>/dev/null\n";
				stream << config->pathToRoute +" del default 2>/dev/null\n";
				stream << config->pathToRoute +" del default 2>/dev/null\n";
				stream << config->pathToRoute +" add default gw "+firstgateway+" "+firstdefaultinterface+" 2>/dev/null\n";
				file.close();
			}

			proc = new QProcess(this);
			proc->addArgument( "/bin/sh" );
			proc->addArgument(FixDefaultRouteScript);

			connect( proc, SIGNAL( processExited () ), this, SLOT( processHasFinished() ) );

			if ( !proc->start(env) )
			{
				config->appendLogEntry(i18n("unable to start proc (%1)!").arg(i18n("script for fixing default route")), KVpncConfig::error);
				//KMessageBox::information( 0,i18n("unable to start process (%1)!").arg(QString("route "+i18n("defaultinterface")+")")),i18n("Start Failed"));
				return "none";
			}
			else
			{

				//std::cout << "getDefaultInterface() started." << std::endl;
				config->appendLogEntry(i18n("Try to fix multiple default routes: delete all and add to first interface with gateway to which a default route has pointed. Note: This can be wrong."), KVpncConfig::debug);


				while ( proc->isRunning())
				{
					app->processEvents();
				}
				disconnect( proc, SIGNAL( processExited () ), this, SLOT( processHasFinished() ) );

				defaultinterface=firstdefaultinterface;
			}
		}
	}
	return defaultinterface;
}

QString NetworkInterface::getGatewayOfInterface(QString interface)
{
	QString gateway;
	// TODO fixme
	if ( !interface.isEmpty() )
	{

		tmpfile = new KTempFile();
		QString tmpPath = locateLocal ( "data", "kvpnc/" );
		QString GetGatewayOfInterfaceScript = tmpPath + "get_gateway_of_interface_script_"+interface+".sh";

		QFile file ( GetGatewayOfInterfaceScript );
		QTextStream stream( &file );
		if ( file.open( IO_WriteOnly ) )
		{
			stream << "# generated by kvpnc. Do not edit it." << "\n";
			stream << "\n";
			stream << config->pathToRoute +" -n | grep '"+interface+"' | grep -v 'UG' | grep '0.0.0.0' |  awk {'print $2'} > "+ tmpfile->name()+"\n";
			file.close();
		}


		proc = new QProcess(this);
		proc->addArgument( "/bin/sh" );
		proc->addArgument(GetGatewayOfInterfaceScript);
		retrieveGatewayOfInterface=true;
		readOutput=true;

		//connect( proc, SIGNAL( readyReadStdout() ), this, SLOT( readFromStdout() ) );
		///	connect( proc, SIGNAL( readyReadStderr() ), this, SLOT( readFromStderr() ) );
		connect( proc, SIGNAL( processExited () ), this, SLOT( processHasFinished() ) );


		if ( !proc->start(env) )
		{
			config->appendLogEntry(i18n("unable to start proc (%1)!").arg(i18n("script for get gateway from interface")), KVpncConfig::error);
		}
	}
	while ( retrieveGatewayOfInterface == true && proc->isRunning() )
		app->processEvents();

	while ( readOutput)
		app->processEvents();

	// 		disconnect( proc, SIGNAL( readyReadStdout() ), this, SLOT( readFromStdout() ) );
	// 		disconnect( proc, SIGNAL( readyReadStderr() ), this, SLOT( readFromStderr() ) );
	disconnect( proc, SIGNAL( processExited () ), this, SLOT( processHasFinished() ) );
	//delete proc;

gateway=GatewayAddress;

gateway= gateway.stripWhiteSpace();

	if (gateway == "0.0.0.0")
		gateway="none";

	return gateway;
}

QString NetworkInterface::getGatewayOfDefaultInterface(QString interface)
{
	QString gateway="";
	// TODO fixme
	if ( !interface.isEmpty() )
	{
		tmpfile->unlink();
		tmpfile = new KTempFile();
		QString tmpPath = locateLocal ( "data", "kvpnc/" );
		QString GetGatewayOfDefaultInterfaceScript = tmpPath + "get_gateway_of_default_interface_script_"+interface+".sh";

		QFile file ( GetGatewayOfDefaultInterfaceScript );
		QTextStream stream( &file );
		if ( file.open( IO_WriteOnly ) )
		{
			stream << "# generated by kvpnc. Do not edit it." << "\n";
			stream << "\n";
			stream << config->pathToRoute +" -n | grep '"+interface+"' | grep 'UG' | grep '0.0.0.0' |  awk {'print $2'} > "+ tmpfile->name()+"\n";
			file.close();
		}


		proc = new QProcess(this);
		proc->addArgument( "/bin/sh" );
		proc->addArgument(GetGatewayOfDefaultInterfaceScript);
		retrieveGatewayOfDefaultInterface=true;
		readOutput=true;

		//connect( proc, SIGNAL( readyReadStdout() ), this, SLOT( readFromStdout() ) );
		///	connect( proc, SIGNAL( readyReadStderr() ), this, SLOT( readFromStderr() ) );
		connect( proc, SIGNAL( processExited () ), this, SLOT( processHasFinished() ) );


		if ( !proc->start(env) )
		{
			config->appendLogEntry(i18n("unable to start proc (%1)!").arg(i18n("script for get gateway from default interface")), KVpncConfig::error);
		}
	}
	while ( retrieveGatewayOfDefaultInterface == true && proc->isRunning() )
		app->processEvents();

	while ( readOutput)
		app->processEvents();

	// 		disconnect( proc, SIGNAL( readyReadStdout() ), this, SLOT( readFromStdout() ) );
	// 		disconnect( proc, SIGNAL( readyReadStderr() ), this, SLOT( readFromStderr() ) );
	disconnect( proc, SIGNAL( processExited () ), this, SLOT( processHasFinished() ) );
	//delete proc;

		gateway= GatewayAddress;

		//KMessageBox::information( 0,gateway,"gateway2");
	

	//gateway= gateway.stripWhiteSpace();
	if (gateway.find('\n') > -1)
	{
		//config->appendLogEntry(i18n("2 or more default routes found! This unusual and must be fixed by the administrator."), KVpncConfig::error);


		// try to fix that
		config->appendLogEntry(i18n("Warning: Multiple default routes on a network interface found. KVpnc will use the first one. This can be wrong."), KVpncConfig::debug);
		//gateway=gateway.left(gateway.find("\n")+1).stripWhiteSpace(); // 1.2.3.4\n6.7.8.9 -> 1.2.3.4
			gateway = gateway.section('\n',0,0);
	}

	if (gateway == "0.0.0.0")
		gateway="none";
	return gateway;
}

QString  NetworkInterface::getExternalIpAddress()
{
	qInitNetworkProtocols();
	ExternalIpAddress="";
	getExternalIpAddressRunning=true;
	http = new QHttp();
	connect (http,SIGNAL(readyRead(const QHttpResponseHeader &)), this, SLOT(externalIpDataRecieved(const QHttpResponseHeader &)));

	// FIXME how it could be better?
	http->setHost( "checkip.dyndns.org" );

	http->get
	( "/" );
	while ( getExternalIpAddressRunning )
		app->processEvents();
	return ExternalIpAddress;
}

void NetworkInterface::readFromStdout()
{
	while ( proc->canReadLineStdout() )
	{
		QString line = proc->readLineStdout() ;
		//		QString line = QString(proc->readStdout());


		/*
		example for one interface 
		 
		eth0      Protokoll:Ethernet  Hardware Adresse 00:10:4B:B2:19:00
		          inet Adresse:192.168.0.99  Bcast:192.168.0.255  Maske:255.255.255.0
		          inet6 Adresse: fe80::210:4bff:feb2:1900/64 Gltigkeitsbereich:Verbindung
		          UP BROADCAST NOTRAILERS RUNNING MULTICAST  MTU:1500  Metric:1
		          RX packets:31549 errors:0 dropped:0 overruns:0 frame:0
		          TX packets:34046 errors:0 dropped:0 overruns:0 carrier:0
		          Kollisionen:0 Sendewarteschlangenl�ge:1000
		          RX bytes:11308743 (10.7 Mb)  TX bytes:3701511 (3.5 Mb)
		          Interrupt:10 Basisadresse:0xdc00
		*/

		if ( interfaceTest )
		{
			if ( line.find( "proto", 0 , FALSE ) != -1 )
			{
				interfaceExists = true;
				interfaceTest = false;
			}
		}

		if ( line.find( "proto", 0 , FALSE ) != -1 )
		{

			if ( retrieveAllNetworkInterfaces )
			{
				QString interface = line.simplifyWhiteSpace().section( ' ', 0, 0 ); // eth0
				InterfaceList.append( interface );
				//	std::cout << "dbg: found interface: " << interface << std::endl;
			}


		}

		// 		if ( retrieveInterfaceIP || retrieveInterfaceAddress )
		// 		{
		// 			if ( line.find( "inet a", 0 , FALSE ) != -1 )
		// 			{
		// 				QString interfaceIP = line.simplifyWhiteSpace().section( ' ', 1, 1 ).section( ':', 1, 1 ); // eth0
		// 				//std::cout << "dbg: found interface IP: " << interfaceIP << std::endl;
		// 				if ( retrieveInterfaceIP )
		// 				{
		// 					InterfaceIP = interfaceIP;
		// 					retrieveInterfaceIP = false;
		// 				}
		// 				if ( retrieveInterfaceAddress )
		// 				{
		// 					if ( line.find( "proto", 0 , FALSE ) != -1 )
		// 					{
		// 						if ( IPforInterface == interfaceIP )
		// 						{
		// 							InterfaceAddress = interfaceIP;
		// 							//		std::cout << "dbg: found interface address: " << interfaceIP << std::endl;
		// 							retrieveInterfaceAddress = false;
		// 						}
		// 					}
		// 				}
		// 			}
		// 		}
	}
}

void NetworkInterface::readFromStderr()
{
	//while ( proc->canReadLineStderr() ) {
	//	QString line = proc->readLineStderr() ;
	QString line = QString( proc->readStderr() );

	if ( interfaceTest )
	{
		interfaceExists = false;
		interfaceTest = false;
	}
	//std::cerr << "dbg err: " << line << std::endl;
	//}
}

void NetworkInterface::processHasFinished()
{


	//std::cout << "dbg: processHasFinished():" << proc->exitStatus() << std::endl;;
	if ( retrieveAllNetworkInterfaces )
		retrieveAllNetworkInterfaces = false;


	if ( retrieveInterfaceIP )
	{
		//std::cout << "tmp file: " << tmpfile->name() << std::endl;
		InterfaceIP = QString(tmpfile->file()->readAll()).stripWhiteSpace();
		//KMessageBox::information( 0,this->defaultinterface,"default if");
		//tmpfile->unlink();
	}

	if (retrieveDefaultInterface )
	{
		defaultinterface = QString(tmpfile->file()->readAll()) ;
		tmpfile->unlink();
		retrieveDefaultInterface=false;
	}

	if (retrieveInterfaceAddress )
	{
		//std::cout << "tmp file: " << tmpfile->name() << std::endl;
		InterfaceAddress = QString(tmpfile->file()->readAll()).stripWhiteSpace();
		//KMessageBox::information( 0,this->defaultinterface,"default if");
		tmpfile->unlink();
		retrieveInterfaceAddress=false;
	}

	if (retrieveGatewayOfInterface )
	{
		//std::cout << "tmp file: " << tmpfile->name() << std::endl;
		GatewayAddress = QString(tmpfile->file()->readAll()).stripWhiteSpace();
		//KMessageBox::information( 0,GatewayAddress,"GatewayAddress");
		
		tmpfile->unlink();
		retrieveGatewayOfInterface=false;
	}

	if (retrieveGatewayOfDefaultInterface )
	{
		//std::cout << "tmp file: " << tmpfile->name() << std::endl;
		GatewayAddress = QString(tmpfile->file()->readAll());
		//KMessageBox::information( 0,this->defaultinterface,"default if");
		tmpfile->unlink();
		retrieveGatewayOfDefaultInterface=false;
	}

	readOutput=false;
}

void NetworkInterface::externalIpDataRecieved(const QHttpResponseHeader &)
{
	ExternalIpAddress=QString(http->readAll()).stripWhiteSpace().remove ("Current IP Address: ").stripWhiteSpace();
	getExternalIpAddressRunning=false;
}

#include "networkinterface.moc"
