/***************************************************************************
 *   Copyright (C) 2004 by Christoph Thielecke                             *
 *   crissi99@gmx.de                                                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "profilepptpoptions.h"

#include <qcheckbox.h>
#include <qspinbox.h>
#include <klineedit.h>

ProfilePptpOptions::ProfilePptpOptions(QWidget *parent)
		: ProfilePptpOptionsBase(parent)
{}


ProfilePptpOptions::~ProfilePptpOptions()
{}

void ProfilePptpOptions::useDnsServerToggled(bool)
{
	if ( DnsServerCheckbox->isChecked() )
		DnsServerLineedit->setEnabled( true );
	else
		DnsServerLineedit->setEnabled( false );
}


void ProfilePptpOptions::mtuToggled(bool)
{
	if (MtuCheckbox->isChecked())
		MtuSpinbox->setEnabled(true);
	else
		MtuSpinbox->setEnabled(false);
}

void ProfilePptpOptions::keepDefaultRouteToggled(bool)
{
	if (KeepDefaultRouteCheckBox->isChecked())
	{
		ReplaceDefaultRouteCheckbox->setEnabled(false);
		SetDefaultRouteCheckbox->setEnabled(false);
	}
	else
	{
		ReplaceDefaultRouteCheckbox->setEnabled(true);
		SetDefaultRouteCheckbox->setEnabled(true);
	}
	
}




