/***************************************************************************
*   Copyright (C) 2004 by Christoph Thielecke                             *
*   crissi99@gmx.de                                                       *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
*                                                                         *
*   This program is distributed in the hope that it will be useful,       *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
*   GNU General Public License for more details.                          *
*                                                                         *
*   You should have received a copy of the GNU General Public License     *
*   along with this program; if not, write to the                         *
*   Free Software Foundation, Inc.,                                       *
*   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
***************************************************************************/

// KDE includes
#include <kcmdlineargs.h>
#include <kaboutdata.h>
#include <kmessagebox.h>

#include <klocale.h>
#include <dcopclient.h>

// App includes
#include "kvpnc.h"
static const char *description =
    I18N_NOOP( "KDE frontend for various vpn clients\nCurrently supported protocols:\n-Cisco\n-IPSec (*S/WAN/racoon)\n-PPTP\n-OpenVPN" );

QString currentdate ( "+CVS(" + QDate().currentDate().toString( "yyyyMMdd" ) + QTime().currentTime().toString( "hhmm" ) + ")" );


#define __is_release__

QString versionstring1 = "0.8.7";

#ifdef __is_release__
static const char *VERSION = versionstring1.ascii();
QString version =QString(VERSION);
#else
QString versionstring = versionstring1 + currentdate;
static const char *VERSION = versionstring.ascii() ;
#endif


static KCmdLineOptions options[] =
    {
        // INSERT YOUR COMMANDLINE OPTIONS HERE
        { "openvpnimport <file>", I18N_NOOP( "Import OpenVPN config file" ), 0 },
        { "ciscoimport <file>", I18N_NOOP( "Import Cisco PCF file" ), 0 },
        { ":", I18N_NOOP( "Extra options:" ), 0 },
        KCmdLineLastOption // End of options.
    };

int main( int argc, char *argv[] ) {
	KAboutData aboutData( "kvpnc", I18N_NOOP( "KVpnc" ),
	                      VERSION, description, KAboutData::License_GPL_V2,
	                      I18N_NOOP( "(C) 2005, the KVpnc team" ), 0,
	                      "http://home.gna.org/kvpnc/", "crissi99@gmx.de" );

	aboutData.addAuthor( "Christoph Thielecke", I18N_NOOP( "Developer and maintainer" ), "crissi99@gmx.de" );

	aboutData.addCredit( "KDE Team" , I18N_NOOP( "KDE" ), "" );
	aboutData.addCredit( "KDevelop Team" , I18N_NOOP( "KDevelop" ), "" );
	aboutData.addCredit( "Maurice Massar" , I18N_NOOP( "Vpnc" ), "vpnc@unix-ag.uni-kl.de" );
	aboutData.addCredit( "Witek Strzelczyk", I18N_NOOP( "Polish translation" ), "witek_strzelczyk@go2.pl" );
	aboutData.addCredit( "Tomas Olah" , I18N_NOOP( "Slovak translation" ), "tomas.olah@alert.sk" );
	aboutData.addCredit( "Lapo Luchini" , I18N_NOOP( "Italian translation" ), "lapo@lapo.it" );
	aboutData.addCredit( "Karoly Barcza", I18N_NOOP( "Hungary translation" ), "kbarcza@blackpanther.hu" );
	aboutData.addCredit( "Luk De Ketelaere, Jorgen Kessler" , I18N_NOOP( "Dutch translation" ), "balboy@kvirc.net, jkesseler@home.nl" );
	aboutData.addCredit( "Atanas M." , I18N_NOOP( "Bulgarian translation" ), "bugar@developer.bg" );
	aboutData.addCredit( "Juanjo Avarez Martinez" , I18N_NOOP( "Spanish translation" ), "juanjux@yahoo.es" );
	aboutData.addCredit( "He Shi Jun, Marius Pacha" , I18N_NOOP( "Chinese translation" ), "hax.sfo@gmail.com, marius@matux.de" );
	aboutData.addCredit( "Valeriy Girchenko" , I18N_NOOP( "Russian translation" ), "valeragir@mail.ru" );
	aboutData.addCredit( "Ahinu, Florian Fainelli, Damien Raude-Morvan" , I18N_NOOP( "French translation" ), "ahinu@wanadoo.fr, florian@alphacore.net,drazib@drazzib.com" );
	aboutData.addCredit( "Marc Serra Romero" , I18N_NOOP( "Catalan translation" ), "mad93@majomo.com" );
	aboutData.addCredit( "Buelent SENER" , I18N_NOOP( "Turkish  translation" ), "bsener@inonu.edu.tr" );
	aboutData.addCredit( "Laurent Montel", I18N_NOOP( "Patches" ), "montel@kde.org" );
	aboutData.addCredit( "Peter Kussmann" , I18N_NOOP( "Test environment, OpenVPN testing, new ideas" ), "peter.kussmann@gmx.de" );
	aboutData.addCredit( "D. Klinkenberg" , I18N_NOOP( "Testing PPTP, usebility hints & tests, bug hunting" ), "d.klinkenberg@gmx.net" );
	aboutData.addCredit( "Lenon Kitchens" , I18N_NOOP( "Testing OpenSWAN, bug hunting" ), "lenon@sanctuary.org" );
	aboutData.addCredit( "Fathi Boudra" , I18N_NOOP( "Testing OpenVPN, bug hunting" ), "fboudra@free.fr" );
	aboutData.addCredit( "HAL9000" , I18N_NOOP( "Cisco password decoder" ), "hal9000@evilscientists.de" );
	aboutData.addCredit( "Marcin Prejsnar" , I18N_NOOP( "Testing OpenVPN auth+cert, bug hunting" ), "alex@pronet.pl" );

	KCmdLineArgs::init( argc, argv, &aboutData );
	KCmdLineArgs::addCmdLineOptions( options ); // Add our own options.

	KApplication a;

	// Broken on request from Eric M.
	//  if(a.isRestored()) {
	//    RESTORE(KVpnc);
	//  } else {
	/*
	if (getenv("USER") != "root"){
		KMessageBox::error( 0, I18N_NOOP( "Kvpnc must be started as root!" ) );
		exit(0);
	}
	*/

	// Initialize command line args
	KCmdLineArgs::init( argc, argv, "kvpnc", "kvpnc", description, versionstring1.ascii() );

	// Tell which options are supported
	KCmdLineArgs::addCmdLineOptions( options );

	// Add options from other components
	KApplication::addCmdLineOptions();

	KCmdLineArgs *args = KCmdLineArgs::parsedArgs();



	KVpnc *kvpnc = new KVpnc( &a );
	a.setMainWidget( kvpnc );
	kvpnc->show();
	DCOPClient* dcop = a.dcopClient();
	dcop->attach();
	dcop->registerAs( "kvpnc" );
	dcop->setNotifications( true );
	kvpnc->show();

	if ( args->isSet( "openvpnimport" ) ) {
		QString openvpnimportfile = QString( args->getOption( "openvpnimport" ) );
		kvpnc->importOpenvpnProfileClicked( openvpnimportfile );
	} 
	else if ( args->isSet( "ciscoimport" ) ) {
		QString ciscoimportfile = QString( args->getOption( "ciscoimport" ) );
		kvpnc->importOpenvpnProfileClicked( ciscoimportfile );
	}

	//  }
	int ret = a.exec();
	return ret;
}
