/***************************************************************************
 *   Copyright (C) 2004 by Christoph Thielecke                             *
 *   crissi99@gmx.de                                                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "profilegeneraloptions.h"
#include "advancedsettingsdialog.h"
#include <klocale.h>
#include <qcheckbox.h>
#include <qspinbox.h>
#include <klineedit.h>
#include <kcombobox.h>
#include <knuminput.h>

ProfileGeneralOptions::ProfileGeneralOptions(QWidget *parent, KVpncConfig *GlobalConfig)
		: ProfileGeneralOptionsBase(parent)
{
	this->GlobalConfig = GlobalConfig;
}


ProfileGeneralOptions::~ProfileGeneralOptions()
{}

void ProfileGeneralOptions::advancedSettingsClicked()
{
	if (GlobalConfig->currentProfile ==0)
		return;

	AdvancedSettingsDialog d1(this, i18n("Advanced Settings"),GlobalConfig->currentProfile,GlobalConfig->currentProfile->getConnectionType(), GlobalConfig);

	d1.main->LocalPortCheckbox->setEnabled( false );
	d1.main->IkeGroupCheckbox->setEnabled( false );
	d1.main->PerfectForwardSecrecyCombobox->setEnabled( false );
	d1.main->SingleDesCheckbox->setEnabled( false );
	d1.main->NtDomainNameCheckbox->setEnabled( false );
	d1.main->LocalPortSpinbox->setEnabled( false );
	d1.main->ApplicationVersionLineedit->setEnabled( false );
	d1.main->NtDomainNameLineedit->setEnabled( false );
	d1.main->PerfectForwardSecurityCheckbox->setEnabled( false );
	d1.main->IkeGroupCombobox->setEnabled( false );
	d1.main->ApplicationVersionCheckbox->setEnabled( false );
	d1.main->UseGlobalIpsecSecretCheckbox->setEnabled( false );
	d1.main->IkeGroupCheckbox->setEnabled( false );



	d1.main->UseGlobalIpsecSecretCheckbox->setChecked ( GlobalConfig->currentProfile->getUseGlobalIpsecSecret() );
	d1.main->SingleDesCheckbox->setChecked( GlobalConfig->currentProfile->getUseSpecialRemoteID() );
	d1.main->IkeGroupCheckbox->setChecked ( GlobalConfig->currentProfile->getUseIkeGroup() );

	d1.main->PerfectForwardSecurityCheckbox->setChecked( GlobalConfig->currentProfile->getUsePerfectForwardSecrety() );
	d1.main->NtDomainNameCheckbox->setEnabled ( GlobalConfig->currentProfile->getUseNtDomainName() );
	d1.main->ApplicationVersionCheckbox->setEnabled ( GlobalConfig->currentProfile->getUseApplicationVersion() );
	d1.main->UseGlobalIpsecSecretCheckbox->setEnabled ( GlobalConfig->currentProfile->getUseGlobalIpsecSecret() );

	d1.main->LocalPortSpinbox->setValue( GlobalConfig->currentProfile->getLocalPort() );
	if (!GlobalConfig->currentProfile->getIkeGroup().isEmpty())
		d1.main->IkeGroupCombobox->setCurrentText( GlobalConfig->currentProfile->getIkeGroup() );
	if (!GlobalConfig->currentProfile->getPerfectForwardSecrety().isEmpty())
		d1.main->PerfectForwardSecrecyCombobox->setCurrentText( GlobalConfig->currentProfile->getPerfectForwardSecrety() );
	d1.main->NtDomainNameLineedit->setText( GlobalConfig->currentProfile->getNtDomainName() );
	d1.main->ApplicationVersionLineedit->setText( GlobalConfig->currentProfile->getApplicationVersion() );


	d1.main->NtDomainNameCheckbox->setChecked( GlobalConfig->currentProfile->getUseNtDomainName() );
	d1.main->NtDomainNameLineedit->setText( GlobalConfig->currentProfile->getNtDomainName() );

	if ( GlobalConfig->currentProfile->getUseAdvancedSettings() )
	{
		if (GlobalConfig->currentProfile->connectiontype == VpnAccountData::cisco)
		{
			d1.main->LocalPortCheckbox->setEnabled ( true );
			d1.main->PerfectForwardSecurityCheckbox->setEnabled ( true );
			d1.main->IkeGroupCheckbox->setEnabled( true );
			d1.main->SingleDesCheckbox->setEnabled ( true );
			d1.main->NtDomainNameCheckbox->setEnabled ( true );
			d1.main->ApplicationVersionCheckbox->setEnabled ( true );
			d1.main->UseGlobalIpsecSecretCheckbox->setEnabled ( true );
		}

		else if (GlobalConfig->currentProfile->connectiontype == VpnAccountData::racoon)
		{
			d1.main->LocalPortCheckbox->setEnabled ( true );
			d1.main->PerfectForwardSecurityCheckbox->setEnabled ( true );
			d1.main->IkeGroupCheckbox->setEnabled( true );
			//d1.main->SingleDesCheckbox->setEnabled ( true );
		}

		else if (GlobalConfig->currentProfile->connectiontype == VpnAccountData::pptp)
		{
			d1.main->NtDomainNameCheckbox->setEnabled ( true );
			d1.main->NtDomainNameCheckbox->setEnabled( true );
			//d1.main->NtDomainNameLineedit->setEnabled( true );

			d1.main->IkeGroupCheckbox->setEnabled( true );
			if (!GlobalConfig->currentProfile->getIkeGroup().isEmpty())
				d1.main->IkeGroupCombobox->setCurrentText(GlobalConfig->currentProfile->getIkeGroup());
		}


		d1.main->IkeGroupCheckbox->setChecked ( GlobalConfig->currentProfile->getUseIkeGroup() );

		d1.main->SingleDesCheckbox->setChecked( GlobalConfig->currentProfile->getUseSingleDes() );

		d1.main->IkeGroupCheckbox->setChecked ( GlobalConfig->currentProfile->getUseIkeGroup() );

		d1.main->UseGlobalIpsecSecretCheckbox->setChecked ( GlobalConfig->currentProfile->getUseGlobalIpsecSecret() );

		d1.main->PerfectForwardSecurityCheckbox->setChecked( GlobalConfig->currentProfile->getUsePerfectForwardSecrety() );

		if ( GlobalConfig->currentProfile->getUseNtDomainName() )
		{
			d1.main->NtDomainNameLineedit->setEnabled ( true );
			d1.main->NtDomainNameCheckbox->setChecked( true );
		}

		if ( GlobalConfig->currentProfile->getUseApplicationVersion() )
		{
			d1.main->ApplicationVersionLineedit->setEnabled ( true );
			d1.main->ApplicationVersionCheckbox->setChecked( true );
		}

		if ( GlobalConfig->currentProfile->getUseLocalPort() )
		{
			d1.main->LocalPortSpinbox->setEnabled ( true );
			d1.main->LocalPortCheckbox->setChecked( true );
		}

		d1.main->IkeGroupCombobox->setEnabled (  GlobalConfig->currentProfile->getUseIkeGroup() );


	}

	d1.exec();

	GlobalConfig->saveOptions();
}

void ProfileGeneralOptions::pingIpAfterConnectToggled(bool)
{
	if (PingCheckBox->isChecked())
		PingIPLineEdit->setEnabled(true);
	else
		PingIPLineEdit->setEnabled(false);
}

void ProfileGeneralOptions::useConnectionStatusCheckToggled()
{
	if (UseConnectionStatusCheckCheckBox->isChecked())
	{
		ConnectionStatusCheckIntervalNumInput->setEnabled(true);
		ConnectionStatusSuccessCountNumInput->setEnabled(true);
	}
	else
	{
		ConnectionStatusCheckIntervalNumInput->setEnabled(false);
		ConnectionStatusSuccessCountNumInput->setEnabled(false);
	}

}

void ProfileGeneralOptions::useReconnectDelayToggled(bool)
{
	if (UseReconnectDelayCheckBox->isChecked())
		ReconnectDelayNumInput->setEnabled(true);
	else
		ReconnectDelayNumInput->setEnabled(false);
}

void ProfileGeneralOptions::useReconnectAfterDisconnectToggled(bool)
{
	if (DoReconnectAfterConnectionLostCheckBox->isChecked())
	{
			if (UseReconnectDelayCheckBox->isChecked())
		ReconnectDelayNumInput->setEnabled(true);
	else
		ReconnectDelayNumInput->setEnabled(false);

	UseReconnectDelayCheckBox->setEnabled(true);
	}
	else
	{
		ReconnectDelayNumInput->setEnabled(false);
		UseReconnectDelayCheckBox->setEnabled(false);
	}
}


void ProfileGeneralOptions::mtuToggled(bool)
{
	if (MtuCheckbox->isChecked())
		MtuSpinbox->setEnabled(true);
	else
		MtuSpinbox->setEnabled(false);
}




