/***************************************************************************
*   Copyright (C) 2004 by Christoph Thielecke                             *
*   crissi99@gmx.de                                                       *
*                                                                         *
*   Contains parts of code of the konversation project (konvisettingsdialog.cpp)
*   http://konversation.kde.org/                                         *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
*                                                                         *
*   This program is distributed in the hope that it will be useful,       *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
*   GNU General Public License for more details.                          *
*                                                                         *
*   You should have received a copy of the GNU General Public License     *
*   along with this program; if not, write to the                         *
*   Free Software Foundation, Inc.,                                       *
*   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
***************************************************************************/ 
//BEGIN INCLUDES
#include "preferencesdialog.h"
#include <qtabwidget.h>
#include <qpushbutton.h>
#include <klocale.h>
#include <qcheckbox.h>
#include <kmessagebox.h>
#include <qspinbox.h>
#include <qpixmap.h>
#include <kurlrequester.h>
#include <kcolordialog.h>
#include <kcombobox.h>
#include <qlabel.h>
#include <qstringlist.h>
#include <qcursor.h>
#include <qobjectlist.h>
#include <kiconloader.h>
#include <klineedit.h>
#include <kinputdialog.h>
#include <knuminput.h>
#include <klistview.h>
#include <ktextedit.h>
#include <kpassdlg.h>
#include <qlayout.h>
#include <qhbox.h>
#include <qcursor.h>
#include "networkinterface.h"
#include "utils.h"
#include "importcertificatedialog.h"
#include "newprofiledialog.h"

#include <iostream> 
//END INCLUDES

PreferencesDialog::PreferencesDialog( QWidget *parent, QApplication *app, QTextEdit *LogOutput, KVpncConfig *GlobalConfig, bool showOnlyProfiles ) : KDialogBase ( KDialogBase::TreeList, i18n( "Preferences..." ),
		        KDialogBase::Ok | KDialogBase::Apply | KDialogBase::Cancel | KDialogBase::Help, KDialogBase::Ok,
		        parent, "configdialog" )
{
	//main = new PreferencesDialogBase(this);

	//setMainWidget(main);

	//main->setMinimumSize(main->sizeHint())

	this->AccountList = GlobalConfig->AccountList;
	this->LogOutput = LogOutput;
	this->currentProfile = GlobalConfig->currentProfile;
	this->KvpncDebugLevel = GlobalConfig->KvpncDebugLevel;
	this->app = app;
	this->GlobalConfig = GlobalConfig;

	lastProfileName = "";

	this->showOnlyProfiles = showOnlyProfiles;
	if ( showOnlyProfiles )
	{
		setCaption( i18n( "Manage Profiles" ) );
	}
	setupGui();

	// 	DaemonOptionsWidget->ProgramsInPathcheckBox->setChecked(GlobalConfig->programsInPath);
	// 	programsInPathToggled(GlobalConfig->programsInPath);
	//

	ok_icon = KGlobal::iconLoader() ->loadIcon( "button_ok", KIcon::NoGroup, 16 );
	wrong_icon = KGlobal::iconLoader() ->loadIcon( "button_cancel", KIcon::NoGroup, 16 );

	unfoldTreeList ();
	if ( !showOnlyProfiles )
	{
		DaemonOptionsWidget->RacoonDebugLevelComboBox->clear();
		// 		DaemonOptionsWidget->RacoonDebugLevelComboBox->insertItem( "info" );
		DaemonOptionsWidget->RacoonDebugLevelComboBox->insertItem( "notify" );
		DaemonOptionsWidget->RacoonDebugLevelComboBox->insertItem( "debug" );
		DaemonOptionsWidget->RacoonDebugLevelComboBox->insertItem( "debug2" );

		ProfileRacoonOptionsWidget->HashAlgoComboBox->insertItem("SHA1");
		ProfileRacoonOptionsWidget->HashAlgoComboBox->insertItem("MD5");

		if ( GlobalConfig->PptpDebugLevel == 0 )
			DaemonOptionsWidget->PptpDebugLevelComboBox->setCurrentText( i18n( "low" ) );
		else if ( GlobalConfig->PptpDebugLevel == 1 )
			DaemonOptionsWidget->PptpDebugLevelComboBox->setCurrentText( i18n( "default" ) );
		else if ( GlobalConfig->PptpDebugLevel == 2 )
			DaemonOptionsWidget->PptpDebugLevelComboBox->setCurrentText( i18n( "high" ) );

		DaemonOptionsWidget->DoKillL2tpdIfStillRunningCheckBox->setChecked(GlobalConfig->doKillL2tpdIfStillRunning);
		DaemonOptionsWidget->DoKillRacoonIfStillRunningCheckBox->setChecked(GlobalConfig->doKillRacoonIfStillRunning);

		ToolInfo *VpncInfo = Utils( GlobalConfig ).getToolInfo( GlobalConfig, "vpnc" );

		VpncInfo->collectToolInfo();
		ToolInfo *IpsecInfo = Utils( GlobalConfig ).getToolInfo( GlobalConfig, "ipsec" );
		IpsecInfo->collectToolInfo();
		ToolInfo *RacoonInfo = Utils( GlobalConfig ).getToolInfo( GlobalConfig, "racoon" );
		RacoonInfo->collectToolInfo();
		ToolInfo *PppdInfo = Utils( GlobalConfig ).getToolInfo( GlobalConfig, "pppd" );
		PppdInfo->collectToolInfo();
		ToolInfo *PptpInfo = Utils( GlobalConfig ).getToolInfo( GlobalConfig, "pptp" );
		PptpInfo->collectToolInfo();
		ToolInfo *L2tpdInfo = Utils( GlobalConfig ).getToolInfo( GlobalConfig, "l2tpd" );
		L2tpdInfo->collectToolInfo();

		ToolInfo *OpenvpnInfo = Utils( GlobalConfig ).getToolInfo( GlobalConfig, "openvpn" );
		OpenvpnInfo->collectToolInfo();

		DaemonOptionsWidget->VpncVersionLineEdit->setText( VpncInfo->Version );
		DaemonOptionsWidget->IpsecVersionLineEdit->setText( IpsecInfo->Version );
		DaemonOptionsWidget->RacoonVersionLineEdit->setText( RacoonInfo->Version );
		DaemonOptionsWidget->PppdVersionLineEdit->setText( PppdInfo->Version );
		DaemonOptionsWidget->PptpVersionLineEdit->setText( PptpInfo->Version );
		DaemonOptionsWidget->OpenvpnVersionLineEdit->setText( OpenvpnInfo->Version );
		DaemonOptionsWidget->L2tpdVersionLineEdit->setText( L2tpdInfo->Version );

		if (GlobalConfig->pathToVpnc.isEmpty() && !VpncInfo->PathToExec.isEmpty())
			DaemonOptionsWidget->VpncPathInput->setURL( VpncInfo->PathToExec );
		else
			DaemonOptionsWidget->VpncPathInput->setURL( GlobalConfig->pathToVpnc );

		if (GlobalConfig->pathToFreeswan.isEmpty() && !IpsecInfo->PathToExec.isEmpty())
			DaemonOptionsWidget->FreeswanPathInput->setURL( IpsecInfo->PathToExec );
		else
			DaemonOptionsWidget->FreeswanPathInput->setURL( GlobalConfig->pathToFreeswan );

		if (GlobalConfig->pathToRacoon.isEmpty() && !RacoonInfo->PathToExec.isEmpty())
			DaemonOptionsWidget->RacoonPathInput->setURL( RacoonInfo->PathToExec );
		else
			DaemonOptionsWidget->RacoonPathInput->setURL( GlobalConfig->pathToRacoon );

		if (GlobalConfig->pathToPppd.isEmpty() && !PppdInfo->PathToExec.isEmpty())
			DaemonOptionsWidget->PppdPathInput->setURL( PppdInfo->PathToExec );
		else
			DaemonOptionsWidget->PppdPathInput->setURL( GlobalConfig->pathToPppd );

		if (GlobalConfig->pathToPptp.isEmpty() && !PptpInfo->PathToExec.isEmpty())
			DaemonOptionsWidget->PptpPathInput->setURL( PptpInfo->PathToExec );
		else
			DaemonOptionsWidget->PptpPathInput->setURL( GlobalConfig->pathToPptp );

		if (GlobalConfig->pathToOpenvpn.isEmpty() && !OpenvpnInfo->PathToExec.isEmpty())
			DaemonOptionsWidget->OpenvpnPathInput->setURL( OpenvpnInfo->PathToExec );
		else
			DaemonOptionsWidget->OpenvpnPathInput->setURL( GlobalConfig->pathToOpenvpn );

		if (GlobalConfig->pathToL2tpd.isEmpty() && !L2tpdInfo->PathToExec.isEmpty())
			DaemonOptionsWidget->L2tpdPathInput->setURL( L2tpdInfo->PathToExec );
		else
			DaemonOptionsWidget->L2tpdPathInput->setURL( GlobalConfig->pathToL2tpd );

		if ( VpncInfo->found && QFileInfo( VpncInfo->PathToExec ).isFile() && VpncInfo->found )
			DaemonOptionsWidget->VpncStatePixmapLabel->setPixmap( ok_icon );
		else
			DaemonOptionsWidget->VpncStatePixmapLabel->setPixmap( wrong_icon );
		if ( IpsecInfo->found )
			DaemonOptionsWidget->IpsecStatePixmapLabel->setPixmap( ok_icon );
		else
			DaemonOptionsWidget->IpsecStatePixmapLabel->setPixmap( wrong_icon );
		if ( RacoonInfo->found )
			DaemonOptionsWidget->RacoonStatePixmapLabel->setPixmap( ok_icon );
		else
			DaemonOptionsWidget->RacoonStatePixmapLabel->setPixmap( wrong_icon );
		if ( PppdInfo->found )
			DaemonOptionsWidget->PppdStatePixmapLabel->setPixmap( ok_icon );
		else
			DaemonOptionsWidget->PppdStatePixmapLabel->setPixmap( wrong_icon );
		if ( PptpInfo->found )
			DaemonOptionsWidget->PptpStatePixmapLabel->setPixmap( ok_icon );
		else
			DaemonOptionsWidget->PptpStatePixmapLabel->setPixmap( wrong_icon );
		if ( OpenvpnInfo->found )
			DaemonOptionsWidget->OpenvpnStatePixmapLabel->setPixmap( ok_icon );
		else
			DaemonOptionsWidget->OpenvpnStatePixmapLabel->setPixmap( wrong_icon );
		if ( L2tpdInfo->found )
			DaemonOptionsWidget->L2tpdStatePixmapLabel->setPixmap( ok_icon );
		else
			DaemonOptionsWidget->L2tpdStatePixmapLabel->setPixmap( wrong_icon );

		HelperProgramOptionsWidget->IptablesPathInput->setURL( GlobalConfig->pathToIptables );
		HelperProgramOptionsWidget->OpenSSLPathInput->setURL( GlobalConfig->pathToOpenssl );
		HelperProgramOptionsWidget->KillPathInput->setURL( GlobalConfig->pathToKill );
		HelperProgramOptionsWidget->KillallPathInput->setURL( GlobalConfig->pathToKillall );
		HelperProgramOptionsWidget->PingPathInput->setURL( GlobalConfig->pathToPing );
		HelperProgramOptionsWidget->IpPathInput->setURL( GlobalConfig->pathToIp );
		HelperProgramOptionsWidget->IfconfigPathInput->setURL( GlobalConfig->pathToIfconfig );
		HelperProgramOptionsWidget->RoutePathInput->setURL( GlobalConfig->pathToRoute );
		HelperProgramOptionsWidget->Pkcs11ToolPathInput->setURL( GlobalConfig->pathToPkcs11Tool );

		ToolInfo *OpensslInfo = Utils( GlobalConfig ).getToolInfo( GlobalConfig, "openssl" );
		OpensslInfo->collectToolInfo();
		ToolInfo *IptablesInfo = Utils( GlobalConfig ).getToolInfo( GlobalConfig, "iptables" );
		IptablesInfo->collectToolInfo();
		ToolInfo *KillInfo = Utils( GlobalConfig ).getToolInfo( GlobalConfig, "kill" );
		KillInfo->collectToolInfo();
		ToolInfo *KillallInfo = Utils( GlobalConfig ).getToolInfo( GlobalConfig, "killall" );
		KillallInfo->collectToolInfo();
		ToolInfo *PingInfo = Utils( GlobalConfig ).getToolInfo( GlobalConfig, "ping" );
		PingInfo->collectToolInfo();
		ToolInfo *IpInfo = Utils( GlobalConfig ).getToolInfo( GlobalConfig, "ip" );
		IpInfo->collectToolInfo();
		ToolInfo *IfconfigInfo = Utils( GlobalConfig ).getToolInfo( GlobalConfig, "ifconfig" );
		IfconfigInfo->collectToolInfo();
		ToolInfo *RouteInfo = Utils( GlobalConfig ).getToolInfo( GlobalConfig, "route" );
		RouteInfo->collectToolInfo();
		ToolInfo *Pkcs11ToolInfo = Utils( GlobalConfig ).getToolInfo( GlobalConfig, "pkcs11-tool" );
		Pkcs11ToolInfo->collectToolInfo();

		HelperProgramOptionsWidget->OpensslVersionLineEdit->setText( OpensslInfo->Version );
		HelperProgramOptionsWidget->IptablesVersionLineEdit->setText( IptablesInfo->Version );
		HelperProgramOptionsWidget->KillVersionLineEdit->setText( KillInfo->Version );
		HelperProgramOptionsWidget->KillallVersionLineEdit->setText( KillallInfo->Version );
		HelperProgramOptionsWidget->PingVersionLineEdit->setText( PingInfo->Version );
		HelperProgramOptionsWidget->IpVersionLineEdit->setText( IpInfo->Version );
		HelperProgramOptionsWidget->IfconfigVersionLineEdit->setText( IfconfigInfo->Version );
		HelperProgramOptionsWidget->RouteVersionLineEdit->setText( RouteInfo->Version );
		HelperProgramOptionsWidget->Pkcs11ToolVersionLineEdit->setText( Pkcs11ToolInfo->Version );


		if ( OpensslInfo->found )
			HelperProgramOptionsWidget->OpensslStatePixmapLabel->setPixmap( ok_icon );
		else
			HelperProgramOptionsWidget->OpensslStatePixmapLabel->setPixmap( wrong_icon );
		if ( IptablesInfo->found )
			HelperProgramOptionsWidget->IptablesStatePixmapLabel->setPixmap( ok_icon );
		else
			HelperProgramOptionsWidget->IptablesStatePixmapLabel->setPixmap( wrong_icon );
		if ( KillInfo->found )
			HelperProgramOptionsWidget->KillStatePixmapLabel->setPixmap( ok_icon );
		else
			HelperProgramOptionsWidget->KillStatePixmapLabel->setPixmap( wrong_icon );
		if ( KillallInfo->found )
			HelperProgramOptionsWidget->KillallStatePixmapLabel->setPixmap( ok_icon );
		else
			HelperProgramOptionsWidget->KillallStatePixmapLabel->setPixmap( wrong_icon );
		if ( PingInfo->found )
			HelperProgramOptionsWidget->PingStatePixmapLabel->setPixmap( ok_icon );
		else
			HelperProgramOptionsWidget->PingStatePixmapLabel->setPixmap( wrong_icon );
		if ( IpInfo->found )
			HelperProgramOptionsWidget->IpStatePixmapLabel->setPixmap( ok_icon );
		else
			HelperProgramOptionsWidget->IpStatePixmapLabel->setPixmap( wrong_icon );
		if ( IfconfigInfo->found )
			HelperProgramOptionsWidget->IfconfigStatePixmapLabel->setPixmap( ok_icon );
		else
			HelperProgramOptionsWidget->IfconfigStatePixmapLabel->setPixmap( wrong_icon );
		if ( RouteInfo->found )
			HelperProgramOptionsWidget->RouteStatePixmapLabel->setPixmap( ok_icon );
		else
			HelperProgramOptionsWidget->RouteStatePixmapLabel->setPixmap( wrong_icon );
		if ( Pkcs11ToolInfo->found )
			HelperProgramOptionsWidget->Pkcs11ToolStatePixmapLabel->setPixmap( ok_icon );
		else
			HelperProgramOptionsWidget->Pkcs11ToolStatePixmapLabel->setPixmap( wrong_icon );


		ConnectOptionsWidget->checkMinimizeAfterConnectCheck->setChecked( GlobalConfig->minimizeAfterConnect );
		DebugOptionsWidget->showDebugCheck->setChecked( GlobalConfig->showDebugConsole );
		DebugOptionsWidget->WriteLogCheck->setChecked( GlobalConfig->writeLogFile );
		DebugOptionsWidget->spinKvpncDebugLevel->setValue ( GlobalConfig->KvpncDebugLevel );

		if ( GlobalConfig->RacoonDebugLevel != "notify" || GlobalConfig->RacoonDebugLevel != "debug" || GlobalConfig->RacoonDebugLevel != "debug2" )
			GlobalConfig->RacoonDebugLevel = "notify";

		DaemonOptionsWidget->RacoonDebugLevelComboBox->setCurrentText ( GlobalConfig->RacoonDebugLevel );
		DaemonOptionsWidget->spinVpncDebugLevel->setValue ( GlobalConfig->VpncDebugLevel );
		DaemonOptionsWidget->spinOpenvpnDebugLevel->setValue ( GlobalConfig->OpenvpnDebugLevel - 1 );
		DaemonOptionsWidget->DebugPppdcheckBox->setChecked( GlobalConfig->enableDebugPppd );
		DaemonOptionsWidget->FreeswanVerboseCheckBox->setChecked( GlobalConfig->enableFreeswanVerbose );
		ProfileCiscoOptionsWidget->PeerTimeoutIntNumInput->setValue( GlobalConfig->tryConnectTimeout );
		ConnectOptionsWidget->SilentQuitcheckBox->setChecked( GlobalConfig->useSilentQuit );
		GeneralOptionsWidget->DontQuitOnCloseEventCheckBox->setChecked( GlobalConfig->dontQuitOnCloseEvent );
		GeneralOptionsWidget->HideOnStartupCheckBox->setChecked (GlobalConfig->hideMainWindow);
		GeneralOptionsWidget->useKwalletCheckBox->setChecked( GlobalConfig->useKwallet );
		DaemonOptionsWidget->ProgramsInPathcheckBox->setChecked( GlobalConfig->programsInPath );
		DebugOptionsWidget->KeepConnectionFilesCheckBox->setChecked( GlobalConfig->holdGeneratedScripts );
		LogOptionsWidget->InfoLogLabel->setPaletteBackgroundColor ( GlobalConfig->InfoLogColor );
		LogOptionsWidget->RemoteLogLabel->setPaletteBackgroundColor ( GlobalConfig->RemoteLogColor );
		LogOptionsWidget->ErrorLogLabel->setPaletteBackgroundColor ( GlobalConfig->ErrorLogColor );
		LogOptionsWidget->SuccessLogLabel->setPaletteBackgroundColor ( GlobalConfig->SuccessLogColor );
		LogOptionsWidget->DebugLogLabel->setPaletteBackgroundColor ( GlobalConfig->DebugLogColor );
		LogOptionsWidget->BackgroundLogLabel->setPaletteBackgroundColor ( GlobalConfig->DebugBackgroundcolor );
		LogOptionsWidget->UseColorizedLogOutputcheckBox->setChecked( GlobalConfig->useColorizedLogOutput );
		DaemonOptionsWidget->ShowInterfaceIPinTooltipCheckBox->setChecked( GlobalConfig->showInterfaceIPinTooltip );
		ConnectOptionsWidget->DoAutoConnectCheckBox->setChecked( GlobalConfig->doAutoConnectAtStartup );
		LogOptionsWidget->LogFontSizeSpinBox->setValue( GlobalConfig->LogViewerFontSize );

		bool profileInList = false;
		for ( uint i = 0; i < GlobalConfig->AccountList->count();i++ )
		{
			ConnectOptionsWidget->AutoConnectProfileComboBox->insertItem( GlobalConfig->AccountList->at( i ) ->getName() );
			if ( GlobalConfig->AccountList->at( i ) ->getName() == GlobalConfig->AutoConnectProfile )
			{
				profileInList = true;
			}
		}

		if ( profileInList )
		{
			ConnectOptionsWidget->AutoConnectProfileComboBox->setCurrentText( GlobalConfig->AutoConnectProfile );
		}
		else
		{
			GlobalConfig->doAutoConnectAtStartup = false;
			ConnectOptionsWidget->DoAutoConnectCheckBox->setChecked( GlobalConfig->doAutoConnectAtStartup );
		}
	}
	KDialogBase::adjustSize();

	// TODO read types from list
	ProfileGeneralOptionsWidget->ConnectionTypeComboBox->insertItem( i18n( "Cisco (vpnc)" ), VpnAccountData::cisco );
	ProfileGeneralOptionsWidget->ConnectionTypeComboBox->insertItem( i18n( "IPSec (racoon)" ), VpnAccountData::racoon );
	ProfileGeneralOptionsWidget->ConnectionTypeComboBox->insertItem( i18n( "IPSec (FreeSWAN)" ), VpnAccountData::freeswan );
	ProfileGeneralOptionsWidget->ConnectionTypeComboBox->insertItem( i18n( "PPTP" ), VpnAccountData::pptp );
	ProfileGeneralOptionsWidget->ConnectionTypeComboBox->insertItem( i18n( "OpenVPN" ), VpnAccountData::openvpn );
	ProfileGeneralOptionsWidget->ConnectionTypeComboBox->insertItem( i18n( "L2TP (racoon)" ), VpnAccountData::l2tpd_racoon );
	ProfileGeneralOptionsWidget->ConnectionTypeComboBox->insertItem( i18n( "L2TP (OpenSWAN)" ), VpnAccountData::l2tpd_freeswan );
	//ConnectionTypeComboBox->insertItem( "-", 5 );

	ProfileRacoonOptionsWidget->DHGroupComboBox->insertItem( "modp768" );
	ProfileRacoonOptionsWidget->DHGroupComboBox->insertItem( "modp1024" );
	ProfileRacoonOptionsWidget->DHGroupComboBox->insertItem( "ec2n155" );
	ProfileRacoonOptionsWidget->DHGroupComboBox->insertItem( "ec2n185" );
	ProfileRacoonOptionsWidget->DHGroupComboBox->insertItem( "modp1536" );
	ProfileRacoonOptionsWidget->DHGroupComboBox->insertItem( "modp2048" );
	ProfileRacoonOptionsWidget->DHGroupComboBox->insertItem( "modp3072" );
	ProfileRacoonOptionsWidget->DHGroupComboBox->insertItem( "modp4096" );
	ProfileRacoonOptionsWidget->DHGroupComboBox->insertItem( "modp6144" );
	ProfileRacoonOptionsWidget->DHGroupComboBox->insertItem( "modp8192" );

	QStringList KernelCrypto = Utils( GlobalConfig ).getKernelCrypto();

	//FIXME why this is not in kernel crypto list???
	ProfileRacoonOptionsWidget->EncryptionAlgorithmComboBox->insertItem( "3des" );

	// 	ProfileRacoonOptionsWidget->EncryptionAlgorithmComboBox->insertItem("des" );
	// 	ProfileRacoonOptionsWidget->EncryptionAlgorithmComboBox->insertItem("des_iv64" );
	// 	ProfileRacoonOptionsWidget->EncryptionAlgorithmComboBox->insertItem("des_iv32" );
	// 	ProfileRacoonOptionsWidget->EncryptionAlgorithmComboBox->insertItem("rc5" );
	// 	ProfileRacoonOptionsWidget->EncryptionAlgorithmComboBox->insertItem("rc4" );
	// 	ProfileRacoonOptionsWidget->EncryptionAlgorithmComboBox->insertItem("idea" );
	// 	ProfileRacoonOptionsWidget->EncryptionAlgorithmComboBox->insertItem("3idea" );
	// 	ProfileRacoonOptionsWidget->EncryptionAlgorithmComboBox->insertItem("cast128" );
	// 	ProfileRacoonOptionsWidget->EncryptionAlgorithmComboBox->insertItem("blowfish" );
	// 	ProfileRacoonOptionsWidget->EncryptionAlgorithmComboBox->insertItem("null_enc" );
	// 	ProfileRacoonOptionsWidget->EncryptionAlgorithmComboBox->insertItem("twofish" );
	// 	ProfileRacoonOptionsWidget->EncryptionAlgorithmComboBox->insertItem("rijndael" );
	// 	ProfileRacoonOptionsWidget->EncryptionAlgorithmComboBox->insertItem("aes" );

	for ( QStringList::Iterator it = KernelCrypto.begin(); it != KernelCrypto.end(); ++it )
	{
		ProfileRacoonOptionsWidget->EncryptionAlgorithmComboBox->insertItem( *it );
	}


	ProfileRacoonOptionsWidget->AuthenticationAlgorithmComboBox->insertItem( "des" );
	ProfileRacoonOptionsWidget->AuthenticationAlgorithmComboBox->insertItem( "3des" );
	ProfileRacoonOptionsWidget->AuthenticationAlgorithmComboBox->insertItem( "des_iv64" );
	ProfileRacoonOptionsWidget->AuthenticationAlgorithmComboBox->insertItem( "des_iv32" );
	ProfileRacoonOptionsWidget->AuthenticationAlgorithmComboBox->insertItem( "hmac_md5" );
	ProfileRacoonOptionsWidget->AuthenticationAlgorithmComboBox->insertItem( "hmac_sha1" );
	ProfileRacoonOptionsWidget->AuthenticationAlgorithmComboBox->insertItem( "hmac_sha256" );
	ProfileRacoonOptionsWidget->AuthenticationAlgorithmComboBox->insertItem( "hmac_sha384" );
	ProfileRacoonOptionsWidget->AuthenticationAlgorithmComboBox->insertItem( "hmac_sha512" );
	ProfileRacoonOptionsWidget->AuthenticationAlgorithmComboBox->insertItem( "non_auth" );

	ProfileNetworkHttpProxyOptionsWidget->HttpProxyAuthTypeComboBox->insertItem( "Basic" );
	ProfileNetworkHttpProxyOptionsWidget->HttpProxyAuthTypeComboBox->insertItem( "NTLM" );

	QStringList ciphers = Utils( GlobalConfig ).getOpenvpnCiphers();
	QStringList digests = Utils( GlobalConfig ).getOpenvpnDigests();

	for ( QStringList::Iterator it = ciphers.begin(); it != ciphers.end(); ++it )
	{
		ProfileOpenvpnOptionsWidget->UserdefiniedCipherComboBox->insertItem( *it );
	}

	for ( QStringList::Iterator it = digests.begin(); it != digests.end(); ++it )
	{
		ProfileOpenvpnOptionsWidget->UserdefiniedDigestComboBox->insertItem( *it );
	}

	ProfilePptpOptionsWidget->AuthMethodComboBox->insertItem("chap");
	ProfilePptpOptionsWidget->AuthMethodComboBox->insertItem("pap");

	ProfileNetworkGeneralOptionsWidget->TunnelDeviceTypeComboBox->insertItem("TUN");
	ProfileNetworkGeneralOptionsWidget->TunnelDeviceTypeComboBox->insertItem("TAP");

	profileAddedOrDeleted = false;
	NewProfileName = "";

	// profile data
	VpnAccountData * it;
	if ( !GlobalConfig->AccountList->isEmpty() )
	{
		for ( it = GlobalConfig->AccountList->first(); it; it = GlobalConfig->AccountList->next() )
		{
			if ( it != 0 )
			{
				if ( GlobalConfig->KvpncDebugLevel > 2 )
					GlobalConfig->appendLogEntry( "item found: " + it->getName(), KVpncConfig::debug );

				ProfileGeneralSelector->insertItem( it->getName() );
				ProfileNetworkRouteSelector->insertItem( it->getName() );
				ProfileNetworkGeneralSelector->insertItem( it->getName() );
				ProfileNetworkNatSelector->insertItem( it->getName() );
				ProfileNetworkHttpProxySelector->insertItem( it->getName() );
				ProfileNetworkVirtualIpSelector->insertItem( it->getName() );
				ProfileCertSelector->insertItem( it->getName() );
				ProfileSmartcardSelector->insertItem( it->getName() );
				ProfilePskSelector->insertItem( it->getName() );
				ProfileUserSelector->insertItem( it->getName() );
				ProfileOpenvpnSelector->insertItem( it->getName() );
				ProfilePptpSelector->insertItem( it->getName() );
				ProfileRacoonSelector->insertItem( it->getName() );
				ProfileCiscoSelector->insertItem( it->getName() );
				ProfileCmdExecBeforeConnectSelector->insertItem( it->getName() );
				ProfileCmdExecBeforeDisconnectSelector->insertItem( it->getName() );
				ProfileCmdExecAfterConnectSelector->insertItem( it->getName() );
				ProfileCmdExecAfterDisconnectSelector->insertItem( it->getName() );
			}
		}


		if ( GlobalConfig->currentProfile != 0 )
		{
			// set only if in list of current ciphers
			//		if ( ciphers.contains(GlobalConfig->currentProfile->getUserdefiniedCipher())) {
			if ( !GlobalConfig->currentProfile->getUserdefiniedCipher().isEmpty() )
				ProfileOpenvpnOptionsWidget->UserdefiniedCipherComboBox->setCurrentText( GlobalConfig->currentProfile->getUserdefiniedCipher() );
			else
				ProfileOpenvpnOptionsWidget->UserdefiniedCipherComboBox->setCurrentText( ciphers.first() );
			ProfileOpenvpnOptionsWidget->UseUserdefiniedCipherCheckBox->setChecked( GlobalConfig->currentProfile->getUseUserdefiniedCipher() );
			// 		}
			// 		else
			// 			ProfileOpenvpnOptionsWidget->UseUserdefinedPortCheckBox->setChecked(false);


			ProfileOpenvpnOptionsWidget->UseTlsAuthCheckBox->setChecked( GlobalConfig->currentProfile->getUseTlsAuth() );
			ProfileOpenvpnOptionsWidget->TlsAuthURLRequester->setURL( GlobalConfig->currentProfile->getTlsAuthFile() );

			ProfileOpenvpnOptionsWidget->UseTlsRemoteHostCheckBox->setChecked( GlobalConfig->currentProfile->getUseTlsRemoteHost() );
			ProfileOpenvpnOptionsWidget->TlsRemoteHostLineEdit->setText( GlobalConfig->currentProfile->getTlsRemoteHost() );

			ProfileNetworkHttpProxyOptionsWidget->UseHttpProxyCheckBox->setChecked( GlobalConfig->currentProfile->getUseHttpProxy() );
			ProfileNetworkHttpProxyOptionsWidget->HttpProxyLineEdit->setText( GlobalConfig->currentProfile->getHttpProxy() );
			ProfileNetworkHttpProxyOptionsWidget->HttpProxyTimeoutIntSpinBox->setValue( GlobalConfig->currentProfile->getHttpProxyTimeout() );
			ProfileNetworkHttpProxyOptionsWidget->HttpProxyPortIntNumInput->setValue( GlobalConfig->currentProfile->getHttpProxyPort() );

			if ( GlobalConfig->currentProfile->getHttpProxyAuthType() == "basic" )
				ProfileNetworkHttpProxyOptionsWidget->HttpProxyAuthTypeComboBox->setCurrentText( "Basic" );
			else if ( GlobalConfig->currentProfile->getHttpProxyAuthType() == "ntlm" )
				ProfileNetworkHttpProxyOptionsWidget->HttpProxyAuthTypeComboBox->setCurrentText( "NTLM" );
			else
				ProfileNetworkHttpProxyOptionsWidget->HttpProxyAuthTypeComboBox->setCurrentText( "Basic" );

			ProfileNetworkHttpProxyOptionsWidget->HttpProxyUserLineEdit->setText( GlobalConfig->currentProfile->getHttpProxyUser() );
			ProfileNetworkHttpProxyOptionsWidget->HttpProxyAuthPasswordEdit->setText( GlobalConfig->currentProfile->getHttpProxyPass() );

			ProfileNetworkHttpProxyOptionsWidget->UseHttpProxyAuthCheckBox->setChecked( GlobalConfig->currentProfile->getUseHttpProxyAuth() );

			if ( GlobalConfig->currentProfile->getUseHttpProxyAuth() )
			{
				ProfileNetworkHttpProxyOptionsWidget->UseHttpProxyCheckBox->setEnabled( true );
				ProfileNetworkHttpProxyOptionsWidget->HttpProxyAuthTextLabel->setEnabled( true );
				ProfileNetworkHttpProxyOptionsWidget->HttpProxyAuthTypeComboBox->setEnabled( true );
				ProfileNetworkHttpProxyOptionsWidget->HttpProxyUserTextLabel->setEnabled( true );
				ProfileNetworkHttpProxyOptionsWidget->HttpProxyUserLineEdit->setEnabled( true );
				ProfileNetworkHttpProxyOptionsWidget->HttpProxyPassTextLabel->setEnabled( true );
				ProfileNetworkHttpProxyOptionsWidget->HttpProxyAuthPasswordEdit->setEnabled( true );
			}

			ProfileGeneralSelector->setCurrentText( GlobalConfig->currentProfile->getName() );
			ProfileNetworkRouteSelector->setCurrentText( GlobalConfig->currentProfile->getName() );
			ProfileNetworkGeneralSelector->setCurrentText( GlobalConfig->currentProfile->getName() );
			ProfileNetworkNatSelector->setCurrentText( GlobalConfig->currentProfile->getName() );
			ProfileNetworkHttpProxySelector->setCurrentText( GlobalConfig->currentProfile->getName() );
			ProfileNetworkVirtualIpSelector->setCurrentText( GlobalConfig->currentProfile->getName() );
			ProfileCertSelector->setCurrentText( GlobalConfig->currentProfile->getName() );
			ProfileSmartcardSelector->setCurrentText( GlobalConfig->currentProfile->getName() );
			ProfilePskSelector->setCurrentText( GlobalConfig->currentProfile->getName() );
			ProfileUserSelector->setCurrentText( GlobalConfig->currentProfile->getName() );
			ProfileOpenvpnSelector->setCurrentText( GlobalConfig->currentProfile->getName() );
			ProfilePptpSelector->setCurrentText( GlobalConfig->currentProfile->getName() );
			ProfileRacoonSelector->setCurrentText( GlobalConfig->currentProfile->getName() );
			ProfileCiscoSelector->setCurrentText( GlobalConfig->currentProfile->getName() );
			ProfileCmdExecBeforeConnectSelector->setCurrentText( GlobalConfig->currentProfile->getName() );
			ProfileCmdExecBeforeDisconnectSelector->setCurrentText( GlobalConfig->currentProfile->getName() );
			ProfileCmdExecAfterConnectSelector->setCurrentText( GlobalConfig->currentProfile->getName() );
			ProfileCmdExecAfterDisconnectSelector->setCurrentText( GlobalConfig->currentProfile->getName() );

			ProfileNetworkGeneralOptionsWidget->MtuCheckbox->setChecked( GlobalConfig->currentProfile->getUseMtu() );
			ProfileNetworkGeneralOptionsWidget->MtuSpinbox->setValue( GlobalConfig->currentProfile->getMtu() );

			if ( GlobalConfig->currentProfile->getConnectionType() == VpnAccountData::cisco || GlobalConfig->currentProfile->getConnectionType() == VpnAccountData::pptp ||
					GlobalConfig->currentProfile->getConnectionType() == VpnAccountData::freeswan || GlobalConfig->currentProfile->getConnectionType() == VpnAccountData::l2tpd_freeswan ||
					GlobalConfig->currentProfile->getConnectionType() == VpnAccountData::openvpn )
			{
				ProfileNetworkGeneralOptionsWidget->MtuCheckbox->setEnabled( true );

				if ( GlobalConfig->currentProfile->getUseMtu() )
					ProfileNetworkGeneralOptionsWidget->MtuSpinbox->setEnabled( true );
				else
					ProfileNetworkGeneralOptionsWidget->MtuSpinbox->setEnabled( false );
			}
			else
			{
				ProfileNetworkGeneralOptionsWidget->MtuCheckbox->setEnabled( false );
			}
		}
		else
		{
			// 			ProfileGeneralOptionsWidget->ProfileComboBox->setCurrentText( "" );
			// 			ProfileNetworkRouteOptionsWidget->ProfileComboBox->setCurrentText( "" );
			// 			ProfileNetworkNatOptionsWidget->ProfileComboBox->setCurrentText( "" );
			// 			ProfileNetworkVirtualIpOptionsWidget->ProfileComboBox->setCurrentText( "" );
			// 			ProfileCertPskOptionsWidget->ProfileComboBox->setCurrentText( "" );
			// 			ProfileUserOptionsWidget->ProfileComboBox->setCurrentText( "" );
			// 			ProfileOpenvpnOptionsWidget->ProfileComboBox->setCurrentText( "" );
			// 			ProfilePptpOptionsWidget->ProfileComboBox->setCurrentText( "" );
			// 			ProfileRacoonOptionsWidget->ProfileComboBox->setCurrentText( "" );
			// 			ProfileCiscoOptionsWidget->ProfileComboBox->setCurrentText( "" );
			// 			ProfileCmdExecBeforeConnectOptionsWidget->ProfileComboBox->setCurrentText( "" );
			// 			ProfileCmdExecBeforeDisconnectOptionsWidget->ProfileComboBox->setCurrentText( "" );
			// 			ProfileCmdExecAfterConnectOptionsWidget->ProfileComboBox->setCurrentText( "" );
			// 			ProfileCmdExecAfterDisconnectOptionsWidget->ProfileComboBox->setCurrentText( "" );

			ProfileGeneralOptionsWidget->setEnabled( false );
			ProfileNetworkRouteOptionsWidget->setEnabled( false );
			ProfileNetworkNatOptionsWidget->setEnabled( false );
			ProfileNetworkVirtualIpOptionsWidget->setEnabled( false );
			ProfileCertOptionsWidget->setEnabled( false );
			ProfilePskOptionsWidget->setEnabled( false );
			ProfileUserOptionsWidget->setEnabled( false );
			ProfileOpenvpnOptionsWidget->setEnabled( false );
			ProfilePptpOptionsWidget->setEnabled( false );
			ProfileRacoonOptionsWidget->setEnabled( false );
			ProfileCiscoOptionsWidget->setEnabled( false );
			ProfileCmdExecBeforeConnectOptionsWidget->setEnabled( false );
			ProfileCmdExecBeforeDisconnectOptionsWidget->setEnabled( false );
			ProfileCmdExecAfterConnectOptionsWidget->setEnabled( false );
			ProfileCmdExecAfterDisconnectOptionsWidget->setEnabled( false );
			ProfileGeneralOptionsWidget->NewSessionPushButton->setEnabled( true );

		}
	}
	else
	{
		ProfileGeneralOptionsWidget->AdvancedSettingsPushButton->setEnabled( false );
		ProfileGeneralOptionsWidget->RenameSessionPushButton->setEnabled( false );
		ProfileGeneralOptionsWidget->DeleteSessionPushButton->setEnabled( false );
		ProfileGeneralOptionsWidget->SaveSessionPushButton->setEnabled( false );
	}


	NetworkInterface iface( GlobalConfig, GlobalConfig->appPointer );
	QStringList list = iface.getAllNetworkInterfaces();
	ProfileNetworkGeneralOptionsWidget->NetworkDeviceComboBox->insertItem( "default" );

	// 	// pppd settings
	ProfilePptpOptionsWidget->DnsServerLineedit->setEnabled( false );

	// disabled for now
	ProfileCertOptionsWidget->AllowEmptyPrivateKeyPasswordCheckBox->hide();

	ProfileNetworkVirtualIpOptionsWidget->UseVirtualIPCheckBox->setEnabled( true );
	ProfileNetworkVirtualIpOptionsWidget->RemoteVirtualIpLineEdit->setEnabled( true );
	ProfileNetworkVirtualIpOptionsWidget->LocalVirtualIpEdit->setEnabled( true );
	ProfileNetworkVirtualIpOptionsWidget->LabelRemoteVirtualIp->setEnabled( true );
	ProfileNetworkVirtualIpOptionsWidget->LabelLocalVirtualIp->setEnabled( true );

	for ( QStringList::Iterator it = list.begin(); it != list.end(); ++it )
	{
		ProfileNetworkGeneralOptionsWidget->NetworkDeviceComboBox->insertItem( QString( *it ) );
	}
	ProfileNetworkGeneralOptionsWidget->NetworkDeviceComboBox->setEnabled( true );
	ProfileNetworkGeneralOptionsWidget->LabelNetworkDevice->setEnabled( true );

	if ( GlobalConfig->currentProfile != 0 )
	{
		profileChanged( GlobalConfig->currentProfile->getName() );

	}

	canAccept = true;
	KDialogBase::adjustSize();
}

void PreferencesDialog::setupGui()
{

	setShowIconsInTreeList( true );

	QStringList path;
	path.clear();
	path << i18n( "KVpnc" );
	setFolderIcon ( path, SmallIcon( "application", KIcon::SizeSmall ) );

	path.clear();

	QVBoxLayout *lo;

	if ( !showOnlyProfiles )
	{
		/* called as preferences dialog */

		// General page
		path << i18n( "Application" ) << i18n( "General" );
		QFrame* GeneralFrame = addPage( path, i18n( "General" ), BarIcon( "kvpnc", KIcon::SizeSmall ) );
		lo = new QVBoxLayout( GeneralFrame, 0, KDialog::spacingHint() );
		GeneralOptionsWidget = new ConfigGeneralOptions( GeneralFrame );
		lo->addWidget( GeneralOptionsWidget );

		// 		const QObjectList *GeneralOptionsWidgetList = GeneralOptionsWidget->queryList( "QCheckBox" );
		// 		QObjectListIt it( *GeneralOptionsWidgetList );
		//
		// 		for ( QObject *child = it.current(); it; ++it)
		// 		{
		// // 			std::cout << "name: " << child->name() << std::endl;
		// 			connect(child, SIGNAL(stateChanged(int)), this, SLOT(checkboxStateChanged(int)));
		// 		}

		// Debug
		path.clear();
		path << i18n( "Application" ) << i18n( "Debug" );
		QFrame* DebugFrame = addPage( path, i18n( "Debug" ), BarIcon( "bug", KIcon::SizeSmall ) );
		lo = new QVBoxLayout( DebugFrame );
		lo->setSpacing( KDialog::spacingHint() );
		DebugOptionsWidget = new ConfigDebugOptions( DebugFrame );
		lo->addWidget( DebugOptionsWidget );

		path.clear();
		path << i18n( "Application" ) << i18n( "Connect" );
		QFrame* ConnectFrame = addPage( path, i18n( "Connect" ), BarIcon( "connecting", KIcon::SizeSmall ) );
		lo = new QVBoxLayout( ConnectFrame );
		lo->setSpacing( KDialog::spacingHint() );
		ConnectOptionsWidget = new ConfigConnectOptions( ConnectFrame );
		lo->addWidget( ConnectOptionsWidget );

		path.clear();
		path << i18n( "Application" ) << i18n( "Log" );
		QFrame* LogFrame = addPage( path, i18n( "Log" ), BarIcon( "text_center", KIcon::SizeSmall ) );
		lo = new QVBoxLayout( LogFrame );
		lo->setSpacing( KDialog::spacingHint() );
		LogOptionsWidget = new ConfigLogOptions( LogFrame );
		lo->addWidget( LogOptionsWidget );

		path << i18n( "Programs" );
		setFolderIcon ( path, SmallIcon( "kvpnc", KIcon::SizeSmall ) );

		path.clear();
		path << i18n( "Programs" ) << i18n( "Daemons" );
		DaemonFrame = addVBoxPage( path, i18n( "Daemons" ), BarIcon( "fork", KIcon::SizeSmall ) );
// 		DaemonFrame->resize(DaemonFrame->sizeHint());
// 		lo = new QVBoxLayout( DaemonFrame );
		DaemonScrollView = new QScrollView(DaemonFrame, "daemonscrollview");
		lo = new QVBoxLayout( DaemonScrollView );
		lo->setSpacing( KDialog::spacingHint() );
		lo->addWidget(DaemonScrollView);
		DaemonOptionsWidget = new ConfigDaemonOptions( DaemonScrollView->viewport() );
		DaemonScrollView->addChild(DaemonOptionsWidget);
// 		DaemonOptionsWidget->setFixedSize(520,DaemonOptionsWidget->height());
		DaemonOptionsWidget->setFixedSize(DaemonScrollView->contentsWidth ()-DaemonScrollView->verticalScrollBar()->height()-95,DaemonOptionsWidget->height());

// 		DaemonScrollView->adjustSize();
// 		DaemonOptionsWidget->resize(DaemonOptionsWidget->sizeHint());

// 		DaemonScrollView->resize(sv->sizeHint());
// 		lo->addWidget( DaemonScrollView );
// 		DaemonFrame->adjustSize();
		

		connect( DaemonOptionsWidget->OpenvpnPathInput, SIGNAL( urlSelected( const QString& ) ), this, SLOT( OpenvpnPathChanged( const QString& ) ) );
		connect( DaemonOptionsWidget->FreeswanPathInput, SIGNAL( urlSelected( const QString& ) ), this, SLOT( FreeswanPathChanged( const QString& ) ) );
		connect( DaemonOptionsWidget->PppdPathInput, SIGNAL( urlSelected( const QString& ) ), this, SLOT( PppdPathChanged( const QString& ) ) );
		connect( DaemonOptionsWidget->PptpPathInput, SIGNAL( urlSelected( const QString& ) ), this, SLOT( PptpPathChanged( const QString& ) ) );
		connect( DaemonOptionsWidget->RacoonPathInput, SIGNAL( urlSelected( const QString& ) ), this, SLOT( RacoonPathChanged( const QString& ) ) );
		connect( DaemonOptionsWidget->VpncPathInput, SIGNAL( urlSelected( const QString& ) ), this, SLOT( VpncPathChanged( const QString& ) ) );
		connect( DaemonOptionsWidget->L2tpdPathInput, SIGNAL( urlSelected( const QString& ) ), this, SLOT( L2tpdPathChanged( const QString& ) ) );


		path.clear();
		path << i18n( "Programs" ) << i18n( "Helper Programs" );
		QFrame* HelperProgramFrame = addPage( path, i18n( "Helper Programs" ), BarIcon( "tool", KIcon::SizeSmall ) );
		lo = new QVBoxLayout( HelperProgramFrame );
		lo->setSpacing( KDialog::spacingHint() );
		
		HelperProgramOptionsWidget = new ConfigHelperProgramOptions( HelperProgramFrame );
		lo->addWidget( HelperProgramFrame );

		setTreeListAutoResize( false );
	}

	// Profile page
	path.clear();
	path << i18n( "Profile" );
	setFolderIcon ( path, SmallIcon( "view_icon", KIcon::SizeSmall ) );

	path.clear();
	path << i18n( "Profile" ) << i18n( "General" );
	QFrame* ProfileGeneralOptionsFrame = addPage( path, i18n( "General" ), BarIcon( "application", KIcon::SizeSmall ) );
	lo = new QVBoxLayout( ProfileGeneralOptionsFrame );
	lo->setSpacing( KDialog::spacingHint() );

	QWidget *ProfileGeneralSelectorWidget = new QWidget( ProfileGeneralOptionsFrame );
	QHBoxLayout *ProfileGeneralSelectorLayout = new QHBoxLayout( ProfileGeneralSelectorWidget );
	QLabel *ProfileGeneralSelectorLabel = new QLabel( ProfileGeneralSelectorWidget );
	ProfileGeneralSelectorLabel->setText( i18n( "Profile:" ) );
	ProfileGeneralSelector = new QComboBox( ProfileGeneralSelectorWidget );
	ProfileGeneralSelectorLayout->addWidget( ProfileGeneralSelectorLabel );
	ProfileGeneralSelectorLayout->addWidget( ProfileGeneralSelector );

	ProfileGeneralOptionsWidget = new ProfileGeneralOptions( ProfileGeneralOptionsFrame, GlobalConfig );

	lo->addWidget( ProfileGeneralSelectorWidget );
	lo->addWidget( ProfileGeneralOptionsWidget );
	ProfileGeneralSelector->setEnabled( true );

	path.clear();
	path << i18n( "Profile" ) << i18n( "Authenticate" ) << i18n( "User data" );
	QFrame* ProfileUserOptionsFrame = addPage( path, i18n( "User Data" ), BarIcon( "user", KIcon::SizeSmall ) );
	lo = new QVBoxLayout( ProfileUserOptionsFrame );
	lo->setSpacing( KDialog::spacingHint() );

	QWidget *ProfileUserSelectorWidget = new QWidget( ProfileUserOptionsFrame );
	QHBoxLayout *ProfileUserSelectorLayout = new QHBoxLayout( ProfileUserSelectorWidget );
	QLabel *ProfileUserSelectorLabel = new QLabel( ProfileUserSelectorWidget );
	ProfileUserSelectorLabel->setText( i18n( "Profile:" ) );
	ProfileUserSelector = new QComboBox( ProfileUserSelectorWidget );
	ProfileUserSelectorLayout->addWidget( ProfileUserSelectorLabel );
	ProfileUserSelectorLayout->addWidget( ProfileUserSelector );
	

	ProfileUserOptionsWidget = new ProfileUserOptions( ProfileUserOptionsFrame );
	lo->addWidget( ProfileUserSelectorWidget );
	lo->addWidget( ProfileUserOptionsWidget );
	ProfileUserSelector->setEnabled( true );
	connect(ProfileUserOptionsWidget->NtDomainNameCheckbox, SIGNAL(toggled(bool)), ProfileUserOptionsWidget, SLOT( domainNameToggled(bool) ));

	path.clear();
	path << i18n( "Profile" ) << i18n( "Authenticate" ) << i18n( "Certificate" );
	QFrame* ProfileCertOptionsFrame = addVBoxPage( path, i18n( "Certificate" ), BarIcon( "certimport", KIcon::SizeSmall ) );
	lo = new QVBoxLayout( ProfileCertOptionsFrame );
	lo->setSpacing( KDialog::spacingHint() );
	QWidget *ProfileCertSelectorWidget = new QWidget( ProfileCertOptionsFrame );
	QHBoxLayout *ProfileCertSelectorLayout = new QHBoxLayout( ProfileCertSelectorWidget );
	QLabel *ProfileCertSelectorLabel = new QLabel( ProfileCertSelectorWidget );
	ProfileCertSelectorLabel->setText( i18n( "Profile:" ) );
	ProfileCertSelector = new QComboBox( ProfileCertSelectorWidget );
	ProfileCertSelectorLayout->addWidget( ProfileCertSelectorLabel );
	ProfileCertSelectorLayout->addWidget( ProfileCertSelector );

	ProfileCertOptionsWidget = new ProfileCertOptions( ProfileCertOptionsFrame);
	lo->addWidget( ProfileCertSelectorWidget );
	lo->addWidget( ProfileCertOptionsWidget );
	ProfileCertSelector->setEnabled( true );

	path.clear();
	path << i18n( "Profile" ) << i18n( "Authenticate" ) << i18n( "Smartcard" );
	QFrame* ProfileSmartcardOptionsFrame = addPage( path, i18n( "Smartcard" ), BarIcon( "smartcard", KIcon::SizeSmall ) );
	lo = new QVBoxLayout( ProfileSmartcardOptionsFrame );
	lo->setSpacing( KDialog::spacingHint() );

	QWidget *ProfileSmartcardSelectorWidget = new QWidget( ProfileSmartcardOptionsFrame );
	QHBoxLayout *ProfileSmartcardSelectorLayout = new QHBoxLayout( ProfileSmartcardSelectorWidget );
	QLabel *ProfileSmartcardSelectorLabel = new QLabel( ProfileSmartcardSelectorWidget );
	ProfileSmartcardSelectorLabel->setText( i18n( "Profile:" ) );
	ProfileSmartcardSelector = new QComboBox( ProfileSmartcardSelectorWidget );
	ProfileSmartcardSelectorLayout->addWidget( ProfileSmartcardSelectorLabel );
	ProfileSmartcardSelectorLayout->addWidget( ProfileSmartcardSelector );

	ProfileSmartcardOptionsWidget = new ProfileSmartcardOptions( ProfileSmartcardOptionsFrame );
	lo->addWidget( ProfileSmartcardSelectorWidget );
	lo->addWidget( ProfileSmartcardOptionsWidget );
	ProfileSmartcardSelector->setEnabled( true );
	connect(ProfileSmartcardOptionsWidget->DetectPkcs11SlotsPushButton, SIGNAL(clicked()), this, SLOT(detectPkcs11Slots()));
	connect(ProfileSmartcardOptionsWidget->DetectPkcs11IdPushButton, SIGNAL(clicked()), this, SLOT(detectPkcs11Ids()));

	path.clear();
	path << i18n( "Profile" ) << i18n( "Authenticate" ) << i18n( "PSK" );
	QFrame* ProfilePskOptionsFrame = addPage( path, i18n( "PSK" ), BarIcon( "password", KIcon::SizeSmall ) );
	lo = new QVBoxLayout( ProfilePskOptionsFrame );
	lo->setSpacing( KDialog::spacingHint() );

	QWidget *ProfilePskSelectorWidget = new QWidget( ProfilePskOptionsFrame );
	QHBoxLayout *ProfilePskSelectorLayout = new QHBoxLayout( ProfilePskSelectorWidget );
	QLabel *ProfilePskSelectorLabel = new QLabel( ProfilePskSelectorWidget );
	ProfilePskSelectorLabel->setText( i18n( "Profile:" ) );
	ProfilePskSelector = new QComboBox( ProfilePskSelectorWidget );
	ProfilePskSelectorLayout->addWidget( ProfilePskSelectorLabel );
	ProfilePskSelectorLayout->addWidget( ProfilePskSelector );

	ProfilePskOptionsWidget = new ProfilePskOptions( ProfilePskOptionsFrame );
	lo->addWidget( ProfilePskSelectorWidget );
	lo->addWidget( ProfilePskOptionsWidget );
	ProfilePskSelector->setEnabled( true );

	path.clear();
	path << i18n( "Profile" ) << i18n( "Network" ) << i18n( "General" );
	QFrame* ProfileNetworkGeneralOptionsFrame = addPage( path, i18n( "General" ), BarIcon( "network", KIcon::SizeSmall ) );
	lo = new QVBoxLayout( ProfileNetworkGeneralOptionsFrame );
	lo->setSpacing( KDialog::spacingHint() );

	QWidget *ProfileNetworkGeneralSelectorWidget = new QWidget( ProfileNetworkGeneralOptionsFrame );
	QHBoxLayout *ProfileNetworkGeneralSelectorLayout = new QHBoxLayout( ProfileNetworkGeneralSelectorWidget );
	QLabel *ProfileNetworkGeneralSelectorLabel = new QLabel( ProfileNetworkGeneralSelectorWidget );
	ProfileNetworkGeneralSelectorLabel->setText( i18n( "Profile:" ) );
	ProfileNetworkGeneralSelector = new QComboBox( ProfileNetworkGeneralSelectorWidget );
	ProfileNetworkGeneralSelectorLayout->addWidget( ProfileNetworkGeneralSelectorLabel );
	ProfileNetworkGeneralSelectorLayout->addWidget( ProfileNetworkGeneralSelector );

	ProfileNetworkGeneralOptionsWidget = new ProfileNetworkGeneralOptions( ProfileNetworkGeneralOptionsFrame );

	lo->addWidget( ProfileNetworkGeneralSelectorWidget );
	lo->addWidget( ProfileNetworkGeneralOptionsWidget );
	ProfileNetworkGeneralSelector->setEnabled( true );

	path.clear();
	path << i18n( "Profile" ) << i18n( "Network" ) << i18n( "Routes" );
	QFrame* ProfileNetworkRouteOptionsFrame = addPage( path, i18n( "Routes" ), BarIcon( "route", KIcon::SizeSmall ) );
	lo = new QVBoxLayout( ProfileNetworkRouteOptionsFrame );
	lo->setSpacing( KDialog::spacingHint() );

	QWidget *ProfileNetworkRouteSelectorWidget = new QWidget( ProfileNetworkRouteOptionsFrame );
	QHBoxLayout *ProfileNetworkRouteSelectorLayout = new QHBoxLayout( ProfileNetworkRouteSelectorWidget );
	QLabel *ProfileNetworkRouteSelectorLabel = new QLabel( ProfileNetworkRouteSelectorWidget );
	ProfileNetworkRouteSelectorLabel->setText( i18n( "Profile:" ) );
	ProfileNetworkRouteSelector = new QComboBox( ProfileNetworkRouteSelectorWidget );
	ProfileNetworkRouteSelectorLayout->addWidget( ProfileNetworkRouteSelectorLabel );
	ProfileNetworkRouteSelectorLayout->addWidget( ProfileNetworkRouteSelector );

	ProfileNetworkRouteOptionsWidget = new ProfileNetworkRouteOptions( ProfileNetworkRouteOptionsFrame );

	lo->addWidget( ProfileNetworkRouteSelectorWidget );
	lo->addWidget( ProfileNetworkRouteOptionsWidget );
	ProfileNetworkRouteSelector->setEnabled( true );

	path.clear();
	path << i18n( "Profile" ) << i18n( "Network" ) << i18n( "NAT" );
	QFrame* ProfileNetworkNatOptionsFrame = addPage( path, i18n( "NAT" ), BarIcon( "application", KIcon::SizeSmall ) );
	lo = new QVBoxLayout( ProfileNetworkNatOptionsFrame );
	lo->setSpacing( KDialog::spacingHint() );

	QWidget *ProfileNetworkNatSelectorWidget = new QWidget( ProfileNetworkNatOptionsFrame );
	QHBoxLayout *ProfileNetworkNatSelectorLayout = new QHBoxLayout( ProfileNetworkNatSelectorWidget );
	QLabel *ProfileNetworkNatSelectorLabel = new QLabel( ProfileNetworkNatSelectorWidget );
	ProfileNetworkNatSelectorLabel->setText( i18n( "Profile:" ) );
	ProfileNetworkNatSelector = new QComboBox( ProfileNetworkNatSelectorWidget );
	ProfileNetworkNatSelectorLayout->addWidget( ProfileNetworkNatSelectorLabel );
	ProfileNetworkNatSelectorLayout->addWidget( ProfileNetworkNatSelector );

	ProfileNetworkNatOptionsWidget = new ProfileNetworkNatOptions( ProfileNetworkNatOptionsFrame );

	lo->addWidget( ProfileNetworkNatSelectorWidget );
	lo->addWidget( ProfileNetworkNatOptionsWidget );
	ProfileNetworkNatSelector->setEnabled( true );

	path.clear();
	path << i18n( "Profile" ) << i18n( "Network" ) << i18n( "HTTP proxy" );
	QFrame* ProfileNetworkHttpProxyOptionsFrame = addPage( path, i18n( "HTTP proxy" ), BarIcon( "application", KIcon::SizeSmall ) );
	lo = new QVBoxLayout( ProfileNetworkHttpProxyOptionsFrame );
	lo->setSpacing( KDialog::spacingHint() );

	QWidget *ProfileNetworkHttpProxySelectorWidget = new QWidget( ProfileNetworkHttpProxyOptionsFrame );
	QHBoxLayout *ProfileNetworkHttpProxySelectorLayout = new QHBoxLayout( ProfileNetworkHttpProxySelectorWidget );
	QLabel *ProfileNetworkHttpProxySelectorLabel = new QLabel( ProfileNetworkHttpProxySelectorWidget );
	ProfileNetworkHttpProxySelectorLabel->setText( i18n( "Profile:" ) );
	ProfileNetworkHttpProxySelector = new QComboBox( ProfileNetworkHttpProxySelectorWidget );
	ProfileNetworkHttpProxySelectorLayout->addWidget( ProfileNetworkHttpProxySelectorLabel );
	ProfileNetworkHttpProxySelectorLayout->addWidget( ProfileNetworkHttpProxySelector );

	ProfileNetworkHttpProxyOptionsWidget = new ProfileNetworkHttpProxyOptions( ProfileNetworkHttpProxyOptionsFrame );

	lo->addWidget( ProfileNetworkHttpProxySelectorWidget );
	lo->addWidget( ProfileNetworkHttpProxyOptionsWidget );
	ProfileNetworkHttpProxySelector->setEnabled( true );


	path.clear();
	path << i18n( "Profile" ) << i18n( "Network" ) << i18n( "Virtual IP" );
	QFrame* ProfileNetworkVirtualIpOptionsFrame = addPage( path, i18n( "Virtual IP" ), BarIcon( "application", KIcon::SizeSmall ) );
	lo = new QVBoxLayout( ProfileNetworkVirtualIpOptionsFrame );
	lo->setSpacing( KDialog::spacingHint() );

	QWidget *ProfileNetworkVirtualIpSelectorWidget = new QWidget( ProfileNetworkVirtualIpOptionsFrame );
	QHBoxLayout *ProfileNetworkVirtualIpSelectorLayout = new QHBoxLayout( ProfileNetworkVirtualIpSelectorWidget );
	QLabel *ProfileNetworkVirtualIpSelectorLabel = new QLabel( ProfileNetworkVirtualIpSelectorWidget );
	ProfileNetworkVirtualIpSelectorLabel->setText( i18n( "Profile:" ) );
	ProfileNetworkVirtualIpSelector = new QComboBox( ProfileNetworkVirtualIpSelectorWidget );
	ProfileNetworkVirtualIpSelectorLayout->addWidget( ProfileNetworkVirtualIpSelectorLabel );
	ProfileNetworkVirtualIpSelectorLayout->addWidget( ProfileNetworkVirtualIpSelector );

	ProfileNetworkVirtualIpOptionsWidget = new ProfileNetworkVirtualIpOptions( ProfileNetworkVirtualIpOptionsFrame );

	lo->addWidget( ProfileNetworkVirtualIpSelectorWidget );
	lo->addWidget( ProfileNetworkVirtualIpOptionsWidget );
	ProfileNetworkVirtualIpSelector->setEnabled( true );

	path.clear();
	path << i18n( "Profile" ) << i18n( "Connection specific" ) << i18n( "Cisco" );
	QFrame* ProfileCiscoOptionsFrame = addPage( path, i18n( "Cisco" ), BarIcon( "cisco", KIcon::SizeSmall ) );
	lo = new QVBoxLayout( ProfileCiscoOptionsFrame );
	lo->setSpacing( KDialog::spacingHint() );

	QWidget *ProfileCiscoSelectorWidget = new QWidget( ProfileCiscoOptionsFrame );
	QHBoxLayout *ProfileCiscoSelectorLayout = new QHBoxLayout( ProfileCiscoSelectorWidget );
	QLabel *ProfileCiscoSelectorLabel = new QLabel( ProfileCiscoSelectorWidget );
	ProfileCiscoSelectorLabel->setText( i18n( "Profile:" ) );
	ProfileCiscoSelector = new QComboBox( ProfileCiscoSelectorWidget );
	ProfileCiscoSelectorLayout->addWidget( ProfileCiscoSelectorLabel );
	ProfileCiscoSelectorLayout->addWidget( ProfileCiscoSelector );

	ProfileCiscoOptionsWidget = new ProfileCiscoOptions( ProfileCiscoOptionsFrame );

	lo->addWidget( ProfileCiscoSelectorWidget );
	lo->addWidget( ProfileCiscoOptionsWidget );
	ProfileCiscoSelector->setEnabled( true );
	connect (ProfileCiscoOptionsWidget->LocalPortCheckbox, SIGNAL(toggled(bool)),this, SLOT(localPortToggled(bool)));

	path.clear();
	path << i18n( "Profile" ) << i18n( "Connection specific" ) << i18n( "Racoon/*SWAN" );
	QFrame* ProfileRacoonOptionsFrame = addPage( path, i18n( "Racoon/FreeSWAN (OpenSWAN)" ), BarIcon( "kame", KIcon::SizeSmall ) );
	lo = new QVBoxLayout( ProfileRacoonOptionsFrame );
	lo->setSpacing( KDialog::spacingHint() );

	QWidget *ProfileRacoonSelectorWidget = new QWidget( ProfileRacoonOptionsFrame );
	QHBoxLayout *ProfileRacoonSelectorLayout = new QHBoxLayout( ProfileRacoonSelectorWidget );
	QLabel *ProfileRacoonSelectorLabel = new QLabel( ProfileRacoonSelectorWidget );
	ProfileRacoonSelectorLabel->setText( i18n( "Profile:" ) );
	ProfileRacoonSelector = new QComboBox( ProfileRacoonSelectorWidget );
	ProfileRacoonSelectorLayout->addWidget( ProfileRacoonSelectorLabel );
	ProfileRacoonSelectorLayout->addWidget( ProfileRacoonSelector );

	ProfileRacoonOptionsWidget = new ProfileRacoonOptions( ProfileRacoonOptionsFrame );
	ProfileRacoonOptionsWidget->ExchangeModeComboBox->insertItem( "main", 0 );
	ProfileRacoonOptionsWidget->ExchangeModeComboBox->insertItem( "aggressive", 1 );
	ProfileRacoonOptionsWidget->ExchangeModeComboBox->insertItem( "base", 2 );
	ProfileRacoonOptionsWidget->ExchangeModeComboBox->setCurrentItem( 0 ); // main


	lo->addWidget( ProfileRacoonSelectorWidget );
	lo->addWidget( ProfileRacoonOptionsWidget );
	ProfileRacoonSelector->setEnabled( true );

	path.clear();
	path << i18n( "Profile" ) << i18n( "Connection specific" ) << i18n( "OpenVPN" );
	QFrame* ProfileOpenvpnOptionsFrame = addPage( path, i18n( "OpenVPN" ), BarIcon( "openvpn", KIcon::SizeSmall ) );
	lo = new QVBoxLayout( ProfileOpenvpnOptionsFrame );
	lo->setSpacing( KDialog::spacingHint() );

	QWidget *ProfileOpenvpnSelectorWidget = new QWidget( ProfileOpenvpnOptionsFrame );
	QHBoxLayout *ProfileOpenvpnSelectorLayout = new QHBoxLayout( ProfileOpenvpnSelectorWidget );
	QLabel *ProfileOpenvpnSelectorLabel = new QLabel( ProfileOpenvpnSelectorWidget );
	ProfileOpenvpnSelectorLabel->setText( i18n( "Profile:" ) );
	ProfileOpenvpnSelector = new QComboBox( ProfileOpenvpnSelectorWidget );
	ProfileOpenvpnSelectorLayout->addWidget( ProfileOpenvpnSelectorLabel );
	ProfileOpenvpnSelectorLayout->addWidget( ProfileOpenvpnSelector );

	ProfileOpenvpnOptionsWidget = new ProfileOpenvpnOptions( ProfileOpenvpnOptionsFrame );

	lo->addWidget( ProfileOpenvpnSelectorWidget );
	lo->addWidget( ProfileOpenvpnOptionsWidget );
	ProfileOpenvpnSelector->setEnabled( true );

	path.clear();
	path << i18n( "Profile" ) << i18n( "Connection specific" ) << i18n( "PPTP" );
	QFrame* ProfilePptpOptionsFrame = addPage( path, i18n( "PPTP" ), BarIcon( "application", KIcon::SizeSmall ) );
	lo = new QVBoxLayout( ProfilePptpOptionsFrame );
	lo->setSpacing( KDialog::spacingHint() );

	QWidget *ProfilePptpSelectorWidget = new QWidget( ProfilePptpOptionsFrame );
	QHBoxLayout *ProfilePptpSelectorLayout = new QHBoxLayout( ProfilePptpSelectorWidget );
	QLabel *ProfilePptpSelectorLabel = new QLabel( ProfilePptpSelectorWidget );
	ProfilePptpSelectorLabel->setText( i18n( "Profile:" ) );
	ProfilePptpSelector = new QComboBox( ProfilePptpSelectorWidget );
	ProfilePptpSelectorLayout->addWidget( ProfilePptpSelectorLabel );
	ProfilePptpSelectorLayout->addWidget( ProfilePptpSelector );

	ProfilePptpOptionsWidget = new ProfilePptpOptions( ProfilePptpOptionsFrame );

	lo->addWidget( ProfilePptpSelectorWidget );
	lo->addWidget( ProfilePptpOptionsWidget );
	ProfilePptpSelector->setEnabled( true );

	path.clear();
	path << i18n( "Profile" ) << i18n( "Command Execution" ) << i18n( "Before Connect" );
	QFrame* ProfileCmdExecBeforeConnectOptionsFrame = addPage( path, i18n( "Before Connect" ), BarIcon( "exec", KIcon::SizeSmall ) );
	lo = new QVBoxLayout( ProfileCmdExecBeforeConnectOptionsFrame );
	lo->setSpacing( KDialog::spacingHint() );

	QWidget *ProfileCmdExecBeforeConnectSelectorWidget = new QWidget( ProfileCmdExecBeforeConnectOptionsFrame );
	QHBoxLayout *ProfileCmdExecBeforeConnectSelectorLayout = new QHBoxLayout( ProfileCmdExecBeforeConnectSelectorWidget );
	QLabel *ProfileCmdExecBeforeConnectSelectorLabel = new QLabel( ProfileCmdExecBeforeConnectSelectorWidget );
	ProfileCmdExecBeforeConnectSelectorLabel->setText( i18n( "Profile:" ) );
	ProfileCmdExecBeforeConnectSelector = new QComboBox( ProfileCmdExecBeforeConnectSelectorWidget );
	ProfileCmdExecBeforeConnectSelectorLayout->addWidget( ProfileCmdExecBeforeConnectSelectorLabel );
	ProfileCmdExecBeforeConnectSelectorLayout->addWidget( ProfileCmdExecBeforeConnectSelector );

	ProfileCmdExecBeforeConnectOptionsWidget = new ProfileCmdExecBeforeConnectOptions( ProfileCmdExecBeforeConnectOptionsFrame );

	lo->addWidget( ProfileCmdExecBeforeConnectSelectorWidget );
	lo->addWidget( ProfileCmdExecBeforeConnectOptionsWidget );
	ProfileCmdExecBeforeConnectSelector->setEnabled( true );

	path.clear();
	path << i18n( "Profile" ) << i18n( "Command Execution" ) << i18n( "After Connect" );
	QFrame* ProfileCmdExecAfterConnectOptionsFrame = addPage( path, i18n( "After Connect" ), BarIcon( "exec", KIcon::SizeSmall ) );
	lo = new QVBoxLayout( ProfileCmdExecAfterConnectOptionsFrame );
	lo->setSpacing( KDialog::spacingHint() );

	QWidget *ProfileCmdExecAfterConnectSelectorWidget = new QWidget( ProfileCmdExecAfterConnectOptionsFrame );
	QHBoxLayout *ProfileCmdExecAfterConnectSelectorLayout = new QHBoxLayout( ProfileCmdExecAfterConnectSelectorWidget );
	QLabel *ProfileCmdExecAfterConnectSelectorLabel = new QLabel( ProfileCmdExecAfterConnectSelectorWidget );
	ProfileCmdExecAfterConnectSelectorLabel->setText( i18n( "Profile:" ) );
	ProfileCmdExecAfterConnectSelector = new QComboBox( ProfileCmdExecAfterConnectSelectorWidget );
	ProfileCmdExecAfterConnectSelectorLayout->addWidget( ProfileCmdExecAfterConnectSelectorLabel );
	ProfileCmdExecAfterConnectSelectorLayout->addWidget( ProfileCmdExecAfterConnectSelector );

	ProfileCmdExecAfterConnectOptionsWidget = new ProfileCmdExecAfterConnectOptions( ProfileCmdExecAfterConnectOptionsFrame );
	lo->addWidget( ProfileCmdExecAfterConnectSelectorWidget );
	lo->addWidget( ProfileCmdExecAfterConnectOptionsWidget );
	ProfileCmdExecAfterConnectSelector->setEnabled( true );

	path.clear();
	path << i18n( "Profile" ) << i18n( "Command Execution" ) << i18n( "Before Disconnect" );
	QFrame* ProfileCmdExecBeforeDisconnectOptionsFrame = addPage( path, i18n( "Before Disconnect" ), BarIcon( "exec", KIcon::SizeSmall ) );
	lo = new QVBoxLayout( ProfileCmdExecBeforeDisconnectOptionsFrame );
	lo->setSpacing( KDialog::spacingHint() );

	QWidget *ProfileCmdExecBeforeDisconnectSelectorWidget = new QWidget( ProfileCmdExecBeforeDisconnectOptionsFrame );
	QHBoxLayout *ProfileCmdExecBeforeDisconnectSelectorLayout = new QHBoxLayout( ProfileCmdExecBeforeDisconnectSelectorWidget );
	QLabel *ProfileCmdExecBeforeDisconnectSelectorLabel = new QLabel( ProfileCmdExecBeforeDisconnectSelectorWidget );
	ProfileCmdExecBeforeDisconnectSelectorLabel->setText( i18n( "Profile:" ) );
	ProfileCmdExecBeforeDisconnectSelector = new QComboBox( ProfileCmdExecBeforeDisconnectSelectorWidget );
	ProfileCmdExecBeforeDisconnectSelectorLayout->addWidget( ProfileCmdExecBeforeDisconnectSelectorLabel );
	ProfileCmdExecBeforeDisconnectSelectorLayout->addWidget( ProfileCmdExecBeforeDisconnectSelector );

	ProfileCmdExecBeforeDisconnectOptionsWidget = new ProfileCmdExecBeforeDisconnectOptions( ProfileCmdExecBeforeDisconnectOptionsFrame );
	lo->addWidget( ProfileCmdExecBeforeDisconnectSelectorWidget );
	lo->addWidget( ProfileCmdExecBeforeDisconnectOptionsWidget );
	ProfileCmdExecBeforeDisconnectSelector->setEnabled( true );

	path.clear();
	path << i18n( "Profile" ) << i18n( "Command Execution" ) << i18n( "After Disconnect" );
	QFrame* ProfileCmdExecAfterDisconnectOptionsFrame = addPage( path, i18n( "Command Execute After Disconnect" ), BarIcon( "exec", KIcon::SizeSmall ) );
	lo = new QVBoxLayout( ProfileCmdExecAfterDisconnectOptionsFrame );
	lo->setSpacing( KDialog::spacingHint() );

	QWidget *ProfileCmdExecAfterDisconnectSelectorWidget = new QWidget( ProfileCmdExecAfterDisconnectOptionsFrame );
	QHBoxLayout *ProfileCmdExecAfterDisconnectSelectorLayout = new QHBoxLayout( ProfileCmdExecAfterDisconnectSelectorWidget );
	QLabel *ProfileCmdExecAfterDisconnectSelectorLabel = new QLabel( ProfileCmdExecAfterDisconnectSelectorWidget );
	ProfileCmdExecAfterDisconnectSelectorLabel->setText( i18n( "Profile:" ) );
	ProfileCmdExecAfterDisconnectSelector = new QComboBox( ProfileCmdExecAfterDisconnectSelectorWidget );
	ProfileCmdExecAfterDisconnectSelectorLayout->addWidget( ProfileCmdExecAfterDisconnectSelectorLabel );
	ProfileCmdExecAfterDisconnectSelectorLayout->addWidget( ProfileCmdExecAfterDisconnectSelector );

	ProfileCmdExecAfterDisconnectOptionsWidget = new ProfileCmdExecAfterDisconnectOptions( ProfileCmdExecAfterDisconnectOptionsFrame );
	lo->addWidget( ProfileCmdExecAfterDisconnectSelectorWidget );
	lo->addWidget( ProfileCmdExecAfterDisconnectOptionsWidget );
	ProfileCmdExecAfterDisconnectSelector->setEnabled( true );

// 	resize(QSize(800,600));
// 	setFixedSize(QSize(800,600));
// 	adjustSize();

	if ( !showOnlyProfiles )
	{
// 		DaemonScrollView->adjustSize();	
// 			DaemonScrollView->updateContents();
// 		DaemonOptionsWidget->resize(DaemonOptionsWidget->height(),DaemonScrollView->visibleWidth()-100);
			DaemonOptionsWidget->sizeHint();
	}
// 	CertScrollView->adjustSize();
// 		CertScrollView->updateContents();
// 	ProfileCertOptionsWidget->adjustSize();
// 	adjustSize();
// 	DaemonOptionsWidget->adjustSize();
	

// 	adjustSize();
	// 	enableButtonApply(false);

	/* connect profile combobox of each profile widget */
	connect( ProfileGeneralSelector, SIGNAL( activated ( const QString& ) ), this, SLOT( profileChanged( const QString& ) ) );
	connect( ProfileNetworkRouteSelector, SIGNAL( activated ( const QString& ) ), this, SLOT( profileChanged( const QString& ) ) );
	connect( ProfileNetworkGeneralSelector, SIGNAL( activated ( const QString& ) ), this, SLOT( profileChanged( const QString& ) ) );
	connect( ProfileNetworkNatSelector, SIGNAL( activated ( const QString& ) ), this, SLOT( profileChanged( const QString& ) ) );
	connect( ProfileNetworkHttpProxySelector, SIGNAL( activated ( const QString& ) ), this, SLOT( profileChanged( const QString& ) ) );
	connect( ProfileNetworkVirtualIpSelector, SIGNAL( activated ( const QString& ) ), this, SLOT( profileChanged( const QString& ) ) );
	connect( ProfileCertSelector, SIGNAL( activated ( const QString& ) ), this, SLOT( profileChanged( const QString& ) ) );
	connect( ProfileSmartcardSelector, SIGNAL( activated ( const QString& ) ), this, SLOT( profileChanged( const QString& ) ) );
	connect( ProfilePskSelector, SIGNAL( activated ( const QString& ) ), this, SLOT( profileChanged( const QString& ) ) );
	connect( ProfileUserSelector, SIGNAL( activated ( const QString& ) ), this, SLOT( profileChanged( const QString& ) ) );
	connect( ProfileOpenvpnSelector, SIGNAL( activated ( const QString& ) ), this, SLOT( profileChanged( const QString& ) ) );
	connect( ProfilePptpSelector, SIGNAL( activated ( const QString& ) ), this, SLOT( profileChanged( const QString& ) ) );
	connect( ProfileRacoonSelector, SIGNAL( activated ( const QString& ) ), this, SLOT( profileChanged( const QString& ) ) );
	connect( ProfileCiscoSelector, SIGNAL( activated ( const QString& ) ), this, SLOT( profileChanged( const QString& ) ) );
	connect( ProfileCmdExecBeforeConnectSelector, SIGNAL( activated ( const QString& ) ), this, SLOT( profileChanged( const QString& ) ) );
	connect( ProfileCmdExecBeforeDisconnectSelector, SIGNAL( activated ( const QString& ) ), this, SLOT( profileChanged( const QString& ) ) );
	connect( ProfileCmdExecAfterConnectSelector, SIGNAL( activated ( const QString& ) ), this, SLOT( profileChanged( const QString& ) ) );
	connect( ProfileCmdExecAfterDisconnectSelector, SIGNAL( activated ( const QString& ) ), this, SLOT( profileChanged( const QString& ) ) );

	connect( ProfileOpenvpnOptionsWidget->AuthWithUsernameAndPasswordCheckBox, SIGNAL( toggled ( bool ) ), this, SLOT( userAuthToggled( bool ) ) );

	connect( ProfileCertOptionsWidget->AuthTypeComboBox, SIGNAL( activated ( int ) ), this, SLOT( authTypeChanged( int ) ) );
// 	connect( ProfileCertOptionsWidget->UseSpecialServerSmartcardificateCheckBox, SIGNAL (toggled(bool)), SLOT(useSpecialServerSmartcardificateToggled(bool) ) );
	connect( ProfilePskOptionsWidget->AuthTypeComboBox, SIGNAL( activated ( int ) ), this, SLOT( authTypeChanged( int ) ) );



// 	connect ( ProfileGeneralOptionsWidget->NewSessionPushButton , SIGNAL( clicked () ), this, SLOT( newSessionClicked() ) );
	connect ( ProfileGeneralOptionsWidget->SaveSessionPushButton, SIGNAL( clicked () ), this, SLOT( saveSessionClicked() ) );
	connect ( ProfileGeneralOptionsWidget->RenameSessionPushButton, SIGNAL( clicked () ), this, SLOT( renameSessionClicked() ) );
	connect ( ProfileGeneralOptionsWidget->DeleteSessionPushButton, SIGNAL( clicked () ), this, SLOT( deleteSessionClicked() ) );
	connect ( this, SIGNAL( aboutToShowPage( QWidget * ) ), this, SLOT( pageChanged( QWidget * ) ) );
	connect ( this, SIGNAL( applyClicked () ), this, SLOT( saveSessionClicked() ) );

}

void PreferencesDialog::accept()
{
	//MyprofileWidget->saveSessionClicked();
	if ( !showOnlyProfiles )
	{
		GlobalConfig->pathToVpnc = DaemonOptionsWidget->VpncPathInput->url();
		GlobalConfig->pathToRacoon = DaemonOptionsWidget->RacoonPathInput->url();
		GlobalConfig->pathToIptables = HelperProgramOptionsWidget->IptablesPathInput->url();
		GlobalConfig->pathToOpenssl = HelperProgramOptionsWidget->OpenSSLPathInput->url();
		GlobalConfig->pathToPppd = DaemonOptionsWidget->PppdPathInput->url();
		GlobalConfig->pathToPptp = DaemonOptionsWidget->PptpPathInput->url();
		GlobalConfig->pathToKill = HelperProgramOptionsWidget->KillPathInput->url();
		GlobalConfig->pathToKillall = HelperProgramOptionsWidget->KillallPathInput->url();
		GlobalConfig->pathToPing = HelperProgramOptionsWidget->PingPathInput->url();
		GlobalConfig->pathToOpenvpn = DaemonOptionsWidget->OpenvpnPathInput->url();
		GlobalConfig->pathToFreeswan = DaemonOptionsWidget->FreeswanPathInput->url();
		GlobalConfig->pathToIp = HelperProgramOptionsWidget->IpPathInput->url();
		GlobalConfig->pathToIfconfig = HelperProgramOptionsWidget->IfconfigPathInput->url();
		GlobalConfig->pathToRoute = HelperProgramOptionsWidget->RoutePathInput->url();
		GlobalConfig->pathToPkcs11Tool = HelperProgramOptionsWidget->Pkcs11ToolPathInput->url();
		GlobalConfig->minimizeAfterConnect = ConnectOptionsWidget->checkMinimizeAfterConnectCheck->isChecked();
		GlobalConfig->showDebugConsole = DebugOptionsWidget->showDebugCheck->isChecked();
		GlobalConfig->useSilentQuit = ConnectOptionsWidget->SilentQuitcheckBox->isChecked();
		GlobalConfig->dontQuitOnCloseEvent = GeneralOptionsWidget->DontQuitOnCloseEventCheckBox->isChecked();
		GlobalConfig->useKwallet = GeneralOptionsWidget->useKwalletCheckBox->isChecked();
		GlobalConfig->writeLogFile = DebugOptionsWidget->WriteLogCheck->isChecked();
		GlobalConfig->KvpncDebugLevel = DebugOptionsWidget->spinKvpncDebugLevel->value();
		GlobalConfig->RacoonDebugLevel = DaemonOptionsWidget->RacoonDebugLevelComboBox->currentText();
		GlobalConfig->VpncDebugLevel = DaemonOptionsWidget->spinVpncDebugLevel->value();
		GlobalConfig->OpenvpnDebugLevel = DaemonOptionsWidget->spinOpenvpnDebugLevel->value() + 1;

		if ( DaemonOptionsWidget->PptpDebugLevelComboBox->currentText() == i18n( "low" ) )
			GlobalConfig->PptpDebugLevel = 0;
		else if ( DaemonOptionsWidget->PptpDebugLevelComboBox->currentText() == i18n( "default" ) )
			GlobalConfig->PptpDebugLevel = 1;
		else if ( DaemonOptionsWidget->PptpDebugLevelComboBox->currentText() == i18n( "high" ) )
			GlobalConfig->PptpDebugLevel = 2;

		GlobalConfig->enableDebugPppd = DaemonOptionsWidget->DebugPppdcheckBox->isChecked();
		GlobalConfig->tryConnectTimeout = ProfileCiscoOptionsWidget->PeerTimeoutIntNumInput->value();
		GlobalConfig->programsInPath = DaemonOptionsWidget->ProgramsInPathcheckBox->isChecked();
		GlobalConfig->holdGeneratedScripts = DebugOptionsWidget->KeepConnectionFilesCheckBox->isChecked();
		GlobalConfig->InfoLogColor = LogOptionsWidget->InfoLogLabel->paletteBackgroundColor ();
		GlobalConfig->RemoteLogColor = LogOptionsWidget->RemoteLogLabel->paletteBackgroundColor();
		GlobalConfig->ErrorLogColor = LogOptionsWidget->ErrorLogLabel->paletteBackgroundColor ();
		GlobalConfig->SuccessLogColor = LogOptionsWidget->SuccessLogLabel->paletteBackgroundColor ();
		GlobalConfig->DebugLogColor = LogOptionsWidget->DebugLogLabel->paletteBackgroundColor ();
		GlobalConfig->DebugBackgroundcolor = LogOptionsWidget->BackgroundLogLabel->paletteBackgroundColor ();
		GlobalConfig->useColorizedLogOutput = LogOptionsWidget->UseColorizedLogOutputcheckBox->isChecked();
		GlobalConfig->showInterfaceIPinTooltip = DaemonOptionsWidget->ShowInterfaceIPinTooltipCheckBox->isChecked();
		GlobalConfig->doAutoConnectAtStartup = ConnectOptionsWidget->DoAutoConnectCheckBox->isChecked();
		GlobalConfig->AutoConnectProfile = ConnectOptionsWidget->AutoConnectProfileComboBox->currentText();
		GlobalConfig->LogViewerFontSize = LogOptionsWidget->LogFontSizeSpinBox->value();
	}
	if ( GlobalConfig->currentProfile != 0 && !GlobalConfig->AccountList->isEmpty() )
		saveSessionClicked();


	if ( canAccept )
		QDialog::accept();
}

void PreferencesDialog::slotApply()
{
	saveSessionClicked();
}

PreferencesDialog::~PreferencesDialog()
{
	delete ProfileGeneralSelector;
	delete ProfileNetworkRouteSelector;
	delete ProfileNetworkNatSelector;
	delete ProfileNetworkHttpProxySelector;
	delete ProfileNetworkVirtualIpSelector;
	delete ProfileCertSelector;
	delete ProfileSmartcardSelector;
	delete ProfilePskSelector;
	delete ProfileUserSelector;
	delete ProfileOpenvpnSelector;
	delete ProfilePptpSelector;
	delete ProfileRacoonSelector;
	delete ProfileCiscoSelector;
	delete ProfileCmdExecBeforeConnectSelector;
	delete ProfileCmdExecBeforeDisconnectSelector;
	delete ProfileCmdExecAfterConnectSelector;
	delete ProfileCmdExecAfterDisconnectSelector;
}

void PreferencesDialog::connectionTypeChanged( int type )
{


	if ( GlobalConfig->KvpncDebugLevel > 1 )
		GlobalConfig->appendLogEntry( i18n( "connectionTypeChanged(): %1" ).arg( QString().setNum( type ) ), GlobalConfig->debug );

	// 		KMessageBox::information(0,"connection type changed: "+QString().setNum(type),QString("type set"));

	if ( GlobalConfig->currentProfile == 0 )
		return ;

	GlobalConfig->currentProfile->setConnectionType( ( VpnAccountData::ConnectionType ) ( type ) );

	ProfileGeneralOptionsWidget->DeleteSessionPushButton->setEnabled ( TRUE );
	ProfileGeneralOptionsWidget->NewSessionPushButton->setEnabled ( TRUE );
	ProfileGeneralOptionsWidget->SaveSessionPushButton->setEnabled ( TRUE );

	// First we should set a type
	// 	parent->buttonCancel->setEnabled( FALSE );
	// 	parent->buttonOk->setEnabled( FALSE );
	ProfileGeneralOptionsWidget->AdvancedSettingsPushButton->setEnabled( false );

	if ( GlobalConfig->currentProfile->getConnectionType() == VpnAccountData::cisco )
	{

		if ( GlobalConfig->KvpncDebugLevel > 0 )
			GlobalConfig->appendLogEntry( "new type: cisco", GlobalConfig->debug );

		ProfileCiscoOptionsWidget->IDLineEdit->setEnabled( true );
		ProfileCiscoOptionsWidget->LabelID->setEnabled( true );

		ProfileGeneralOptionsWidget->AdvancedSettingsPushButton->setEnabled( true );

		ProfileNetworkGeneralOptionsWidget->NetworkDeviceComboBox->setEnabled( true );
		ProfileNetworkGeneralOptionsWidget->LabelNetworkDevice->setEnabled( true );
		ProfileNetworkGeneralOptionsWidget->RemoteNetAddrLineEdit->setEnabled( false );
		ProfileNetworkGeneralOptionsWidget->RemoteNetMaskComboBox->setEnabled( false );

		ProfileNetworkNatOptionsWidget->UseUdpCheckbox->setEnabled( true );
		ProfileNetworkNatOptionsWidget->UdpPortCheckbox->setEnabled( true );
		if ( GlobalConfig->currentProfile->getUseUdp() )
			ProfileNetworkNatOptionsWidget->UdpPortCheckbox->setEnabled( true );
		else
			ProfileNetworkNatOptionsWidget->UdpPortCheckbox->setEnabled( false );
		emit authTypeChanged( GlobalConfig->currentProfile->getAuthType() );
	} // vpnc

	else if ( GlobalConfig->currentProfile->getConnectionType() == VpnAccountData::racoon )
	{

		if ( GlobalConfig->KvpncDebugLevel > 0 )
			GlobalConfig->appendLogEntry( i18n( "New type: %1" ).arg( "racoon" ), GlobalConfig->debug );

		ProfileGeneralOptionsWidget->AdvancedSettingsPushButton->setEnabled( true );
	}
	else if ( GlobalConfig->currentProfile->getConnectionType() == VpnAccountData::l2tpd_racoon )
	{

		if ( GlobalConfig->KvpncDebugLevel > 0 )
			GlobalConfig->appendLogEntry( i18n( "New type: %1" ).arg( "l2tpd (racoon)" ), GlobalConfig->debug );

		ProfileGeneralOptionsWidget->AdvancedSettingsPushButton->setEnabled( true );
	}
	else if ( GlobalConfig->currentProfile->getConnectionType() == VpnAccountData::freeswan )
	{

		if ( GlobalConfig->KvpncDebugLevel > 0 )
			GlobalConfig->appendLogEntry( i18n( "New type: %1" ).arg( "freeswan" ), GlobalConfig->debug );
	}
	else if ( GlobalConfig->currentProfile->getConnectionType() == VpnAccountData::l2tpd_freeswan )
	{

		if ( GlobalConfig->KvpncDebugLevel > 0 )
			GlobalConfig->appendLogEntry( i18n( "New type: %1" ).arg( "l2tpd (openswan)" ), GlobalConfig->debug );
	}
	else if ( GlobalConfig->currentProfile->getConnectionType() == VpnAccountData::pptp )
	{

		if ( GlobalConfig->KvpncDebugLevel > 0 )
			GlobalConfig->appendLogEntry( "new type: pptp", GlobalConfig->debug );

		ProfileGeneralOptionsWidget->AdvancedSettingsPushButton->setEnabled( true );

		authTypeChanged( VpnAccountData::pptp );
	} // pptp
	else if ( GlobalConfig->currentProfile->getConnectionType() == VpnAccountData::openvpn )
	{
		if ( GlobalConfig->KvpncDebugLevel > 0 )
			GlobalConfig->appendLogEntry( i18n( "new type: %1" ).arg( "openvpn" ), GlobalConfig->debug );

		ProfileGeneralOptionsWidget->AdvancedSettingsPushButton->setEnabled( false );
		ProfileNetworkGeneralOptionsWidget->RemoteNetAddrLineEdit->setEnabled( false );
		ProfileNetworkGeneralOptionsWidget->LabelRemoteNetwork->setEnabled( false );
		ProfileNetworkGeneralOptionsWidget->RemoteNetMaskComboBox->setEnabled( false );
		ProfileCiscoOptionsWidget->IDLineEdit->setEnabled( false );
		ProfileCiscoOptionsWidget->LabelID->setEnabled( false );
		// 		buttonCancel->setEnabled( TRUE );
		// 		buttonOk->setEnabled( TRUE );

		ProfileNetworkNatOptionsWidget->UseUdpCheckbox->setEnabled( true );
		ProfileNetworkNatOptionsWidget->UdpPortCheckbox->setEnabled( true );
		if ( GlobalConfig->currentProfile->getUseUdp() )
			ProfileNetworkNatOptionsWidget->UdpPortCheckbox->setEnabled( true );
		else
			ProfileNetworkNatOptionsWidget->UdpPortCheckbox->setEnabled( false );

		emit authTypeChanged( GlobalConfig->currentProfile->getAuthType() );
	} // openvpn

	// other
	else if ( GlobalConfig->currentProfile->getConnectionType() == VpnAccountData::other )
	{

		if ( GlobalConfig->KvpncDebugLevel > 0 )
			GlobalConfig->appendLogEntry( i18n( "new type: none specified" ), GlobalConfig->debug );
	}
	else
	{
		GlobalConfig->appendLogEntry( i18n( "unknown type" ), GlobalConfig->debug );
	}

	if ( GlobalConfig->currentProfile->getConnectionType() == VpnAccountData::l2tpd_racoon ||
	        GlobalConfig->currentProfile->getConnectionType() == VpnAccountData::racoon ||
	        GlobalConfig->currentProfile->getConnectionType() == VpnAccountData::freeswan ||
				GlobalConfig->currentProfile->getConnectionType() == VpnAccountData::l2tpd_freeswan)
	{
		if ( GlobalConfig->currentProfile != 0 )
		{
			ProfileCertOptionsWidget->privkeypathURLRequester->setURL( GlobalConfig->currentProfile->getPrivateKey() );
			ProfileCertOptionsWidget->PrivkeyPasswordEdit->setText( GlobalConfig->currentProfile->getPrivateKeyPass() );
			ProfileCertOptionsWidget->SavePrivateKeyPasswordCheckBox->setChecked ( GlobalConfig->currentProfile->getSavePrivateKeyPassword() );
		}
		ProfileGeneralOptionsWidget->AdvancedSettingsPushButton->setEnabled( false );

		ProfileNetworkGeneralOptionsWidget->NetworkDeviceComboBox->setEnabled ( true );
		ProfileNetworkGeneralOptionsWidget->LabelNetworkDevice->setEnabled( true );

		ProfileCiscoOptionsWidget->IDLineEdit->setEnabled( false );
		ProfileCiscoOptionsWidget->LabelID->setEnabled( false );

		// 		buttonCancel->setEnabled( TRUE );
		// 		buttonOk->setEnabled( TRUE );
		if ( ProfileCertOptionsWidget->UseSpecialRemoteIDcheckBox->isChecked() )
			ProfileCertOptionsWidget->RemoteIDLineEdit->setEnabled( true );
		else
			ProfileCertOptionsWidget->RemoteIDLineEdit->setEnabled( false );

		if ( ProfilePskOptionsWidget->UseSpecialRemoteIDcheckBox->isChecked() )
			ProfilePskOptionsWidget->RemoteIDLineEdit->setEnabled( true );
		else
			ProfilePskOptionsWidget->RemoteIDLineEdit->setEnabled( false );

		ProfileNetworkNatOptionsWidget->UseUdpCheckbox->setEnabled( true );
		ProfileNetworkNatOptionsWidget->UdpPortCheckbox->setEnabled( true );
		if ( GlobalConfig->currentProfile->getUseUdp() )
			ProfileNetworkNatOptionsWidget->UdpPortCheckbox->setEnabled( true );
		else
			ProfileNetworkNatOptionsWidget->UdpPortCheckbox->setEnabled( false );

		emit authTypeChanged( GlobalConfig->currentProfile->getAuthType() );
	} // racoon/freeswan


}

void PreferencesDialog::authTypeChanged( int authtype )
{
	if ( GlobalConfig->currentProfile == 0 )
		return ;

	ProfilePskOptionsWidget->PskInFileCheckBox->setEnabled( true );

	if ( GlobalConfig->KvpncDebugLevel > 0 )
	{

		QString type;
		if ( GlobalConfig->currentProfile->getAuthType() == VpnAccountData::cert )
			type = "cert";
		else if ( GlobalConfig->currentProfile->getAuthType() == VpnAccountData::psk )
			type = "psk";


		GlobalConfig->appendLogEntry( i18n( "New authtype: \"%1\"." ).arg( type ) , GlobalConfig->debug );
	}

	ProfilePskOptionsWidget->PskGroupBox->setEnabled( false );
	ProfileCertOptionsWidget->AuthTypeComboBox->setEnabled( false );
	ProfilePskOptionsWidget->AuthTypeComboBox->setEnabled( false );
	ProfileCertOptionsWidget->LabelAuthType->setEnabled( false );
	ProfilePskOptionsWidget->LabelAuthType->setEnabled( false );
	ProfileCertOptionsWidget->CaCertpathURLRequester->setEnabled( false );
	ProfileCertOptionsWidget->SpecialServerCertificateURLRequester->setEnabled( false );

	int connectiontype = ProfileGeneralOptionsWidget->ConnectionTypeComboBox->currentItem();


	if ( connectiontype == VpnAccountData::cisco || connectiontype == VpnAccountData::pptp )
	{
		if ( connectiontype == VpnAccountData::cisco )
		{
			ProfilePskOptionsWidget->PskGroupBox->setEnabled( true );
			ProfilePskOptionsWidget->PSKLineEdit->setEnabled( true );
			ProfilePskOptionsWidget->LabelPsk->setEnabled( true );
			ProfilePskOptionsWidget->PskInFileCheckBox->setChecked( false );
			ProfilePskOptionsWidget->PskInFileCheckBox->setEnabled( false );
			ProfilePskOptionsWidget->PSKFileURLRequester->setEnabled( false );
			ProfilePskOptionsWidget->LabelPskFile->setEnabled( false );
		}

	}

	// racoon or freeswan
	else if ( connectiontype == VpnAccountData::freeswan || connectiontype == VpnAccountData::l2tpd_freeswan ||
					connectiontype == VpnAccountData::racoon || connectiontype == VpnAccountData::l2tpd_racoon )
	{

		ProfileCertOptionsWidget->AuthTypeComboBox->setEnabled( true );
		ProfilePskOptionsWidget->AuthTypeComboBox->setEnabled( true );
		ProfileCertOptionsWidget->LabelAuthType->setEnabled( true );
		ProfilePskOptionsWidget->LabelAuthType->setEnabled( true );
		// cert
		if ( authtype == VpnAccountData::cert )
		{
			// certificate
			ProfileCertOptionsWidget->setEnabled( true );
			ProfileCertOptionsWidget->x509certURLRequester->setEnabled( true );
			ProfileCertOptionsWidget->LabelCertificate->setEnabled( true );

			ProfileCertOptionsWidget->certpathURLRequester->setEnabled( true );
			ProfileCertOptionsWidget->LabelCertificatePath->setEnabled( true );

			ProfileCertOptionsWidget->ImportCertificatePushButton->setEnabled( true );

			ProfilePskOptionsWidget->PskGroupBox->setEnabled( false );
			ProfilePskOptionsWidget->PSKLineEdit->setEnabled( false );
			ProfilePskOptionsWidget->LabelPsk->setEnabled( false );

		}

		// psk
		if ( authtype == VpnAccountData::psk )
		{
			// psk
			ProfilePskOptionsWidget->PskGroupBox->setEnabled( true );
			ProfilePskOptionsWidget->PSKLineEdit->setEnabled( true );
			ProfilePskOptionsWidget->LabelPsk->setEnabled( true );

			ProfileCertOptionsWidget->setEnabled( false );
			ProfileCertOptionsWidget->x509certURLRequester->setEnabled( false );
			ProfileCertOptionsWidget->LabelCertificate->setEnabled( false );

			ProfileCertOptionsWidget->certpathURLRequester->setEnabled( false );
			ProfileCertOptionsWidget->LabelCertificatePath->setEnabled( false );

			ProfileCertOptionsWidget->ImportCertificatePushButton->setEnabled( false );

		}
	}
	else if ( connectiontype == VpnAccountData::openvpn )
	{

		ProfileCertOptionsWidget->AuthTypeComboBox->setEnabled( true );
		ProfilePskOptionsWidget->AuthTypeComboBox->setEnabled( true );
		ProfileCertOptionsWidget->LabelAuthType->setEnabled( true );
		ProfilePskOptionsWidget->LabelAuthType->setEnabled( true );
		// cert
		if ( authtype == VpnAccountData::cert )
		{
			// certificate
			ProfileCertOptionsWidget->setEnabled( true );
			ProfileCertOptionsWidget->x509certURLRequester->setEnabled( true );
			ProfileCertOptionsWidget->CaCertpathURLRequester->setEnabled( true );
			ProfileCertOptionsWidget->LabelCertificate->setEnabled( true );

			ProfileCertOptionsWidget->certpathURLRequester->setEnabled( true );
			ProfileCertOptionsWidget->LabelCertificatePath->setEnabled( true );
			ProfileCertOptionsWidget->privkeypathURLRequester->setEnabled( true );
			ProfileCertOptionsWidget->LabelPrivateKeyPath->setEnabled( true );

			ProfileCertOptionsWidget->ImportCertificatePushButton->setEnabled( true );

			ProfilePskOptionsWidget->PskGroupBox->setEnabled( false );
			ProfilePskOptionsWidget->PSKFileURLRequester->setEnabled( false );
			ProfileCertOptionsWidget->LabelPrivateKeyPath->setEnabled( true );
		}

		// psk
		if ( authtype == VpnAccountData::psk )
		{
			// psk
			ProfilePskOptionsWidget->PskGroupBox->setEnabled( true );
			ProfilePskOptionsWidget->PSKFileURLRequester->setEnabled( true );
			ProfilePskOptionsWidget->PSKLineEdit->setEnabled( true );
			ProfilePskOptionsWidget->LabelPsk->setEnabled( true );

			ProfileCertOptionsWidget->setEnabled( false );
			ProfileCertOptionsWidget->LabelPrivateKeyPath->setEnabled( false );
			ProfileCertOptionsWidget->x509certURLRequester->setEnabled( false );
			ProfileCertOptionsWidget->LabelCertificate->setEnabled( false );

			ProfileCertOptionsWidget->certpathURLRequester->setEnabled( false );
			ProfileCertOptionsWidget->LabelCertificatePath->setEnabled( false );
			ProfileCertOptionsWidget->ImportCertificatePushButton->setEnabled( false );
		}

	}
}

void PreferencesDialog::profileChanged( const QString& itemtext )
{

	if ( !GlobalConfig->AccountList->isEmpty() && !itemtext.isEmpty() )
	{

		//	KMessageBox::information(0,"item clicked",Name);
		// profile data
		VpnAccountData * it;
		for ( it = GlobalConfig->AccountList->first(); it; it = GlobalConfig->AccountList->next() )
		{
			if ( it->getName() == itemtext )
			{
				GlobalConfig->currentProfile = it;
				break;
			}
		}

		if (GlobalConfig->currentProfile == 0)
			return;

		ProfileGeneralOptionsWidget->setEnabled( true );
		ProfileNetworkRouteOptionsWidget->setEnabled( true );
		ProfileNetworkNatOptionsWidget->setEnabled( true );
		ProfileNetworkVirtualIpOptionsWidget->setEnabled( true );
		ProfileCertOptionsWidget->setEnabled( true );
		ProfilePskOptionsWidget->setEnabled( true );
		ProfileUserOptionsWidget->setEnabled( true );
		ProfileOpenvpnOptionsWidget->setEnabled( true );
		ProfilePptpOptionsWidget->setEnabled( true );
		ProfileRacoonOptionsWidget->setEnabled( true );
		ProfileCiscoOptionsWidget->setEnabled( true );
		ProfileCmdExecBeforeConnectOptionsWidget->setEnabled( true );
		ProfileCmdExecBeforeDisconnectOptionsWidget->setEnabled( true );
		ProfileCmdExecAfterConnectOptionsWidget->setEnabled( true );
		ProfileCmdExecAfterDisconnectOptionsWidget->setEnabled( true );

		ProfileNetworkGeneralOptionsWidget->RemoteNetAddrLineEdit->setEnabled( false );
		ProfileNetworkGeneralOptionsWidget->LabelRemoteNetwork->setEnabled( false );
		ProfileNetworkGeneralOptionsWidget->RemoteNetMaskComboBox->setEnabled( false );
		ProfileNetworkGeneralOptionsWidget->NetworkDeviceComboBox->setEnabled( false );
		ProfileNetworkGeneralOptionsWidget->RemoteNetDividetextLabel->setEnabled( false );
		ProfileNetworkGeneralOptionsWidget->LabelNetworkDevice->setEnabled( false );
		ProfileSmartcardOptionsWidget->UseSmartcardCheckBox->setEnabled( false );

		QString Name = itemtext;
		lastProfileName = Name;

		ProfileGeneralSelector->setCurrentText( lastProfileName );
		ProfileNetworkRouteSelector->setCurrentText( lastProfileName );
		ProfileNetworkNatSelector->setCurrentText( lastProfileName );
		ProfileNetworkHttpProxySelector->setCurrentText( lastProfileName );
		ProfileNetworkVirtualIpSelector->setCurrentText( lastProfileName );
		ProfileCertSelector->setCurrentText( lastProfileName );
		ProfileSmartcardSelector->setCurrentText( lastProfileName );
		ProfilePskSelector->setCurrentText( lastProfileName );
		ProfileUserSelector->setCurrentText( lastProfileName );
		ProfileOpenvpnSelector->setCurrentText( lastProfileName );
		ProfilePptpSelector->setCurrentText( lastProfileName );
		ProfileRacoonSelector->setCurrentText( lastProfileName );
		ProfileCiscoSelector->setCurrentText( lastProfileName );
		ProfileCmdExecBeforeConnectSelector->setCurrentText( lastProfileName );
		ProfileCmdExecBeforeDisconnectSelector->setCurrentText( lastProfileName );
		ProfileCmdExecAfterConnectSelector->setCurrentText( lastProfileName );
		ProfileCmdExecAfterDisconnectSelector->setCurrentText( lastProfileName );

		if ( GlobalConfig->KvpncDebugLevel > 0 )
			GlobalConfig->appendLogEntry( i18n( "New profile: %1" ).arg( Name ), GlobalConfig->debug );

		ProfileCertOptionsWidget->x509certURLRequester->clear();
		ProfileCertOptionsWidget->certpathURLRequester->clear();
		ProfileUserOptionsWidget->UsernameLineEdit->clear();
		ProfilePskOptionsWidget->PSKLineEdit->clear();
		ProfileCertOptionsWidget->RemoteIDLineEdit->clear();
		ProfileNetworkGeneralOptionsWidget->RemoteNetAddrLineEdit->clear();
		ProfileGeneralOptionsWidget->gatewayLineEdit->clear();
		ProfileNetworkRouteOptionsWidget->NetworkListView->clear();
		ProfileCertOptionsWidget->SpecialServerCertificateURLRequester->clear();

		ProfilePskOptionsWidget->CheckSavePsk->setChecked( false );
		ProfileUserOptionsWidget->CheckUserPass->setChecked( false );
		ProfileCiscoOptionsWidget->IDLineEdit->clear();
		ProfileUserOptionsWidget->UsernameLineEdit->clear();
		ProfileUserOptionsWidget->PasswordEdit->clear();
		ProfileCmdExecBeforeConnectOptionsWidget->CmdBeforeConnectTextEdit->setEnabled( false );
		ProfileCmdExecAfterConnectOptionsWidget->CmdAfterConnectTextEdit->setEnabled( false );
		ProfileCmdExecBeforeDisconnectOptionsWidget->CmdBeforeDisconnectTextEdit->setEnabled( false );
		ProfileCmdExecAfterDisconnectOptionsWidget->CmdAfterDisconnectTextEdit->setEnabled( false );
		ProfileCmdExecBeforeConnectOptionsWidget->ExcuteCmdBeforeConnectCheckBox->setChecked( false );
		ProfileCmdExecAfterConnectOptionsWidget->ExcuteCmdAfterConnectCheckBox->setChecked( false );
		ProfileCmdExecBeforeDisconnectOptionsWidget->ExcuteCmdBeforeDisconnectCheckBox->setChecked( false );
		ProfileCmdExecAfterDisconnectOptionsWidget->ExcuteCmdAfterDisconnectCheckBox->setChecked( false );
		ProfileNetworkVirtualIpOptionsWidget->UseVirtualIPCheckBox->setChecked( false );
		ProfileCertOptionsWidget->UseSpecialServerCertificateCheckBox->setChecked( false );

		ProfilePptpOptionsWidget->RefuseEapCheckbox->setChecked( false );
		ProfilePptpOptionsWidget->RequireMppeCheckbox->setChecked( false );
		ProfilePptpOptionsWidget->Refuse128BitEncryptionCheckbox->setChecked( false );
		ProfilePptpOptionsWidget->Refuse40BitEncryptionCheckbox->setChecked( false );
		ProfilePptpOptionsWidget->UseNoMPPECompressionCheckbox->setChecked( false );
		ProfilePptpOptionsWidget->DnsServerCheckbox->setChecked( false );
		ProfilePptpOptionsWidget->DnsServerLineedit->clear();
		ProfilePptpOptionsWidget->AllowStatefulModeCheckbox->setChecked( false );
		ProfilePptpOptionsWidget->GetDnsFromPeerCheckbox->setChecked( false );
		ProfilePptpOptionsWidget->UseNoBsdCompCheckbox->setChecked( false );
		ProfilePptpOptionsWidget->UseNoDeflateCheckbox->setChecked( false );
		ProfileNetworkGeneralOptionsWidget->MtuSpinbox->setValue( 1500 );
		ProfileNetworkGeneralOptionsWidget->MtuCheckbox->setChecked( false );
		ProfilePptpOptionsWidget->DisableCcpCheckbox->setChecked( false );

		ProfileNetworkVirtualIpOptionsWidget->setEnabled( false );

		ProfileNetworkGeneralOptionsWidget->TunnelDeviceTypeComboBox->setEnabled(false);
		ProfileNetworkGeneralOptionsWidget->TunnelDeviceTypeLabel->setEnabled(false);


		if ( it == 0 )
		{
			ProfileGeneralOptionsWidget->RenameSessionPushButton->setEnabled( false );
			ProfileGeneralOptionsWidget->DeleteSessionPushButton->setEnabled( false );
			ProfileGeneralOptionsWidget->SaveSessionPushButton->setEnabled( false );
			return ;
		}
		else
		{
			ProfileGeneralOptionsWidget->AdvancedSettingsPushButton->setEnabled( true );
			ProfileGeneralOptionsWidget->DeleteSessionPushButton->setEnabled( true );
			ProfileGeneralOptionsWidget->SaveSessionPushButton->setEnabled( true );
		}

		ProfileCertOptionsWidget->RemoteIDLineEdit->clear();
		ProfileNetworkGeneralOptionsWidget->RemoteNetMaskComboBox->setCurrentText( "24" );
		ProfileGeneralOptionsWidget->DescriptionLineEdit->setText( it->getDescription() );
		ProfileGeneralOptionsWidget->gatewayLineEdit->setText( it->getGateway() );


		if (GlobalConfig->currentProfile->getTunnelDeviceType() == QString("tap"))
			ProfileNetworkGeneralOptionsWidget->TunnelDeviceTypeComboBox->setCurrentItem(1);
		else
			ProfileNetworkGeneralOptionsWidget->TunnelDeviceTypeComboBox->setCurrentItem(0);


		// 	AdvancedSettingsPushButton->setEnabled( false );
		if ( ( it->getNetworkDevice() ).isEmpty() )
		{
			ProfileNetworkGeneralOptionsWidget->NetworkDeviceComboBox->setCurrentText( "default" );

			if ( GlobalConfig->KvpncDebugLevel > 2 )
				GlobalConfig->appendLogEntry( i18n( "profile \"%1\": no network device defined, using \"default\"." ).arg( it->getName() ), GlobalConfig->debug );
		}
		else
		{
			ProfileNetworkGeneralOptionsWidget->NetworkDeviceComboBox->setCurrentText( it->getNetworkDevice() );

			if ( GlobalConfig->KvpncDebugLevel > 2 )
				GlobalConfig->appendLogEntry( i18n( "profile \"%1\": network device defined, using \"%2\"." ).arg( it->getName() ).arg( it->getNetworkDevice() ), GlobalConfig->debug );
		}

		ProfileGeneralOptionsWidget->ConnectionTypeComboBox->setCurrentItem( it->getConnectionType() );

		// 	KMessageBox::information(0,"profilechanged() new conntype: "+QString().setNum(it->getConnectionType()),QString("type set"));

		ProfileGeneralOptionsWidget->gatewayLineEdit->setText( it->getGateway() );

		ProfilePskOptionsWidget->PSKLineEdit->setText( it->getPreSharedKey() );

		ProfileCertOptionsWidget->UseMailAddressAsIdentifierCheckBox->setChecked( it->getUseMailAddressAsIdentifier() );

		ProfileNetworkGeneralOptionsWidget->PingIPLineEdit->setText( it->getPingHostIP() );
		ProfileNetworkGeneralOptionsWidget->PingCheckBox ->setChecked( it->getDoPingIP() );

		ProfileUserOptionsWidget->UsernameLineEdit->setText( it->getUserName() );
		ProfileUserOptionsWidget->PasswordEdit->setText( it->getUserPassword() );
		ProfileUserOptionsWidget->CheckUserPass->setChecked( it->getSaveUserPassword() );

		if ( it->getUseUdp() )
			ProfileNetworkNatOptionsWidget->UseUdpCheckbox->setChecked( true );
		else
			ProfileNetworkNatOptionsWidget->UseUdpCheckbox->setChecked( false );

		ProfileNetworkNatOptionsWidget->UdpPortSpinbox->setValue( it->getUdpPort() );
		if ( it->getUseUdpPort() )
			ProfileNetworkNatOptionsWidget->UdpPortCheckbox->setChecked( true );
		else
			ProfileNetworkNatOptionsWidget->UdpPortCheckbox->setChecked( false );

		ProfileNetworkNatOptionsWidget->UseUdpCheckbox->setEnabled( true );
		ProfileNetworkNatOptionsWidget->UdpPortCheckbox->setEnabled( true );
		if ( it->getUseUdp() )
			ProfileNetworkNatOptionsWidget->UdpPortCheckbox->setEnabled( true );
		else
			ProfileNetworkNatOptionsWidget->UdpPortCheckbox->setEnabled( false );

		if ( it->getConnectionType() == VpnAccountData::openvpn )
			connect ( ProfileNetworkNatOptionsWidget->UseUdpCheckbox, SIGNAL( toggled( bool ) ), this, SLOT( useUdpToggled( bool ) ) );
		else
			disconnect ( ProfileNetworkNatOptionsWidget->UseUdpCheckbox, SIGNAL( toggled( bool ) ), this, SLOT( useUdpToggled( bool ) ) );


		ProfileNetworkGeneralOptionsWidget->MtuCheckbox->setChecked( it->getUseMtu() );
		ProfileNetworkGeneralOptionsWidget->MtuSpinbox->setValue( it->getMtu() );

		if ( it->getConnectionType() == VpnAccountData::cisco || it->getConnectionType() == VpnAccountData::pptp )
		{
			ProfileNetworkGeneralOptionsWidget->MtuCheckbox->setEnabled( true );

			if ( GlobalConfig->currentProfile->getUseMtu() )
				ProfileNetworkGeneralOptionsWidget->MtuSpinbox->setEnabled( true );
			else
				ProfileNetworkGeneralOptionsWidget->MtuSpinbox->setEnabled( false );
		}
		else
		{
			ProfileNetworkGeneralOptionsWidget->MtuCheckbox->setEnabled( false );
		}

		/* connection specific */
		if ( it->getConnectionType() == VpnAccountData::cisco )
		{
			ProfilePskOptionsWidget->CheckSavePsk->setChecked( it->getSavePsk() );
			ProfileUserOptionsWidget->CheckUserPass->setChecked ( it->getSaveUserPassword() );
			ProfileCiscoOptionsWidget->IDLineEdit->setText( it->getID() );
			ProfileUserOptionsWidget->UsernameLineEdit->setText ( it->getUserName() );
			ProfilePskOptionsWidget->PSKLineEdit->setText( it->getPreSharedKey() );
			ProfileUserOptionsWidget->PasswordEdit->setText ( it->getUserPassword() );

			ProfileCertOptionsWidget->AuthTypeComboBox->setCurrentItem( 1 ); // PSK
			ProfileCertOptionsWidget->AuthTypeComboBox->setEnabled( false );

			ProfilePskOptionsWidget->AuthTypeComboBox->setCurrentItem( 1 ); // PSK
			ProfilePskOptionsWidget->AuthTypeComboBox->setEnabled( false );


			ProfilePskOptionsWidget->PSKLineEdit->setText( it->getPreSharedKey() );
			ProfilePskOptionsWidget->CheckSavePsk->setChecked( it->getSavePsk() );

			ProfileCiscoOptionsWidget->IDLineEdit->setEnabled( true );
			ProfileCiscoOptionsWidget->LabelID->setEnabled( true );
			ProfileCiscoOptionsWidget->AllowEmptyGroupPasswordCheckBox->setChecked ( it->getAllowEmptyGroupPassword() );
			ProfileCiscoOptionsWidget->UseXauthInteractiveCheckBox->setChecked( it->getUseXauthInteractive() );
			ProfileCiscoOptionsWidget->LocalPortCheckbox->setChecked ( it->getUseLocalPort() );
			ProfileCiscoOptionsWidget->LocalPortSpinbox->setValue( it->getLocalPort() );

			int vpnc_version_major = 0;
			int vpnc_version_minor = 2;
			int vpnc_version_subminor = 1;

			ToolInfo *Tool = Utils( GlobalConfig ).getToolInfo( GlobalConfig, "vpnc" );
			if ( !Tool->Version.isEmpty() )
			{
				vpnc_version_major = ( Tool->Version.section( '.', 0, 0 ) ).toInt();
				vpnc_version_minor = ( Tool->Version.section( '.', 1, 1 ) ).toInt();
				vpnc_version_subminor = ( Tool->Version.section( '.', 2, 2 ) ).toInt();
			}

			if ( vpnc_version_minor < 3 )
			{
				GlobalConfig->appendLogEntry( i18n( "%1 is too old. Minimum requirement is %2, disabling Xauth interactive option." ).arg( "vpnc" ).arg( "0.3.x" ), GlobalConfig->error );
				ProfileCiscoOptionsWidget->UseXauthInteractiveCheckBox->setEnabled( false );
			}

			if ( it->getUseUdp() )
				ProfileNetworkNatOptionsWidget->UseUdpCheckbox->setChecked( true );
			else
				ProfileNetworkNatOptionsWidget->UseUdpCheckbox->setChecked( false );

			ProfileNetworkNatOptionsWidget->UdpPortSpinbox->setValue( it->getUdpPort() );
			if ( it->getUseUdpPort() )
				ProfileNetworkNatOptionsWidget->UdpPortCheckbox->setChecked( true );
			else
				ProfileNetworkNatOptionsWidget->UdpPortCheckbox->setChecked( false );

			ProfileNetworkNatOptionsWidget->UseUdpCheckbox->setEnabled( true );
			ProfileNetworkNatOptionsWidget->UdpPortCheckbox->setEnabled( true );
			if ( it->getUseUdp() )
				ProfileNetworkNatOptionsWidget->UdpPortCheckbox->setEnabled( true );
			else
				ProfileNetworkNatOptionsWidget->UdpPortCheckbox->setEnabled( false );

			ProfileGeneralOptionsWidget->AdvancedSettingsPushButton->setEnabled( true );

			ProfileNetworkGeneralOptionsWidget->RemoteNetAddrLineEdit->setEnabled( false );
			ProfileNetworkGeneralOptionsWidget->LabelRemoteNetwork->setEnabled( false );
			ProfileNetworkGeneralOptionsWidget->RemoteNetMaskComboBox->setEnabled( false );
			ProfileCertOptionsWidget->RemoteIDLineEdit->setEnabled( false );

			ProfilePptpOptionsWidget->setEnabled( false );
			ProfileOpenvpnOptionsWidget->setEnabled( false );
			ProfileCiscoOptionsWidget->setEnabled( true );
			ProfileRacoonOptionsWidget->setEnabled( false );

			ProfileNetworkGeneralOptionsWidget->UseReconnectDelayCheckBox->setChecked( it->getUseReconnectDelay() );
			ProfileNetworkGeneralOptionsWidget->ReconnectDelayNumInput->setEnabled( it->getUseReconnectDelay() );
			ProfileNetworkGeneralOptionsWidget->ReconnectDelayNumInput->setValue( it->getReconnectDelay() );

			ProfileCiscoOptionsWidget->PeerTimeoutIntNumInput->setValue( it->getPeerTimeout() );

			ProfileUserOptionsWidget->NtDomainNameCheckbox->setEnabled( true );
			ProfileUserOptionsWidget->NtDomainNameLineedit->setEnabled ( false );
			ProfileUserOptionsWidget->NtDomainNameLineedit->setText( it->getNtDomainName() );
			if ( it->getUseNtDomainName() )
			{
				ProfileUserOptionsWidget->NtDomainNameLineedit->setEnabled ( true );
				ProfileUserOptionsWidget->NtDomainNameCheckbox->setChecked( true );
			}

			if ( it->getUseGlobalIpsecSecret() )
				ProfileCiscoOptionsWidget->UseGlobalIpsecSecretCheckbox->setChecked ( true );
			else
				ProfileCiscoOptionsWidget->UseGlobalIpsecSecretCheckbox->setChecked ( false );

			ProfileCiscoOptionsWidget->UseGlobalIpsecSecretCheckbox->setChecked ( it->getUseGlobalIpsecSecret() );
			

			//FIXME
			// 			ProfileNetworkRouteOptionsWidget->InterfaceComboBox->insertItem("tun0");
			ProfileNetworkGeneralOptionsWidget->TunnelDeviceTypeComboBox->setEnabled(true);
			ProfileNetworkGeneralOptionsWidget->TunnelDeviceTypeLabel->setEnabled(true);
		} // vpnc

		else if ( it->getConnectionType() == VpnAccountData::ConnectionType( VpnAccountData::l2tpd_racoon ) || it->getConnectionType() == VpnAccountData::ConnectionType( VpnAccountData::racoon ) || it->getConnectionType() == VpnAccountData::ConnectionType( VpnAccountData::freeswan ) || it->getConnectionType() == VpnAccountData::ConnectionType( VpnAccountData::l2tpd_freeswan ) )
		{
			ProfileNetworkGeneralOptionsWidget->RemoteNetAddrLineEdit->setText( it->getRemoteNetAddr() );
			if ( !it->getRemoteNetMask().isEmpty() )
				ProfileNetworkGeneralOptionsWidget->RemoteNetMaskComboBox->setCurrentText( it->getRemoteNetMask() );

			if ( it->getAuthType() == VpnAccountData::cert )
			{
				ProfileCertOptionsWidget->AuthTypeComboBox->setCurrentItem( 0 );
				ProfilePskOptionsWidget->AuthTypeComboBox->setCurrentItem( 0 );
			}
			else
			{
				ProfileCertOptionsWidget->AuthTypeComboBox->setCurrentItem( 1 );
				ProfilePskOptionsWidget->AuthTypeComboBox->setCurrentItem( 1 );
			}


			if ( it->getUsePerfectForwardSecrety() )
				ProfileRacoonOptionsWidget->DisablePfsCheckBox->setChecked( false );
			else
				ProfileRacoonOptionsWidget->DisablePfsCheckBox->setChecked( true );

			ProfileCertOptionsWidget->x509certURLRequester->setURL( it->getX509Certificate() );
			ProfileCertOptionsWidget->CaCertpathURLRequester->setURL( it->getCaCertificate() );
			ProfileCertOptionsWidget->certpathURLRequester->setURL( it->getCertPath() );
			ProfileCertOptionsWidget->PrivkeyPasswordEdit->setText( it->getPrivateKeyPass() );
			ProfileCertOptionsWidget->SavePrivateKeyPasswordCheckBox->setChecked( it->getSavePrivateKeyPassword() );
			ProfileCertOptionsWidget->privkeypathURLRequester->setURL( it->getPrivateKey() );

			ProfileNetworkGeneralOptionsWidget->PingCheckBox->setChecked( it->getDoPingIP() );
			ProfileNetworkGeneralOptionsWidget->PingIPLineEdit->setText( it->getPingHostIP() );
			ProfileCertOptionsWidget->RemoteIDLineEdit->setText( it->getSpecialRemoteID() );
			ProfileCertOptionsWidget->UseSpecialRemoteIDcheckBox->setChecked( it->getUseSpecialRemoteID() );
			ProfilePskOptionsWidget->UseSpecialRemoteIDcheckBox->setChecked( it->getUseSpecialRemoteID() );
			ProfilePskOptionsWidget->PSKLineEdit->setText( it->getPreSharedKey() );
			ProfilePskOptionsWidget->CheckSavePsk->setChecked( it->getSavePsk() );

			ProfileRacoonOptionsWidget->UseRightNextHopCheckBox->setChecked(it->getUseRightNextHop());
			ProfileRacoonOptionsWidget->UseLeftNextHopCheckBox->setChecked(it->getUseLeftNextHop());
			ProfileRacoonOptionsWidget->LeftNextHopLineEdit->setText( it->getLeftNextHop() );
			ProfileRacoonOptionsWidget->RightNextHopLineEdit->setText( it->getRightNextHop() );
			ProfileRacoonOptionsWidget->DisableOpportunisticEncryptionCheckBox->setChecked( it->getDisableOpportunisticEncryption() );

			// TODO made it useable for freeswan
			if ( it->getConnectionType() == VpnAccountData::freeswan || it->getConnectionType() == VpnAccountData::l2tpd_freeswan)
			{
			ProfilePptpOptionsWidget->setEnabled( false );
			ProfileOpenvpnOptionsWidget->setEnabled( false );
			ProfileCiscoOptionsWidget->setEnabled( false );
			ProfileRacoonOptionsWidget->setEnabled( true );


				ProfileCertOptionsWidget->SpecialServerCertificateURLRequester->setEnabled( false );
				ProfileCertOptionsWidget->UseSpecialServerCertificateCheckBox->setChecked( it->getUseSpecialServerCertificate() );
				if ( it->getUseSpecialServerCertificate() )
					ProfileCertOptionsWidget->SpecialServerCertificateURLRequester->setURL( it->getSpecialServerCertificate() );

				ProfileRacoonOptionsWidget->FreeswanGroupBox->show();

				ProfileRacoonOptionsWidget->HashAlgoComboBox->setEnabled( false );
				ProfileRacoonOptionsWidget->HashAlgoTextLabel->setEnabled( false );
				ProfileRacoonOptionsWidget->UseModeConfigCheckBox->setEnabled( false );

				ProfileNetworkGeneralOptionsWidget->RemoteNetAddrLineEdit->setEnabled( true );
				ProfileNetworkGeneralOptionsWidget->LabelRemoteNetwork->setEnabled( true );
				ProfileNetworkGeneralOptionsWidget->RemoteNetMaskComboBox->setEnabled( true );

				ToolInfo *tool = Utils( GlobalConfig ).getToolInfo( GlobalConfig, "ipsec" );
				QString realversion = tool->Version.section( ' ', 1, 1 ).section( '/', 0, 0 ).right( tool->Version.section( ' ', 1, 1 ).section( '/', 0, 0 ).length() - 1 );
				QString realtype = tool->Version.section( ' ', 0, 0 ).lower();

				if ( it->getConnectionType() == VpnAccountData::l2tpd_freeswan )
					ProfileUserOptionsWidget->setEnabled( true );
				else
					ProfileUserOptionsWidget->setEnabled( false );

				if ( realversion.find( "1.", 0, -1 ) > -1 )
				{
					ProfileRacoonOptionsWidget->ExchangeModeComboBox->setEnabled( false );
				}
				else
				{
					ProfileRacoonOptionsWidget->ExchangeModeComboBox->setEnabled( true );
				}

				ProfileNetworkGeneralOptionsWidget->MtuCheckbox->setEnabled( true );

				if ( GlobalConfig->currentProfile->getUseMtu() )
					ProfileNetworkGeneralOptionsWidget->MtuSpinbox->setEnabled( true );
				else
					ProfileNetworkGeneralOptionsWidget->MtuSpinbox->setEnabled( false );

				// 				ProfileNetworkRouteOptionsWidget->InterfaceComboBox->insertItem("ipsec0");

				ProfileSmartcardOptionsWidget->UseSmartcardCheckBox->setEnabled( true );
			}
			else
			{
				// racoon

				ProfileRacoonOptionsWidget->HashAlgoComboBox->setEnabled( true );
				ProfileRacoonOptionsWidget->HashAlgoTextLabel->setEnabled( true );
				ProfileRacoonOptionsWidget->UseModeConfigCheckBox->setEnabled( true );
				ProfileRacoonOptionsWidget->ExchangeModeComboBox->setEnabled( true );
				ProfileRacoonOptionsWidget->FreeswanGroupBox->hide();

				if ( it->getConnectionType() == VpnAccountData::racoon )
				{
					ProfileNetworkGeneralOptionsWidget->RemoteNetAddrLineEdit->setEnabled( true );
					ProfileNetworkGeneralOptionsWidget->LabelRemoteNetwork->setEnabled( true );
					ProfileNetworkGeneralOptionsWidget->RemoteNetMaskComboBox->setEnabled( true );
					ProfileNetworkGeneralOptionsWidget->RemoteNetDividetextLabel->setEnabled( true );
				}

				if ( it->getConnectionType() == VpnAccountData::l2tpd_racoon )
				{
					ProfileUserOptionsWidget->setEnabled( true );

					ProfileNetworkGeneralOptionsWidget->RemoteNetAddrLineEdit->setEnabled( false );
					ProfileNetworkGeneralOptionsWidget->LabelRemoteNetwork->setEnabled( false );
					ProfileNetworkGeneralOptionsWidget->RemoteNetMaskComboBox->setEnabled( false );
					ProfileNetworkGeneralOptionsWidget->RemoteNetAddrLineEdit->setEnabled( false );
					ProfileNetworkGeneralOptionsWidget->RemoteNetDividetextLabel->setEnabled( false );

					ProfileNetworkGeneralOptionsWidget->MtuCheckbox->setEnabled( true );

					if ( GlobalConfig->currentProfile->getUseMtu() )
						ProfileNetworkGeneralOptionsWidget->MtuSpinbox->setEnabled( true );
					else
						ProfileNetworkGeneralOptionsWidget->MtuSpinbox->setEnabled( false );
				}
// 				else
// 				{
// 					ProfileNetworkGeneralOptionsWidget->MtuCheckbox->setEnabled( false );
// 				}

			}

			// FIXME
			// 					ProfileNetworkRouteOptionsWidget->main->InterfaceComboBox->insertItem("ppp0");

			//FIXME
			// 				ProfileNetworkRouteOptionsWidget->main->InterfaceComboBox->insertItem("tun0");
		}

		ProfileNetworkVirtualIpOptionsWidget->UseVirtualIPCheckBox->setChecked( it->getUseVirtualIP() );
		ProfileNetworkVirtualIpOptionsWidget->UseVirtualIPCheckBox->setEnabled( true );

		// 			ProfileNetworkNatOptionsWidget->UseUdpCheckbox->setChecked(it->getUseUdp());
		// 			ProfileNetworkNatOptionsWidget->UdpPortSpinbox->setValue(it->getUdpPort());
		// 			if (it->getUseUdpPort() )
		// 				ProfileNetworkNatOptionsWidget->UdpPortCheckbox->setChecked(true);
		// 			else
		// 				ProfileNetworkNatOptionsWidget->UdpPortCheckbox->setChecked(false);


		ProfileNetworkNatOptionsWidget->UseUdpCheckbox->setEnabled( true );
		ProfileNetworkNatOptionsWidget->UdpPortCheckbox->setEnabled( true );
		if ( it->getUseUdp() )
			ProfileNetworkNatOptionsWidget->UdpPortCheckbox->setEnabled( true );
		else
			ProfileNetworkNatOptionsWidget->UdpPortCheckbox->setEnabled( false );


		ProfileCertOptionsWidget->ImportCertificatePushButton->setEnabled( true );

		ProfileCiscoOptionsWidget->IDLineEdit->setEnabled( false );
		ProfileCiscoOptionsWidget->LabelID->setEnabled( false );

		if ( it->getConnectionType() == VpnAccountData::racoon || it->getConnectionType() == VpnAccountData::l2tpd_racoon )
		{
			ProfileGeneralOptionsWidget->AdvancedSettingsPushButton->setEnabled( true );

			ProfilePptpOptionsWidget->setEnabled( false );
			ProfileOpenvpnOptionsWidget->setEnabled( false );
			ProfileCiscoOptionsWidget->setEnabled( false );
			ProfileRacoonOptionsWidget->setEnabled( true );

			if ( it->getHashAlgo() == "sha1" )
				ProfileRacoonOptionsWidget->HashAlgoComboBox->setCurrentText( "SHA1" );
			if ( it->getHashAlgo() == "md5" )
				ProfileRacoonOptionsWidget->HashAlgoComboBox->setCurrentText( "MD5" );

			ProfileRacoonOptionsWidget->DHGroupComboBox->setCurrentText( it->getIkeGroup() );
			ProfileRacoonOptionsWidget->EncryptionAlgorithmComboBox->setCurrentText( it->getEncryptionAlgorithm() );
			ProfileRacoonOptionsWidget->AuthenticationAlgorithmComboBox->setCurrentText( it->getAuthenticationAlgorithm() );

			ProfileRacoonOptionsWidget->ExchangeModeComboBox->setCurrentText( it->getExchangeMode() );
			ProfileRacoonOptionsWidget->UseModeConfigCheckBox->setChecked( it->getUseModeConfig() );

		} // racoon or freeswan

		else if ( it->getConnectionType() == VpnAccountData::ConnectionType( VpnAccountData::pptp ) )
		{
			ProfilePskOptionsWidget->CheckSavePsk->setChecked( it->getSavePsk() );
			ProfileUserOptionsWidget->CheckUserPass->setChecked ( it->getSaveUserPassword() );
			ProfileUserOptionsWidget->UsernameLineEdit->setText ( it->getUserName() );
			ProfileUserOptionsWidget->PasswordEdit->setText ( it->getUserPassword() );
			ProfileNetworkGeneralOptionsWidget->PingCheckBox->setChecked( it->getDoPingIP() );
			ProfileNetworkGeneralOptionsWidget->PingIPLineEdit->setText( it->getPingHostIP() );

			if ( !it->getRemoteNetAddr().isEmpty() && !it->getRemoteNetMask().isEmpty() )
			{
				ProfileNetworkGeneralOptionsWidget->RemoteNetAddrLineEdit->setText( it->getRemoteNetAddr() );
				if ( !it->getRemoteNetMask().isEmpty() )
					ProfileNetworkGeneralOptionsWidget->RemoteNetMaskComboBox->setCurrentText( it->getRemoteNetMask() );
			}

			ProfilePptpOptionsWidget->RefuseEapCheckbox->setChecked( it->getRefuseEap() );
			ProfilePptpOptionsWidget->RequireMppeCheckbox->setChecked( it->getRequireMppe() );
			ProfilePptpOptionsWidget->Refuse128BitEncryptionCheckbox->setChecked( it->getRefuse128BitEncryption() );
			ProfilePptpOptionsWidget->Refuse40BitEncryptionCheckbox->setChecked( it->getRefuse40BitEncryption() );
			ProfilePptpOptionsWidget->UseNoMPPECompressionCheckbox->setChecked( it->getDisableMPPEComp() );
			ProfilePptpOptionsWidget->GetDnsFromPeerCheckbox->setChecked( it->getUseGetDnsFromPeer() );
			ProfilePptpOptionsWidget->DnsServerCheckbox->setChecked( it->getUseDnsServer() );
			ProfilePptpOptionsWidget->DnsServerLineedit->setText( it->getDnsServer() );
			ProfilePptpOptionsWidget->UseNoBsdCompCheckbox->setChecked( it->getUseNoBsdComp() );
			ProfilePptpOptionsWidget->UseNoDeflateCheckbox->setChecked( it->getUseNoDeflate() );

			ProfilePptpOptionsWidget->AllowStatefulModeCheckbox->setChecked( it->getAllowStatefulMode() );
			ProfilePptpOptionsWidget->UseNoIpDefaultCheckbox->setChecked( it->getUseNoIpDefault() );
			ProfilePptpOptionsWidget->DisableCcpCheckbox->setChecked( it->getDisableCcp() );

			ProfileUserOptionsWidget->NtDomainNameCheckbox->setEnabled( true );
			ProfileUserOptionsWidget->NtDomainNameLineedit->setEnabled ( false );
			ProfileUserOptionsWidget->NtDomainNameLineedit->setText( it->getNtDomainName() );
			if ( it->getUseNtDomainName() )
			{
				ProfileUserOptionsWidget->NtDomainNameLineedit->setEnabled ( true );
				ProfileUserOptionsWidget->NtDomainNameCheckbox->setChecked( true );
			}

			ProfileGeneralOptionsWidget->AdvancedSettingsPushButton->setEnabled( true );

			ProfileCiscoOptionsWidget->IDLineEdit->setEnabled( false );
			ProfileCiscoOptionsWidget->LabelID->setEnabled( false );

			ProfileNetworkGeneralOptionsWidget->RemoteNetAddrLineEdit->setEnabled( false );
			ProfileNetworkGeneralOptionsWidget->LabelRemoteNetwork->setEnabled( false );
			ProfileNetworkGeneralOptionsWidget->RemoteNetMaskComboBox->setEnabled( false );
			ProfileCertOptionsWidget->ImportCertificatePushButton->setEnabled( false );
			ProfileNetworkGeneralOptionsWidget->NetworkDeviceComboBox->setEnabled( false );
			ProfileNetworkGeneralOptionsWidget->RemoteNetDividetextLabel->setEnabled( false );
			ProfileNetworkGeneralOptionsWidget->LabelNetworkDevice->setEnabled( false );

			ProfilePptpOptionsWidget->setEnabled( true );
			ProfileOpenvpnOptionsWidget->setEnabled( false );
			ProfileCiscoOptionsWidget->setEnabled( false );
			ProfileRacoonOptionsWidget->setEnabled( false );

			if (it->getAuthMethod() == "chap")
				ProfilePptpOptionsWidget->AuthMethodComboBox->setCurrentItem(0);
			else
				ProfilePptpOptionsWidget->AuthMethodComboBox->setCurrentItem(1);

			//FIXME
			// 			ProfileNetworkRouteOptionsWidget->InterfaceComboBox->insertItem("ppp0");
		} // pptp

		else if ( it->getConnectionType() == VpnAccountData::ConnectionType( VpnAccountData::openvpn ) )
		{

			if ( it->getAuthType() == VpnAccountData::cert )
			{
				ProfileCertOptionsWidget->AuthTypeComboBox->setCurrentItem( 0 );
				ProfilePskOptionsWidget->AuthTypeComboBox->setCurrentItem( 0 );
			}
			else
			{
				ProfileCertOptionsWidget->AuthTypeComboBox->setCurrentItem( 1 );
				ProfilePskOptionsWidget->AuthTypeComboBox->setCurrentItem( 1 );
			}

			ProfileCertOptionsWidget->x509certURLRequester->setURL( it->getX509Certificate() );
			ProfileCertOptionsWidget->CaCertpathURLRequester->setURL( it->getCaCertificate() );
			ProfileCertOptionsWidget->certpathURLRequester->setURL( it->getCertPath() );
			ProfileCertOptionsWidget->PrivkeyPasswordEdit->setText( it->getPrivateKeyPass() );
			ProfileCertOptionsWidget->SavePrivateKeyPasswordCheckBox->setChecked( it->getSavePrivateKeyPassword() );
			ProfileCertOptionsWidget->privkeypathURLRequester->setURL( it->getPrivateKey() );
			ProfilePskOptionsWidget->PSKLineEdit->setText( it->getPreSharedKey() );
			ProfilePskOptionsWidget->PskInFileCheckBox->setChecked( it->getPskIsInFile() );
			ProfilePskOptionsWidget->CheckSavePsk->setChecked( it->getSavePsk() );
			ProfileNetworkGeneralOptionsWidget->PingCheckBox->setChecked( it->getDoPingIP() );
			ProfileNetworkGeneralOptionsWidget->PingIPLineEdit->setText( it->getPingHostIP() );

			ProfileNetworkVirtualIpOptionsWidget->LocalVirtualIpEdit->setText( it->getLocalVirtualIP() );
			ProfileNetworkVirtualIpOptionsWidget->RemoteVirtualIpLineEdit->setText( it->getRemoteVirtualIP() );

			// 			ProfileNetworkGeneralOptionsWidget->RemoteNetAddrLineEdit->setText( it->getRemoteNetAddr() );
			//
			// 			if (!it->getRemoteNetMask().isEmpty())
			// 				ProfileNetworkGeneralOptionsWidget->RemoteNetMaskComboBox->setCurrentText( it->getRemoteNetMask() );


			if ( it->getUseUdp() )
				ProfileNetworkNatOptionsWidget->UseUdpCheckbox->setChecked( true );
			else
				ProfileNetworkNatOptionsWidget->UseUdpCheckbox->setChecked( false );

			ProfileNetworkNatOptionsWidget->UdpPortSpinbox->setValue( it->getUdpPort() );
			if ( it->getUseUdpPort() )
				ProfileNetworkNatOptionsWidget->UdpPortCheckbox->setChecked( true );
			else
				ProfileNetworkNatOptionsWidget->UdpPortCheckbox->setChecked( false );

			ProfileNetworkNatOptionsWidget->UseUdpCheckbox->setEnabled( true );
			ProfileNetworkNatOptionsWidget->UdpPortCheckbox->setEnabled( true );
			if ( it->getUseUdp() )
				ProfileNetworkNatOptionsWidget->UdpPortCheckbox->setEnabled( true );
			else
				ProfileNetworkNatOptionsWidget->UdpPortCheckbox->setEnabled( false );

			ProfileNetworkVirtualIpOptionsWidget->setEnabled( true );

			ProfilePptpOptionsWidget->setEnabled( false );
			ProfileOpenvpnOptionsWidget->setEnabled( true );
			ProfileCiscoOptionsWidget->setEnabled( false );
			ProfileRacoonOptionsWidget->setEnabled( false );

			if ( GlobalConfig->currentProfile->getAuthWithUsernameAndPassword() )
				ProfileUserOptionsWidget->setEnabled( true );
			else
				ProfileUserOptionsWidget->setEnabled( false );

			ProfileNetworkVirtualIpOptionsWidget->LocalVirtualIpEdit->setEnabled( false );
			ProfileNetworkVirtualIpOptionsWidget->RemoteVirtualIpLineEdit->setEnabled( false );

			if ( GlobalConfig->currentProfile->getUseUserdefinedPort() )
			{
				ProfileOpenvpnOptionsWidget->UseUserdefinedPortCheckBox->setChecked( true );
				ProfileOpenvpnOptionsWidget->UserdefinedPortSpinBox->setEnabled( true );
			}
			else
			{
				ProfileOpenvpnOptionsWidget->UseUserdefinedPortCheckBox->setChecked( false );
				ProfileOpenvpnOptionsWidget->UserdefinedPortSpinBox->setEnabled( false );
			}

			if ( it->getAuthType() == VpnAccountData::cert )
				ProfileOpenvpnOptionsWidget->UseNsCertTypeCheckBox->setEnabled( true );
			else
				ProfileOpenvpnOptionsWidget->UseNsCertTypeCheckBox->setEnabled( false );


			if ( GlobalConfig->currentProfile->getUseNsCertType() )
			{
				ProfileOpenvpnOptionsWidget->UseNsCertTypeCheckBox->setChecked( true );
				ProfileOpenvpnOptionsWidget->NsCertTypeComboBox->setEnabled( true );

				if ( GlobalConfig->currentProfile->getNsCertType() == "client" )
					ProfileOpenvpnOptionsWidget->NsCertTypeComboBox->setCurrentItem( 0 );
				else
					ProfileOpenvpnOptionsWidget->NsCertTypeComboBox->setCurrentItem( 1 );
			}
			else
			{
				ProfileOpenvpnOptionsWidget->UseNsCertTypeCheckBox->setChecked( false );
				ProfileOpenvpnOptionsWidget->NsCertTypeComboBox->setEnabled( false );
			}
			ProfileOpenvpnOptionsWidget->UserdefinedPortSpinBox->setValue( GlobalConfig->currentProfile->getUserdefinedPort() );

			if ( GlobalConfig->currentProfile->getDisableLzoCompression() )
				ProfileOpenvpnOptionsWidget->DisableLzoCompressionCheckBox->setChecked( true );
			else
				ProfileOpenvpnOptionsWidget->DisableLzoCompressionCheckBox->setChecked( false );

			ProfileOpenvpnOptionsWidget->UserdefinedPortSpinBox->setValue( GlobalConfig->currentProfile->getUserdefinedPort() );

			if ( GlobalConfig->currentProfile->getAuthWithUsernameAndPassword() )
				ProfileOpenvpnOptionsWidget->AuthWithUsernameAndPasswordCheckBox->setChecked ( true );
			else
				ProfileOpenvpnOptionsWidget->AuthWithUsernameAndPasswordCheckBox->setChecked ( false );

			if ( GlobalConfig->currentProfile->getUseTlsRemoteHost() )
			{
				ProfileOpenvpnOptionsWidget->UseTlsRemoteHostCheckBox->setChecked( true );
				ProfileOpenvpnOptionsWidget->TlsRemoteHostLineEdit->setEnabled( true );
			}
			else
			{
				ProfileOpenvpnOptionsWidget->UseTlsRemoteHostCheckBox->setChecked( false );
				ProfileOpenvpnOptionsWidget->TlsRemoteHostLineEdit->setEnabled( false );
			}


			if ( GlobalConfig->currentProfile->getUseTlsAuth() )
			{
				ProfileOpenvpnOptionsWidget->UseTlsAuthCheckBox->setChecked( true );
				ProfileOpenvpnOptionsWidget->TlsAuthURLRequester->setEnabled( true );
			}
			else
			{
				ProfileOpenvpnOptionsWidget->UseTlsAuthCheckBox->setChecked( false );
				ProfileOpenvpnOptionsWidget->TlsAuthURLRequester->setEnabled( false );
			}

			ProfileNetworkVirtualIpOptionsWidget->UseVirtualIPCheckBox->setEnabled( true );

			ProfileNetworkVirtualIpOptionsWidget->UseVirtualIPCheckBox->setChecked( GlobalConfig->currentProfile->getUseVirtualIP() );

			if ( GlobalConfig->currentProfile->getConnectionType() == VpnAccountData::openvpn )
				ProfileNetworkVirtualIpOptionsWidget->setEnabled( true );
			else
			{
				ProfileNetworkVirtualIpOptionsWidget->setEnabled( false );

				ProfileNetworkVirtualIpOptionsWidget->RemoteVirtualIpLineEdit->setText( GlobalConfig->currentProfile->getRemoteVirtualIP() );
				ProfileNetworkVirtualIpOptionsWidget->LocalVirtualIpEdit->setText( GlobalConfig->currentProfile->getLocalVirtualIP() );
			}

			ProfilePskOptionsWidget->CheckSavePsk->setChecked( it->getSavePsk() );
			ProfileUserOptionsWidget->CheckUserPass->setChecked ( it->getSaveUserPassword() );
			ProfileUserOptionsWidget->UsernameLineEdit->setText ( it->getUserName() );
			ProfileUserOptionsWidget->PasswordEdit->setText ( it->getUserPassword() );

			ProfileOpenvpnOptionsWidget->TlsAuthURLRequester->setURL ( it->getTlsAuthFile() );
			ProfileOpenvpnOptionsWidget->TlsRemoteHostLineEdit->setText( it->getTlsRemoteHost() );

			ProfileOpenvpnOptionsWidget->UseUserdefinedRemotePortCheckBox->setChecked( it->getUseRemotePort() );
			ProfileOpenvpnOptionsWidget->UserdefinedRemotePortSpinBox->setValue( it->getRemotePort() );

			ProfileOpenvpnOptionsWidget->UserdefinedFragmentSizeSpinBox->setValue( it->getFragment() );

			ProfileOpenvpnOptionsWidget->UseUserdefinedFragmentationSizeCheckBox->setChecked( it->getUseFragment() );

			ProfileNetworkHttpProxyOptionsWidget->UseHttpProxyCheckBox->setChecked( GlobalConfig->currentProfile->getUseHttpProxy() );
			ProfileNetworkHttpProxyOptionsWidget->HttpProxyLineEdit->setText( GlobalConfig->currentProfile->getHttpProxy() );
			ProfileNetworkHttpProxyOptionsWidget->HttpProxyTimeoutIntSpinBox->setValue( GlobalConfig->currentProfile->getHttpProxyTimeout() );
			ProfileNetworkHttpProxyOptionsWidget->HttpProxyPortIntNumInput->setValue( GlobalConfig->currentProfile->getHttpProxyPort() );

			if ( GlobalConfig->currentProfile->getHttpProxyAuthType() == "basic" )
				ProfileNetworkHttpProxyOptionsWidget->HttpProxyAuthTypeComboBox->setCurrentText( "Basic" );
			else if ( GlobalConfig->currentProfile->getHttpProxyAuthType() == "ntlm" )
				ProfileNetworkHttpProxyOptionsWidget->HttpProxyAuthTypeComboBox->setCurrentText( "NTLM" );
			else
				ProfileNetworkHttpProxyOptionsWidget->HttpProxyAuthTypeComboBox->setCurrentText( "Basic" );

			ProfileNetworkHttpProxyOptionsWidget->HttpProxyUserLineEdit->setText( GlobalConfig->currentProfile->getHttpProxyUser() );
			ProfileNetworkHttpProxyOptionsWidget->HttpProxyAuthPasswordEdit->setText( GlobalConfig->currentProfile->getHttpProxyPass() );

			ProfileNetworkHttpProxyOptionsWidget->UseHttpProxyAuthCheckBox->setChecked( GlobalConfig->currentProfile->getUseHttpProxyAuth() );

			if ( GlobalConfig->currentProfile->getUseHttpProxyAuth() )
			{
				ProfileNetworkHttpProxyOptionsWidget->UseHttpProxyCheckBox->setEnabled( true );
				ProfileNetworkHttpProxyOptionsWidget->HttpProxyAuthTextLabel->setEnabled( true );
				ProfileNetworkHttpProxyOptionsWidget->HttpProxyAuthTypeComboBox->setEnabled( true );
				ProfileNetworkHttpProxyOptionsWidget->HttpProxyUserTextLabel->setEnabled( true );
				ProfileNetworkHttpProxyOptionsWidget->HttpProxyUserLineEdit->setEnabled( true );
				ProfileNetworkHttpProxyOptionsWidget->HttpProxyPassTextLabel->setEnabled( true );
				ProfileNetworkHttpProxyOptionsWidget->HttpProxyAuthPasswordEdit->setEnabled( true );
			}

			if ( GlobalConfig->currentProfile->getUseOnlyCaCertAndUserAuth() )
				ProfileOpenvpnOptionsWidget->UseOnlyCaCertAndUserAuthCheckBox->setChecked( true );
			else
				ProfileOpenvpnOptionsWidget->UseOnlyCaCertAndUserAuthCheckBox->setChecked( false );

			ProfileOpenvpnOptionsWidget->UserdefiniedDigestComboBox->setCurrentText(GlobalConfig->currentProfile->getAuthenticationAlgorithm());
			ProfileSmartcardOptionsWidget->UseSmartcardCheckBox->setEnabled( true );

			//FIXME
			// 			ProfileNetworkRouteOptionsWidget->InterfaceComboBox->insertItem("tun0");
			ProfileNetworkGeneralOptionsWidget->TunnelDeviceTypeComboBox->setEnabled(true);
			ProfileNetworkGeneralOptionsWidget->TunnelDeviceTypeLabel->setEnabled(true);
		} // openvpn



		if ( it->getKeepDefaultRoute() == true )
			ProfileNetworkRouteOptionsWidget->DefaultRouteComboBox->setCurrentItem( 0 );
		else
			ProfileNetworkRouteOptionsWidget->DefaultRouteComboBox->setCurrentItem( 1 );

		ProfileSmartcardOptionsWidget->UseSmartcardCheckBox->setChecked( it->getUseSmartcard() );

		ProfileCmdExecBeforeConnectOptionsWidget->ExcuteCmdBeforeConnectCheckBox->setChecked( it->getExecuteCmdBeforeConnect() );
		ProfileCmdExecAfterConnectOptionsWidget->ExcuteCmdAfterConnectCheckBox->setChecked( it->getExecuteCmdAfterConnect() );
		ProfileCmdExecBeforeDisconnectOptionsWidget->ExcuteCmdBeforeDisconnectCheckBox->setChecked( it->getExecuteCmdBeforeDisconnect() );
		ProfileCmdExecAfterDisconnectOptionsWidget->ExcuteCmdAfterDisconnectCheckBox->setChecked( it->getExecuteCmdAfterDisconnect() );
		ProfileCmdExecBeforeConnectOptionsWidget->CmdBeforeConnectTextEdit->setText( it->getCommandBeforeConnect() );
		ProfileCmdExecAfterConnectOptionsWidget->CmdAfterConnectTextEdit->setText( it->getCommandAfterConnect() );
		ProfileCmdExecBeforeDisconnectOptionsWidget->CmdBeforeDisconnectTextEdit->setText ( it->getCommandBeforeDisconnect() );
		ProfileCmdExecAfterDisconnectOptionsWidget->CmdAfterDisconnectTextEdit->setText ( it->getCommandAfterDisconnect() );
		ProfileCmdExecBeforeConnectOptionsWidget->CmdBeforeConnectTextEdit->setEnabled( it->getExecuteCmdBeforeConnect() );
		ProfileCmdExecAfterConnectOptionsWidget->CmdAfterConnectTextEdit->setEnabled( it->getExecuteCmdAfterConnect() );
		ProfileCmdExecBeforeDisconnectOptionsWidget->CmdBeforeDisconnectTextEdit->setEnabled( it->getExecuteCmdBeforeDisconnect() );
		ProfileCmdExecAfterDisconnectOptionsWidget->CmdAfterDisconnectTextEdit->setEnabled( it->getExecuteCmdAfterDisconnect() );
		ProfileCmdExecAfterConnectOptionsWidget->CommandAfterConnectDelayTimeNumInput->setValue(it->getCommandAfterConnectDelayTime());

		if ( GlobalConfig->currentProfile->getDoPingIP() )
			ProfileNetworkGeneralOptionsWidget->PingIPLineEdit->setEnabled( true );
		else
			ProfileNetworkGeneralOptionsWidget->PingIPLineEdit->setEnabled( false );

		ProfileCertOptionsWidget->AllowEmptyPrivateKeyPasswordCheckBox->setChecked(it->getAllowEmptyPrivateKeyPassword());
		ProfileOpenvpnOptionsWidget->AllowIpAddressChangeOfPeerCheckBox->setChecked(it->getAllowIpAddressChangeOfPeer());

		ProfileNetworkGeneralOptionsWidget->PingIPLineEdit->setText( GlobalConfig->currentProfile->getPingHostIP() );
		ProfileNetworkGeneralOptionsWidget->PingCheckBox ->setChecked( GlobalConfig->currentProfile->getDoPingIP() );
		ProfileNetworkGeneralOptionsWidget->UseConnectionStatusCheckCheckBox->setChecked( GlobalConfig->currentProfile->getUseConnectionStatusCheck() );
		ProfileNetworkGeneralOptionsWidget->ConnectionStatusSuccessCountNumInput->setValue( GlobalConfig->currentProfile->getConnectionStatusCheckSuccessCount() );
		ProfileNetworkGeneralOptionsWidget->ConnectionStatusCheckIntervalNumInput->setValue( GlobalConfig->currentProfile->getConnectionStatusInterval() );
		ProfileNetworkGeneralOptionsWidget->DoReconnectAfterConnectionLostCheckBox->setChecked( GlobalConfig->currentProfile->getDoReconnectAfterConnectionLost() );

		ProfileNetworkRouteOptionsWidget->UseExtraNetworkRoutesCheckbox->setChecked( it->getUseAdditionalNetworkRoutes() );
		QStringList AdditionalNetworkRoutes = it->getAdditionalNetworkRoutes();
		// example entry:
		// <network>/<netmask>#<gateway>

		for ( QStringList::Iterator it2 = AdditionalNetworkRoutes.begin() ; it2 != AdditionalNetworkRoutes.end(); ++it2 )
		{
			QString networkstring = *it2;
			QString Network = networkstring.section( '#', 0, 0 ).section( '/', 0, 0 );
			QString Netmask = networkstring.section( '#', 0, 0 ).section( '/', 1, 1 );
			QString Gateway = networkstring.section( '#', 1, 1 ).section( '/', 0, 0 );
			QString Interface = networkstring.section( '#', 2, 2 );

			ProfileNetworkRouteOptionsWidget->NetworkListView->insertItem( new QListViewItem( ProfileNetworkRouteOptionsWidget->NetworkListView, Network, Netmask, Gateway, Interface ) );

		}

		ProfileNetworkGeneralOptionsWidget->RemoteNetAddrLineEdit->setText( it->getRemoteNetAddr() );
		if ( !it->getRemoteNetMask().isEmpty() )
			ProfileNetworkGeneralOptionsWidget->RemoteNetMaskComboBox->setCurrentText( it->getRemoteNetMask() );

		connectionTypeChanged( ProfileGeneralOptionsWidget->ConnectionTypeComboBox->currentItem() );
		ProfileCertOptionsWidget->AuthTypeComboBox->setCurrentItem( it->getAuthType() );
		ProfilePskOptionsWidget->AuthTypeComboBox->setCurrentItem( it->getAuthType() );
		ProfileCertOptionsWidget->x509certURLRequester->setFilter( "*.pem *.crt" );
		ProfileCertOptionsWidget->certpathURLRequester->setMode( KFile::Directory );


		ProfileSmartcardOptionsWidget->UsePkcs11ProvidersCheckBox->setChecked(it->getUsePkcs11Providers());

		
		if (!it->getPkcs11Id().isEmpty())
			ProfileSmartcardOptionsWidget->Pkcs11IdComboBox->insertItem(it->getPkcs11Id());
		if (!it->getPkcs11Slot().isEmpty())
			ProfileSmartcardOptionsWidget->Pkcs11SlotComboBox->insertItem(it->getPkcs11Slot());
		
// 		QString Pkcs11SlotType = it->getPkcs11SlotType();
// 		if (Pkcs11SlotType == "id")
// 			ProfileSmartcardOptionsWidget->Pkcs11SlotTypeComboBox->setCurrentText(i18n("ID"));
// 		else if (Pkcs11SlotType == "name")
// 			ProfileSmartcardOptionsWidget->Pkcs11SlotTypeComboBox->setCurrentText(i18n("Name"));
// 		else
// 			ProfileSmartcardOptionsWidget->Pkcs11SlotTypeComboBox->setCurrentText(i18n("Label"));
		ProfileSmartcardOptionsWidget->Pkcs11SlotTypeComboBox->setCurrentText(i18n("ID"));
		ProfileSmartcardOptionsWidget->Pkcs11SlotTypeComboBox->setEnabled(false);
		ProfileSmartcardOptionsWidget->Pkcs11SlotTypeLabel->setEnabled(false);

		QString Pkcs11IdType = it->getPkcs11IdType();
		if (Pkcs11IdType == "id")
			ProfileSmartcardOptionsWidget->Pkcs11IdTypeComboBox->setCurrentText(i18n("ID"));
		else if (Pkcs11IdType == "label")
			ProfileSmartcardOptionsWidget->Pkcs11IdTypeComboBox->setCurrentText(i18n("Label"));
		else
			ProfileSmartcardOptionsWidget->Pkcs11IdTypeComboBox->setCurrentText(i18n("Subject"));

// 		ProfileSmartcardOptionsWidget->Pkcs11IdTypeComboBox->setCurrentText(i18n("ID"));
// 		ProfileSmartcardOptionsWidget->Pkcs11IdTypeComboBox->setEnabled(false);

		QString Pkcs11SignMode = it->getPkcs11SignMode();
		if (Pkcs11SignMode == "auto")
			ProfileSmartcardOptionsWidget->Pkcs11SignModeComboBox->setCurrentText(i18n("auto"));
		else if (Pkcs11SignMode == "sign")
			ProfileSmartcardOptionsWidget->Pkcs11SignModeComboBox->setCurrentText(i18n("sign"));
		else if (Pkcs11SignMode == "recover")
			ProfileSmartcardOptionsWidget->Pkcs11SignModeComboBox->setCurrentText(i18n("recover"));
		else
			ProfileSmartcardOptionsWidget->Pkcs11SignModeComboBox->setCurrentText(i18n("any"));

		ProfileSmartcardOptionsWidget->Pkcs11ProvidersURLRequester->setURL(it->getPkcs11Providers());

		if ( GlobalConfig->currentProfile->getAuthType() == VpnAccountData::cert)
		{
			if (GlobalConfig->currentProfile->getUseSmartcard() && ProfileSmartcardOptionsWidget->UseSmartcardCheckBox->isEnabled() )
			{
			ProfileCertOptionsWidget->x509certURLRequester->setEnabled(false);
			ProfileCertOptionsWidget->PrivkeyPasswordEdit->setEnabled(false);
			ProfileCertOptionsWidget->SavePrivateKeyPasswordCheckBox->setEnabled(false);
			ProfileCertOptionsWidget->privkeypathURLRequester->setEnabled(false);
			ProfileCertOptionsWidget->LabelCertificate->setEnabled(false);
			ProfileCertOptionsWidget->LabelPrivateKeyPath->setEnabled(false);
			}
			else
			{
			ProfileCertOptionsWidget->x509certURLRequester->setEnabled(true);
			ProfileCertOptionsWidget->PrivkeyPasswordEdit->setEnabled(true);
			ProfileCertOptionsWidget->SavePrivateKeyPasswordCheckBox->setEnabled(true);
			ProfileCertOptionsWidget->privkeypathURLRequester->setEnabled(true);
			ProfileCertOptionsWidget->LabelCertificate->setEnabled(true);
			ProfileCertOptionsWidget->LabelPrivateKeyPath->setEnabled(true);
			}
		}
		
	}
	else
	{
		// 		ProfileGeneralOptionsWidget->ProfileComboBox->setCurrentText( "" );
		// 		ProfileNetworkRouteOptionsWidget->ProfileComboBox->setCurrentText( "" );
		// 		ProfileNetworkNatOptionsWidget->ProfileComboBox->setCurrentText( "" );
		// 		ProfileNetworkVirtualIpOptionsWidget->ProfileComboBox->setCurrentText( "" );
		// 		ProfileCertPskOptionsWidget->ProfileComboBox->setCurrentText( "" );
		// 		ProfileUserOptionsWidget->ProfileComboBox->setCurrentText( "" );
		// 		ProfileOpenvpnOptionsWidget->ProfileComboBox->setCurrentText( "" );
		// 		ProfilePptpOptionsWidget->ProfileComboBox->setCurrentText( "" );
		// 		ProfileRacoonOptionsWidget->ProfileComboBox->setCurrentText( "" );
		// 		ProfileCiscoOptionsWidget->ProfileComboBox->setCurrentText( "" );
		// 		ProfileCmdExecBeforeConnectOptionsWidget->ProfileComboBox->setCurrentText( "" );
		// 		ProfileCmdExecBeforeDisconnectOptionsWidget->ProfileComboBox->setCurrentText( "" );
		// 		ProfileCmdExecAfterConnectOptionsWidget->ProfileComboBox->setCurrentText( "" );
		// 		ProfileCmdExecAfterDisconnectOptionsWidget->ProfileComboBox->setCurrentText( "" );

		ProfileGeneralOptionsWidget->setEnabled( false );
		ProfileNetworkRouteOptionsWidget->setEnabled( false );
		ProfileNetworkNatOptionsWidget->setEnabled( false );
		ProfileNetworkVirtualIpOptionsWidget->setEnabled( false );
		ProfileCertOptionsWidget->setEnabled( false );
		ProfilePskOptionsWidget->setEnabled( false );
		ProfileUserOptionsWidget->setEnabled( false );
		ProfileOpenvpnOptionsWidget->setEnabled( false );
		ProfilePptpOptionsWidget->setEnabled( false );
		ProfileRacoonOptionsWidget->setEnabled( false );
		ProfileCiscoOptionsWidget->setEnabled( false );
		ProfileCmdExecBeforeConnectOptionsWidget->setEnabled( false );
		ProfileCmdExecBeforeDisconnectOptionsWidget->setEnabled( false );
		ProfileCmdExecAfterConnectOptionsWidget->setEnabled( false );
		ProfileCmdExecAfterDisconnectOptionsWidget->setEnabled( false );
		ProfileGeneralOptionsWidget->NewSessionPushButton->setEnabled( true );

	}
}

void PreferencesDialog::saveSessionClicked()
{


	if ( !showOnlyProfiles )
	{
		GlobalConfig->pathToVpnc = DaemonOptionsWidget->VpncPathInput->url();
		GlobalConfig->pathToFreeswan = DaemonOptionsWidget->FreeswanPathInput->url();
		GlobalConfig->pathToRacoon = DaemonOptionsWidget->RacoonPathInput->url();

		if ( DaemonOptionsWidget->PptpDebugLevelComboBox->currentText() == "low" )
			GlobalConfig->PptpDebugLevel = 0;
		else if ( DaemonOptionsWidget->PptpDebugLevelComboBox->currentText() == "default" )
			GlobalConfig->PptpDebugLevel = 1;
		else if ( DaemonOptionsWidget->PptpDebugLevelComboBox->currentText() == "high" )
			GlobalConfig->PptpDebugLevel = 2;


		GlobalConfig->pathToPppd = DaemonOptionsWidget->PppdPathInput->url();
		GlobalConfig->pathToPptp = DaemonOptionsWidget->PptpPathInput->url();
		GlobalConfig->pathToOpenvpn = DaemonOptionsWidget->OpenvpnPathInput->url();


		GlobalConfig->pathToIptables = HelperProgramOptionsWidget->IptablesPathInput->url();
		GlobalConfig->pathToOpenssl = HelperProgramOptionsWidget->OpenSSLPathInput->url();
		GlobalConfig->pathToKill = HelperProgramOptionsWidget->KillPathInput->url();
		GlobalConfig->pathToKillall = HelperProgramOptionsWidget->KillallPathInput->url();
		GlobalConfig->pathToPing = HelperProgramOptionsWidget->PingPathInput->url();
		GlobalConfig->pathToIp = HelperProgramOptionsWidget->IpPathInput->url();
		GlobalConfig->pathToIfconfig = HelperProgramOptionsWidget->IfconfigPathInput->url();
		GlobalConfig->pathToRoute = HelperProgramOptionsWidget->RoutePathInput->url();
		GlobalConfig->pathToPkcs11Tool = HelperProgramOptionsWidget->Pkcs11ToolPathInput->url();

		GlobalConfig->minimizeAfterConnect = ConnectOptionsWidget->checkMinimizeAfterConnectCheck->isChecked();
		GlobalConfig->showDebugConsole = DebugOptionsWidget->showDebugCheck->isChecked();
		GlobalConfig->writeLogFile = DebugOptionsWidget->WriteLogCheck->isChecked();
		GlobalConfig->KvpncDebugLevel = DebugOptionsWidget->spinKvpncDebugLevel->value ();
		GlobalConfig->RacoonDebugLevel = DaemonOptionsWidget->RacoonDebugLevelComboBox->currentText ();
		GlobalConfig->VpncDebugLevel = DaemonOptionsWidget->spinVpncDebugLevel->value ();
		GlobalConfig->OpenvpnDebugLevel = DaemonOptionsWidget->spinOpenvpnDebugLevel->value () + 1;
		GlobalConfig->enableDebugPppd = DaemonOptionsWidget->DebugPppdcheckBox->isChecked();
		GlobalConfig->enableFreeswanVerbose = DaemonOptionsWidget->FreeswanVerboseCheckBox->isChecked();
		GlobalConfig->tryConnectTimeout = ProfileCiscoOptionsWidget->PeerTimeoutIntNumInput->value();
		GlobalConfig->useSilentQuit = ConnectOptionsWidget->SilentQuitcheckBox->isChecked();
		GlobalConfig->dontQuitOnCloseEvent = GeneralOptionsWidget->DontQuitOnCloseEventCheckBox->isChecked();
		GlobalConfig->hideMainWindow = GeneralOptionsWidget->HideOnStartupCheckBox->isChecked ();
		GlobalConfig->useKwallet = GeneralOptionsWidget->useKwalletCheckBox->isChecked();
		GlobalConfig->programsInPath = DaemonOptionsWidget->ProgramsInPathcheckBox->isChecked();
		GlobalConfig->holdGeneratedScripts = DebugOptionsWidget->KeepConnectionFilesCheckBox->isChecked();
		GlobalConfig->InfoLogColor = LogOptionsWidget->InfoLogLabel->paletteBackgroundColor ();
		GlobalConfig->RemoteLogColor = LogOptionsWidget->RemoteLogLabel->paletteBackgroundColor ();
		GlobalConfig->ErrorLogColor = LogOptionsWidget->ErrorLogLabel->paletteBackgroundColor ();
		GlobalConfig->SuccessLogColor = LogOptionsWidget->SuccessLogLabel->paletteBackgroundColor ();
		GlobalConfig->DebugLogColor = LogOptionsWidget->DebugLogLabel->paletteBackgroundColor ();
		GlobalConfig->useColorizedLogOutput = LogOptionsWidget->UseColorizedLogOutputcheckBox->isChecked();
		GlobalConfig->showInterfaceIPinTooltip = DaemonOptionsWidget->ShowInterfaceIPinTooltipCheckBox->isChecked();
		GlobalConfig->doAutoConnectAtStartup = ConnectOptionsWidget->DoAutoConnectCheckBox->isChecked();
		GlobalConfig->LogViewerFontSize = LogOptionsWidget->LogFontSizeSpinBox->value();
		GlobalConfig->doKillL2tpdIfStillRunning =DaemonOptionsWidget->DoKillL2tpdIfStillRunningCheckBox->isChecked();
		GlobalConfig->doKillRacoonIfStillRunning =DaemonOptionsWidget->DoKillRacoonIfStillRunningCheckBox->isChecked();
	}


	if ( GlobalConfig->currentProfile == 0 )
		return ;

	canAccept = true;

	GlobalConfig->appPointer->setOverrideCursor( QCursor( Qt::WaitCursor ) );

	VpnAccountData *profile = GlobalConfig->currentProfile;

	//QString itemString=ConnectionTypeComboBox->currentText();
	int item = ProfileGeneralOptionsWidget->ConnectionTypeComboBox->currentItem() ;
	GlobalConfig->currentProfile->setConnectionType( ( VpnAccountData::ConnectionType ) ( item ) );

	// 	KMessageBox::information(0,"connection type changed: "+QString().setNum(item),QString("type set"));

	profile->setDescription( ProfileGeneralOptionsWidget->DescriptionLineEdit->text() );

	// cisco
	if ( item == VpnAccountData::cisco )
	{

		// 		std::cout << "currentItem: " << ProfileGeneralOptionsWidget->ConnectionTypeComboBox->currentItem() << ", guessed type: cisco" << std::endl;


		if ( ProfileUserOptionsWidget->CheckUserPass->isChecked() && ! ProfileUserOptionsWidget->UsernameLineEdit->text().isEmpty() )
		{
			profile->setSaveUserPassword( true );
			profile->setUserPassword( ProfileUserOptionsWidget->UsernameLineEdit->text() );
		}
		else
		{
			profile->setSaveUserPassword( false );
		}

		if ( ProfilePskOptionsWidget->CheckSavePsk->isChecked() && !ProfilePskOptionsWidget->PSKLineEdit->text().isEmpty() )
		{
			profile->setSavePsk( true );
			profile->setPreSharedKey( ProfilePskOptionsWidget->PSKLineEdit->text() );
		}
		else
		{
			profile->setSavePsk( false );
		}
		profile->setAllowEmptyGroupPassword( ProfileCiscoOptionsWidget->AllowEmptyGroupPasswordCheckBox->isChecked() );
		profile->setUseXauthInteractive( ProfileCiscoOptionsWidget->UseXauthInteractiveCheckBox->isChecked() );
		profile->setUseGlobalIpsecSecret( ProfileCiscoOptionsWidget->UseGlobalIpsecSecretCheckbox->isChecked());

		profile->setNtDomainName(ProfileUserOptionsWidget->NtDomainNameLineedit->text() );

		if ( ProfileUserOptionsWidget->NtDomainNameCheckbox->isChecked() )
		{
			profile->setNtDomainName( ProfileUserOptionsWidget->NtDomainNameLineedit->text() );
			profile->setUseNtDomainName( true );
		}
		else
		{
			profile->setUseNtDomainName( false );
		}
		profile->setUseLocalPort(ProfileCiscoOptionsWidget->LocalPortCheckbox->isChecked ( ) );
		profile->setLocalPort(ProfileCiscoOptionsWidget->LocalPortSpinbox->value( ) );

		profile->setPeerTimeout( ProfileCiscoOptionsWidget->PeerTimeoutIntNumInput->value() );
	}
	else if ( item == VpnAccountData::racoon || item == VpnAccountData::l2tpd_racoon || item == VpnAccountData::freeswan || item == VpnAccountData::l2tpd_freeswan )
	{
		profile->setSpecialRemoteID( ProfileCertOptionsWidget->RemoteIDLineEdit->text() );

		if ( profile->getAuthType() == VpnAccountData::cert )
			profile->setUseSpecialRemoteID( ProfileCertOptionsWidget->UseSpecialRemoteIDcheckBox->isChecked() );
		else
			profile->setUseSpecialRemoteID( ProfilePskOptionsWidget->UseSpecialRemoteIDcheckBox->isChecked() );

		profile->setDisableOpportunisticEncryption( ProfileRacoonOptionsWidget->DisableOpportunisticEncryptionCheckBox->isChecked( ) );

		profile->setPrivateKey( ProfileCertOptionsWidget->privkeypathURLRequester->url() );
		profile->setPrivateKeyPass( ProfileCertOptionsWidget->PrivkeyPasswordEdit->text() );
		profile->setSaveUserPassword ( ProfileCertOptionsWidget->SavePrivateKeyPasswordCheckBox->isChecked() );

		if ( item == VpnAccountData::racoon || item == VpnAccountData::freeswan )
		{
			bool validAddr = true;
			if ( ProfileNetworkGeneralOptionsWidget->RemoteNetAddrLineEdit->text().contains( '.' ) != 3 )
			{
				KMessageBox::error ( this, i18n( "No IP address entered!" ), i18n( "No IP Address" ) );
				GlobalConfig->appendLogEntry( i18n( "No IP address entered!" ) , GlobalConfig->error );
				validAddr = false;
			}
			else
			{
				QString addr = ProfileNetworkGeneralOptionsWidget->RemoteNetAddrLineEdit->text();
				int part0 = addr.section( '.', 0, 0 ).toInt();
				int part1 = addr.section( '.', 1, 1 ).toInt();
				int part2 = addr.section( '.', 2, 2 ).toInt();
				int part3 = addr.section( '.', 3, 3 ).toInt();
	
				/*
							LogOutput->append ("part0: "+QString().setNum(part0));
							LogOutput->append ("part1: "+QString().setNum(part1));
							LogOutput->append ("part2: "+QString().setNum(part2));
							LogOutput->append ("part3: "+QString().setNum(part3));
				*/
				if ( ( part0 < 1 || part0 > 254 ) || ( part1 < 0 || part1 > 254 ) || ( part2 < 0 || part2 > 254 ) || ( part3 < 0 || part3 > 254 ) )
				{
					KMessageBox::error ( this, i18n( "IP address (remote net) is not valid!" ), i18n( "Invalid IP Address" ) );
					// 				GlobalConfig->appendLogEntry( i18n( "IP address (remote net) is not valid!" ) ,GlobalConfig->error);
					canAccept = false;
					validAddr = false;
				}
				if ( validAddr == true )
				{
					profile->setRemoteNetAddr( addr );
					profile->setRemoteNetMask( ProfileNetworkGeneralOptionsWidget->RemoteNetMaskComboBox->currentText() );
				}
			}
		}

		if ( ProfileCertOptionsWidget->AuthTypeComboBox->currentItem() == 0 )
			profile->setAuthType( VpnAccountData::cert );
		else
			profile->setAuthType( VpnAccountData::psk );

		if ( ProfilePskOptionsWidget->AuthTypeComboBox->currentItem() == 0 )
			profile->setAuthType( VpnAccountData::cert );
		else
			profile->setAuthType( VpnAccountData::psk );


		profile->setX509Certificate( ProfileCertOptionsWidget->x509certURLRequester->url() );
		profile->setCertPath( ProfileCertOptionsWidget->certpathURLRequester->url() );

		profile->setPreSharedKey( ProfilePskOptionsWidget->PSKLineEdit->text() );

		if ( ProfileGeneralOptionsWidget->ConnectionTypeComboBox->currentItem() == VpnAccountData::racoon ||
		        ProfileGeneralOptionsWidget->ConnectionTypeComboBox->currentItem() == VpnAccountData::l2tpd_racoon
		   )
		{
			if ( ProfileRacoonOptionsWidget->HashAlgoComboBox->currentText() == "SHA1" )
			{
				profile->setHashAlgo( "sha1" );
			}
			if ( ProfileRacoonOptionsWidget->HashAlgoComboBox->currentText() == "MD5" )
			{
				profile->setHashAlgo( "md5" );
			}

			profile->setIkeGroup( ProfileRacoonOptionsWidget->DHGroupComboBox->currentText() );
			profile->setEncryptionAlgorithm( ProfileRacoonOptionsWidget->EncryptionAlgorithmComboBox->currentText() );
			profile->setAuthenticationAlgorithm( ProfileRacoonOptionsWidget->AuthenticationAlgorithmComboBox->currentText() );

			if ( ProfileGeneralOptionsWidget->ConnectionTypeComboBox->currentItem() == VpnAccountData::l2tpd_racoon )
			{
				profile->setUserName( ProfileUserOptionsWidget->UsernameLineEdit->text() );

				if ( ProfileUserOptionsWidget->CheckUserPass->isChecked() )
				{
					profile->setSaveUserPassword( true );
					profile->setUserPassword( ProfileUserOptionsWidget->PasswordEdit->text() );
				}
				else
					profile->setSaveUserPassword( true );
			}

		}
	}
	else if ( item == VpnAccountData::pptp )
	{

		bool validAddr = true;
		if ( !ProfileNetworkGeneralOptionsWidget->RemoteNetAddrLineEdit->text().isEmpty() )
		{
			if ( ProfileNetworkGeneralOptionsWidget->RemoteNetAddrLineEdit->text().contains( '.' ) != 3 )
			{
				//KMessageBox::error ( this, i18n( "No IP address entered!" ), i18n( "No IP Address" ) );
				validAddr = false;
			}
			else
			{
				QString addr = ProfileNetworkGeneralOptionsWidget->RemoteNetAddrLineEdit->text();
				int part0 = addr.section( '.', 0, 0 ).toInt();
				int part1 = addr.section( '.', 1, 1 ).toInt();
				int part2 = addr.section( '.', 2, 2 ).toInt();
				int part3 = addr.section( '.', 3, 3 ).toInt();

				/*
							LogOutput->append ("part0: "+QString().setNum(part0));
							LogOutput->append ("part1: "+QString().setNum(part1));
							LogOutput->append ("part2: "+QString().setNum(part2));
							LogOutput->append ("part3: "+QString().setNum(part3));
				*/

				if ( ( part0 < 1 || part0 > 254 ) || ( part1 < 0 || part1 > 254 ) || ( part2 < 0 || part2 > 254 ) || ( part3 < 0 || part3 > 254 ) )
				{
					KMessageBox::error ( this, i18n( "Invalid values in IP address (remote net)!" ), i18n( "Invalid Values in IP Address" ) );
					GlobalConfig->appendLogEntry( i18n( "Invalid values in IP address (remote net)!" ) , GlobalConfig->error );
					validAddr = false;
				}


				if ( validAddr == true )
				{
					profile->setRemoteNetAddr( addr );
					profile->setRemoteNetMask( ProfileNetworkGeneralOptionsWidget->RemoteNetMaskComboBox->currentText() );
				}

			}
		}
		else
		{
			profile->setRemoteNetAddr( "" );
			profile->setRemoteNetMask( "" );
		}

		// 		if (ProfileNetworkRouteOptionsWidget->DefaultRouteComboBox->currentText() == i18n("Keep default route"))
		if ( ProfileNetworkRouteOptionsWidget->DefaultRouteComboBox->currentItem() == 0 )
		{
			profile->setSetDefaultRoute( false );
			profile->setReplaceDefaultRoute( false );
			profile->setKeepDefaultRoute( true );
		}

		profile->setAllowStatefulMode( ProfilePptpOptionsWidget->AllowStatefulModeCheckbox->isChecked() );
		profile->setUseNoIpDefault( ProfilePptpOptionsWidget->UseNoIpDefaultCheckbox->isChecked() );
		profile->setDisableMPPEComp( ProfilePptpOptionsWidget->UseNoMPPECompressionCheckbox->isChecked() );
		profile->setRefuseEap( ProfilePptpOptionsWidget->RefuseEapCheckbox->isChecked() );
		profile->setRequireMppe( ProfilePptpOptionsWidget->RequireMppeCheckbox->isChecked() );
		profile->setRefuse128BitEncryption( ProfilePptpOptionsWidget->Refuse128BitEncryptionCheckbox->isChecked() );
		profile->setRefuse40BitEncryption( ProfilePptpOptionsWidget->Refuse40BitEncryptionCheckbox->isChecked() );
		profile->setDisableMPPEComp( ProfilePptpOptionsWidget->UseNoMPPECompressionCheckbox->isChecked() );
		profile->setUseGetDnsFromPeer( ProfilePptpOptionsWidget->GetDnsFromPeerCheckbox->isChecked() );
		profile->setUseDnsServer( ProfilePptpOptionsWidget->DnsServerCheckbox->isChecked() );
		profile->setDnsServer( ProfilePptpOptionsWidget->DnsServerLineedit->text() );
		profile->setUseNoBsdComp( ProfilePptpOptionsWidget->UseNoBsdCompCheckbox->isChecked() );
		profile->setUseNoDeflate( ProfilePptpOptionsWidget->UseNoDeflateCheckbox->isChecked() );
		// 		if (ProfileNetworkRouteOptionsWidget->DefaultRouteComboBox->currentText() == i18n("Keep default route"))
	
		profile->setNtDomainName(ProfileUserOptionsWidget->NtDomainNameLineedit->text() );

		if ( ProfileUserOptionsWidget->NtDomainNameCheckbox->isChecked() )
		{
			profile->setNtDomainName( ProfileUserOptionsWidget->NtDomainNameLineedit->text() );
			profile->setUseNtDomainName( true );
		}
		else
		{
			profile->setUseNtDomainName( false );
		}
			if (ProfilePptpOptionsWidget->AuthMethodComboBox->currentItem() == 0)
				profile->setAuthMethod("chap");
			else
				profile->setAuthMethod("pap");

	}
	else if ( item == VpnAccountData::openvpn )
	{

		ProfileNetworkGeneralOptionsWidget->RemoteNetAddrLineEdit->setEnabled( false );
		ProfileNetworkGeneralOptionsWidget->RemoteNetMaskComboBox->setEnabled( false );

		bool validAddr = true;
		if ( ProfileNetworkGeneralOptionsWidget->PingCheckBox->isChecked() && ProfileNetworkGeneralOptionsWidget->PingIPLineEdit->text().contains( '.' ) != 3 )
		{
			KMessageBox::error ( this, i18n( "No IP address entered!" ), i18n( "No IP Address" ) );
			GlobalConfig->appendLogEntry( i18n( "No IP address entered!" ) , GlobalConfig->error );
			validAddr = false;
		}
		else
		{
			QString addr = ProfileNetworkGeneralOptionsWidget->PingIPLineEdit->text();
			// 					int part0 = addr.section( '.', 0, 0 ).toInt();
			// 					int part1 = addr.section( '.', 1, 1 ).toInt();
			// 					int part2 = addr.section( '.', 2, 2 ).toInt();
			// 					int part3 = addr.section( '.', 3, 3 ).toInt();

			/*
						LogOutput->append ("part0: "+QString().setNum(part0));
						LogOutput->append ("part1: "+QString().setNum(part1));
						LogOutput->append ("part2: "+QString().setNum(part2));
						LogOutput->append ("part3: "+QString().setNum(part3));
			*/ 
			// 					if ( ( part0 < 1 || part0 > 254 ) || ( part1 < 0 || part1 > 254 ) || ( part2 < 0 || part2 > 254 ) || ( part3 < 0 || part3 > 254 ) )
			// 					{
			// 						KMessageBox::error ( this, i18n( "IP address (remote net) is invalid!" ), i18n( "Invalid IP Address" ) );
			// 						GlobalConfig->appendLogEntry(i18n( "IP address (remote net) is invalid!" ) ,GlobalConfig->error);
			// 						validAddr = false;
			// 					}


		}

		// 		QString LocalVirtualIp = ProfileNetworkVirtualIpOptionsWidget->LocalVirtualIpEdit->text();
		// 		if (Utils( GlobalConfig ).isValidIPv4Adress(LocalVirtualIp) == false)
		// 			KMessageBox::error ( this, i18n( "No valid IP address entered!" ), i18n( "No Valid IP Address" ) );
		// 		else
		// 		{
		// 			profile->setLocalVirtualIP( LocalVirtualIp);
		// 		}
		//
		// 		QString RemoteVirtualIp = RemoteVirtualIpLineEdit->text();
		// 		if (Utils( GlobalConfig ).isValidIPv4Adress(RemoteVirtualIp) == false)
		// 			KMessageBox::error ( this, i18n( "No valid IP address entered!" ), i18n( "No Valid IP Address" ) );
		// 		else
		// 		{
		// 			profile->setRemoteVirtualIP( RemoteVirtualIp);
		// 		}


		if ( ProfileCertOptionsWidget->AuthTypeComboBox->currentItem() == 0 )
			profile->setAuthType( VpnAccountData::cert );
		else
			profile->setAuthType( VpnAccountData::psk );

		if ( ProfilePskOptionsWidget->AuthTypeComboBox->currentItem() == 0 )
			profile->setAuthType( VpnAccountData::cert );
		else
			profile->setAuthType( VpnAccountData::psk );

		profile->setPreSharedKeyFile( ProfilePskOptionsWidget->PSKFileURLRequester->url() );
		profile->setPskIsInFile( ProfilePskOptionsWidget->PskInFileCheckBox->isChecked() );
		profile->setX509Certificate( ProfileCertOptionsWidget->x509certURLRequester->url() );
		profile->setCaCertificate( ProfileCertOptionsWidget->CaCertpathURLRequester->url() );
		profile->setCertPath( ProfileCertOptionsWidget->certpathURLRequester->url() );
		profile->setPrivateKey ( ProfileCertOptionsWidget->privkeypathURLRequester->url() );
		profile->setPrivateKeyPass ( ProfileCertOptionsWidget->PrivkeyPasswordEdit->text() );
		profile->setSavePrivateKeyPassword( ProfileCertOptionsWidget->SavePrivateKeyPasswordCheckBox->isChecked() );
		
		if (ProfileNetworkGeneralOptionsWidget->TunnelDeviceTypeComboBox->currentItem() == 1)
			profile->setTunnelDeviceType( "tap");
		else
			profile->setTunnelDeviceType("tun");

		profile->setUserdefinedPort( ProfileOpenvpnOptionsWidget->UserdefinedPortSpinBox->value() );
		profile->setUseUserdefinedPort( ProfileOpenvpnOptionsWidget->UseUserdefinedPortCheckBox->isChecked() );
		profile->setDisableLzoCompression ( ProfileOpenvpnOptionsWidget->DisableLzoCompressionCheckBox->isChecked() );

		profile->setUserdefinedPort( ProfileOpenvpnOptionsWidget->UserdefinedPortSpinBox->value() );

		profile->setAuthWithUsernameAndPassword( ProfileOpenvpnOptionsWidget->AuthWithUsernameAndPasswordCheckBox->isChecked () );
		profile->setUserName( ProfileUserOptionsWidget->UsernameLineEdit->text() );
		profile->setUserPassword( ProfileUserOptionsWidget->PasswordEdit->text() );


		GlobalConfig->currentProfile->setUserdefiniedCipher( ProfileOpenvpnOptionsWidget->UserdefiniedCipherComboBox->currentText() );
		GlobalConfig->currentProfile->setUseUserdefiniedCipher( ProfileOpenvpnOptionsWidget->UseUserdefiniedCipherCheckBox->isChecked() );

		GlobalConfig->currentProfile->setUseTlsAuth( ProfileOpenvpnOptionsWidget->UseTlsAuthCheckBox->isChecked() );
		GlobalConfig->currentProfile->setTlsAuthFile( ProfileOpenvpnOptionsWidget->TlsAuthURLRequester->url() );

		GlobalConfig->currentProfile->setUseTlsRemoteHost( ProfileOpenvpnOptionsWidget->UseTlsRemoteHostCheckBox->isChecked() );
		GlobalConfig->currentProfile->setTlsRemoteHost( ProfileOpenvpnOptionsWidget->TlsRemoteHostLineEdit->text() );

		GlobalConfig->currentProfile->setUseHttpProxy( ProfileNetworkHttpProxyOptionsWidget->UseHttpProxyCheckBox->isChecked() );
		GlobalConfig->currentProfile->setHttpProxy( ProfileNetworkHttpProxyOptionsWidget->HttpProxyLineEdit->text( ) );
		GlobalConfig->currentProfile->setHttpProxyPort( ProfileNetworkHttpProxyOptionsWidget->HttpProxyPortIntNumInput->value( ) );
		GlobalConfig->currentProfile->setHttpProxyTimeout( ProfileNetworkHttpProxyOptionsWidget->HttpProxyTimeoutIntSpinBox->value() );

		GlobalConfig->currentProfile->setMssfix( ProfileOpenvpnOptionsWidget->UserdefinedPacketSizeSpinBox->value() );
		GlobalConfig->currentProfile->setFragment( ProfileOpenvpnOptionsWidget->UserdefinedFragmentSizeSpinBox->value() );
		GlobalConfig->currentProfile->setUseMssfix( ProfileOpenvpnOptionsWidget->UseUserdefinedPacketSizeCheckBox->isChecked() );
		GlobalConfig->currentProfile->setUseFragment( ProfileOpenvpnOptionsWidget->UseUserdefinedFragmentationSizeCheckBox->isChecked() );

		if ( ProfilePskOptionsWidget->AuthTypeComboBox->currentItem() == 1 && ProfilePskOptionsWidget->PskInFileCheckBox->isChecked() && ProfilePskOptionsWidget->PSKFileURLRequester->url().isEmpty() )
		{
			KMessageBox::error ( this, i18n( "PSK file can't be empty!" ), i18n( "Empty PSK file" ) );
			// 			GlobalConfig->appendLogEntry(i18n( "PSK file can't be empty!" ) ,GlobalConfig->error);
			canAccept = false;
		}

		if ( ProfilePskOptionsWidget->AuthTypeComboBox->currentItem() == 1 && ( !ProfilePskOptionsWidget->PskInFileCheckBox->isChecked() && ProfilePskOptionsWidget->CheckSavePsk->isChecked() ) && ProfilePskOptionsWidget->PSKLineEdit->text().isEmpty() )
		{
			KMessageBox::error ( this, i18n( "PSK can't be empty!" ), i18n( "Empty PSK" ) );
			// 			GlobalConfig->appendLogEntry(i18n( "PSK can't be empty!" ) ,GlobalConfig->error);
			canAccept = false;
		}

		if ( ProfileOpenvpnOptionsWidget->UseTlsAuthCheckBox->isChecked() && ProfileOpenvpnOptionsWidget->TlsAuthURLRequester->url().isEmpty() )
		{
			KMessageBox::error ( this, i18n( "TLS remote host can't be empty!" ), i18n( "Empty TLS remote host" ) );
			// 			GlobalConfig->appendLogEntry(i18n( "TLS remote host can't be empty!" ) ,GlobalConfig->error);
			canAccept = false;
		}

		if ( ProfileNetworkHttpProxyOptionsWidget->UseHttpProxyCheckBox->isChecked() && ProfileNetworkHttpProxyOptionsWidget->HttpProxyLineEdit->text().isEmpty() )
		{
			KMessageBox::error ( this, i18n( "HTTP proxy host can't be empty!" ), i18n( "Empty HTTP proxy host" ) );
			// 			GlobalConfig->appendLogEntry(i18n( "HTTP proxy host can't be empty!" ) ,GlobalConfig->error);
			canAccept = false;
		}

		if ( ProfileOpenvpnOptionsWidget->UseUserdefinedRemotePortCheckBox->isChecked() )
			profile->setUseRemotePort( true );
		else
			profile->setUseRemotePort( false );
		profile->setRemotePort( ProfileOpenvpnOptionsWidget->UserdefinedRemotePortSpinBox->value() );


		if ( ProfileNetworkHttpProxyOptionsWidget->HttpProxyAuthTypeComboBox->currentText() == "Basic" )
			profile->setHttpProxyAuthType( "basic" );
		if ( ProfileNetworkHttpProxyOptionsWidget->HttpProxyAuthTypeComboBox->currentText() == "NTLM" )
			profile->setHttpProxyAuthType( "ntlm" );

		if ( ProfileNetworkHttpProxyOptionsWidget->UseHttpProxyCheckBox->isChecked() && ProfileNetworkHttpProxyOptionsWidget->HttpProxyUserLineEdit->text().isEmpty() )
		{
			KMessageBox::error ( this, i18n( "Username for HTTP proxy authentication can't be empty!" ), i18n( "Empty HTTP proxy username for authentication" ) );
			// 			GlobalConfig->appendLogEntry(i18n( "Username for HTTP proxy authentication can't be empty!" ) ,GlobalConfig->error);
			canAccept = false;
		}
		else
			profile->setHttpProxyUser( ProfileNetworkHttpProxyOptionsWidget->HttpProxyUserLineEdit->text() );

		if ( ProfileNetworkHttpProxyOptionsWidget->UseHttpProxyCheckBox->isChecked() && ProfileNetworkHttpProxyOptionsWidget->HttpProxyAuthPasswordEdit->text().isEmpty() )
		{
			KMessageBox::error ( this, i18n( "Password for HTTP proxy authentication can't be empty!" ), i18n( "Empty HTTP proxy password for authentication" ) );
			// 			GlobalConfig->appendLogEntry(i18n( "Password for HTTP proxy authentication can't be empty!" ) ,GlobalConfig->error);
			canAccept = false;
		}
		else
			profile->setHttpProxyPass( ProfileNetworkHttpProxyOptionsWidget->HttpProxyAuthPasswordEdit->text() );

		profile->setUseHttpProxyAuth( ProfileNetworkHttpProxyOptionsWidget->UseHttpProxyAuthCheckBox->isChecked() );

		profile->setUseOnlyCaCertAndUserAuth( ProfileOpenvpnOptionsWidget->UseOnlyCaCertAndUserAuthCheckBox->isChecked() );

		profile->setAuthenticationAlgorithm(ProfileOpenvpnOptionsWidget->UserdefiniedDigestComboBox->currentText());

	} // openvpn

	if ( ProfileNetworkGeneralOptionsWidget->PingCheckBox->isChecked() && !ProfileNetworkGeneralOptionsWidget->PingIPLineEdit->text().isEmpty() )
	{
		// do check for vailid IP
		if ( !Utils( GlobalConfig ).isValidIPv4Address( ProfileNetworkGeneralOptionsWidget->PingIPLineEdit->text() ) )
		{
			KMessageBox::error ( this, i18n( "No valid IP address entered!" ), i18n( "No Valid IP Address" ) );
			// 			GlobalConfig->appendLogEntry( i18n( "No valid IP address entered!" ) ,GlobalConfig->error);
			canAccept = false;
		}
		else
		{
			profile->setPingHostIP( ProfileNetworkGeneralOptionsWidget->PingIPLineEdit->text() );
			profile->setDoPingIP( ProfileNetworkGeneralOptionsWidget->PingCheckBox->isChecked() );
		}
	}
	else
	{
		if ( ProfileNetworkGeneralOptionsWidget->PingCheckBox->isChecked() && ProfileNetworkGeneralOptionsWidget->PingIPLineEdit->text() == QString( "" ) )
		{
			KMessageBox::error ( this, i18n( "No IP address (ping host) entered!" ), i18n( "No IP Address" ) );
			GlobalConfig->appendLogEntry( i18n( "No IP address (ping host) entered!" ) , GlobalConfig->error );
			canAccept = false;
		}
		else
			profile->setPingHostIP( "" );
	}

	if ( ProfileNetworkRouteOptionsWidget->DefaultRouteComboBox->currentItem() == 1 )
	{
		profile->setSetDefaultRoute( true );
		profile->setReplaceDefaultRoute( true );
		profile->setKeepDefaultRoute( false );
	}
	else
	{
		profile->setSetDefaultRoute( false );
		profile->setReplaceDefaultRoute( false );
		profile->setKeepDefaultRoute( true );
	}

	profile->setUseSmartcard( ProfileSmartcardOptionsWidget->UseSmartcardCheckBox->isChecked() );

	profile->setAllowEmptyPrivateKeyPassword( ProfileCertOptionsWidget->AllowEmptyPrivateKeyPasswordCheckBox->isChecked());
	profile->setAllowIpAddressChangeOfPeer(ProfileOpenvpnOptionsWidget->AllowIpAddressChangeOfPeerCheckBox->isChecked());

	profile->setUseConnectionStatusCheck( ProfileNetworkGeneralOptionsWidget->UseConnectionStatusCheckCheckBox->isChecked() );
	profile->setConnectionStatusCheckSuccessCount( ProfileNetworkGeneralOptionsWidget->ConnectionStatusSuccessCountNumInput->value() );
	profile->setConnectionStatusInterval( ProfileNetworkGeneralOptionsWidget->ConnectionStatusCheckIntervalNumInput->value() );
	profile->setDoReconnectAfterConnectionLost( ProfileNetworkGeneralOptionsWidget->DoReconnectAfterConnectionLostCheckBox->isChecked() );
	profile->setUseReconnectDelay( ProfileNetworkGeneralOptionsWidget->UseReconnectDelayCheckBox->isChecked() );
	profile->setReconnectDelay( ProfileNetworkGeneralOptionsWidget->ReconnectDelayNumInput->value() );

	profile->setLeftNextHop( ProfileRacoonOptionsWidget->LeftNextHopLineEdit->text() ); //TODO check valid IP
	profile->setRightNextHop( ProfileRacoonOptionsWidget->RightNextHopLineEdit->text( ) ); //TODO check valid IP
	profile->setUseRightNextHop(ProfileRacoonOptionsWidget->UseRightNextHopCheckBox->isChecked());
	profile->setUseLeftNextHop(ProfileRacoonOptionsWidget->UseLeftNextHopCheckBox->isChecked());
	

	if ( item == VpnAccountData::ConnectionType( VpnAccountData::freeswan ) ||
			item == VpnAccountData::ConnectionType( VpnAccountData::l2tpd_freeswan ) ||
	        item == VpnAccountData::ConnectionType( VpnAccountData::racoon ) ||
	        item == VpnAccountData::ConnectionType( VpnAccountData::l2tpd_racoon ) )
	{

		if ( ProfileNetworkVirtualIpOptionsWidget->UseVirtualIPCheckBox->isChecked() && !ProfileNetworkVirtualIpOptionsWidget->LocalVirtualIpEdit->text().isEmpty() )
		{
			// do check for vailid IP
			if ( !Utils( GlobalConfig ).isValidIPv4Address( ProfileNetworkVirtualIpOptionsWidget->LocalVirtualIpEdit->text() ) )
			{
				KMessageBox::error ( this, i18n( "No valid IP address entered!" ), i18n( "No Valid IP Address" ) );
				GlobalConfig->appendLogEntry( i18n( "No valid IP address entered!" ) , GlobalConfig->error );
				canAccept = false;
			}
			else
			{
				profile->setVirtualIP( ProfileNetworkVirtualIpOptionsWidget->LocalVirtualIpEdit->text() );
				profile->setUseVirtualIP( ProfileNetworkVirtualIpOptionsWidget->UseVirtualIPCheckBox->isChecked() );
			}
		}
		else
		{
			if ( ProfileNetworkVirtualIpOptionsWidget->UseVirtualIPCheckBox->isChecked() && ProfileNetworkVirtualIpOptionsWidget->LocalVirtualIpEdit->text().isEmpty() )
			{
				KMessageBox::error ( this, i18n( "No IP address (virtual IP) entered!" ), i18n( "No IP Address" ) );
				// 				GlobalConfig->appendLogEntry(i18n( "No IP address (virtual IP) entered!" ) ,GlobalConfig->error);
				canAccept = false;
			}
			else
			{
				profile->setVirtualIP( "" );
				profile->setUseVirtualIP( false );
			}
		}
	}

	if ( ProfileRacoonOptionsWidget->DisablePfsCheckBox->isChecked() )
		profile->setUsePerfectForwardSecrety( false );
	else
		profile->setUsePerfectForwardSecrety( true );

	profile->setSavePsk( ProfilePskOptionsWidget->CheckSavePsk->isChecked() );
	profile->setSaveUserPassword( ProfileUserOptionsWidget->CheckUserPass->isChecked () );
	profile->setID( ProfileCiscoOptionsWidget->IDLineEdit->text() );
	profile->setUserName( ProfileUserOptionsWidget->UsernameLineEdit->text () );

	if ( ProfileUserOptionsWidget->CheckUserPass->isChecked() )
		profile->setUserPassword( ProfileUserOptionsWidget->PasswordEdit->text ( ) );
	else
		profile->setUserPassword( "" );

	if ( ProfilePskOptionsWidget->CheckSavePsk->isChecked() )
		profile->setPreSharedKey( ProfilePskOptionsWidget->PSKLineEdit->text( ) );
	else
		profile->setPreSharedKey( "" );

	profile->setUseMailAddressAsIdentifier( ProfileCertOptionsWidget->UseMailAddressAsIdentifierCheckBox->isChecked() );

	profile->setGateway( ProfileGeneralOptionsWidget->gatewayLineEdit->text() );
	// 	std::cout << "save: set gateway to: " << ProfileGeneralOptionsWidget->gatewayLineEdit->text() << ", now it is in profile: " << profile->getGateway() << std::endl;
	profile->setPreSharedKey( ProfilePskOptionsWidget->PSKLineEdit->text() );
	profile->setX509Certificate( ProfileCertOptionsWidget->x509certURLRequester->url() );
	profile->setCertPath( ProfileCertOptionsWidget->certpathURLRequester->url() );
	profile->setPrivateKeyPass( ProfileCertOptionsWidget->PrivkeyPasswordEdit->text() );
	profile->setSavePrivateKeyPassword( ProfileCertOptionsWidget->SavePrivateKeyPasswordCheckBox->isChecked() );
	profile->setNetworkDevice( ProfileNetworkGeneralOptionsWidget->NetworkDeviceComboBox->currentText() );

	profile->setDoPingIP( ProfileNetworkGeneralOptionsWidget->PingCheckBox->isChecked() );

	if ( ProfileCertOptionsWidget->AuthTypeComboBox->currentItem() == 0 )
		profile->setAuthType( VpnAccountData::cert );
	if ( ProfileCertOptionsWidget->AuthTypeComboBox->currentItem() == 1 )
		profile->setAuthType( VpnAccountData::psk );

	if ( ProfilePskOptionsWidget->AuthTypeComboBox->currentItem() == 0 )
		profile->setAuthType( VpnAccountData::cert );
	if ( ProfilePskOptionsWidget->AuthTypeComboBox->currentItem() == 1 )
		profile->setAuthType( VpnAccountData::psk );



	if ( ProfileNetworkNatOptionsWidget->UseUdpCheckbox->isChecked() )
		profile->setUseUdp( true );
	else
		profile->setUseUdp( false );

	if ( ProfileNetworkNatOptionsWidget->UdpPortCheckbox->isChecked() )
	{
		profile->setUdpPort( ProfileNetworkNatOptionsWidget->UdpPortSpinbox->value() );
		profile->setUseUdpPort( true );
	}
	else
	{
		profile->setUdpPort( 0 );
		profile->setUseUdpPort( false );
	}

	profile->setUseMtu( ProfileNetworkGeneralOptionsWidget->MtuCheckbox->isChecked() );
	profile->setMtu ( ProfileNetworkGeneralOptionsWidget->MtuSpinbox->value() );

	profile->setExecuteCmdBeforeConnect( ( ProfileCmdExecBeforeConnectOptionsWidget->ExcuteCmdBeforeConnectCheckBox->isChecked() ) );
	profile->setExecuteCmdAfterConnect( ( ProfileCmdExecAfterConnectOptionsWidget->ExcuteCmdAfterConnectCheckBox->isChecked() ) );
	profile->setExecuteCmdBeforeDisconnect( ( ProfileCmdExecBeforeDisconnectOptionsWidget->ExcuteCmdBeforeDisconnectCheckBox->isChecked() ) );
	profile->setExecuteCmdAfterDisconnect( ( ProfileCmdExecAfterDisconnectOptionsWidget->ExcuteCmdAfterDisconnectCheckBox->isChecked() ) );

	profile->setCommandBeforeConnect( ProfileCmdExecBeforeConnectOptionsWidget->CmdBeforeConnectTextEdit->text() );
	profile->setCommandAfterConnect( ProfileCmdExecAfterConnectOptionsWidget->CmdAfterConnectTextEdit->text() );
	profile->setCommandBeforeDisconnect( ProfileCmdExecBeforeDisconnectOptionsWidget->CmdBeforeDisconnectTextEdit->text() );
	profile->setCommandAfterDisconnect( ProfileCmdExecAfterDisconnectOptionsWidget->CmdAfterDisconnectTextEdit->text() );
	profile->setCommandAfterConnectDelayTime(ProfileCmdExecAfterConnectOptionsWidget->CommandAfterConnectDelayTimeNumInput->value());

	profile->setUseAdditionalNetworkRoutes( ProfileNetworkRouteOptionsWidget->UseExtraNetworkRoutesCheckbox->isChecked() );

	if ( ProfileNetworkRouteOptionsWidget->UseExtraNetworkRoutesCheckbox->isChecked() && ProfileNetworkRouteOptionsWidget->NetworkListView->childCount() > 0 )
	{
		QStringList AdditionalNetworkRoutes;
		QListViewItemIterator it( ProfileNetworkRouteOptionsWidget->NetworkListView );
		for ( ; it.current(); ++it )
		{
			// example entry:
			// <network>/<netmask>#<gateway>
			QString network = QString( it.current() ->text( 0 ) + "/" + it.current() ->text( 1 ) );
			network.append( "#" );
			network.append( it.current() ->text( 2 ) ); // gateway
			network.append( "#" );
			network.append( it.current() ->text( 3 ) ); // interface
			AdditionalNetworkRoutes.append( network );
		}
		profile->setAdditionalNetworkRoutes( AdditionalNetworkRoutes );
	}

	profile->setUseSpecialServerCertificate( ProfileCertOptionsWidget->UseSpecialServerCertificateCheckBox->isChecked() );

	if ( ProfileCertOptionsWidget->UseSpecialServerCertificateCheckBox->isChecked() )
	{
		if ( !ProfileCertOptionsWidget->SpecialServerCertificateURLRequester->url().isEmpty() )
			profile->setSpecialServerCertificate( ProfileCertOptionsWidget->SpecialServerCertificateURLRequester->url() );
		else
		{
			KMessageBox::error ( this, i18n( "Special server certificate can't be empty!" ), i18n( "No Server Certificate" ) );
			// 			GlobalConfig->appendLogEntry( i18n( "Special server certificate can't be empty!" ) ,GlobalConfig->error);
			canAccept = false;
		}
	}

	profile->setUseNsCertType( ProfileOpenvpnOptionsWidget->UseNsCertTypeCheckBox->isChecked() );

	if ( ProfileOpenvpnOptionsWidget->NsCertTypeComboBox->currentText() == "client" )
		profile->setNsCertType( "client" );
	else
		profile->setNsCertType( "server" );

	if ( GlobalConfig->currentProfile->getAuthType() == VpnAccountData::cert && 
			ProfileSmartcardOptionsWidget->UseSmartcardCheckBox->isEnabled() &&
			ProfileSmartcardOptionsWidget->UseSmartcardCheckBox->isChecked() )
	{
		if ( !ProfileSmartcardOptionsWidget->Pkcs11SlotComboBox->currentText().isEmpty() )
			profile->setPkcs11Slot(ProfileSmartcardOptionsWidget->Pkcs11SlotComboBox->currentText());
		else
		{
			KMessageBox::error ( this, i18n( "Slot at smartcard can't be empty!" ), i18n( "No smartcard slot" ) );
			// 			GlobalConfig->appendLogEntry( i18n( "Slot at smartcard can't be empty!" ) ,GlobalConfig->error);
			canAccept = false;
		}
		if ( !ProfileSmartcardOptionsWidget->Pkcs11IdComboBox->currentText().isEmpty() )
			profile->setPkcs11Id(ProfileSmartcardOptionsWidget->Pkcs11IdComboBox->currentText());
		else
		{
			KMessageBox::error ( this, i18n( "ID for certificate at smartcard can't be empty!" ), i18n( "No certificate ID" ) );
			// 			GlobalConfig->appendLogEntry( i18n( "ID for certificate at smartcard can't be empty!" ) ,GlobalConfig->error);
			canAccept = false;
		}
		QString Pkcs11SlotType = ProfileSmartcardOptionsWidget->Pkcs11SlotTypeComboBox->currentText();
		if (Pkcs11SlotType == i18n("ID"))
			profile->setPkcs11SlotType("id");
		else if (Pkcs11SlotType == i18n("Name"))
			profile->setPkcs11SlotType("name");
		else
			profile->setPkcs11SlotType("label");

		QString Pkcs11IdType = ProfileSmartcardOptionsWidget->Pkcs11IdTypeComboBox->currentText();
		if (Pkcs11IdType == i18n("ID"))
			profile->setPkcs11IdType("id");
		else if (Pkcs11IdType == i18n("Label"))
			profile->setPkcs11IdType("label");
		else
			profile->setPkcs11IdType("subject");

		QString Pkcs11SignMode = ProfileSmartcardOptionsWidget->Pkcs11SignModeComboBox->currentText();
		if (Pkcs11SignMode == i18n("auto"))
			profile->setPkcs11SignMode("auto");
		else if (Pkcs11SignMode == i18n("sign"))
			profile->setPkcs11SignMode("sign");
		else if (Pkcs11SignMode == i18n("recover"))
			profile->setPkcs11SignMode("recover");
		else
			profile->setPkcs11SignMode("any");
	}

	if (ProfileSmartcardOptionsWidget->UsePkcs11ProvidersCheckBox->isChecked())
	{
		if ( !ProfileSmartcardOptionsWidget->Pkcs11ProvidersURLRequester->url().isEmpty() )
			profile->setPkcs11Providers(ProfileSmartcardOptionsWidget->Pkcs11ProvidersURLRequester->url());
		else
		{
			KMessageBox::error ( this, i18n( "Library path to lib for use with smartcard can't be empty!" ), i18n( "No providers lib" ) );
			// 			GlobalConfig->appendLogEntry( i18n( "Library path to lib for use with smartcard can't be empty!" ) ,GlobalConfig->error);
			canAccept = false;
		}
	}
	profile->setUsePkcs11Providers (ProfileSmartcardOptionsWidget->UsePkcs11ProvidersCheckBox->isChecked());

	profile->setDontSaveUsername( ProfileUserOptionsWidget->DontSaveUsernameCheckBox->isChecked() );
	profile->setExchangeMode( ProfileRacoonOptionsWidget->ExchangeModeComboBox->currentText() );
	profile->setDisableCcp( ProfilePptpOptionsWidget->DisableCcpCheckbox->isChecked() );

	//GlobalConfig->appendLogEntry( i18n( "Profile \"%1\" saved." ).arg( newName ),GlobalConfig->debug);

	profile->setPskIsInFile ( ProfilePskOptionsWidget->PskInFileCheckBox->isChecked() );


	if (ProfileNetworkGeneralOptionsWidget->TunnelDeviceTypeComboBox->currentItem() == 1)
		GlobalConfig->currentProfile->setTunnelDeviceType("tap");
	else
		GlobalConfig->currentProfile->setTunnelDeviceType("tun");


	GlobalConfig->appPointer->restoreOverrideCursor();
	// 	enableButtonApply(false);

	GlobalConfig->config->sync();

}

void PreferencesDialog::deleteSessionClicked()
{
	QString Name = ProfileGeneralSelector->currentText();
	if ( !ProfileGeneralSelector->currentText().isEmpty() )
	{
		int result = KMessageBox::questionYesNo ( this, i18n( "Really delete \"%1\"?" ).arg( Name ), i18n( "Delete?" ), KStdGuiItem::del(), KStdGuiItem::cancel() );
		//LogOutput->append( "Result: "+ QString().setNum(result) ) ;
		if ( result == 3 )        // Yes
		{
			VpnAccountData * it;
			if ( !GlobalConfig->AccountList->isEmpty() )
			{
				for ( it = GlobalConfig->AccountList->first(); it; it = GlobalConfig->AccountList->next() )
				{
					if ( ProfileGeneralSelector->currentText().isEmpty() )
					{
						// 					this->deleteSessionAction->setEnabled ( FALSE );
						//			this->advancedSessionAction->setEnabled ( FALSE );
						// 					this->saveSessionAction->setEnabled ( FALSE );
					}
					else
					{
						if ( it->getName() == Name )
						{
							GlobalConfig->removeEntry( GlobalConfig->currentProfile->getName() );
							GlobalConfig->currentProfile = it;
							ProfileGeneralSelector->removeItem( ProfileGeneralSelector->currentItem() );
							ProfileNetworkRouteSelector->removeItem( ProfileGeneralSelector->currentItem() );
							ProfileNetworkNatSelector->removeItem( ProfileGeneralSelector->currentItem() );
							ProfileNetworkHttpProxySelector->removeItem( ProfileGeneralSelector->currentItem() );
							ProfileNetworkVirtualIpSelector->removeItem( ProfileGeneralSelector->currentItem() );
							ProfileCertSelector->removeItem( ProfileGeneralSelector->currentItem() );
							ProfileSmartcardSelector->removeItem( ProfileGeneralSelector->currentItem() );
							ProfilePskSelector->removeItem( ProfileGeneralSelector->currentItem() );
							ProfileUserSelector->removeItem( ProfileGeneralSelector->currentItem() );
							ProfileOpenvpnSelector->removeItem( ProfileGeneralSelector->currentItem() );
							ProfilePptpSelector->removeItem( ProfileGeneralSelector->currentItem() );
							ProfileRacoonSelector->removeItem( ProfileGeneralSelector->currentItem() );
							ProfileCiscoSelector->removeItem( ProfileGeneralSelector->currentItem() );
							ProfileCmdExecBeforeConnectSelector->removeItem( ProfileGeneralSelector->currentItem() );
							ProfileCmdExecBeforeDisconnectSelector->removeItem( ProfileGeneralSelector->currentItem() );
							ProfileCmdExecAfterConnectSelector->removeItem( ProfileGeneralSelector->currentItem() );
							ProfileCmdExecAfterDisconnectSelector->removeItem( ProfileGeneralSelector->currentItem() );
							break;
						}
					}
				}
			}

			if ( !GlobalConfig->AccountList->isEmpty() )
			{
				GlobalConfig->currentProfile = GlobalConfig->AccountList->first();
				ProfileGeneralSelector->setCurrentText( GlobalConfig->AccountList->first() ->getName() );
				//ConnectOptionsWidget->ProfileGeneralOptionsWidget->ProfileComboBox->setSelected(0, true);
				profileChanged ( GlobalConfig->AccountList->first() ->getName() );
				connectionTypeChanged( GlobalConfig->AccountList->first() ->getConnectionType() );
				authTypeChanged( GlobalConfig->AccountList->first() ->getAuthType() );
				// 				buttonCancel->setEnabled( true );
				// 				buttonOk->setEnabled( true );
			}
			else
			{
				ProfileGeneralOptionsWidget->DeleteSessionPushButton->setEnabled ( FALSE );
				ProfileGeneralOptionsWidget->RenameSessionPushButton->setEnabled ( FALSE );
				ProfileGeneralOptionsWidget->SaveSessionPushButton->setEnabled ( FALSE );
				ProfileGeneralOptionsWidget->AdvancedSettingsPushButton->setEnabled( false );
				GlobalConfig->lastProfile = "";
				GlobalConfig->currentProfile = 0L;
				// 				CiscoPptpGroupBox->setEnabled( false );
				//				FreeswanRacoonGroupBox->setEnabled( false );
				// 				OpenvpnGroupBox->setEnabled( false );
				// 				GeneralGroupbox->setEnabled( false );
				//				CommandExecutionGroupBox->setEnabled( false );
			}

			//		slotStatusMsg ( i18n( "Profile \"%1\" deleted." ).arg( Name ), ID_FLASH_MSG );

			profileAddedOrDeleted = true;
			saveSessionClicked();
			GlobalConfig->removeEntry( Name );
			GlobalConfig->appendLogEntry ( i18n( "Profile \"%1\" deleted." ).arg( Name ), GlobalConfig->debug );

			
			//saveOptions(); // TODO save, currently after closing dialog
			//			sessionToggled();
			//if ( ConnectOptionsWidget->ProfileGeneralOptionsWidget->ProfileComboBox->currentText().isEmpty() )
			//	ConnectOptionsWidget->ProfileGeneralOptionsWidget->ProfileComboBox->setEnabled ( FALSE );
		}
	}

}

void PreferencesDialog::newSessionClicked()
{

	// call new profile dialog...
	NewProfileDialog newdlg( GlobalConfig->appPointer, this, i18n( "New profile" ), GlobalConfig );
	newdlg.exec();
	if ( newdlg.newProfileCreated )
	{
		QString Name = newdlg.profileData->getName();
		VpnAccountData * it;
		for ( it = GlobalConfig->AccountList->first(); it; it = GlobalConfig->AccountList->next() )
		{
			if ( it->getName() == Name )
			{

				ProfileGeneralSelector->insertItem( Name );
				ProfileNetworkRouteSelector->insertItem( Name );
				ProfileNetworkNatSelector->insertItem( Name );
				ProfileNetworkHttpProxySelector->insertItem( Name );
				ProfileNetworkVirtualIpSelector->insertItem( Name );
				ProfileCertSelector->insertItem( Name );
				ProfileSmartcardSelector->insertItem( Name );
				ProfilePskSelector->insertItem( Name );
				ProfileUserSelector->insertItem( Name );
				ProfileOpenvpnSelector->insertItem( Name );
				ProfilePptpSelector->insertItem( Name );
				ProfileRacoonSelector->insertItem( Name );
				ProfileCiscoSelector->insertItem( Name );
				ProfileCmdExecBeforeConnectSelector->insertItem( Name );
				ProfileCmdExecBeforeDisconnectSelector->insertItem( Name );
				ProfileCmdExecAfterConnectSelector->insertItem( Name );
				ProfileCmdExecAfterDisconnectSelector->insertItem( Name );

				ProfileGeneralSelector->setCurrentText ( Name );
				ProfileNetworkRouteSelector->setCurrentText ( Name );
				ProfileNetworkNatSelector->setCurrentText ( Name );
				ProfileNetworkHttpProxySelector->setCurrentText ( Name );
				ProfileNetworkVirtualIpSelector->setCurrentText ( Name );
				ProfileCertSelector->setCurrentText ( Name );
				ProfileSmartcardSelector->setCurrentText ( Name );
				ProfilePskSelector->setCurrentText ( Name );
				ProfileUserSelector->setCurrentText ( Name );
				ProfileOpenvpnSelector->setCurrentText ( Name );
				ProfilePptpSelector->setCurrentText ( Name );
				ProfileRacoonSelector->setCurrentText ( Name );
				ProfileCiscoSelector->setCurrentText ( Name );
				ProfileCmdExecBeforeConnectSelector->setCurrentText ( Name );
				ProfileCmdExecBeforeDisconnectSelector->setCurrentText ( Name );
				ProfileCmdExecAfterConnectSelector->setCurrentText ( Name );
				ProfileCmdExecAfterDisconnectSelector->setCurrentText ( Name );

				GlobalConfig->currentProfile = it;
				break;
			}
		}

		ProfileGeneralOptionsWidget->AdvancedSettingsPushButton->setEnabled( TRUE );
		ProfileGeneralOptionsWidget->RenameSessionPushButton->setEnabled( TRUE );
		ProfileGeneralOptionsWidget->DeleteSessionPushButton->setEnabled( TRUE );
		ProfileGeneralOptionsWidget->SaveSessionPushButton->setEnabled ( TRUE );

		// 		CiscoPptpGroupBox->setEnabled( true );
		// 		//		FreeswanRacoonGroupBox->setEnabled( true );
		// 		OpenvpnGroupBox->setEnabled( true );
		// 		GeneralGroupbox->setEnabled( true );
		// 		CommandExecutionGroupBox->setEnabled( true );

		KMessageBox::information ( this, i18n( "Profile \"%1\" added.\nNow set the right type,\n fill in the fields\nand press \"Save\" to complete the profile." ).arg( Name ), i18n( "Complete Profile" ) );
		//slotStatusMsg ( i18n( "Profile \"%1\" added." ).arg( Name ), ID_FLASH_MSG );

		GlobalConfig->appendLogEntry ( i18n( "Profile \"%1\" added." ).arg( Name ), GlobalConfig->debug );
		profileAddedOrDeleted = true;
		NewProfileName = Name;
		profileChanged ( Name );
		connectionTypeChanged( ProfileGeneralOptionsWidget->ConnectionTypeComboBox->currentItem() );
		authTypeChanged( ProfileCertOptionsWidget->AuthTypeComboBox->currentItem() );
		authTypeChanged( ProfilePskOptionsWidget->AuthTypeComboBox->currentItem() );
		saveSessionClicked();
	}
	else
	{

		GlobalConfig->appendLogEntry ( i18n( "Creation of the new profile canceled." ), GlobalConfig->debug );
	}

}

void PreferencesDialog::renameSessionClicked()
{
	bool ok = true;
	bool nameOk = false;
	QString oldName = GlobalConfig->currentProfile->getName();
	QString *newName;

	while ( nameOk == false )
	{
		newName = new QString( KInputDialog::getText ( i18n( "New Name" ), i18n( "Enter new name for profile:" ), oldName, &ok, this ) );
		if ( newName->contains( ' ' ) )
		{
			KMessageBox::error ( this, i18n( "Blanks are not allowed in profile names!" ), i18n( "Illegal Character in Name" ) );
			GlobalConfig->appendLogEntry( i18n( "Blanks are not allowed in profile names!" ) , GlobalConfig->error );
			ok = false;
		}
		if ( *newName == oldName  )
		{
// 			KMessageBox::error ( this, i18n( "Profile name can be same!" ), i18n( "Same name" ) );
// 			GlobalConfig->appendLogEntry( i18n( "Profile name can be same!" ) , GlobalConfig->error );
			ok = false;
			nameOk=true;
		}
		else
			nameOk=true;
	}
	if ( ok )
	{
		GlobalConfig->currentProfile->setName( *newName );
		ProfileGeneralSelector->clear();
		ProfileNetworkRouteSelector->clear();
		ProfileNetworkNatSelector->clear();
		ProfileNetworkHttpProxySelector->clear();
		ProfileNetworkVirtualIpSelector->clear();
		ProfileCertSelector->clear();
		ProfileSmartcardSelector->clear();
		ProfilePskSelector->clear();
		ProfileUserSelector->clear();
		ProfileOpenvpnSelector->clear();
		ProfilePptpSelector->clear();
		ProfileRacoonSelector->clear();
		ProfileCiscoSelector->clear();
		ProfileCmdExecBeforeConnectSelector->clear();
		ProfileCmdExecBeforeDisconnectSelector->clear();
		ProfileCmdExecAfterConnectSelector->clear();
		ProfileCmdExecAfterDisconnectSelector->clear();

		if ( !GlobalConfig->AccountList->isEmpty() )
		{
			VpnAccountData * it;
			for ( it = GlobalConfig->AccountList->first(); it; it = GlobalConfig->AccountList->next() )
			{
				if ( it != 0 )
				{
					ProfileGeneralSelector->insertItem( it->getName() );
					ProfileNetworkRouteSelector->insertItem( it->getName() );
					ProfileNetworkNatSelector->insertItem( it->getName() );
					ProfileNetworkHttpProxySelector->insertItem( it->getName() );
					ProfileNetworkVirtualIpSelector->insertItem( it->getName() );
					ProfileCertSelector->insertItem( it->getName() );
					ProfileSmartcardSelector->insertItem( it->getName() );
					ProfilePskSelector->insertItem( it->getName() );
					ProfileUserSelector->insertItem( it->getName() );
					ProfileOpenvpnSelector->insertItem( it->getName() );
					ProfilePptpSelector->insertItem( it->getName() );
					ProfileRacoonSelector->insertItem( it->getName() );
					ProfileCiscoSelector->insertItem( it->getName() );
					ProfileCmdExecBeforeConnectSelector->insertItem( it->getName() );
					ProfileCmdExecBeforeDisconnectSelector->insertItem( it->getName() );
					ProfileCmdExecAfterConnectSelector->insertItem( it->getName() );
					ProfileCmdExecAfterDisconnectSelector->insertItem( it->getName() );
				}
			}
			ProfileGeneralSelector->setCurrentText( *newName );
			ProfileNetworkRouteSelector->setCurrentText( *newName );
			ProfileNetworkNatSelector->setCurrentText( *newName );
			ProfileNetworkHttpProxySelector->setCurrentText( *newName );
			ProfileNetworkVirtualIpSelector->setCurrentText( *newName );
			ProfileCertSelector->setCurrentText( *newName );
			ProfileSmartcardSelector->setCurrentText( *newName );
			ProfilePskSelector->setCurrentText( *newName );
			ProfileUserSelector->setCurrentText( *newName );
			ProfileOpenvpnSelector->setCurrentText( *newName );
			ProfilePptpSelector->setCurrentText( *newName );
			ProfileRacoonSelector->setCurrentText( *newName );
			ProfileCiscoSelector->setCurrentText( *newName );
			ProfileCmdExecBeforeConnectSelector->setCurrentText( *newName );
			ProfileCmdExecBeforeDisconnectSelector->setCurrentText( *newName );
			ProfileCmdExecAfterConnectSelector->setCurrentText( *newName );
			ProfileCmdExecAfterDisconnectSelector->setCurrentText( *newName );

		}

		if ( !showOnlyProfiles )
		{
			ConnectOptionsWidget->AutoConnectProfileComboBox->clear();
			for ( uint i = 1; i < GlobalConfig->AccountList->count();i++ )
			{
				ConnectOptionsWidget->AutoConnectProfileComboBox->insertItem( GlobalConfig->AccountList->at( i ) ->getName() );
			}
		}
		profileAddedOrDeleted = true;

		GlobalConfig->lastProfile = QString(*newName);

		saveSessionClicked();
		GlobalConfig->removeEntry( oldName );

		GlobalConfig->appendLogEntry( i18n( "Profile \"%1\" renamed to \"%2\"." ).arg( oldName ).arg( *newName ), GlobalConfig->debug );
	}

}

void PreferencesDialog::importCertificate()
{
	ImportCertificateDialog dlg( this, i18n( "Import certificate..." ).ascii(), GlobalConfig );
	//int result =
	dlg.exec();
}

void PreferencesDialog::pageChanged( QWidget* )
{
	//std::cout << "page changed, new profile: "<< lastProfileName << std::endl;
	profileChanged( lastProfileName );
}

void PreferencesDialog::userAuthToggled( bool )
{
	if ( ProfileOpenvpnOptionsWidget->AuthWithUsernameAndPasswordCheckBox->isChecked() )
		ProfileUserOptionsWidget->setEnabled( true );
	else
		ProfileUserOptionsWidget->setEnabled( false );

}

void PreferencesDialog::useUdpToggled( bool )
{
	if ( ProfileNetworkNatOptionsWidget->UseUdpCheckbox->isChecked() )
	{
		ProfileOpenvpnOptionsWidget->UseUserdefinedPacketSizeCheckBox->setEnabled( true );
		ProfileOpenvpnOptionsWidget->userdefiniedPacketSizeToggled( ProfileOpenvpnOptionsWidget->UseUserdefinedPacketSizeCheckBox->isChecked() );
		ProfileOpenvpnOptionsWidget->userdefiniedFragmentationSizeToggled( ProfileOpenvpnOptionsWidget->UseUserdefinedFragmentationSizeCheckBox->isChecked() );
	}
	else
	{
		ProfileOpenvpnOptionsWidget->UseUserdefinedPacketSizeCheckBox->setEnabled( false );
		ProfileOpenvpnOptionsWidget->userdefiniedPacketSizeToggled( ProfileOpenvpnOptionsWidget->UseUserdefinedPacketSizeCheckBox->isChecked() );
		ProfileOpenvpnOptionsWidget->userdefiniedFragmentationSizeToggled( ProfileOpenvpnOptionsWidget->UseUserdefinedFragmentationSizeCheckBox->isChecked() );
	}
}

void PreferencesDialog::OpenvpnPathChanged( const QString& )
{
	ToolInfo * OpenvpnInfo = Utils( GlobalConfig ).getToolInfo( GlobalConfig, "openvpn" );
// 	OpenvpnInfo->PathToExec = DaemonOptionsWidget->OpenvpnPathInput->url();
// 	GlobalConfig->pathToOpenvpn = DaemonOptionsWidget->OpenvpnPathInput->url();
// 	OpenvpnInfo->addSearchPath(DaemonOptionsWidget->OpenvpnPathInput->url());
	OpenvpnInfo->TryPath_first = DaemonOptionsWidget->OpenvpnPathInput->url();
	OpenvpnInfo->collectToolInfo();

	DaemonOptionsWidget->OpenvpnVersionLineEdit->setText( OpenvpnInfo->Version );

	if ( OpenvpnInfo->found )
		DaemonOptionsWidget->OpenvpnStatePixmapLabel->setPixmap( ok_icon );
	else
		DaemonOptionsWidget->OpenvpnStatePixmapLabel->setPixmap( wrong_icon );
}

void PreferencesDialog::FreeswanPathChanged( const QString& )
{
	// 	KMessageBox::information(0,"path changed","Freeswan");

	ToolInfo * IpsecInfo = Utils( GlobalConfig ).getToolInfo( GlobalConfig, "ipsec" );
// 	IpsecInfo->removeSearchPath( IpsecInfo->PathToExec );
// 	IpsecInfo->PathToExec = DaemonOptionsWidget->FreeswanPathInput->url();
// 	GlobalConfig->pathToFreeswan = DaemonOptionsWidget->FreeswanPathInput->url();
// 	IpsecInfo->addSearchPath(DaemonOptionsWidget->FreeswanPathInput->url());
	IpsecInfo->TryPath_first = DaemonOptionsWidget->FreeswanPathInput->url();
	IpsecInfo->collectToolInfo();

	DaemonOptionsWidget->IpsecVersionLineEdit->setText( IpsecInfo->Version );

	if ( IpsecInfo->found )
		DaemonOptionsWidget->IpsecStatePixmapLabel->setPixmap( ok_icon );
	else
		DaemonOptionsWidget->IpsecStatePixmapLabel->setPixmap( wrong_icon );
}

void PreferencesDialog::PppdPathChanged( const QString& )
{
	// 	KMessageBox::information(0,"path changed","Pppd");

	ToolInfo * PppdInfo = Utils( GlobalConfig ).getToolInfo( GlobalConfig, "pppd" );
// 	PppdInfo->removeSearchPath( PppdInfo->PathToExec );
// 	PppdInfo->PathToExec = DaemonOptionsWidget->PppdPathInput->url();
// 	GlobalConfig->pathToPppd = DaemonOptionsWidget->PppdPathInput->url();
// 	PppdInfo->addSearchPath(DaemonOptionsWidget->PppdPathInput->url());
	PppdInfo->TryPath_first = DaemonOptionsWidget->PppdPathInput->url();
	PppdInfo->collectToolInfo();

	DaemonOptionsWidget->PppdVersionLineEdit->setText( PppdInfo->Version );

	if ( PppdInfo->found )
		DaemonOptionsWidget->PppdStatePixmapLabel->setPixmap( ok_icon );
	else
		DaemonOptionsWidget->PppdStatePixmapLabel->setPixmap( wrong_icon );
}

void PreferencesDialog::PptpPathChanged( const QString& )
{
	// 	KMessageBox::information(0,"path changed","Pptp");

	ToolInfo * PptpInfo = Utils( GlobalConfig ).getToolInfo( GlobalConfig, "pptpd" );
// 	PptpInfo->PathToExec = DaemonOptionsWidget->PptpPathInput->url();
// 	GlobalConfig->pathToPptp = DaemonOptionsWidget->PptpPathInput->url();
// 	PptpInfo->removeSearchPath( PptpInfo->PathToExec );
// 	PptpInfo->addSearchPath(DaemonOptionsWidget->PptpPathInput->url());
	PptpInfo->TryPath_first = DaemonOptionsWidget->PptpPathInput->url();
	PptpInfo->collectToolInfo();

	DaemonOptionsWidget->PptpVersionLineEdit->setText( PptpInfo->Version );

	if ( PptpInfo->found )
		DaemonOptionsWidget->PptpStatePixmapLabel->setPixmap( ok_icon );
	else
		DaemonOptionsWidget->PptpStatePixmapLabel->setPixmap( wrong_icon );
}

void PreferencesDialog::RacoonPathChanged( const QString& )
{
	// 	KMessageBox::information(0,"path changed","Racoon");

	ToolInfo * RacoonInfo = Utils( GlobalConfig ).getToolInfo( GlobalConfig, "racoon" );
// 	RacoonInfo->removeSearchPath( RacoonInfo->PathToExec );
// 	RacoonInfo->PathToExec = DaemonOptionsWidget->RacoonPathInput->url();
// 	GlobalConfig->pathToRacoon = DaemonOptionsWidget->RacoonPathInput->url();
// 	RacoonInfo->addSearchPath(DaemonOptionsWidget->RacoonPathInput->url());
	RacoonInfo->TryPath_first = DaemonOptionsWidget->RacoonPathInput->url();
	RacoonInfo->collectToolInfo();

	DaemonOptionsWidget->RacoonVersionLineEdit->setText( RacoonInfo->Version );

	QPixmap ok_icon = KGlobal::iconLoader() ->loadIcon( "button_ok", KIcon::NoGroup );
	QPixmap wrong_icon = KGlobal::iconLoader() ->loadIcon( "button_cancel", KIcon::NoGroup );

	if ( RacoonInfo->found )
		DaemonOptionsWidget->RacoonStatePixmapLabel->setPixmap( ok_icon );
	else
		DaemonOptionsWidget->RacoonStatePixmapLabel->setPixmap( wrong_icon );
}

void PreferencesDialog::VpncPathChanged( const QString& )
{
	// 		KMessageBox::information(0,"path changed","Vpnc");

	ToolInfo * VpncInfo = Utils( GlobalConfig ).getToolInfo( GlobalConfig, "vpnc" );

// 	VpncInfo->removeSearchPath( VpncInfo->PathToExec );

// 	VpncInfo->PathToExec = DaemonOptionsWidget->VpncPathInput->url();
// 	GlobalConfig->pathToVpnc = DaemonOptionsWidget->VpncPathInput->url();
	// 	KMessageBox::information(0,VpncInfo->PathToExec,"vpnc path");
// 	VpncInfo->addSearchPath(DaemonOptionsWidget->VpncPathInput->url());
	VpncInfo->TryPath_first = DaemonOptionsWidget->VpncPathInput->url();
	VpncInfo->collectToolInfo();

	DaemonOptionsWidget->VpncVersionLineEdit->setText( VpncInfo->Version );
	// 	KMessageBox::information(0,VpncInfo->Version,"vpnc version");

	if ( VpncInfo->found )
		DaemonOptionsWidget->VpncStatePixmapLabel->setPixmap( ok_icon );
	else
		DaemonOptionsWidget->VpncStatePixmapLabel->setPixmap( wrong_icon );
}

void PreferencesDialog::L2tpdPathChanged( const QString& )
{
	// 		KMessageBox::information(0,"path changed","L2tpd");

	ToolInfo * L2tpdInfo = Utils( GlobalConfig ).getToolInfo( GlobalConfig, "l2tpd" );

// 	L2tpdInfo->removeSearchPath( L2tpdInfo->PathToExec );

// 	L2tpdInfo->PathToExec = DaemonOptionsWidget->L2tpdPathInput->url();
// 	GlobalConfig->pathToL2tpd = DaemonOptionsWidget->L2tpdPathInput->url();
	// 	KMessageBox::information(0,L2tpdInfo->PathToExec,"l2tpd path");
// 	L2tpdInfo->addSearchPath(DaemonOptionsWidget->L2tpdPathInput->url());
	L2tpdInfo->TryPath_first = DaemonOptionsWidget->L2tpdPathInput->url();

	L2tpdInfo->collectToolInfo();

	DaemonOptionsWidget->L2tpdVersionLineEdit->setText( L2tpdInfo->Version );
	// 	KMessageBox::information(0,L2tpdInfo->Version,"l2tpd version");

	if ( L2tpdInfo->found )
		DaemonOptionsWidget->L2tpdStatePixmapLabel->setPixmap( ok_icon );
	else
		DaemonOptionsWidget->L2tpdStatePixmapLabel->setPixmap( wrong_icon );
}

void PreferencesDialog::lineeditTextChanged( const QString & )
{
	enableButtonApply( true );
}

void PreferencesDialog::checkboxStateChanged( int )
{
	enableButtonApply( true );
	std::cout << "foo" << std::endl;
}

void PreferencesDialog::showEvent(QShowEvent* e)
{
  KDialogBase::showEvent(e);

  QSplitter* splitter = ((QSplitter*)child(0, "QSplitter", true));
  KListView* listView = ((KListView*)child(0, "KListView", true));

  if (splitter && listView)
  {
    int visible = listView->visibleWidth();
    int content = listView->contentsWidth();

    if (visible < content)
    {
      int shiftSplitterBy = content - visible;
      resize(width()+shiftSplitterBy, height());
      QValueList<int> oldSizes = splitter->sizes();
      QValueList<int> newSizes;
      newSizes << oldSizes[0] + shiftSplitterBy << oldSizes[1] - shiftSplitterBy;
      splitter->setSizes(newSizes);
    }
  }
}

void PreferencesDialog::detectPkcs11Ids()
{
	GlobalConfig->appPointer->setOverrideCursor( QCursor(Qt::WaitCursor) );
	ProfileSmartcardOptionsWidget->Pkcs11IdComboBox->clear();
	
	int Pkcs11IdType = ProfileSmartcardOptionsWidget->Pkcs11IdTypeComboBox->currentItem();
	QString Pkcs11IdTypeTmp;
		if (Pkcs11IdType == 0)
		{
			Pkcs11IdTypeTmp="id";

			if (KvpncDebugLevel > 1)
				GlobalConfig->appendLogEntry(i18n("Pkcs11IdType: %1").arg(Pkcs11IdTypeTmp),KVpncConfig::debug);
		}
		else if (Pkcs11IdType == 1)
		{
			Pkcs11IdTypeTmp="label";
			if (KvpncDebugLevel > 1)
				GlobalConfig->appendLogEntry(i18n("Pkcs11IdType: %1").arg(Pkcs11IdTypeTmp),KVpncConfig::debug);
		}
		else
		{
			Pkcs11IdTypeTmp="subject";
			if (KvpncDebugLevel > 1)
				GlobalConfig->appendLogEntry(i18n("Pkcs11IdType: %1").arg(Pkcs11IdTypeTmp),KVpncConfig::debug);
		}

		QString ProviderLib="";
		if (ProfileSmartcardOptionsWidget->UsePkcs11ProvidersCheckBox->isChecked() && !ProfileSmartcardOptionsWidget->Pkcs11ProvidersURLRequester->url().isEmpty())
			ProviderLib = ProfileSmartcardOptionsWidget->Pkcs11ProvidersURLRequester->url();

		// we have to split slot id and name ("0 : foobar") => 0
		QString Pkcs11Slot = ProfileSmartcardOptionsWidget->Pkcs11SlotComboBox->currentText().section(':',0,0).stripWhiteSpace();

 		QStringList Pkcs11Ids  = Utils(GlobalConfig).getSmartcardCertsFromSlot(Pkcs11Slot,Pkcs11IdTypeTmp, ProviderLib );
		for ( QStringList::Iterator it = Pkcs11Ids.begin(); it != Pkcs11Ids.end(); ++it )
			ProfileSmartcardOptionsWidget->Pkcs11IdComboBox->insertItem( QString(*it));
		GlobalConfig->appPointer->restoreOverrideCursor();
}

void PreferencesDialog::detectPkcs11Slots()
{
	GlobalConfig->appPointer->setOverrideCursor( QCursor(Qt::WaitCursor) );
	ProfileSmartcardOptionsWidget->Pkcs11SlotComboBox->clear();
	QString ProviderLib="";
	if (ProfileSmartcardOptionsWidget->UsePkcs11ProvidersCheckBox->isChecked() && !ProfileSmartcardOptionsWidget->Pkcs11ProvidersURLRequester->url().isEmpty())
		ProviderLib = ProfileSmartcardOptionsWidget->Pkcs11ProvidersURLRequester->url();
	QStringList Pkcs11Slots = Utils(GlobalConfig).getSmartcardSlots(ProviderLib);
		for ( QStringList::Iterator it = Pkcs11Slots.begin(); it != Pkcs11Slots.end(); ++it )
			ProfileSmartcardOptionsWidget->Pkcs11SlotComboBox->insertItem( QString(*it));
	GlobalConfig->appPointer->restoreOverrideCursor();
}

void PreferencesDialog::localPortToggled(bool)
{
	if ( ProfileCiscoOptionsWidget->LocalPortCheckbox->isChecked() )
		ProfileCiscoOptionsWidget->LocalPortSpinbox->setEnabled( true );
	else
		ProfileCiscoOptionsWidget->LocalPortSpinbox->setEnabled( false );
}

void PreferencesDialog::useSpecialServerSmartcardificateToggled(bool)
{
// 	if (ProfileCertOptionsWidget->UseSpecialServerSmartcardificateCheckBox->isChecked())
// 	{
// 		ProfileSmartcardOptionsWidget->SpecialServerSmartcardificateURLRequester->setEnabled(TRUE);
// 	}
// 	else
// 	{
// 		ProfileSmartcardOptionsWidget->SpecialServerSmartcardificateURLRequester->setEnabled(FALSE);
// 	}
}


#include "preferencesdialog.moc"
