/***************************************************************************
*   Copyright (C) 2004 by Christoph Thielecke                             *
*   crissi99@gmx.de                                                       *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
*                                                                         *
*   This program is distributed in the hope that it will be useful,       *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
*   GNU General Public License for more details.                          *
*                                                                         *
*   You should have received a copy of the GNU General Public License     *
*   along with this program; if not, write to the                         *
*   Free Software Foundation, Inc.,                                       *
*   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
***************************************************************************/
#ifndef PREFERENCESDIALOG_H
#define PREFERENCESDIALOG_H

#include <kdialogbase.h>

#include <qptrlist.h>
#include <qtextedit.h>
#include <qcolor.h>
#include <qscrollview.h>

#include "vpnaccountdata.h"

// content
#include "configdebugoptions.h"
#include "configgeneraloptions.h"
#include "configconnectoptions.h"
#include "configlogoptions.h"
#include "configdaemonoptions.h"
#include "confighelperprogramoptions.h"
#include "profilecertoptions.h"
#include "profilesmartcardoptions.h"
#include "profilepskoptions.h"
#include "profileciscooptions.h"
#include "profilecmdexecafterconnectoptions.h"
#include "profilecmdexecafterdisconnectoptions.h"
#include "profilecmdexecbeforeconnectoptions.h"
#include "profilecmdexecbeforedisconnectoptions.h"
#include "profilegeneraloptions.h"
#include "profilenetworkgeneraloptions.h"
#include "profilenetworknatoptions.h"
#include "profilenetworkhttpproxyoptions.h"
#include "profilenetworkrouteoptions.h"
#include "profilenetworkvirtualipoptions.h"
#include "profileopenvpnoptions.h"
#include "profilepptpoptions.h"
#include "profileracoonoptions.h"
#include "profileuseroptions.h"


/**
@author Christoph Thielecke
*/
class PreferencesDialog : public KDialogBase
{
	Q_OBJECT
public:

	/**
	 *  Constructor
	 * @param parent parent widget
	 * @param app pointer to main application
	 * @param LogOutput textedit for debug messages
	 * @param GlobalConfig pointer to configuration object
	 * @param showOnlyProfiles view mode. true: show as profile manager, false: show as preferences dialog
	 * @return
	 */
	PreferencesDialog( QWidget *parent, QApplication *app,QTextEdit *LogOutput, KVpncConfig *GlobalConfig, bool showOnlyProfiles);
	~PreferencesDialog();

public slots:
	void accept();
	void slotApply();
	void authTypeChanged( int authtype );
	void connectionTypeChanged( int connectiontype );
	void profileChanged( const QString& itemtext );
	void saveSessionClicked();
	void deleteSessionClicked();
	void renameSessionClicked();
	void newSessionClicked();
	void importCertificate();
	void pageChanged(QWidget *);
	void userAuthToggled(bool);
	void useUdpToggled(bool);
	void useSpecialServerSmartcardificateToggled(bool);

private slots:
	void OpenvpnPathChanged(const QString&);
	void FreeswanPathChanged(const QString&);
	void PppdPathChanged(const QString&);
	void PptpPathChanged(const QString&);
	void RacoonPathChanged(const QString&);
	void VpncPathChanged(const QString&);
	void L2tpdPathChanged(const QString&);
	
	void lineeditTextChanged(const QString &);
	void checkboxStateChanged(int);
	void showEvent(QShowEvent* e);
	void detectPkcs11Ids();
	void detectPkcs11Slots();
	void localPortToggled(bool);


protected:
	void setupGui();
	QPtrList<VpnAccountData> *AccountList;
	QTextEdit *LogOutput;
	VpnAccountData *currentProfile;
	KVpncConfig *GlobalConfig;
	QString lastProfileName;
	int KvpncDebugLevel;
	bool canAccept;
	QPixmap ok_icon;
	QPixmap wrong_icon;
	QScrollView* DaemonScrollView;

public:
	QApplication *app;

	/* -- option pages -- */
	// Kvpnc
	ConfigGeneralOptions *GeneralOptionsWidget;
	ConfigDebugOptions *DebugOptionsWidget;
	ConfigConnectOptions *ConnectOptionsWidget;
	ConfigLogOptions *LogOptionsWidget;

	// programs
	ConfigDaemonOptions *DaemonOptionsWidget;
	ConfigHelperProgramOptions *HelperProgramOptionsWidget;

	// profile
	ProfileGeneralOptions *ProfileGeneralOptionsWidget;
	ProfileNetworkRouteOptions *ProfileNetworkRouteOptionsWidget;
	ProfileNetworkGeneralOptions *ProfileNetworkGeneralOptionsWidget;
	ProfileNetworkNatOptions *ProfileNetworkNatOptionsWidget;
	ProfileNetworkVirtualIpOptions *ProfileNetworkVirtualIpOptionsWidget;
	ProfileCertOptions *ProfileCertOptionsWidget;
	ProfileSmartcardOptions *ProfileSmartcardOptionsWidget;
	ProfilePskOptions *ProfilePskOptionsWidget;
	ProfileUserOptions *ProfileUserOptionsWidget;
	ProfileOpenvpnOptions *ProfileOpenvpnOptionsWidget;
	ProfileNetworkHttpProxyOptions *ProfileNetworkHttpProxyOptionsWidget;
	ProfilePptpOptions *ProfilePptpOptionsWidget;
	ProfileRacoonOptions *ProfileRacoonOptionsWidget;
	ProfileCiscoOptions *ProfileCiscoOptionsWidget;
	ProfileCmdExecBeforeConnectOptions *ProfileCmdExecBeforeConnectOptionsWidget;
	ProfileCmdExecBeforeDisconnectOptions *ProfileCmdExecBeforeDisconnectOptionsWidget;
	ProfileCmdExecAfterConnectOptions *ProfileCmdExecAfterConnectOptionsWidget;
	ProfileCmdExecAfterDisconnectOptions *ProfileCmdExecAfterDisconnectOptionsWidget;


	QComboBox *ProfileGeneralSelector;
	QComboBox *ProfileNetworkRouteSelector;
	QComboBox *ProfileNetworkGeneralSelector;
	QComboBox *ProfileNetworkNatSelector;
	QComboBox *ProfileNetworkVirtualIpSelector;
	QComboBox *ProfileCertSelector;
	QComboBox *ProfileSmartcardSelector;
	QComboBox *ProfilePskSelector;
	QComboBox *ProfileUserSelector;
	QComboBox *ProfileOpenvpnSelector;
	QComboBox *ProfileNetworkHttpProxySelector;
	QComboBox *ProfilePptpSelector;
	QComboBox *ProfileRacoonSelector;
	QComboBox *ProfileCiscoSelector;
	QComboBox *ProfileCmdExecBeforeConnectSelector;
	QComboBox *ProfileCmdExecBeforeDisconnectSelector;
	QComboBox *ProfileCmdExecAfterConnectSelector;
	QComboBox *ProfileCmdExecAfterDisconnectSelector;

	QFrame* DaemonFrame;

	bool profileAddedOrDeleted;
	bool showOnlyProfiles;
	QString NewProfileName;


};

#endif
