/***************************************************************************
 *   Copyright (C) 2004 by Christoph Thielecke                             *
 *   crissi99@gmx.de                                                       *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/
#include "generateopenvpnkeydialog.h"
#include <kmessagebox.h>
#include <ktempfile.h>
#include <klocale.h>
#include <kdialogbase.h>
#include <kurlrequester.h>
#include <qfile.h>
#include <qurl.h>
#include <kurl.h>
#include <qstring.h>

#include <iostream>
//
GenerateOpenvpnKeyDialog::GenerateOpenvpnKeyDialog(KVpncConfig *GlobalConfig,QWidget *parent, const QString& caption)
		: KDialogBase( parent, i18n("Import Cisco PCF profile:"), true, caption,
		               KDialogBase::Ok|KDialogBase::Cancel, KDialogBase::Ok, true )
{
	this->GlobalConfig=GlobalConfig;
	filename = "";
	genOk = false;
	main = new GenerateOpenvpnKeyDialogBase(this);
	setMainWidget(main);
	//main->setMinimumSize(main->sizeHint());

	main->FilenameUrlrequester->setFilter( "*.key" );

}

GenerateOpenvpnKeyDialog::~GenerateOpenvpnKeyDialog()
{}

void GenerateOpenvpnKeyDialog::accept()
{

	//filename="/etc/CiscoSystemsVPNClient/Profiles/hs_harz.pcf";
	filename = main->FilenameUrlrequester->url();
	if ( !filename.isEmpty() )
		canAccept();

	else
	{
		KMessageBox::sorry( 0, i18n( "Filename can not be empty!" ), i18n( "Empty filename" ) );
	}
}


void GenerateOpenvpnKeyDialog::canAccept()
{

	/*
		QFile f( filename );
		if ( !f.exists() )
		{
			KMessageBox::information( 0, i18n( "File not found." ), i18n( "No file" ) );
	 
			//		emit progress( 100 );
			return ;
		}*/
	generateOpenvpnKeyProcess = new QProcess(this);
	generateOpenvpnKeyProcess->addArgument(GlobalConfig->pathToOpenvpn);
	generateOpenvpnKeyProcess->addArgument("--genkey");
	generateOpenvpnKeyProcess->addArgument("--secret");
	generateOpenvpnKeyProcess->addArgument(filename);

	connect( generateOpenvpnKeyProcess, SIGNAL( readyReadStderr() ), this, SLOT( readStdErr() ) );
	connect( generateOpenvpnKeyProcess, SIGNAL( readyReadStdout() ), this, SLOT( readStdErr() ) );
	if ( !generateOpenvpnKeyProcess->start() )
	{
		KMessageBox::sorry( this, i18n( "\"%1\" start failed!" ).arg( "openvpn" ) );
		GlobalConfig->appendLogEntry(i18n( "\"%1\" start failed!" ).arg( "openvpn" ),GlobalConfig->error);
	}
	else
	{
		genOk = true;
	}

	while (generateOpenvpnKeyProcess->isRunning())
	{
		sleep(1);
	}
	if (genOk)
		KMessageBox::information( this, i18n( "Generating the key in \"%1\" was successful." ).arg( filename ) );
	else
		KMessageBox::sorry( this, i18n( "Generating the key in \"%1\" failed!" ).arg( filename ) );
	//std::cout << "accept" << std::endl;
	QDialog::accept();
}

void GenerateOpenvpnKeyDialog::readStdErr()
{
	// while ( generateOpenvpnKeyProcess->canReadLineStderr() ) {
	// ProcessMsg_connect = generateOpenvpnKeyProcess->readLineStderr();
	QString ProcessMsg_connect = QString( generateOpenvpnKeyProcess->readStderr() );
	if (ProcessMsg_connect.isEmpty())
		ProcessMsg_connect = QString( generateOpenvpnKeyProcess->readStdout() );

	if ( ProcessMsg_connect.find( "Permission denied", 0 , FALSE ) > -1 )
	{
		if (GlobalConfig->KvpncDebugLevel > 0 )
			GlobalConfig->appendLogEntry( "[openvpn genkey err] " + ProcessMsg_connect, GlobalConfig->error );
		genOk = false;
		//}
	}
}
