/***************************************************************************
*   Copyright (C) 2004 by Christoph Thielecke                             *
*   crissi99@gmx.de                                                       *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
*                                                                         *
*   This program is distributed in the hope that it will be useful,       *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
*   GNU General Public License for more details.                          *
*                                                                         *
*   You should have received a copy of the GNU General Public License     *
*   along with this program; if not, write to the                         *
*   Free Software Foundation, Inc.,                                       *
*   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
***************************************************************************/
//BEGIN includes
#include "importcertificatedialog.h"
#include <kmessagebox.h>
#include <klocale.h>
#include <kurlrequester.h>
#include <kpassdlg.h>
#include <kcombobox.h>
#include <klineedit.h>
#include <iostream>
#include <qfile.h>
#include <qdir.h>
#include <qtextstream.h>
#include <qurl.h>
#include <iostream>
#include "kvpncconfig.h"
//END includes

ImportCertificateDialog::ImportCertificateDialog( QWidget *parent, const QString& caption, KVpncConfig *GlobalConfig)
		: KDialogBase( parent, i18n("Import certificate..."), true, caption,
		KDialogBase::Ok|KDialogBase::Cancel, KDialogBase::Ok, true )
 {
	main = new ImportCertificateDialogBase(this);
	setMainWidget(main);
	main->setMinimumSize(main->sizeHint());

// FIXME make appendLogEntry accessable
// 	this->GlobalConfig = GlobalConfig;
	filename = "";
	certHash = "";
	importOk = false;
	importSuccess = true;
	doHash = false;
	certName = "";
	certpath = "/etc/racoon/certs/";
	pathToOpenSSL = GlobalConfig->pathToOpenssl;
	main->RacoonCertificatePathUrlrequester->setMode( 2 ); // directory
	main->FilenameUrlrequester->setFilter( "*.p12" );

	connect (main->ImporttypeComboBox, SIGNAL(activated(int)), this, SLOT(typeToggeled(int)));
	typeToggeled( 0 );


	// TMP
	/*
		main->FilenameUrlrequester->setURL( "/home/crissi/thielecke.p12" );
		//main->RacoonCertificatePathUrlrequester->setURL( "/etc/racoon/certs/" );
	main->ImporttypeComboBox->setCurrentItem( 1 );
		main->PrivateKeyPasswordEdit->setText( "12345678" );
		main->PrivateKeyAgainPasswordEdit->setText( "12345678" );
	*/ 
	//main->ImportPasswordEdit->setText( "blah99" );


}

ImportCertificateDialog::~ImportCertificateDialog() {}

void ImportCertificateDialog::accept() {
	importOk = true;
	done=false;

	filename = main->FilenameUrlrequester->url();
	importpassword = main->ImportPasswordEdit->text();
	certpath = main->RacoonCertificatePathUrlrequester->url();

	if ( filename.isEmpty() ) {
		KMessageBox::sorry( 0, i18n( "Filename can't be empty!" ), i18n( "Empty filename" ) );
		importOk = false;
		importSuccess=false;
		return;
	}

// 	if ( filename.right( 3 ) != "p12" || filename.right (3) != "der" || filename.right (3) != "crt" ) {
// 		KMessageBox::sorry( 0, i18n( "Filename isnt ended by \'p12\', 'der' or \'crt\'!" ), i18n( "Wrong filename" ) );
// 		importOk = false;
// 		return;
// 	}

	QFile f( filename );
	if ( f.exists() ) {
		if ( f.open( IO_ReadOnly ) ) {
			f.close();
		} else {
			KMessageBox::sorry( 0, i18n( "File does not exist!" ), i18n( "No file" ) );
			importOk = false;
			return;
		}
	} else {
		KMessageBox::sorry( 0, i18n( "File not readable!" ), i18n( "insufficient rights" ) );
		importOk = false;
		return;
	}

	if ( (main->ImporttypeComboBox->currentItem() == pkcs12_freeswan ||
				main->ImporttypeComboBox->currentItem() == pkcs12_racoon ) &&
				importpassword.isEmpty() ) {
		importOk = false;
		KMessageBox::sorry( 0, i18n( "Password can't be empty!" ), i18n( "Empty password" ) );
		return;
	}

	if ( main->ImporttypeComboBox->currentItem() == pkcs12_freeswan ) {
		if ( main->PrivateKeyPasswordEdit->text().isEmpty() || main->PrivateKeyPasswordEdit->text().length() < 4 ) {
			importOk = false;
			KMessageBox::sorry( 0, i18n( "Private key password field can not be empty or less than 4 characters!" ), i18n( "password empty or too short" ) );
			return;
		}

		if ( main->PrivateKeyAgainPasswordEdit->text().isEmpty() || main->PrivateKeyAgainPasswordEdit->text().length() < 4 ) {
			importOk = false;
			KMessageBox::sorry( 0, i18n( "Private key password (again) field can not be empty!" ), i18n( "password empty or too short" ) );
			return;
		}
		if ( importOk ) {
			if ( main->PrivateKeyPasswordEdit->text() != main->PrivateKeyAgainPasswordEdit->text() ) {
				importOk = false;
				KMessageBox::sorry( 0, i18n( "Private key passwords does not match!" ), i18n( "passwords do not match" ) );
				return;
			}
		}
	}

	if (GlobalConfig->KvpncDebugLevel > 0 )
		std::cout << "file: " << filename << ", type: " << main->ImporttypeComboBox->currentItem() << std::endl;

	// looking for openssl
	if ( pathToOpenSSL.isEmpty() ) {
		QFile openssl( "/usr/sbin/openssl" );
		if ( openssl.exists() )
			pathToOpenSSL = "/usr/sbin/openssl";
		else {
			openssl.setName( "/usr/local/sbin/openssl" );
			if ( openssl.exists() )
				pathToOpenSSL = "/usr/local/sbin/openssl";
			else {
				openssl.setName( "/usr/bin/openssl" );
				if ( openssl.exists() )
					pathToOpenSSL = "/usr/bin/openssl";
				else {
					KMessageBox::error( this, i18n( "Unable to find \"%1\"!" ).arg("openssl") );
					GlobalConfig->appendLogEntry(i18n( "Unable to find \"%1\"!" ).arg("openssl") ,GlobalConfig->error);
					importOk = false;
				}
			}
		}
	}

	QString file = QUrl ( filename ).fileName();
	certName = file.left( file.length() - 4 ); // peter_pan.p12 -> peter_pan

	if ( main->ImporttypeComboBox->currentItem() == pkcs12_racoon ) {
		QFile certpathtest( certpath + "/." );

		if ( !certpathtest.exists() ) {
			KMessageBox::error( this, i18n( "racoon certificate path (%1) doesnt exist!" ).arg( certpath ) );
			GlobalConfig->appendLogEntry(i18n( "racoon certificate path (%1) doesnt exist!" ).arg( certpath ) ,GlobalConfig->error);
			importOk=false;
		} else {
			QFile testfile ( QString(certpath + "/test" ));
			if ( !testfile.open( IO_WriteOnly ) ) {
				KMessageBox::error( this, i18n( "racoon certificate path (%1) isnt writeable!" ).arg( certpath ) );
				GlobalConfig->appendLogEntry(i18n( "racoon certificate path (%1) isnt writeable!" ).arg( certpath )  ,GlobalConfig->error);
				importOk = false;
			}
			else {
				testfile.remove();
			}
		}
	}


	// here we go
	if ( importOk ) {

		/*
		FreeSWAN/Racoon:
		openssl pkcs12 -in cert.p12 -clcerts -out /etc/racoon/certs/mykeys_company.pem -nodes

		DER:
		openssl x509 -in cert.crt -out ca_company.pem -inform DER

		*/
		// 		 		std::cout << "[std]:" << "settings ok." << std::endl;

		ImportProcess = new QProcess( this );
		ImportProcess->addArgument( pathToOpenSSL );

		if ( main->ImporttypeComboBox->currentItem() == pkcs12_freeswan ||
			main->ImporttypeComboBox->currentItem() == pkcs12_racoon
		) {
		ImportProcess->addArgument( "pkcs12" );
		ImportProcess->addArgument( "-in" );
		ImportProcess->addArgument( filename );
		ImportProcess->addArgument( "-nodes" );
		ImportProcess->addArgument( "-clcerts" );
		ImportProcess->addArgument( "-out" );
		}
		else if ( main->ImporttypeComboBox->currentItem() == ca_der ){
			ImportProcess->addArgument( "x509" );
			ImportProcess->addArgument( "-in" );
			ImportProcess->addArgument( filename );
			ImportProcess->addArgument( "-out" );
			ImportProcess->addArgument( certpath + "/ca_" + certName + ".pem" );
			ImportProcess->addArgument( "-inform" );
			ImportProcess->addArgument( "DER" );
		}
		if ( main->ImporttypeComboBox->currentItem() == pkcs12_freeswan ) {
			ImportProcess->addArgument( "/etc/ipsec.d/certs/mykeys_" + certName + ".pem" ); // warning: static
		}
		else if( main->ImporttypeComboBox->currentItem() == pkcs12_racoon ){
			ImportProcess->addArgument( certpath + "/mykeys_" + certName + ".pem" );
		}


		connect( ImportProcess, SIGNAL( readyReadStdout() ), this, SLOT( readFromStdout_import() ) );
		connect( ImportProcess, SIGNAL( readyReadStderr() ), this, SLOT( readFromStderr_import() ) );
		if ( main->ImporttypeComboBox->currentItem() == pkcs12_freeswan ||
			main->ImporttypeComboBox->currentItem() == pkcs12_racoon
		) {
			connect( ImportProcess, SIGNAL( processExited () ), this, SLOT( doCacert() ) );
		}
		if ( main->ImporttypeComboBox->currentItem() == ca_der) {
			connect( ImportProcess, SIGNAL( processExited () ), this, SLOT( doCreateHash() ) );
		}

		if ( !ImportProcess->start() ) {
			KMessageBox::sorry( this, i18n( "Unable to start process (%1)!" ).arg("openssl") );
		} else {
			// ok
			//std::cout << "[std]:" << " openssl started." << std::endl;
		}
	}
	
	
}

void ImportCertificateDialog::canAccept() {
// 	// FIXME
// 	while (ImportProcess->isRunning() && !done)
// 		sleep (1);

	if (importSuccess)
		KMessageBox::information( 0, i18n( "Certificate was sucessfully imported." ), i18n( "import successful" ) );
	else
		KMessageBox::sorry( 0, i18n( "Certificate import failed." ), i18n( "import failed" ) );

	QDialog::accept();
}

void ImportCertificateDialog::doCacert() {
	if ( ImportProcess->normalExit () ) {
		//	LogOutput->append("[dbg]: doCacert()");
		disconnect( ImportProcess, SIGNAL( processExited () ), this, SLOT( doCacert() ) );
		/*
		openssl pkcs12 -in cert.p12 -nokeys -cacerts -out /etc/racoon/certs/ca_company.pem -nodes
		*/
		ImportProcess->clearArguments();
		ImportProcess->addArgument( pathToOpenSSL );
		ImportProcess->addArgument( "pkcs12" );
		ImportProcess->addArgument( "-in" );
		ImportProcess->addArgument( filename );
		ImportProcess->addArgument( "-nokeys" );
		ImportProcess->addArgument( "-cacerts" );
		ImportProcess->addArgument( "-out" );

		if ( main->ImporttypeComboBox->currentItem() == pkcs12_freeswan )
			ImportProcess->addArgument( "/etc/ipsec.d/cacerts/ca_" + certName + ".pem" ); // warning: static
		else
			ImportProcess->addArgument( certpath + "/ca_" + certName + ".pem" );

		ImportProcess->addArgument( "-nodes" );

		connect( ImportProcess, SIGNAL( processExited () ), this, SLOT( doCreateHash() ) );

		if (! ImportProcess->start() )
		{
			KMessageBox::error( 0, i18n( "Unable to extract CA certificate!" ), i18n( "extract failed" ) );
			importSuccess=false;
		}
		else {

		}

	}
}

void ImportCertificateDialog::doPrivateKey() {
	if ( ImportProcess->normalExit () ) {
		//	LogOutput->append("[dbg]: doPrivateKey()");
		disconnect( ImportProcess, SIGNAL( processExited () ), this, SLOT( doPrivateKey() ) );
		/*
		openssl pkcs12 -in cert.p12 -nocerts -out /etc/racoon/certs/ca_company.pem
		*/
		ImportProcess->clearArguments();
		ImportProcess->addArgument( pathToOpenSSL );
		ImportProcess->addArgument( "pkcs12" );
		ImportProcess->addArgument( "-nocerts" );
		ImportProcess->addArgument( "-in" );
		ImportProcess->addArgument( filename );
		ImportProcess->addArgument( "-out" );
		ImportProcess->addArgument( certpath+"/private/" + certName + ".pem" ); // warning: static

		connect( ImportProcess, SIGNAL( processExited () ), this, SLOT( exit() ) );

		//LogOutput->append( "priv key: we starting..." );
		if ( !ImportProcess->start( ) ) {
			KMessageBox::sorry( this, i18n( "Unable to start process (private key)!" ) );
			importSuccess=false;
		}
		else {
		}

	}
}


void ImportCertificateDialog::doCreateHash() {
	if ( ImportProcess->normalExit () ) {

		disconnect( ImportProcess, SIGNAL( processExited () ), this, SLOT( doCreateHash() ) );

		/*
		openssl x509 -noout -hash < /etc/racoon/certs/ca_company.pem
		*/
		ImportProcess->clearArguments();
		ImportProcess->addArgument( pathToOpenSSL );
		ImportProcess->addArgument( "x509" );
		ImportProcess->addArgument( "-noout" );
		ImportProcess->addArgument( "-hash" );
		ImportProcess->addArgument( "-in" );
		if ( main->ImporttypeComboBox->currentItem() == pkcs12_freeswan )
			ImportProcess->addArgument( certpath+"/cacerts/ca_" + certName + ".pem" ); // warning: static
		else
			ImportProcess->addArgument( certpath + "/ca_" + certName + ".pem" );

		connect( ImportProcess, SIGNAL( processExited () ), this, SLOT( doLink() ) );


		//		LogOutput->append( "hash: we starting..." );
		if ( !ImportProcess->start( ) ) {
			KMessageBox::sorry( this, i18n( "Unable to start process (%1)!" ).arg("hash") );
			importSuccess=false;
		} else {
			doHash = true;
		}
	}
}

void ImportCertificateDialog::doLink() {
	if ( ImportProcess->normalExit () ) {
		disconnect( ImportProcess, SIGNAL( processExited () ), this, SLOT( doLink() ) );
		doHash = false;
		ImportProcess->clearArguments();
		/*
		ln -s /etc/racoon/certs/ca_company.pem /etc/racoon/certs/<hash>.0
		*/
		ImportProcess->addArgument( "ln" );
		ImportProcess->addArgument( "-s" );
		if ( main->ImporttypeComboBox->currentItem() == pkcs12_freeswan ) {
			ImportProcess->addArgument( certpath+"/cacerts/ca_" + certName + ".pem" );
			ImportProcess->addArgument( certpath+"/cacerts/" + certHash + ".0" );
		} else {
			ImportProcess->addArgument( certpath + "/ca_" + certName + ".pem" );
			ImportProcess->addArgument( certpath + certHash + ".0" );
		}

		if ( main->ImporttypeComboBox->currentItem() == pkcs12_freeswan )
			connect( ImportProcess, SIGNAL( processExited () ), this, SLOT( doPrivateKey() ) );
		else
			connect( ImportProcess, SIGNAL( processExited () ), this, SLOT( exit() ) );


		if ( !ImportProcess->start( ) ) {
			KMessageBox::sorry( this, i18n( "Unable to start process (%1)!" ).arg("ln -s") );
			importSuccess=false;
		}
		else {
			
		}
	}
}

void ImportCertificateDialog::exit() {
// 	if ( ImportProcess->normalExit() )
// 		importOk=true;
	done=true;
	canAccept();
}

void ImportCertificateDialog::readFromStdout_import() {
	QString line = QString( ImportProcess->readStdout() );

// FIXME make appendLogEntry accessable
// 	LogOutput->append( "<font color=\"red\">[std]: " + line + "</font>" );
	if ( doHash ) {
		certHash = line.left( line.length() - 1 );
		doHash = false;
		//		LogOutput->append( "<font color=\"red\">[std]: hash" + line + "</font>" );
	}

	if ( line.find( "Enter Import Pass" , 0, FALSE ) > -1 ) {

// FIXME make appendLogEntry accessable
// 		LogOutput->append( "<font color=\"green\">[in]: write the password</font>" );
		ImportProcess->writeToStdin( importpassword + "\n" );
	}

	if ( line.find( "Enter PEM pass phrase" , 0, FALSE ) > -1 ) {

// FIXME make appendLogEntry accessable
// 		LogOutput->append( "<font color=\"green\">[in]: write the private key password</font>" );
		ImportProcess->writeToStdin( main->PrivateKeyPasswordEdit->text() + "\n" );
	}

}

void ImportCertificateDialog::readFromStderr_import() {
	QString line = QString( ImportProcess->readStderr() );

// FIXME make appendLogEntry accessable
// 	LogOutput->append( "<font color=\"black\">[err]: " + line + "</font>" );

	if ( line.find( "invalid password" , 0, FALSE ) > -1 ) {
		KMessageBox::sorry( 0, i18n( "wrong password?!." ), i18n( "password failed" ) );
	}

	if ( line.find( "Enter Import Pass", 0, FALSE ) > -1 ) {

// FIXME make appendLogEntry accessable
// 		LogOutput->append( "<font color=\"green\">[in]: write the password</font>" );
		ImportProcess->writeToStdin( importpassword + "\n" );
	}

	if ( line.find( "Enter PEM pass phrase", 0, FALSE ) > -1 ) {

// FIXME make appendLogEntry accessable
// 		LogOutput->append( "<font color=\"green\">[in]: write the private key password</font>" );
		ImportProcess->writeToStdin( main->PrivateKeyPasswordEdit->text() + "\n" );
	}

	// 	if ( line.contains( "Verifying - Enter PEM pass phrase" ) > 0 ) {
	// 		LogOutput->append( "<font color=\"green\">[in]: write the private key password (again)</font>" );
	// 		ImportProcess->writeToStdin( importpassword + "\n" );
	// 	}
	if ( line.find( "unable to  certificate", 0, FALSE ) > -1 ) {
		KMessageBox::error( 0, i18n( "Unable to load certificate!" ), i18n( "load failed" ) );
		GlobalConfig->appendLogEntry( i18n( "Unable to load certificate!" ) ,GlobalConfig->error);
		importOk=true;
		importSuccess=false;
		if (ImportProcess->isRunning()){
			ImportProcess->kill();
		}
		done=true;
	}
	


}

void ImportCertificateDialog::typeToggeled( int type ) {
	//std::cout << "type: " << type << std::endl;
	if ( type == pkcs12_freeswan ) {
		certpath = "/etc/ipsec.d/certs";
		main->PrivateKeyPasswordEdit->setEnabled( true );
		main->PrivateKeyAgainPasswordEdit->setEnabled( true );
		main->RacoonCertificatePathUrlrequester->setEnabled( false );
		main->ImportPasswordEdit->setEnabled( true );
		main->P12GroupBox->setEnabled( true );
		main->FreeswanGroupBox->setEnabled( true );
		main->FilenameUrlrequester->setFilter( "*.p12" );
	}
	else if ( type == pkcs12_racoon ) {
		certpath = "/etc/racoon/certs/";
		main->PrivateKeyPasswordEdit->setEnabled( false );
		main->PrivateKeyAgainPasswordEdit->setEnabled( false );
		main->RacoonCertificatePathUrlrequester->setEnabled( true );
		main->ImportPasswordEdit->setEnabled( true );
		main->P12GroupBox->setEnabled( true );
		main->FreeswanGroupBox->setEnabled( false );
		main->FilenameUrlrequester->setFilter( "*.p12" );
	}
	else if ( type == ca_der ) {
		certpath = "/etc/certs/";
		main->PrivateKeyPasswordEdit->setEnabled( false );
		main->PrivateKeyAgainPasswordEdit->setEnabled( false );
		main->RacoonCertificatePathUrlrequester->setEnabled( true );
		main->ImportPasswordEdit->setEnabled( false );
		main->P12GroupBox->setEnabled( false );
		main->FreeswanGroupBox->setEnabled( false );
		main->FilenameUrlrequester->setFilter( "*.der *.crt" );
	}
	main->RacoonCertificatePathUrlrequester->setURL(certpath);
}


#include "importcertificatedialog.moc"
