/***************************************************************************
*   Copyright (C) 2004 by Christoph Thielecke                             *
*   crissi99@gmx.de                                                       *
*                                                                         *
*   This program is free software; you can redistribute it and/or modify  *
*   it under the terms of the GNU General Public License as published by  *
*   the Free Software Foundation; either version 2 of the License, or     *
*   (at your option) any later version.                                   *
*                                                                         *
*   This program is distributed in the hope that it will be useful,       *
*   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
*   GNU General Public License for more details.                          *
*                                                                         *
*   You should have received a copy of the GNU General Public License     *
*   along with this program; if not, write to the                         *
*   Free Software Foundation, Inc.,                                       *
*   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
***************************************************************************/
#ifndef VPNACCOUNTDATA_H
#define VPNACCOUNTDATA_H

#include <qstring.h>
#include <qobject.h>
#include <qstringlist.h>

//enum connectiontypes{vpnc,racoon,other};



/**
* holds the data for a account
* @author Christoph Thielecke
*/
class VpnAccountData : public QObject {
	public:
		enum ConnectionType {cisco=0, racoon=1, freeswan=2, pptp=3,openvpn=4,other=5};
		enum AuthenticationType {cert=0, psk=1};

		/**
		 * Konstruktor
		 * @param ConnType Type (cisco, freeswan,racoon, etc)
		 * @param Name The name of the account
		 * @param Gateway The hostname/IP of the VPN gateway
		 * @return nothing
		 */
		VpnAccountData( ConnectionType ConnType, QString Name);

		/**
		* Destruktor
		*/
		~VpnAccountData();

		QString getName(); //< returns Name
		ConnectionType getConnectionType(); //< returns Connection type
		QString getGateway(); //< returns Gateway
		QString getID(); //< returns ID
		QString getUserName(); //< returns UserName
		QString getUserPassword(); //< returns UserPassword
		QString getIkeGroup(); //< returns IkeGroup
		QString getPerfectForwardSecrety(); //< returns PerfectForwardSecrecy
		QString getNtDomainName(); //< returns NtDomainName
		QString getApplicationVersion(); //< returns ApplicationVersion
		QString getRemoteNet(); //<returns remoteNet
		QString getPreSharedKey(); // returns PreSharedKey
		QString getX509Certificate(); //< returns x509 certificate
		QString getCaCertificate(); //< returns x509 certificate (CA)
		QString getNetworkDevice(); //< returns NetworkDevice
		QString getCertPath(); //<returns CertPath
		QString getSpecialRemoteID(); //< retunr SpecialRemoteID;
		AuthenticationType getAuthType(); //< returns AuthType
		bool getSaveUserPassword(); //< returns saveUserPassword
		bool getSavePsk(); //< returns savePSK
		bool getUseSingleDes(); //< returns useSingleDes
		bool getUseIkeGroup(); //< returns useIkeGroup
		bool getUsePerfectForwardSecrety(); //< returns usePerfectSecrecy
		bool getUseNtDomainName(); //< returns useNtDomainName
		bool getUseApplicationVersion(); //< returns useApplicationVersion
		bool getUseLocalPort(); //< returns useLocalPort
		bool getUseAdvancedSettings(); //< returns useAdvancedSettings
		bool getUseGlobalIpsecSecret(); //< returns useGlobalIpsecSecret
		bool getDoPingIP(); //< returns doPingIP
		int getLocalPort(); //< returns LocalPort
		QString getPingHostIP(); //< returns last part of IP (host) for ping test
		QString getPrivateKeyPass(); //< returns PrivateKeyPass
		QString getPrivateKey(); //< returns PrivateKey
		bool getUseSpecialRemoteID(); //< returns useSpecialRemoteID
		bool getUseUdp(); //< returns useUdp
		bool getUseUdpPort(); //< returns useUdpPort
		int getUdpPort(); //< returns UdpPort
		bool getUseDnsServer();
		QString getDnsServer();
		bool getUseGetDnsFromPeer();
		bool getRefuse40BitEncryption();
    bool getRefuse128BitEncryption();
    bool getAllowStatefulMode();
    bool getRequireMppe();
    bool getRefuseEap();
		bool getUseNoIpDefault();
		bool getDisableMPPEComp();
		QString getLocalVirtualIP();
		QString getRemoteVirtualIP();
		QString getPreSharedKeyFile();
		bool getExecuteCmdBeforeConnect();
		bool getExecuteCmdAfterConnect();
		bool getExecuteCmdBeforeDisconnect();
		bool getExecuteCmdAfterDisconnect();
		QString getCommandBeforeConnect();
		QString getCommandAfterConnect();
		QString getCommandBeforeDisconnect();
		QString getCommandAfterDisconnect();
		bool getUseNoBsdComp();
		bool getUseNoDeflate();
		bool getSetDefaultRoute();
		bool getReplaceDefaultRoute();
		bool getUseMtu();
		int getMtu();
		bool getUseVirtualIP();
		QString getVirtualIP();
		bool getPskIsInFile();
		bool getUseAdditionalNetworkRoutes();
		QStringList getAdditionalNetworkRoutes();
		bool getUseSpecialServerCertificate();
		QString getSpecialServerCertificate();
		QString getHashAlgo();
		QString getTunnelDeviceType();
		bool getUseUserdefinedPort();
		int getUserdefinedPort();
		bool getKeepDefaultRoute();
		QString getDescription();
		QString getNsCertType();
		bool getUseNsCertType();
		bool getUseConnectionStatusCheck();
		int getConnectionStatusCheckSuccessCount();
		int getConnectionStatusInterval();
		bool getDoReconnectAfterConnectionLost();
		bool getDisableLzoCompression();

		/**
		 *   Sets the connection type
		 * @param type The type
		 */
		void setConnectionType( ConnectionType type );

		/**
		 *   Sets the name of the profile
		 * @param Name The new name
		 */
		void setName( QString Name );

		/**
		 *   Sets the IP/DNS name of the gateway
		 * @param Gateway the IP/DNS name
		 */
		void setGateway( QString Gateway );

		/**
		 *   Sets the remote ID (cisco)
		 * @param ID The ID
		 */
		void setID( QString ID );

		/**
		 *   Sets the group password (cisco)
		 * @param GroupPassword The password
		 */
		void setGroupPassword( QString GroupPassword );

		/**
		 *   Sets the username (cisco)
		 * @param Username The username
		 */
		void setUserName( QString Username );

		/**
		 *   Sets the user password
		 * @param UserPassword The password
		 */
		void setUserPassword( QString UserPassword );

		/**
		 *   Sets if user password should be stored or not
		 * @param saveUserPassword True if password should be stored
		 */
		void setSaveUserPassword( bool saveUserPassword );

		/**
		 *  Sets if group password should be stored or not
		 * @param saveGroupPassword True if password should be stored
		 */
		void setSavePsk( bool savePsk );

		/**
		 *   Sets the IKE group (cisco)
		 * @param IkeGroup The group
		 */
		void setIkeGroup( QString IkeGroup );

		void setPerfectForwardSecrety( QString PerfectForwardSecrecy );
		void setNtDomainName( QString Name );
		void setApplicationVersion( QString version );
		void setUseSingleDes( bool useSingleDes );
		void setLocalPort( int port );
		void setUseIkeGroup( bool useIkeGroup );
		void setUsePerfectForwardSecrety( bool usePerfectForwardSecrety );
		void setUseNtDomainName( bool useNtDomainName );
		void setUseApplicationVersion( bool useApplicationVersion );
		void setUseLocalPort( bool useLocalPort );
		void setUseAdvancedSettings( bool useAdvancedSettings );
		void setUseGlobalIpsecSecret( bool useGlobalIpsecSecret );
		void setRemoteNet( QString RemoteNet );
		void setPreSharedKey( QString PreSharedKey );
		void setX509Certificate( QString x509Certificate );
		void setCaCertificate( QString CaCertificate );
		void setNetworkDevice( QString NetworkDevice );
		void setCertPath( QString CertPath );
		void setAuthType( AuthenticationType authtype );
		void setDoPingIP( bool pingIP );
		void setPingHostIP( QString pingHostIP );
		void setPrivateKeyPass( QString PrivateKeyPass );
		void setPrivateKey( QString PrivateKey );
		void setUseSpecialRemoteID( bool useSpecialRemoteID );
		void setSpecialRemoteID( QString SpecialRemoteID );
		void setUseUdp( bool useUdp );
		void setUseUdpPort( bool useUdpPort);
		void setUdpPort( int UdpPort );
		void setUseDnsServer(bool useDnsServer );
		void setDnsServer(QString DnsServer );
		void setUseGetDnsFromPeer(bool useGetDnsFromPeer );
		void setRefuse40BitEncryption(bool refuse40BitEncryption );
    void setRefuse128BitEncryption(bool refuse128BitEncryption );
    void setAllowStatefulMode(bool allowStatefulMode );
    void setRequireMppe(bool requireMppe );
    void setRefuseEap(bool refuseEap );
		void setUseNoIpDefault (bool useNoIpDefault );
		void setDisableMPPEComp (bool disableMPPEComp );
		void setLocalVirtualIP( QString LocalVirtualIP );
		void setRemoteVirtualIP( QString RemoteVirtualIP );
		void setPreSharedKeyFile( QString PreSharedKeyFile );
		void setExecuteCmdBeforeConnect(bool executeCmdBeforeConnect);
		void setExecuteCmdAfterConnect(bool executeCmdAfterConnect);
		void setExecuteCmdBeforeDisconnect(bool executeCmdBeforeDisonnect);
		void setExecuteCmdAfterDisconnect(bool executeCmdAfterDisonnect);
		void setCommandBeforeConnect(QString CommandBeforeConnect);
		void setCommandAfterConnect(QString CommandAfterConnect);
		void setCommandBeforeDisconnect(QString CommandBeforeDisconnect);
		void setCommandAfterDisconnect(QString CommandAfterDisconnect);
		void setUseNoBsdComp(bool useNoBsdComp);
		void setUseNoDeflate(bool useNoDeflate);
		void setSetDefaultRoute(bool setDefaultRoute); 
		void setReplaceDefaultRoute(bool setReplaceDefaultRoute);
		void setUseMtu(bool useMtu);
		void setMtu (int Mtu);
		void setUseVirtualIP (bool useVirtualIP);
		void setVirtualIP( QString VirtualIP );
		void setPskIsInFile(bool PskIsInFile );
		void setUseAdditionalNetworkRoutes( bool useAdditionalNetworkRoutes );
		void setAdditionalNetworkRoutes( QStringList AdditionalNetworkRoutes );
		void setUseSpecialServerCertificate(bool useSpecialServerCertificate);
		void setSpecialServerCertificate(QString SpecialServerCertificate);
		void setHashAlgo(QString HashAlgo);
		void setTunnelDeviceType(QString TunnelDeviceType);
		void setUseUserdefinedPort(bool useUserdefinedPort);
		void setUserdefinedPort(int UserdefinedPort);
		void setKeepDefaultRoute(bool keepDefaultRoute);
		void setDescription( QString Description );
		void setNsCertType( QString NsCertType );
		void setUseNsCertType ( bool useNsCertType );
		void setUseConnectionStatusCheck ( bool useConnectionStatusCheck );
		void setConnectionStatusCheckSuccessCount ( int connectionStatusCheckSuccessCount );
		void setConnectionStatusInterval ( int connectionStatusInterval );
		void setDoReconnectAfterConnectionLost( bool doReconnectAfterConnectionLost );
		void setDisableLzoCompression(bool disableLzoCompression);

	protected:
		QString Name; //< Name of the profile
		QString Gateway; //< IP/DNS name of the gateway
		QString ID; //< ID of remote gateway
		QString Username; //< Username (cisco)
		QString UserPassword; //< User password (cisco)
		QString IkeGroup; //< DH group for PFS (cisco)
		QString PerfectForwardSecrecy; //< Type of PFS (cisco)
		QString NtDomainName; //< NT domain name for authentication (cisco/pptp)
		QString ApplicationVersion; //< userdefined application version (cisco)
		QString RemoteNet; //< Remote network of VPN
		QString PreSharedKey; //< Pre shared key (freeswan/racoon)
		QString x509Certificate; //< Path to X.509 certificate file
		QString CaCertificate; //< Path to CA certificate file
		QString NetworkDevice; //< Network device
		QString PrivateKeyPass; //< Password for private key
		QString PrivateKey; //< Path to private key file
		QString CertPath; //< Global certificate path
		QString AuthType; //< Authentication type (cert/psk)
		QString pingHostIP; //< IP of the host which should be pinged
		QString SpecialRemoteID; //< userdefined ID of remote gateway
		QString LocalVirtualIP; //< Local virtual IP for tunnel (openvpn)
		QString RemoteVirtualIP; //< Remote virtual IP for tunnel (openvpn)
		QString PreSharedKeyFile; //< for openvpn
		QString HashAlgo; // Hash algorithm for racoon
		bool saveUserPassword; //< True if the user password should be stored (cisco)
		bool savePsk; //< True if the PSK should be stored
		bool useAdvancedSettings; //< True if advanced settings should be used (cisco)
		bool useIkeGroup; //< True if userdefined IKE group should be used
		bool usePerfectForwardSecrety; //< True if userdefined PFS should be used
		bool useNtDomainName; //< True if NT domain name should eb used for authentication
		bool useApplicationVersion; //< True if userdefined application version should be used
		bool useLocalPort; //< True if userdefined local port should be used
		bool useSingleDes; //< True if DES instead of 3DES should be used
		bool useGlobalIpsecSecret; //< True if global group password from /etc/vpnc.conf should be used
		bool doPingIP; //< True if pingHostIP should be pinged after connection is established
		bool useSpecialRemoteID; //< True if userdefined ID of remote gateway instead of certificate issuer should be used
		int LocalPort; //< userdefined local port
		bool useUdp; //< True if NAT-T should be used
		bool useUdpPort; //< True if userdefined UDP port should be used
		int UdpPort; //< Port number of UDP port
		
		bool useDnsServer; //< True if userdefined DNS server should be used
		QString DnsServer; //< userdefined DNS server for pptp
		bool useGetDnsFromPeer; //< True if DNS servers should be retrieved from peer (pptp)bool 
		bool refuse40BitEncryption; //< True if 40 bit encryption is refused (pptp)
    bool refuse128BitEncryption; //< True if 128 bit encryption is refused (pptp)
    bool allowStatefulMode;
    bool requireMppe; //< True if MPPE is required (pptp)
    bool refuseEap; //< True if EAP is refused (pptp)
		bool useNoIpDefault;
		bool disableMPPEComp;
		bool executeCmdBeforeConnect;
		bool executeCmdAfterConnect;
		bool executeCmdBeforeDisconnect;
		bool executeCmdAfterDisconnect;
		QString CommandBeforeConnect;
		QString CommandAfterConnect;
		QString CommandBeforeDisconnect;
		QString CommandAfterDisconnect;
		QString Description; //< Description of the profile
		bool useNoBsdComp;
		bool useNoDeflate;
		bool setDefaultRoute; //< for PPTP
		bool replaceDefaultRoute; //< for PPTP
		bool useMtu;
		int Mtu;
		bool useVirtualIP; //< freeswan/racoon
		QString VirtualIP; //< Virtual IP for freeswan/racoon
		bool PskIsInFile; //< Read PSK from file
		bool useAdditionalNetworkRoutes;
		QStringList AdditionalNetworkRoutes;
		QString SpecialServerCertificate;
		bool useSpecialServerCertificate;
		QString TunnelDeviceType; //< Type of tunnel device which should be used e.g. tun or tap  for openvpn
		bool useUserdefinedPort;
		int UserdefinedPort;
		bool keepDefaultRoute;
		QString NsCertType; //< openvpn
		bool useNsCertType; // <openvpn
		bool useConnectionStatusCheck; //< if true it checks if the gateway is alive within a given time
		int connectionStatusCheckSuccessCount; //< in which count a check must be successful
		int connectionStatusInterval; //< interval which is used for check
		bool doReconnectAfterConnectionLost;
		bool disableLzoCompression;

	public:
		ConnectionType connectiontype; //< Type of the connection (cisco, freeswan, racoon, etc.)
		AuthenticationType authtype; //< Type of authentication (cert, psk)

};

#endif
