/*****************************************************************************
 * Copyright (C) 2004-2009 Christoph Thielecke <crissi99@gmx.de>             *
 *                                                                           *
 * This program is free software; you can redistribute it and/or modify      *
 * it under the terms of the GNU General Public License as published by      *
 * the Free Software Foundation; either version 2 of the License, or         *
 * (at your option) any later version.                                       *
 *                                                                           *
 * This package is distributed in the hope that it will be useful,           *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of            *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             *
 * GNU General Public License for more details.                              *
 *                                                                           *
 * You should have received a copy of the GNU General Public License         *
 * along with this package; if not, write to the Free Software               *
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA *
 *****************************************************************************/

#include "configdaemonoptions.h"

#include <QtCore/QVariant>
#include <QtGui/QCheckBox>
#include <QtGui/QLabel>
#include <QtGui/QLayout>
#include <QtGui/QPushButton>
#include <QtGui/QSpinBox>
#include <QtGui/QToolTip>

#include <kcombobox.h>
#include <klocale.h>
#include <kurlrequester.h>

#include "widgetnotifyhelper.h"

/**
 * Constructs a DaemonOptions as a child of 'parent',
 * with the name 'name' and widget flags set to 'f'.
 */
ConfigDaemonOptions::ConfigDaemonOptions(QWidget* parent)
{
    Q_UNUSED(parent);

    setupUi(this);

    QObject::connect(ProgramsInPathcheckBox, SIGNAL(toggled(bool)), this, SLOT(programsInPathToggled(bool)));
    WidgetNotifyHelper h;
    h.setupChangedAction(this);
    dialogModified = false;
}

ConfigDaemonOptions::~ConfigDaemonOptions()
{
}


void ConfigDaemonOptions::programsInPathToggled(bool)
{
    if (ProgramsInPathcheckBox->isChecked()) {
        //spinVpncDebugLevel->setEnabled( false );
        VpncPathInput->setEnabled(false);
        FreeswanPathInput->setEnabled(false);
        //spinRacoonDebugLevel->setEnabled( false );
        RacoonPathInput->setEnabled(false);
        OpenvpnPathInput->setEnabled(false);
//   ConfigHelperProgramOptionsWidget->OpenSSLPathInput->setEnabled( false );
//   ConfigHelperProgramOptionsWidget->IptablesPathInput->setEnabled( false );
        PppdPathInput->setEnabled(false);
    } else {
        //spinVpncDebugLevel->setEnabled( true );
        VpncPathInput->setEnabled(true);
        FreeswanPathInput->setEnabled(true);
        //spinRacoonDebugLevel->setEnabled( true );
        RacoonPathInput->setEnabled(true);
        OpenvpnPathInput->setEnabled(true);
//   ConfigHelperProgramOptionsWidget->OpenSSLPathInput->setEnabled( true );
//   ConfigHelperProgramOptionsWidget->IptablesPathInput->setEnabled( true );
        PppdPathInput->setEnabled(true);
    }
}

void ConfigDaemonOptions::dialogChanged()
{
    dialogModified = true;
}
