/*****************************************************************************
 * Copyright (C) 2004-2009 Christoph Thielecke <crissi99@gmx.de>             *
 *                                                                           *
 * This program is free software; you can redistribute it and/or modify      *
 * it under the terms of the GNU General Public License as published by      *
 * the Free Software Foundation; either version 2 of the License, or         *
 * (at your option) any later version.                                       *
 *                                                                           *
 * This package is distributed in the hope that it will be useful,           *
 * but WITHOUT ANY WARRANTY; without even the implied warranty of            *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             *
 * GNU General Public License for more details.                              *
 *                                                                           *
 * You should have received a copy of the GNU General Public License         *
 * along with this package; if not, write to the Free Software               *
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA *
 *****************************************************************************/

#include "toolsinfodialog.h"

#include <QtCore/QString>
#include <QtGui/QCursor>
#include <QtGui/QPixmap>
#include <QtGui/QToolTip>
#include <QFileInfo>
#include <QList>
#include <QTreeWidget>
#include <QTreeWidgetItem>

#include <kglobal.h>
#include <kiconloader.h>
#include <klocale.h>

#include "utils.h"

ToolsInfoDialog::ToolsInfoDialog(KVpncConfig *GlobalConfig, QWidget *parent, const char *) : KDialog(parent)
{
    QWidget *page = new QWidget(this);
    ToolsInfoWidget = new Ui_ToolsInfoWidgetBase();
    ToolsInfoWidget->setupUi(page);
    setMainWidget(page);
//  ToolsInfoWidget->InfoListView->setMinimumSize(ToolsInfoWidget->InfoListView->sizeHint());

    QIcon ok_icon = QIcon(KIconLoader::global() ->loadIcon("dialog-ok-apply", KIconLoader::NoGroup, 16));
    QIcon wrong_icon = QIcon(KIconLoader::global() ->loadIcon("dialog-close", KIconLoader::NoGroup, 16));

    setCursor(Qt::BusyCursor);
    ToolsInfoWidget->InfoListView->setMinimumSize(ToolsInfoWidget->InfoListView->sizeHint());
    ToolsInfoWidget->InfoListView->setColumnCount(7);
    QStringList LabelList;
    LabelList << i18n("VPN type") << i18n("State") << i18n("Version") << i18n("Usability") << i18n("required by") << i18n("Path") << i18n("Comment");

    QList<QTreeWidgetItem *> items;
    QStringList values;
    QTreeWidgetItem *item;

    for (int toolIdx = 0; toolIdx < GlobalConfig->ToolList->size(); ++toolIdx) {
        ToolInfo *tool = GlobalConfig->ToolList->at(toolIdx);
        QString state = "";
        QString usability = "";
        QString requiredBy = "";
        QString comment = "";

        tool->programsInPath =  GlobalConfig->programsInPath;

//   tool->collectToolInfo();

        if (!tool->PathToExec.isEmpty() && QFile(tool->PathToExec).exists() && QFileInfo(tool->PathToExec).isFile()) {
//    state=i18n("Found");
            if (tool->Name == "vpnc") {
                if (tool->Version.indexOf("3.3", 0, Qt::CaseInsensitive) > -1 || tool->Version.indexOf("4.", 0, Qt::CaseInsensitive)) {
                    usability = i18n("good");
                    comment = i18n("no certificate support");
                } else if (tool->Version.indexOf("3.2", 0, Qt::CaseInsensitive) > -1) {
                    usability = i18n("limited");
                    comment = i18n("no split DNS support");
                } else if (tool->Version.indexOf("2.", 0, Qt::CaseInsensitive) > -1) {
                    usability = i18n("basic");
                    comment = i18n("no NAT-T, IPSec over IP, no split DNS support");
                }
            } else if (tool->Name == "ciscovpnc") {
                usability = i18n("full");
            } else if (tool->Name == "ipsec") {
                // version is like this: "Openswan U2.4.4/K2.6.15" or "strongSwan U2.4.4/K2.6.15"
                QString realversion = tool->Version.section(' ', 1, 1).section('/', 0, 0).right(tool->Version.section(' ', 1, 1).section('/', 0, 0).length() - 1);
                int majorversion = realversion.section('.', 0, 0).toInt();
                int minorversion = realversion.section('.', 1, 1).toInt();
                int subminorversion = realversion.section('.', 2, 2).toInt();
                QString realtype = tool->Version.section(' ', 0, 0).toLower();

                if (tool->Version.contains("Openswan")) {
                    comment = "Openswan";
                    comment += ", " + i18n("kernel %1 support", QString("2.6"));
                    comment += ", " + i18n("smartcard support");
                } else if (tool->Version.contains("strongSwan")) {
                    comment = "strongSwan";
                    comment += ", " + i18n("no aggressive mode");
                    comment += ", " + i18n("kernel %1 support", QString("2.4"));
                    if (!(majorversion <= 2 && minorversion <= 8 && subminorversion <= 1))
                        comment += ", " + i18n("kernel %1 support", QString("2.6"));
                    comment += ", " + i18n("smartcard support");
                } else {
                    comment += "FreeS/WAN";
                }

                if (realversion.indexOf("2.", 0, Qt::CaseInsensitive) > -1)
                    usability = i18n("full");
                else if (realversion.indexOf("1.", 0, Qt::CaseInsensitive) > -1) {
                    usability = i18n("limited");
                    comment = + ", " + i18n("no aggressive mode");
                } else
                    usability = i18n("unknown");

            } else if (tool->Name == "racoon") {
                //if ( tool->Version.indexOf("2.",0,-1) > -1)
                usability = i18n("full");
                //else if ( tool->Version.indexOf("2.",0,-1) > -1)
                // usability=i18n("limited");
            } else if (tool->Name == "openvpn") {
                if (tool->Version.indexOf("2.", 0, Qt::CaseInsensitive) > -1) {
                    usability = i18n("full");
//      int major=tool->Version.section('.',0,0).toInt();
//      int minor=tool->Version.section('.',1,1).toInt();
//      int subminor=tool->Version.section('.',2,2).toInt();

//      if ( major >= 2 && minor >= 1)
                    if (tool->Capabilities.indexOf(i18n("pkcs11 support"), 0, Qt::CaseInsensitive) > -1) {
                        if (!comment.isEmpty())
                            comment += ", ";
                        comment += i18n("smartcard support");
                    }
                } else if (tool->Version.indexOf("1.", 0, Qt::CaseInsensitive) > -1)
                    //else
                    usability = i18n("limited");
            } else if (tool->Name == "pppd") {
                //if ( tool->Version.indexOf("2.",0,-1) > -1)
                usability = i18n("full");
                //else if ( tool->Version.indexOf("2.",0,-1) > -1)
                // usability=i18n("limited");

                Utils::PppdCapabilities pppdcap = Utils(GlobalConfig).checkPppdCapabilities();
                comment = "";
                if (pppdcap.pppdHasMppeRequiredSupport == true) {
                    if (!comment.isEmpty())
                        comment += ",";
                    comment += "mppe required";
                }
                if (pppdcap.pppdHasRequireMppeSupport == true) {
                    if (!comment.isEmpty())
                        comment += ",";
                    comment += "require-mppe";
                }
                if (pppdcap.pppdHasReplacedefaultrouteSupport == true) {
                    if (!comment.isEmpty())
                        comment += ",";
                    comment += "replacedefaultroute";
                }
                if (pppdcap.pppdHasMppeSupport == true) {
                    if (!comment.isEmpty())
                        comment += ",";
                    comment += "mppe support";
                }
            } else if (tool->Name == "pptp") {
                //if ( tool->Version.indexOf("2.",0,-1) > -1)
                usability = i18n("full");
                //else if ( tool->Version.indexOf("2.",0,-1) > -1)
                // usability=i18n("limited");
            } else if (tool->Name == "vtund") {
                //if ( tool->Version.indexOf("2.",0,-1) > -1)
                usability = i18n("full");
                //else if ( tool->Version.indexOf("2.",0,-1) > -1)
                // usability=i18n("limited");
            } else if (tool->Name == "ping") {
                //if ( tool->Version.indexOf("2.",0,-1) > -1)
                usability = i18n("full");
                //else if ( tool->Version.indexOf("2.",0,-1) > -1)
                // usability=i18n("limited");
            } else if (tool->Name == "pkcs11-tool") {
                //if ( tool->Version.indexOf("2.",0,-1) > -1)
                usability = i18n("full");
                //else if ( tool->Version.indexOf("2.",0,-1) > -1)
                // usability=i18n("limited");
            }

            else if (tool->Name == "cisco_cert_mgr") {
                //if ( tool->Version.indexOf("2.",0,-1) > -1)
                usability = i18n("full");
                //else if ( tool->Version.indexOf("2.",0,-1) > -1)
                // usability=i18n("limited");
                requiredBy = i18n("Cisco (proprietary)");
            }

            else if (tool->Name == "kill") {
                //if ( tool->Version.indexOf("2.",0,-1) > -1)
                usability = i18n("full");
                //else if ( tool->Version.indexOf("2.",0,-1) > -1)
                // usability=i18n("limited");
            } else if (tool->Name == "ip") {
                //if ( tool->Version.indexOf("2.",0,-1) > -1)
                usability = i18n("full");
                //else if ( tool->Version.indexOf("2.",0,-1) > -1)
                // usability=i18n("limited");
            } else if (tool->Name == "ifconfig") {
                //if ( tool->Version.indexOf("2.",0,-1) > -1)
                usability = i18n("full");
                //else if ( tool->Version.indexOf("2.",0,-1) > -1)
                // usability=i18n("limited");
            } else if (tool->Name == "route") {
                //if ( tool->Version.indexOf("2.",0,-1) > -1)
                usability = i18n("full");
                //else if ( tool->Version.indexOf("2.",0,-1) > -1)
                // usability=i18n("limited");
            } else if (tool->Name == "bash") {
                //if ( tool->Version.indexOf("2.",0,-1) > -1)
                usability = i18n("full");
                //else if ( tool->Version.indexOf("2.",0,-1) > -1)
                // usability=i18n("limited");
            } else if (tool->Name == "iptables") {
                //if ( tool->Version.indexOf("2.",0,-1) > -1)
                usability = i18n("full");
                //else if ( tool->Version.indexOf("2.",0,-1) > -1)
                // usability=i18n("limited");
            } else if (tool->Name == "killall") {
                //if ( tool->Version.indexOf("2.",0,-1) > -1)
                usability = i18n("full");
                //else if ( tool->Version.indexOf("2.",0,-1) > -1)
                // usability=i18n("limited");
            } else if (tool->Name == "openssl") {
                //if ( tool->Version.indexOf("2.",0,-1) > -1)
                usability = i18n("full");
                //else if ( tool->Version.indexOf("2.",0,-1) > -1)
                // usability=i18n("limited");
            } else if (tool->Name == "setkey") {
                //if ( tool->Version.indexOf("2.",0,-1) > -1)
                usability = i18n("full");
                //else if ( tool->Version.indexOf("2.",0,-1) > -1)
                // usability=i18n("limited");
            } else if (tool->Name == "vpnclient") {
                //if ( tool->Version.indexOf("2.",0,-1) > -1)
                usability = i18n("full");
                //else if ( tool->Version.indexOf("2.",0,-1) > -1)
                // usability=i18n("limited");
            } else if (tool->Name == "l2tpd") {
                //if ( tool->Version.indexOf("2.",0,-1) > -1)
//     usability=i18n("full");
                //else if ( tool->Version.indexOf("2.",0,-1) > -1)
                // usability=i18n("limited");
            } else if (tool->Name == "xl2tpd") {
                //if ( tool->Version.find("2.",0,-1) > -1)
//     usability=i18n("full");
                //else if ( tool->Version.find("2.",0,-1) > -1)
                // usability=i18n("limited");
            } else if (tool->Name == "openl2tp") {
                //if ( tool->Version.find("2.",0,-1) > -1)
//     usability=i18n("full");
                //else if ( tool->Version.indexOf("2.",0,-1) > -1)
                // usability=i18n("limited");
            } else if (tool->Name == "tail") {
//                 comment += ", " + i18n("kernel %1 support", QString("2.6"));
            } else if (tool->Name == "ssh") {
                int major = tool->Version.section('.', 0, 0).toInt();
                int minor = tool->Version.section('.', 1, 1).section('p', 0, 0).toInt();
                if (major > 4 || (major == 4 && minor >= 3)) {
                    usability = i18n("full");
                } else {
                    if (major < 4)
                        //else
                        usability = i18n("unusable");
                    comment += i18n("no vpn support");
                }
            }

            else {
                // other tools
                usability = i18n("full");
            }

        } else {
//    state=i18n("Not found");
            usability = i18n("none");
        }

//   state=i18n("Found");
        if (tool->Name == "vpnc") {
            requiredBy = i18n("Cisco (free)");
        } else if (tool->Name == "ciscovpnc") {
            requiredBy = i18n("Cisco (proprietary)");
        } else if (tool->Name == "ipsec") {
            QString realversion = tool->Version.section(' ', 1, 1).section('/', 0, 0).right(tool->Version.section(' ', 1, 1).section('/', 0, 0).length() - 1);
            QString realtype = tool->Version.section(' ', 0, 0).toLower();

            if (tool->Version.contains("Openswan")) {
                requiredBy = i18n("Openswan");
            } else if (tool->Version.contains("strongSwan")) {
                requiredBy = i18n("strongSwan");
            } else {
                requiredBy = i18n("FreeS/WAN");
            }

        }

        else if (tool->Name == "racoon") {
            requiredBy = i18n("ipsec-tools (racoon)");
        } else if (tool->Name == "openvpn") {
            requiredBy = i18n("OpenVPN");
        } else if (tool->Name == "pppd") {
            requiredBy = i18n("PPTP");
        } else if (tool->Name == "pptp") {
            requiredBy = i18n("PPTP");
        } else if (tool->Name == "vtund") {
            requiredBy = i18n("VTun");
        } else if (tool->Name == "ping") {
            requiredBy = i18n("KVpnc");
        } else if (tool->Name == "pkcs11-tool") {
            requiredBy = i18n("Smartcard support");
        }

        else if (tool->Name == "cisco_cert_mgr") {
            requiredBy = i18n("Cisco (proprietary)");
        }

        else if (tool->Name == "kill") {
            requiredBy = i18n("KVpnc");
        } else if (tool->Name == "ip") {
            requiredBy = i18n("KVpnc");
        } else if (tool->Name == "ifconfig") {
            requiredBy = i18n("KVpnc");
        } else if (tool->Name == "route") {
            requiredBy = i18n("KVpnc");
        } else if (tool->Name == "bash") {
            requiredBy = i18n("KVpnc");
        } else if (tool->Name == "iptables") {
            requiredBy = i18n("KVpnc");
        } else if (tool->Name == "killall") {
            requiredBy = i18n("KVpnc");
        } else if (tool->Name == "openssl") {
            requiredBy = i18n("Certificate support");
        } else if (tool->Name == "setkey") {
            requiredBy = i18n("ipsec-tools (racoon)");
        } else if (tool->Name == "vpnclient") {
            requiredBy = i18n("Cisco (proprietary)");
        } else if (tool->Name == "l2tpd") {
            requiredBy = i18n("L2TP");
        } else if (tool->Name == "xl2tpd") {
            requiredBy = i18n("L2TP");
        } else if (tool->Name == "openl2tpd") {
            requiredBy = i18n("L2TP");
        } else if (tool->Name == "tail") {
            requiredBy = i18n("ipsec (Openswan, strongSwan, racoon)");
        } else if (tool->Name == "ssh") {
            requiredBy = i18n("SSH VPN");
        } else if (tool->Name == "ksshaskpass") {
            requiredBy = i18n("SSH VPN");
        } else if (tool->Name == "gnome-ssh-askpass") {
            requiredBy = i18n("SSH VPN");
        } else {
            // other tools
        }



        values.clear();
        values << tool->Name << state << tool->Version << usability << requiredBy << tool->PathToExec << comment;
        item = new QTreeWidgetItem((QTreeWidget*)0, values);
        QString tipStr = QString("<h2>" + tool->Name + "</h2><ul><li>" + i18n("Usability:") + " " + usability + "</li><li>" + i18n("Required by:") + " " + requiredBy + "</li></ul>");

        item->setToolTip(0, tipStr);
        item->setToolTip(1, tipStr);
        item->setToolTip(2, tipStr);
        item->setToolTip(3, tipStr);

        if (tool->found == true)
            item->setIcon(0, ok_icon);
        else
            item->setIcon(0, wrong_icon);
        items.append(item);

    }
    ToolsInfoWidget->InfoListView->insertTopLevelItems(0, items);


    this->resize(800, 600);
    ToolsInfoWidget->InfoListView->resize(ToolsInfoWidget->InfoListView->sizeHint());
    resize(sizeHint());
    this->resize(sizeHint());

    setCursor(Qt::ArrowCursor);
}

