#!/usr/bin/ruby

###
### W3C Markup Validation Service for Kwartz
###

host = 'validator.w3.org'
port = 80
path = '/check'
name = 'uploaded_file'

method = ENV['REQUEST_METHOD']
if !method || method != 'POST' then

    print "Content-type: text/html\r\n\r\n"
    html = <<-END
    <html>
      <meta>
        <title>W3C Markup Validation Service for Kwartz</title>
      </meta>
      <body>
        <h2>W3C Markup Validation Service for Kwartz</h2>
        <form method="post" action="#{ENV['SCRIPT_NAME']}"
              enctype="multipart/form-data" >
          Local File:
          <input type="file" name="#{name}" size="30" /><br>
          &nbsp;Attribute:
          <input type="text" name="attr_name" size="5" value="kd" /><br><br>
          <input type="submit" value=" Validate Now!" />
        </form>
      </body>
    </html>
    END
    print html

else

    require 'cgi'
    cgi      = CGI.new
    values   = cgi[name]
    filename = values.original_filename
    content  = values.read
    conttype = values.content_type

    attr_name = cgi['attr_name'].read
    attr_name = 'kd' if !attr_name || attr_name.empty?
    $stderr.print "*** deubg:attr_name=#{attr_name}\n"
    content.gsub!(/\b#{attr_name}=(\".*?\"|[-\#@%:;\w]+)/, '')

    boundary = "------8<--------8<--------8<--------8<--------"
    data = <<END
--#{boundary}\r
Content-Disposition: form-data; name="#{name}"; filename="#{filename}"\r
Content-Type: #{conttype}\r
\r
#{content}
\r
--#{boundary}--\r
END

    header = {
	'Content-Length' => data.length.to_s,
	'Content-Type'   => "multipart/form-data; boundary=#{boundary}",
    }

    require 'net/http'
    http = Net::HTTP.new(host, port)
    resp_header, resp_body = http.post(path, data, header)

    print "Content-Type: text/html\r\n\r\n"
    if resp_header.code == '200' then
	print resp_body
    else
	print "<html><body>\n"
	print "<h2>ERROR: response code = #{resp_header.code}</h2>\n"
	print "</body></html>\n"
    end

end
