/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef CONFIGDIALOG_H
#define CONFIGDIALOG_H

#include <stdio.h>

#include <kdialogbase.h>
#include <kprocess.h>
#include <kwinmodule.h>

#include <qstring.h>
#include <qlineedit.h>
#include <qradiobutton.h>
#include <qbuttongroup.h>
#include <qpushbutton.h>
#include <qcombobox.h>
#include <qvbox.h>
#include <qcheckbox.h>
#include <qthread.h>

class ConfigDialog : public KDialogBase
{
    Q_OBJECT
public:
    ConfigDialog(QWidget *parent, KProcess **helperP, FILE **helperFifoP);
    QString getInterfaceName();
    int getPMMode();
    int getPMM();
    int getBRMode();
    int getBRManualIdx();
    void disableSettings();
    void enableSettings();
    void menuEnableSettings();
    bool settingsEnabled() { return mSettingsPage->isEnabled(); }
    bool batteryPMEnabled() { return mPMBattery->isChecked(); }
    bool transferPMEnabled() { return mPMTransfer->isChecked(); }
    QString getNewESSID() { return mESSIDBox->text(); }
   
    // XXX
    KProcess **mHelperP;
    FILE **mHelperFifoP;

protected slots:
    void slotPMMClicked();
    void slotPMAClicked();
    void slotRBClicked(int id);
    void slotBRClicked();
    void slotDetectClicked();
    void slotShowingPage(QWidget *page);
    void slotHelperExited(KProcess *helper);
    void slotWMWindowAdded(WId id);
    void slotPMEnableClicked();
    void slotPMDisableClicked();

private:
    class HelperSyncThread : public QThread
    {
    public:
        HelperSyncThread(ConfigDialog * cd);
        virtual void run();

    private:
        ConfigDialog *mConfigDialog;
    };

    QVBox *mInterfacePage;
    QVBox *mSettingsPage;
    QVBox *mNetworkPage;

    QLineEdit *mInterfaceBox;
    QRadioButton *mRBDetect;
    QRadioButton *mRBManual;
    QButtonGroup *mRBGroup;
    int mCurrentMode;
    QPushButton *mDetectButton;
    QComboBox *mInterfaceCombo;

    QRadioButton *mPMManual;
    QRadioButton *mPMAuto;
    QButtonGroup *mPMMGroup;

    QPushButton *mPMEnableButton;
    QPushButton *mPMDisableButton;
    //QRadioButton *mPMOn;
    //QRadioButton *mPMOff;
    //QButtonGroup *mPMGroup;
    QCheckBox *mPMBattery;
    QCheckBox *mPMTransfer;

    QRadioButton *mBRAuto;
    QRadioButton *mBRManual;
    QComboBox *mBRCombo;
    QButtonGroup *mBRGroup;

    QLineEdit *mESSIDBox;

    HelperSyncThread *mHelperSyncThread;

    KWinModule *mKWinModule;
};

#endif /* CONFIGDIALOG_H */
