/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef INTERFACEMONITOR_H
#define INTERFACEMONITOR_H

#include <qstring.h>

#include "kwirelessmonitor.h"

class InterfaceMonitor
{
public:
    InterfaceMonitor(const QString& ifName);
    ~InterfaceMonitor();
    void setInterface(const QString& ifName);
    const struct wirelessStats *getStats();
    void getTransferBytes(unsigned long long *rx, unsigned long long *tx);

private:
    QString mIFName;
    int mIFSocket;
    struct wirelessStats mIFStats;

    void initializeBitrateLists();
};

#endif /* INTERFACEMONITOR_H */
