

#include "kprofileconfigdlg.h"
#include "kwlaninterface.h"
#include <qcombobox.h>
#include <qlineedit.h>
#include <qradiobutton.h>
#include <qpushbutton.h>
#include <kmessagebox.h>
#include <kfiledialog.h>
#include <klocale.h>
#include <kdebug.h>
#include <qcheckbox.h>

enum {
    AUTH_NONE = 0,
    AUTH_IEEE8021X = 1,
    AUTH_WPA_PSK = 2,
    AUTH_WPA_EAP = 3,
    AUTH_WPA2_PSK = 4,
    AUTH_WPA2_EAP = 5
};


KProfileConfigDlg::KProfileConfigDlg(QWidget* parent, const char* name, bool modal, WFlags fl)
    : KProfileConfig(parent,name, modal,fl)
{
    m_interface = NULL;
    m_newNetwork = false;

}

KProfileConfigDlg::~KProfileConfigDlg()
{}

/*$SPECIALIZATION$*/
void KProfileConfigDlg::dhcpState(int state)
{
    state = !state;
    leIpAddress->setEnabled(state);
    leNetmask->setEnabled(state);
    leGateway->setEnabled(state);
    lePrimaryDns->setEnabled(state);
    leSecondaryDns->setEnabled(state);
    leDomainName->setEnabled(state);
    cbDontOverrideDns->setEnabled(state);
    cbDontOverrideGw->setEnabled(state);}


void KProfileConfigDlg::browseForServerCertificate()
{
    QString file = KFileDialog::getOpenFileName ();
    if (!file.isEmpty())
        leServerCertificate->setText(file);
}

void KProfileConfigDlg::browseForPrivateKey()
{
    QString file = KFileDialog::getOpenFileName ();
    if (!file.isEmpty())
        lePrivateKey->setText(file);
}

void KProfileConfigDlg::browseForCertificate()
{
    QString file = KFileDialog::getOpenFileName ();
    if (!file.isEmpty())
        leCertificate->setText(file);
}

void KProfileConfigDlg::setInterface( KWlanInterface * interface )
{
    m_interface = interface;
    connect (this, SIGNAL(profileAdded()), m_interface, SLOT(profileAdded()));
}

void KProfileConfigDlg::getEapCapa()
{
  char reply[256];
  size_t reply_len;

  if (m_interface == NULL)
    return;

  reply_len = sizeof(reply) - 1;
  if (m_interface->ctrlRequest("GET_CAPABILITY eap", reply, &reply_len) < 0)
    return;
  reply[reply_len] = '\0';

  QString res(reply);
  QStringList types = QStringList::split(QChar(' '), res);
  cbEap->insertStringList(types);
}

void KProfileConfigDlg::wepEnabled( bool enabled )
{
    leWep0->setEnabled(enabled);
    leWep1->setEnabled(enabled);
    leWep2->setEnabled(enabled);
    leWep3->setEnabled(enabled);
    rbWep0->setEnabled(enabled);
    rbWep1->setEnabled(enabled);
    rbWep2->setEnabled(enabled);
    rbWep3->setEnabled(enabled);
    rbOpen->setEnabled(enabled);
    rbShared->setEnabled(enabled);
}

void KProfileConfigDlg::newNetwork()
{
  m_newNetwork = true;
  getEapCapa();
}

void KProfileConfigDlg::paramsFromConfig(KWlanInterface *interface, QString ssid  )
{
    int i, counter;
    QString ipaddress, netmask,gateway,dns1,dns2,domain;
    bool useDhcp, dontOverrideIp,dontOverrideDns;

    m_editNetworkID = interface->getWpaId( ssid);
    if (m_editNetworkID==-1 ) m_newNetwork = TRUE;
    getEapCapa();
    
    char reply[1024], cmd[256], *pos;
    size_t reply_len;
    leSSID->setText(ssid);
    leSSID->setEnabled(FALSE);
    snprintf(cmd, sizeof(cmd), "GET_NETWORK %d proto", m_editNetworkID);
    reply_len = sizeof(reply);
    int wpa = 0;
    if (interface->ctrlRequest(cmd, reply, &reply_len) >= 0) {
        reply[reply_len] = '\0';
        if (strstr(reply, "RSN") || strstr(reply, "WPA2"))
            wpa = 2;
        else if (strstr(reply, "WPA"))
            wpa = 1;
    }
    int auth = AUTH_NONE, encr = 0;
    snprintf(cmd, sizeof(cmd), "GET_NETWORK %d key_mgmt", m_editNetworkID);
    reply_len = sizeof(reply);
    if (interface->ctrlRequest(cmd, reply, &reply_len) >= 0) {
        reply[reply_len] = '\0';
        if (strstr(reply, "WPA-EAP"))
            auth = wpa & 2 ? AUTH_WPA2_EAP : AUTH_WPA_EAP;
        else if (strstr(reply, "WPA-PSK"))
            auth = wpa & 2 ? AUTH_WPA2_PSK : AUTH_WPA_PSK;
        else if (strstr(reply, "IEEE8021X")) {
            auth = AUTH_IEEE8021X;
            encr = 1;
        }
    }
    

    snprintf(cmd, sizeof(cmd), "GET_NETWORK %d pairwise", m_editNetworkID);
    reply_len = sizeof(reply);
    if (interface->ctrlRequest(cmd, reply, &reply_len) >= 0) {
        reply[reply_len] = '\0';
        if (strstr(reply, "CCMP"))
            encr = 1;
        else if (strstr(reply, "TKIP"))
            encr = 0;
        else if (strstr(reply, "WEP"))
            encr = 1;
        else
            encr = 0;
    }

    snprintf(cmd, sizeof(cmd), "GET_NETWORK %d psk", m_editNetworkID);
    reply_len = sizeof(reply);
    if (interface->ctrlRequest(cmd, reply, &reply_len) >= 0 && reply_len >= 2 && reply[0] == '"') {
        reply[reply_len] = '\0';
        pos = strchr(reply + 1, '"');
        if (pos)
            *pos = '\0';
        lePsk->setText(reply + 1);
    }

    snprintf(cmd, sizeof(cmd), "GET_NETWORK %d identity", m_editNetworkID);
    reply_len = sizeof(reply);
    if (interface->ctrlRequest(cmd, reply, &reply_len) >= 0 && reply_len >= 2 &&
        reply[0] == '"') {
        reply[reply_len] = '\0';
        pos = strchr(reply + 1, '"');
        if (pos)
            *pos = '\0';
        leIdentity->setText(reply + 1);
     }

     snprintf(cmd, sizeof(cmd), "GET_NETWORK %d password", m_editNetworkID);
    reply_len = sizeof(reply);
    if (interface->ctrlRequest(cmd, reply, &reply_len) >= 0 && reply_len >= 2 &&
        reply[0] == '"') {
        reply[reply_len] = '\0';
        pos = strchr(reply + 1, '"');
        if (pos)
            *pos = '\0';
        lePassword->setText(reply + 1);
    }

    snprintf(cmd, sizeof(cmd), "GET_NETWORK %d client_cert", m_editNetworkID);
    reply_len = sizeof(reply);
    if (interface->ctrlRequest(cmd, reply, &reply_len) >= 0 && reply_len >= 2 && reply[0] == '"') {
        reply[reply_len] = '\0';
        pos = strchr(reply + 1, '"');
        if (pos)
            *pos = '\0';
        leCertificate->setText(reply + 1);
    }
    snprintf(cmd, sizeof(cmd), "GET_NETWORK %d ca_cert", m_editNetworkID);
    reply_len = sizeof(reply);
    if (interface->ctrlRequest(cmd, reply, &reply_len) >= 0 && reply_len >= 2 && reply[0] == '"') {
        reply[reply_len] = '\0';
        pos = strchr(reply + 1, '"');
        if (pos)
            *pos = '\0';
        leServerCertificate->setText(reply + 1);
    }
    snprintf(cmd, sizeof(cmd), "GET_NETWORK %d private_key", m_editNetworkID);
    reply_len = sizeof(reply);
    if (interface->ctrlRequest(cmd, reply, &reply_len) >= 0 && reply_len >= 2 &&
        reply[0] == '"') {
        reply[reply_len] = '\0';
        pos = strchr(reply + 1, '"');
        if (pos)
            *pos = '\0';
        lePrivateKey->setText(reply + 1);
    }

    snprintf(cmd, sizeof(cmd), "GET_NETWORK %d eap", m_editNetworkID);
    reply_len = sizeof(reply);
    if (interface->ctrlRequest(cmd, reply, &reply_len) >= 0 && reply_len >= 1) {
        reply[reply_len] = '\0';
        for (i = 0; i < cbEap->count(); i++) {
            if (cbEap->text(i).compare(reply) == 0) {
                cbEap->setCurrentItem(i);
                break;
            }
        }
    }

    for (i = 0; i < 4; i++) {
        snprintf(cmd, sizeof(cmd), "GET_NETWORK %d wep_key%d", m_editNetworkID, i);
        reply_len = sizeof(reply);
        if (interface->ctrlRequest(cmd, reply, &reply_len) >= 0 && reply_len >= 2) {
            reply[reply_len] = '\0';
            if (reply[0] == '"'){
                pos = strchr(reply + 1, '"');
                if (pos)
                    *pos = '\0';
                for (counter = 1; reply[counter]!='\0';counter++)
                    reply[counter-1]=reply[counter];
                reply[counter-1]='\0';
            }
            else {
                // HEX Key
                reply[reply_len] = '\0';
            }
            if (strncmp(reply,"FAIL",4)){
                switch (i) {
                    case 0:
                        leWep0->setText(reply);
                        break;
                    case 1:
                        leWep1->setText(reply);
                        break;
                    case 2:
                        leWep2->setText(reply);
                        break;
                    case 3:
                        leWep3->setText(reply);
                        break;
                }
            }
        }
    }

    snprintf(cmd, sizeof(cmd), "GET_NETWORK %d wep_tx_keyidx", m_editNetworkID);
    reply_len = sizeof(reply);
    if (interface->ctrlRequest(cmd, reply, &reply_len) >= 0 && reply_len >= 1) {
        reply[reply_len] = '\0';
        switch (atoi(reply)) {
            case 0:
                rbWep0->setChecked(true);
                break;
            case 1:
                rbWep1->setChecked(true);
                break;
            case 2:
                rbWep2->setChecked(true);
                break;
            case 3:
                rbWep3->setChecked(true);
                break;
        }
    }
    // check for exesting WEP Key -> -> wep enabled
    if (auth == AUTH_NONE || auth == AUTH_IEEE8021X)
    { 
        if (leWep0->text().isEmpty() && leWep2->text().isEmpty() && leWep2->text().isEmpty() && leWep3->text().isEmpty())
            encr = 0;
    }
    snprintf(cmd, sizeof(cmd), "GET_NETWORK %d auth_alg", m_editNetworkID);
    reply_len = sizeof(reply);
    if (interface->ctrlRequest(cmd, reply, &reply_len) >= 0 && reply_len >= 1) {
        reply[reply_len] = '\0';
        if (strcmp(reply,"OPEN")==0)
            rbOpen->setChecked(TRUE);
        else rbShared->setChecked(TRUE);
    }
    cbAuthentication->setCurrentItem(auth);
    authChanged(auth);
    cbEncryption->setCurrentItem(encr);
    if (auth == AUTH_NONE || auth == AUTH_IEEE8021X)
        wepEnabled(encr == 1);
    // Now fill in IP settings

    m_interface->getConfiguration()->readIpSettings(ssid,useDhcp, ipaddress, netmask, gateway, dns1, dns2,domain,dontOverrideIp,dontOverrideDns);
    cbDhcp->setChecked(useDhcp);
    leIpAddress->setText(ipaddress);
    leNetmask->setText(netmask);
    leGateway->setText(gateway);
    lePrimaryDns->setText(dns1);
    leSecondaryDns->setText(dns2);
    leDomainName->setText(domain);
    cbDontOverrideGw->setChecked(dontOverrideIp);
    cbDontOverrideDns->setChecked(dontOverrideDns);

//pbRemove->setEnabled(true);
    pbAdd->setText("Save");
}

int KProfileConfigDlg::setNetworkParam( int id, const char * field, const char * value, bool quote )
{
    char reply[10], cmd[256];
    size_t reply_len;
    snprintf(cmd, sizeof(cmd), "SET_NETWORK %d %s %s%s%s",id, field, quote ? "\"" : "", value, quote ? "\"" : "");
    reply_len = sizeof(reply);
    m_interface->ctrlRequest(cmd, reply, &reply_len);
    return strncmp(reply, "OK", 2) == 0 ? 0 : -1;
}


void KProfileConfigDlg::paramsFromScanResults(QListViewItem * sel  )
{
    m_newNetwork = true;

    /* SSID BSSID frequency signal flags */
    setCaption(sel->text(0));
    leSSID->setText(sel->text(0));
    
    QString flags = sel->text(4);
    int auth, encr = 0;
    if (flags.find("[WPA2-EAP") >= 0)
        auth = AUTH_WPA2_EAP;
    else if (flags.find("[WPA-EAP") >= 0)
        auth = AUTH_WPA_EAP;
    else if (flags.find("[WPA2-PSK") >= 0)
        auth = AUTH_WPA2_PSK;
    else if (flags.find("[WPA-PSK") >= 0)
        auth = AUTH_WPA_PSK;
    else
        auth = AUTH_NONE;
    
    if (flags.find("-CCMP") >= 0)
        encr = 1;
    else if (flags.find("-TKIP") >= 0)
        encr = 0;
    else if (flags.find("WEP") >= 0)
        encr = 1;
    else
        encr = 0;
 
    cbAuthentication->setCurrentItem(auth);
    authChanged(auth);
    cbEncryption->setCurrentItem(encr);
    encrChanged( cbEncryption->currentText());

    getEapCapa();}


void KProfileConfigDlg::writeWepKey( int network_id, QLineEdit * edit, int id )
{
    char buf[10];
    bool hex;
    const char *txt, *pos;
    size_t len;
  
    if (!edit->isEnabled() || edit->text().isEmpty())
        return;
    
    /*
    * Assume hex key if only hex characters are present and length matches
    * with 40, 104, or 128-bit key
    */
    txt = edit->text().ascii();
    len = strlen(txt);
    if (len == 0)
        return;
    pos = txt;
    hex = true;
    while (*pos) {
        if (!((*pos >= '0' && *pos <= '9') || (*pos >= 'a' && *pos <= 'f') ||
                (*pos >= 'A' && *pos <= 'F'))) {
            hex = false;
            break;
                }
                pos++;
    }
    if (hex && len != 10 && len != 26 && len != 32)
        hex = false;
    snprintf(buf, sizeof(buf), "wep_key%d", id);
    if (setNetworkParam(network_id, buf, txt, !hex)!=0){
        KMessageBox::sorry(this,i18n("Could not write Wep Key! Maybe the Format is wrong."));

    }
}

void KProfileConfigDlg::encrChanged( const QString & sel )
{
    wepEnabled(sel.find("WEP") == 0);
}

void KProfileConfigDlg::addNetwork()
{
    char reply[10], cmd[256];
    size_t reply_len;
    int id;
    int psklen = lePsk->text().length();
    int auth = cbAuthentication->currentItem();
    if (auth == AUTH_WPA_PSK || auth == AUTH_WPA2_PSK) {
        if (psklen < 8 || psklen > 64) {
            KMessageBox::sorry(this, "WPA-PSK requires a passphrase of 8 to 63 characters\n or 64 hex digit PSK");
            return;
        }
    }
        
    if (m_interface == NULL)
        return;
    
    memset(reply, 0, sizeof(reply));
    //reply_len = sizeof(reply) - 1;
    if (!m_newNetwork){
        //First delete Network to clear all settings
        snprintf(cmd, sizeof(cmd), "REMOVE_NETWORK %d", m_editNetworkID);
        reply_len = sizeof(reply);
        m_interface->ctrlRequest(cmd, reply, &reply_len);
        kdDebug() << cmd << " " << reply << endl;
        if (reply[0] == 'F') {
            KMessageBox::sorry(this, i18n("Failed to remove network to wpa_supplicant\nconfiguration."));
            return;
        }
    }
    m_interface->ctrlRequest("ADD_NETWORK", reply, &reply_len);
    if (reply[0] == 'F') {
        KMessageBox::sorry(this,  i18n("Failed to add network to wpa_supplicant\nconfiguration."));
        return;
    }
    id = atoi(reply);
    m_editNetworkID = id;

    setNetworkParam(id, "ssid", leSSID->text().ascii(), true);
    
    char *key_mgmt = NULL, *proto = NULL, *pairwise = NULL;
    switch (auth) {
        case AUTH_NONE:
            key_mgmt = "NONE";
            break;
        case AUTH_IEEE8021X:
            key_mgmt = "IEEE8021X";
            break;
        case AUTH_WPA_PSK:
            key_mgmt = "WPA-PSK";
            proto = "WPA";
            break;
        case AUTH_WPA_EAP:
            key_mgmt = "WPA-EAP";
            proto = "WPA";
            break;
        case AUTH_WPA2_PSK:
            key_mgmt = "WPA-PSK";
            proto = "WPA2";
            break;
        case AUTH_WPA2_EAP:
            key_mgmt = "WPA-EAP";
            proto = "WPA2";
            break;
    }
    if ((auth == AUTH_NONE) && (cbEncryption->currentText()=="None")){
        kdDebug() << "cbEncryption is None " << endl;
        m_interface->getConfiguration()->writeEncryption(leSSID->text(), FALSE);
    }
    else m_interface->getConfiguration()->writeEncryption(leSSID->text(), TRUE);
            
    if (auth == AUTH_WPA_PSK || auth == AUTH_WPA_EAP ||
        auth == AUTH_WPA2_PSK || auth == AUTH_WPA2_EAP) {
        int encr = cbEncryption->currentItem();
        if (encr == 0)
            pairwise = "TKIP";
        else
            pairwise = "CCMP";
            //strcpy(pairwise, "CCMP");
        }
    
        if (proto)
            setNetworkParam(id, "proto", proto, false);
        if (key_mgmt)
            setNetworkParam(id, "key_mgmt", key_mgmt, false);
        if (pairwise) {
            setNetworkParam(id, "pairwise", pairwise, false);
            setNetworkParam(id, "group", "TKIP CCMP WEP104 WEP40", false);
        }
        if (lePsk->isEnabled())
            setNetworkParam(id, "psk", lePsk->text().ascii(), psklen != 64);
        if (cbEap->isEnabled())
            setNetworkParam(id, "eap", cbEap->currentText().ascii(), false);
        if (leIdentity->isEnabled())
            setNetworkParam(id, "identity", leIdentity->text().ascii(), true);
        if (lePassword->isEnabled())
            if (!lePassword->text().isEmpty())
            setNetworkParam(id, "password", lePassword->text().ascii(), true);
        if (leCertificate->isEnabled())
            if (!leCertificate->text().isEmpty())
            setNetworkParam(id, "client_cert", leCertificate->text().ascii(), true);
        if (leServerCertificate->isEnabled())
            if (!leServerCertificate->text().isEmpty())
            setNetworkParam(id, "ca_cert", leServerCertificate->text().ascii(), true);
        if (lePrivateKey->isEnabled())
            if (!lePrivateKey->text().isEmpty())
            setNetworkParam(id, "private_key", lePrivateKey->text().ascii(), true);
        writeWepKey(id, leWep0, 0);
        writeWepKey(id, leWep1, 1);
        writeWepKey(id, leWep2, 2);
        writeWepKey(id, leWep3, 3);
  
        if (rbWep0->isEnabled() && rbWep0->isChecked())
            setNetworkParam(id, "wep_tx_keyidx", "0", false);
        else if (rbWep1->isEnabled() && rbWep1->isChecked())
            setNetworkParam(id, "wep_tx_keyidx", "1", false);
        else if (rbWep2->isEnabled() && rbWep2->isChecked())
            setNetworkParam(id, "wep_tx_keyidx", "2", false);
        else if (rbWep3->isEnabled() && rbWep3->isChecked())
            setNetworkParam(id, "wep_tx_keyidx", "3", false);
        if (rbOpen->isEnabled() && rbOpen->isChecked())
            setNetworkParam(id, "auth_alg","OPEN",false);
        if (rbShared->isEnabled() && rbShared->isChecked())
            setNetworkParam(id, "auth_alg","SHARED",false);

        snprintf(cmd, sizeof(cmd), "ENABLE_NETWORK %d", id);
        reply_len = sizeof(reply);
        m_interface->ctrlRequest(cmd, reply, &reply_len);
        if (strncmp(reply, "OK", 2) != 0) {
            KMessageBox::sorry(this, i18n("Failed to enable network in wpa_supplicant\nconfiguration."));
            /* Network was added, so continue anyway */
        }
        m_interface->ctrlRequest("SAVE_CONFIG", reply, &reply_len);
        if (strncmp(reply,"OK",2) != 0) {
            KMessageBox::sorry(this, i18n("Failed to save the  wpa_supplicant configuration.\nIs update_config=1 defined in wpa_supplicant.conf?"));
        }
        m_interface->ctrlRequest("RECONFIGURE", reply, &reply_len);
        //now save IP settings
        int ret = m_interface->getConfiguration()->writeIpSettings(leSSID->text(),cbDhcp->isChecked(), leIpAddress->text(), leNetmask->text(), leGateway->text(), lePrimaryDns->text(), leSecondaryDns->text(), leDomainName->text(),cbDontOverrideGw->isChecked(), cbDontOverrideDns->isChecked());
        if  (ret !=0) KMessageBox::sorry(this,"Could not write IP Settings");
        emit (profileAdded());

        close();
}

void KProfileConfigDlg::authChanged( int sel )
{
    lePsk->setEnabled(sel == AUTH_WPA_PSK || sel == AUTH_WPA2_PSK);
    bool eap = sel == AUTH_IEEE8021X || sel == AUTH_WPA_EAP ||
            sel == AUTH_WPA2_EAP;
    cbEap->setEnabled(eap);
    leIdentity->setEnabled(eap);
    lePassword->setEnabled(eap);
    leCertificate->setEnabled(eap);
    leServerCertificate->setEnabled(eap);
    lePrivateKey->setEnabled(eap);
    pbBrowseKey->setEnabled(eap);
    pbBrowseCert->setEnabled(eap);
   
    while (cbEncryption->count())
        cbEncryption->removeItem(0);
    
    if (sel == AUTH_NONE || sel == AUTH_IEEE8021X) {
        cbEncryption->insertItem("None");
        cbEncryption->insertItem("WEP");
        cbEncryption->setCurrentItem(sel == AUTH_NONE ? 0 : 1);
    } else {
        cbEncryption->insertItem("TKIP");
        cbEncryption->insertItem("CCMP");
        cbEncryption->setCurrentItem((sel == AUTH_WPA2_PSK ||
                sel == AUTH_WPA2_EAP) ? 1 : 0);
    }
    
    wepEnabled(sel == AUTH_IEEE8021X);
}





#include "kprofileconfigdlg.moc"








