#include "kwlanapplication.h"
#include "kwlanmainwin.h"

#include <qstringlist.h>
#include <kprocess.h>

KWlanApplication::KWlanApplication(bool allowStyles, bool GUIenabled, bool configUnique)
    : KUniqueApplication(allowStyles, GUIenabled, configUnique)
{
}

 KWlanApplication::~KWlanApplication()
{
}

void KWlanApplication::init()
{
    m_ifconfigStdout = QString::null;
    KProcess *ifconfigProcess = new KProcess();
    ifconfigProcess->setEnvironment( "LANG", "C" );
    ifconfigProcess->setEnvironment( "LC_ALL", "C" );
    //TODO: use path to ifconfig
    *ifconfigProcess << "ifconfig" << "-a";
    connect( ifconfigProcess,  SIGNAL( receivedStdout( KProcess*, char*, int ) ),
             this, SLOT( ifconfigProcessStdout( KProcess*, char*, int ) ) );
    connect( ifconfigProcess,  SIGNAL( processExited( KProcess* ) ),
             this, SLOT( ifconfigProcessExited( KProcess* ) ) );

    if ( !ifconfigProcess->start( KProcess::NotifyOnExit, KProcess::Stdout ) )
    {
        delete ifconfigProcess;
        ifconfigProcess = 0L;
    }
}

void KWlanApplication::ifconfigProcessExited( KProcess* process )
{
    //QMap<QString, QString> configs;
    QStringList ifList = QStringList::split( "\n\n", m_ifconfigStdout );
    QStringList::Iterator it;
    for ( it = ifList.begin(); it != ifList.end(); ++it )
    {
        int index = ( *it ).find( ' ' );
        if ( index == -1 )
            continue;
       // QString key = ( *it ).left( index );
        //configs[key] = ( *it ).mid( index );
        if ( (*it).mid(index).contains( "Ethernet" ) )
        {
            KWlanMainWin *widget = new KWlanMainWin();
            if (widget->init( (*it).left(index))!= 0) {
                widget->close();
                continue;
            }
        }
    }
}

void KWlanApplication::ifconfigProcessStdout( KProcess* process, char* buffer, int buflen )
{
    m_ifconfigStdout += QString::fromLatin1( buffer, buflen );
}

