#ifndef KWLANINTERFACE_H
#define KWLANINTERFACE_H

#include "kwlan.h"
#include "wpa_ctrl.h"
#include "wpamsg.h"
#include "kuserdatarequestdlg.h"
#include "configuration.h"


#include <kapplication.h>
#include <qsocketnotifier.h>
#include <wlanlib.h>

class QString;
class QStringList;
class KTempFile;
class KProcess;

class KWlanInterface  : public QObject
{
    Q_OBJECT
    public:
        KWlanInterface();
        ~KWlanInterface();
        enum InterfaceState
        {
            UNKNOWN_STATE = -1,
            NOT_EXISTING  = 0,
            NOT_AVAILABLE = 1,
            AVAILABLE     = 2,
            RX_TRAFFIC    = 4,
            TX_TRAFFIC    = 8
        };

        enum InterfaceType
        {
            UNKNOWN_TYPE,
            ETHERNET,
            PPP
        };
        void setType( int type )
        {
            m_type = type;
        }

        int getType()
        {
            return m_type;
        }

        void setState( int state )
        {
            m_state = state;
        }

        int getState()
        {
            return m_state;
        }
        interfaceData getInterfaceData()
        {
            return m_interfaceData;
        }
        wirelessData getWirelessData()
        {
            return m_wirelessData;
        }
        QString getCurrentProfile()
        {
            return m_ssid;
        }
        QString getConfFile()
        {
            return m_confFile;
        }
        Configuration *getConfiguration()
        {
            return m_configuration;
        }
        void setConfiguration(Configuration *config)
        {
            m_configuration = config;
        }
        bool hasControlConnection()
        {
            if (m_controlConnection) return TRUE;
            return FALSE;
        }
        bool profileActivateNonWpa(QString ssid);
        bool profileActivateWpa(QString ssid);
        
    public slots:
        void init(QString interface);
        int  openControlConnection();
        void checkConnection();
        int  ctrlRequest(const char *command, char *bur, size_t *buflen);
        /// Returns list of all profiles
        QStringList listProfiles();
        QStringList listWpaProfiles();
        QStringList listNonWpaProfiles(QStringList wpaProfiles);
        int getWpaId(QString ssid);
        /// acitvates profile with given ssid
        bool profileActivate(QString ssid);
        void releaseIpAddress();
        void getIpAddress();
        void processMessage(char *message);
        void receiveMsgs();
        void processCtrlReq( const char * request );
        void startWpa(QString driver);
        void stopWpa();
        QString getInterfaceName();
        void profileDelete(QString ssid);
        void profileAdded();
        void ifconfigProcessExited( KProcess* process );
        void iwconfigProcessExited( KProcess* process );
        void ifconfigProcessStdout( KProcess* process, char* buffer, int buflen );
        void iwconfigProcessStdout( KProcess*, char* buffer, int buflen );
        //void iwconfigProcessExited( KProcess* process );
        //void iwconfigProcessStdout( KProcess* process, char* buffer, int buflen );
        void checkConfig();
        void initLogViewer();
        void enableInterface(bool enable);

    signals:
        void wpaStatusChanged(bool started);
        void connectionStatusChanged (bool connected);
        void networksChanged();
        void ipChanged(QString ip);
        void wpaEvent( WpaMsg msg );
        void wpaEvents( WpaMsgList msgs );
        void interfaceUp(bool up);
        
    private:
        char *m_controlInterface,*m_controlInterfaceDir;
        wpa_ctrl *m_controlConnection, *m_monitorConnection;
        WpaMsgList m_messages;
        QSocketNotifier *m_messageNotifier;
        bool m_networkChange;
        bool m_startDhclient;
        bool m_associated;
        bool m_IpAddress;
        bool m_wpaStarted;
        bool m_useDhclient;
        bool m_useDhcpcd;
        bool m_dhcpEnabled;
        bool m_wpaWarned; // User has been warned in case of failure to connect to wpa_supplicant
        bool m_ipConfigured;
        QString m_ssid;
        QString m_staticIpAddress,  m_staticGateway, m_staticNetmask;
        QString m_staticDns1, m_staticDns2, m_domain;
        bool m_dontOverrideDns, m_dontOverrideGw;
        QString m_dhclientPath, m_dhcpcdPath, m_wpaPath; //Path to external applications that are frequently used
        QString m_ifconfigPath, m_iwconfigPath;
        QString m_wpaConf; // path to wpa_supplicant config file for this interface;
        QTimer *m_timer;
        KUserDataRequestDlg *m_userDataRequest;
        KTempFile *resolvconf;
        interfaceData m_interfaceData;
        wirelessData m_wirelessData;
        QString m_ifconfigStdout, m_iwconfigStdout;
        KProcess *m_ifconfigProcess, *m_iwconfigProcess;
        int m_type;
        int m_state;
        QString m_confFile;
        Configuration *m_configuration;
        
        void parseIfconfigOutput();
        void parseIwconfigOutput();
        void updateInterfaceData( QString& config,  int type );
        void updateWirelessData( QString& config );
        void getIpData();

    private slots:
        void cleanTemporaryFiles();
        
};

#endif
