#include "wlanlib.h"

#include <qwidget.h>
#include <kmessagebox.h>
#include <qstringlist.h>
//#include <linux/socket.h>
#include <sys/socket.h>
//#include <net/if.h>	
#include <sys/types.h>
#include <sys/ioctl.h>
#include <stdio.h>
#include <net/ethernet.h>
#include  <iwlib.h>
//#include <wireless.h>
#include <errno.h>
#include <klocale.h>
#include <kstandarddirs.h>
#include <kglobal.h>
#include <qfile.h>
#include <kdesu/client.h>
#include <kpassdlg.h>


QStringList getInterfaces()
{
    char		buff[1024];
    FILE *	fh;
    struct ifconf ifc;
    struct ifreq *ifr;
    int		i;
    int skfd;
    QStringList interfaceList;

    /* Check if /proc/net/wireless is available */
    fh = fopen(PROC_NET_WIRELESS, "r");

    if (fh != NULL) {
       /* Success : use data from /proc/net/wireless */

       /* Eat 2 lines of header */
       fgets(buff, sizeof(buff), fh);
       fgets(buff, sizeof(buff), fh);

       /* Read each device line */
       while(fgets(buff, sizeof(buff), fh)){
          char	name[IFNAMSIZ + 1];
          char *s = buff;
          char *colon;

          /* Extract interface name */
          // remove leading spaces
          while (isspace(*s)) s++;
          colon = strchr(s,':');
          if((colon == NULL) || (((colon - s) + 1) > sizeof(name)))
              name[0] = '\0';
          else {
             /* Copy */
             memcpy(name, s, (colon - s));
             name[colon - s] = '\0';
          }

          if(name[0]=='\0')
            /* Failed to parse, complain and continue */
              KMessageBox::sorry(0,"KWlan", "Cannot parse " PROC_NET_WIRELESS);
	  else
	    /* Got it, print info about this interface */
	    interfaceList.append(name);
    }

       fclose(fh);
    }
    else {
        /* Get list of configured devices using "traditional" way */
        ifc.ifc_len = sizeof(buff);
        ifc.ifc_buf = buff;
 
        if((skfd = iw_sockets_open()) < 0) {
            KMessageBox::sorry(0,"KWlan", "Cannot parse %s" PROC_NET_WIRELESS);
            return interfaceList;
        }

        if(ioctl(skfd, SIOCGIFCONF, &ifc) < 0) {
            KMessageBox::sorry(0,"KWlan",i18n("Could not detect WLAN interfaces!"));
            return interfaceList;
        }
        ifr = ifc.ifc_req;

        /* Print them */
        for(i = ifc.ifc_len / sizeof(struct ifreq); --i >= 0; ifr++)
            interfaceList.append(ifr->ifr_name);
    }
    
 
    return interfaceList;
}


/// get Signal Quality of current link
IwLib::IwLib(const QString &ifname) {
            m_ifname = ifname;
            m_socket = iw_sockets_open();
        }
        
IwLib::~IwLib() {
    if (m_socket > 0)
         iw_sockets_close(m_socket);
    }
            
int IwLib::getQuality() {
    int has_range;
    iw_range range;
    iw_statistics stats;
    if (m_socket < 0)
    	return 0;
    if ( iw_get_range_info(m_socket, m_ifname.ascii(), &range) < 0 )
    	has_range = 0;
    else
        has_range = 1;
    iw_get_stats(m_socket, m_ifname.ascii(), &stats, &range, has_range);
    
        //calculate quality in range 0-100.
    return (100*stats.qual.qual)/range.max_qual.qual;
}

QString IwLib::getBitrate() {
    struct iwreq wrq;
    if (m_socket < 0)
         return QString::null;
    if (iw_get_ext(m_socket, m_ifname.ascii(), SIOCGIWRATE, &wrq) >= 0) {
        char buffer[25];
        iw_print_bitrate(buffer, 25, wrq.u.bitrate.value);
        return QString(buffer);
    }
    return QString::null;
 
}

QString IwLib::getESSID() {
    struct iwreq wrq;
    char buffer[IW_ESSID_MAX_SIZE];
    if (m_socket < 0)
	return QString::null;
        wrq.u.essid.pointer = (char *)&buffer;
    wrq.u.essid.length = IW_ESSID_MAX_SIZE;
    if (iw_get_ext(m_socket, m_ifname.ascii(), SIOCGIWESSID, &wrq) >= 0)
    	return QString::fromAscii((char *)wrq.u.essid.pointer, wrq.u.essid.length);
    else
        return QString::null;
}

bool IwLib::setWepAuth(int authMode) {
    struct iwreq wrq;
    int skfd;
    if (m_socket <0)
        return FALSE;
    wrq.u.data.flags = authMode;
    if (iw_set_ext(skfd, m_ifname.ascii(), SIOCSIWENCODE, &wrq) < 0) return FALSE;
    return TRUE;
}

/// searches dirs for file, returns path to file if found. If not found return string will be empty
QString getPath(QString file)
{
    QString path = "/bin:/sbin:/usr/bin:/usr/sbin:/usr/local/bin:/usr/local/sbin";
    return KGlobal::dirs()->findExe(file, path);
}

//Taken from <net/route.h> - there is no reasen to include the whole file
#define RTF_UP		0x0001
#define RTF_GATEWAY	0x0002

/// Returns true if there is default gateway on an active interface
bool hasGateway() {
  QFile file("/proc/net/route");

  if (file.open(IO_ReadOnly)) {
    QTextStream stream(&file);
    QStringList tokens;

    // Skip the first line containing headers
    tokens = QStringList::split("\t", stream.readLine());
    if (tokens[1] != "Destination" || tokens[3] != "Flags") {
    	qWarning("/proc/net/route layout has changed... Which year is it now?!");
    	return false;
    }

    // Iterate through the routing table and look for a dafeult route, i.e.
    // destination with address 0.0.0.0 on the active interface (RTF_UP) with RTF_GATEWAY flag set
    while (!stream.atEnd()) {
      tokens = QStringList::split("\t", stream.readLine());
      if (tokens[1]  == "00000000" && (tokens[3].toInt() & (RTF_UP | RTF_GATEWAY)))
      	return true;
    }
    // Not required - file will be closed automatically upon destruction of QFile
    file.close();
  }

  // The system we are running on has no /proc/net/route or we didn't find default gateway
  return false;
}

/// Returns true is there is a nameserver entry in /etc/resolv.conf
bool hasNameserver() {
  QFile file("/etc/resolv.conf");

  if (file.open(IO_ReadOnly)) {
    QTextStream stream(&file);
    QString line;

    // We use glibc matching algorithm to find nameservers
    while (!stream.atEnd()) {
      line = stream.readLine();
      if (line.startsWith("nameserver ") || line.startsWith("nameserver\t"))
      	return true;
    }
    // Not required - file will be closed automatically upon destruction of QFile
    file.close();
  }

  return false;
}

