#ifndef KWLANMAINWIN_H
#define KWLANMAINWIN_H
/** Kwlan
 *
 *  This File is part of Kwlan, a network Manager for KDE.
 *  Kwlan is distributed under LGPL license.
 *
 *	@author Thomas Michel <tom.michel@arcor.de>
 */

#include "kwlan.h"
#include "configuration.h"
#include "wpa_ctrl.h"
#include "kwlantraywin.h"
#include "wpamsg.h"
#include <kapplication.h>
#include <qstringlist.h>
#include <qsocketnotifier.h>
#include <qptrlist.h>

class KScanDlg;
class KEventHistoryDlg;
class KUserDataRequestDlg;
class KTempFile;
class KwlanInterface;
class Configuration;
class KDialup;
class KProcess;
class KwlanMainTrayWin;

class KwlanMainWin : public Kwlan
{
    Q_OBJECT

    public:
        KwlanMainWin(QWidget* parent = 0, const char* name = 0, WFlags fl = 0 );
        ~KwlanMainWin();
        /*$PUBLIC_FUNCTIONS$*/
        QStringList getInterfaces()
        {
            return m_interfaces;
        }
    
    public slots:
        /*$PUBLIC_SLOTS$*/
  virtual void          helpHandbook();
        virtual void          fileSettings();
        virtual void          profileActivate();
        virtual void          cbInterfaceChanged(const QString&);
        virtual void          scan();
        virtual void          profileDelete();
        virtual void          profileModify();
        virtual void          profileNew();
        virtual void          dialupNew();
        virtual void          dialupDelete();
        virtual void          dialupModify();
        virtual void          dialupDisconnect();
        virtual void          dialupConnect();
        virtual int           init();
        virtual void          helpAbout();
        virtual void          fileExit();
        void updateDialupNetworks();
        void slotInterfaceGone(KwlanInterface *interface);
        void close();
        void slotCheckInterfaces();
        void slotChangeInterface(QString iface);

    
        
    protected:
        /*$PROTECTED_FUNCTIONS$*/
    
    protected slots:
        /*$PROTECTED_SLOTS$*/
        
    private:
    
        bool getRootPassword();
        QStringList m_wlanInterfaces;
        QSocketNotifier *m_messageNotifier;
        Configuration *m_configuration;
        QString m_confFile;
        QStringList m_interfaces;
        QPtrList<KwlanInterface> m_interfaceList;
        QString m_ifconfigStdout;
        KwlanMainTrayWin *m_tray;
        QTimer *m_timer;
};

#endif


























