/*
   
        (c) 2006 by Thomas Michel <tom.michel@arcor.de>

        Kwlan is free software; you can redistribute it and/or modify
        it under the terms of the GNU Library General Public License as
        published by the Free Software Foundation; either version 2 of
        the License, or (at your option) any later version.

        Kwlan is distributed in the hope that it will be useful,
        but WITHOUT ANY WARRANTY; without even the implied warranty of
        MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
        GNU Library General Public License for more details.

        You should have received a copy of the GNU Library General Public License
        along with this library; see the file COPYING.LIB.  If not, write to
        the Free Software Foundation, Inc., 51 Franklin Steet, Fifth Floor,
        Boston, MA 02110-1301, USA.
*/

#include "configuration.h"

#include <qtimer.h>

#include <kapplication.h>      
#include <qstringlist.h>
#include <kconfig.h>
#include <kdebug.h>


Configuration::Configuration(QString configFile) {
    /// initialises the Configuration object and reads the 
    /// configuration file 
    m_confFile = configFile;
    readSettings();
};

Configuration::~Configuration() {
};

/// reads the global parameters from the configuration file
void Configuration::readSettings() {
    KConfig *conf= new KConfig(m_confFile,false,false,"config");
    if (!conf) return;
    //read settings
    m_startWpa = conf->readBoolEntry("startwpa",FALSE);
    m_startWpaNoQuestion = conf->readBoolEntry("startwpanoquestion",FALSE);
    m_startMinimized = conf->readBoolEntry("startminimized",TRUE);
    m_useCustomWpaConf =conf->readBoolEntry("usecustomwpaconf",FALSE);
    m_customWpaConf = conf->readEntry("customwpaconf","");
    m_ap_scan = conf->readNumEntry("ap_scan",1);
    delete conf;
}



/// saves the global parameters to the configuration file
void Configuration::writeSettings() {
    KConfig *conf= new KConfig(m_confFile,false,false,"config");
    if (!conf) return;
    //conf->writeEntry("startdhcp",m_startDhcp);
    conf->writeEntry("startwpa",m_startWpa);
    conf->writeEntry("startwpanoquestion",m_startWpaNoQuestion);
    conf->writeEntry("startminimized",m_startMinimized);
    conf->writeEntry("usecustomwpaconf",m_useCustomWpaConf);
    conf->writeEntry("customwpaconf",m_customWpaConf);
    conf->writeEntry("ap_scan",m_ap_scan);
    delete conf;
}

int Configuration::readIpSettings(QString ssid, bool &useDhcp, QString & ipaddress, QString & netmask, QString & gateway, QString & dns1, QString & dns2, QString & domain, bool & dontOverrideGw, bool & dontOverrideDns, QStringList & dnsSearchlist)
{
    useDhcp = true;
    KConfig *conf= new KConfig(m_confFile,false,false,"config");
    if (!conf) return -1;
    // switch 
    if (!conf->hasGroup(ssid)) return -1;
    conf->setGroup(ssid);
    //read settings
    useDhcp = conf->readBoolEntry("usedhcp",TRUE);
    ipaddress = conf->readEntry("ipaddress","");
    gateway = conf->readEntry("gateway","");
    netmask= conf->readEntry("netmask","");
    dns1 = conf->readEntry("dns1","");
    dns2 = conf->readEntry("dns2","");
    domain = conf->readEntry("domain","");
    dontOverrideGw = conf->readBoolEntry("dontoverridegw",FALSE);
    dontOverrideDns = conf->readBoolEntry("dontoverridedns",FALSE);
    dnsSearchlist = conf->readListEntry("dnssearchlist");
    delete conf;
    return 0;
}

int Configuration::writeIpSettings(QString ssid, bool useDhcp, QString ipaddress, QString netmask, QString gateway, QString dns1, QString dns2,QString domain, bool dontOverrideGw, bool dontOverrideDns,QStringList searchlist)
{
    KConfig *conf= new KConfig(m_confFile,false,false,"config");
    if (!conf) return -1;
    conf->setGroup(ssid);
    conf->writeEntry("usedhcp",useDhcp);
    conf->writeEntry("ipaddress",ipaddress);
    conf->writeEntry("gateway",gateway);
    conf->writeEntry("netmask",netmask);
    conf->writeEntry("dns1",dns1);
    conf->writeEntry("dns2",dns2);
    conf->writeEntry("domain",domain);
    conf->writeEntry("dontoverridegw",dontOverrideGw);
    conf->writeEntry("dontoverridedns",dontOverrideDns);
    conf->writeEntry("dnssearchlist",searchlist);
    delete conf;
    return 0;
}


void Configuration::writeEncryption (QString ssid, bool encryption)
{
    KConfig *conf= new KConfig(m_confFile,false,false,"config");
    if (!conf) return;
    conf->setGroup(ssid);
    conf->writeEntry("encryption", encryption);
    //if (encryption) kdDebug() << "Network is encrypted" << endl;
    delete conf;
}

void Configuration::readEncryption (QString ssid, bool & encryption)
{
    KConfig *conf= new KConfig(m_confFile,false,false,"config");
    if (!conf) return;
    conf->setGroup(ssid);
    encryption = conf->readBoolEntry("encryption", TRUE);
    delete conf;
}
 
void Configuration::readScriptAfterConnect(QString ssid, QString &script, bool &useRootRights)
{
    KConfig *conf= new KConfig(m_confFile,false,false,"config");
    if (!conf) return;
    conf->setGroup(ssid);
    useRootRights = conf->readBoolEntry("scriptafterconnectuseroot", TRUE);
    script = conf->readEntry("sriptafterconnect","");
    delete conf;
}
     
void Configuration::writeScriptAfterConnect(QString ssid, QString script, bool useRootRights)
{
    KConfig *conf= new KConfig(m_confFile,false,false,"config");
    if (!conf) return;
    conf->setGroup(ssid);
    conf->writeEntry("scriptafterconnectuseroot", useRootRights);
    conf->writeEntry("sriptafterconnect",script);
    delete conf;
}

void Configuration::readScriptBeforeDisconnect(QString ssid, QString &script, bool &useRootRights)
{
    KConfig *conf= new KConfig(m_confFile,false,false,"config");
    if (!conf) return;
    conf->setGroup(ssid);
    useRootRights = conf->readBoolEntry("scriptbeforedisconnectuseroot", TRUE);
    script = conf->readEntry("sriptbeforedisconnect","");
    delete conf;
}

void Configuration::writeScriptBeforeDisconnect(QString ssid, QString script, bool useRootRights)
{
    KConfig *conf= new KConfig(m_confFile,false,false,"config");
    if (!conf) return;
    conf->setGroup(ssid);
    conf->writeEntry("scriptbeforedisconnectuseroot", useRootRights);
    conf->writeEntry("sriptbeforedisconnect",script);
    delete conf;
}

void Configuration::readDriver(QString &driver)
{
    KConfig *conf= new KConfig(m_confFile,false,false,"config");
    if (!conf) return;
    driver = conf->readEntry("driver","");
    delete conf;
}

void Configuration::writeDriver(QString driver)
{
    KConfig *conf= new KConfig(m_confFile,false,false,"config");
    if (!conf) return;
    conf->writeEntry("driver",driver);
    delete conf;
}

void Configuration::readLastSsid(QString &ssid)
{
    KConfig *conf= new KConfig(m_confFile,false,false,"config");
    if (!conf) return;
    ssid = conf->readEntry("ssid","");
    delete conf;
}

void Configuration::writeLastSsid( QString ssid)
{
    KConfig *conf= new KConfig(m_confFile,false,false,"config");
    if (!conf) return;
    conf->writeEntry("ssid",ssid);
    delete conf;
}

QStringList Configuration::getNetworks()
{
    QStringList tmpList;
    KConfig *conf= new KConfig(m_confFile,false,false,"config");
    if (!conf) return tmpList;
    tmpList = conf->groupList();
    return tmpList;
}

void Configuration::deleteNetwork(QString ssid)
{
    KConfig *conf= new KConfig(m_confFile,false,false,"config");
    if (!conf) return;
    kdDebug() << "Deleting group " <<ssid << " in " << m_confFile << endl;
    conf->deleteGroup(ssid);
    delete conf;
}



Configuration& Config(QString confFile) {
    static Configuration conf(confFile);
    return conf;
};


mainConfigurationClass::mainConfigurationClass() {
    m_configuration= new KConfig("kwlanrc.global",false,false,"config");
};

mainConfigurationClass::~mainConfigurationClass() {
    delete m_configuration;
};

bool mainConfigurationClass::readMonitorInterface( QString interface) 
{
    if (!m_configuration) return TRUE;
    //read settings
    m_configuration->setGroup("Monitoring");
    return m_configuration->readBoolEntry(interface,TRUE);
}


void mainConfigurationClass::writeMonitorInterface( QString interface, bool monitored)
{
    if (!m_configuration) return;
    m_configuration->setGroup("Monitoring");
    m_configuration->writeEntry(interface, monitored);
}

bool mainConfigurationClass::readConfigureInterface( QString interface) 
{
    if (!m_configuration) return TRUE;
    //read settings
    m_configuration->setGroup("Configuring");
    return m_configuration->readBoolEntry(interface,TRUE);
}


void mainConfigurationClass::writeConfigureInterface( QString interface, bool configure)
{
    if (!m_configuration) return;
    m_configuration->setGroup("Configuring");
    m_configuration->writeEntry(interface, configure);
}

bool mainConfigurationClass::readStartMinimized()
{
    if (!m_configuration) return TRUE;
    //read settings
    m_configuration->setGroup("");
    return m_configuration->readBoolEntry("startminimized",FALSE);
}

void mainConfigurationClass::writeStartMinimized(bool startMinimized)
{
    if (!m_configuration) return;
    m_configuration->setGroup("");
    m_configuration->writeEntry("startminimized", startMinimized);
}

bool mainConfigurationClass::readShowAvailableOnly()
{
    if (!m_configuration) return TRUE;
    //read settings
    m_configuration->setGroup("");
    return m_configuration->readBoolEntry("showavailableonly",FALSE);
}

void mainConfigurationClass::writeShowAvailableOnly(bool showAvailable)
{
    if (!m_configuration) return;
    m_configuration->setGroup("");
    m_configuration->writeEntry("showavailableonly", showAvailable);
}

bool mainConfigurationClass::readShowCommands()
{
    if (!m_configuration) return TRUE;
    //read settings
    m_configuration->setGroup("");
    return m_configuration->readBoolEntry("showcommands",FALSE);
}

void mainConfigurationClass::writeShowCommands(bool showCommands)
{
    if (!m_configuration) return;
    m_configuration->setGroup("");
    m_configuration->writeEntry("showcommands", showCommands);
}


mainConfigurationClass& mainConfiguration() {
    static mainConfigurationClass conf;
    return conf;
};

/*
PasswordCacheClass::PasswordCacheClass() {
    m_password = "";
    readPasswordExpire();
}

PasswordCacheClass::~PasswordCacheClass() {
    m_password.fill(0);
    kdDebug() << "Password cleared by destructor" << endl;
};


void PasswordCacheClass::setPassword(const QCString &password)
{
    m_password = password;
    if (m_pwexpire !=0) QTimer::singleShot(m_pwexpire * 60000, this, SLOT( wipePassword() ));
};

const QCString& PasswordCacheClass::password() const
{
    return m_password;
}

void PasswordCacheClass::wipePassword()
{
    m_password.fill(0);
    kdDebug() << "Password cleared by timer" << endl;
}

void PasswordCacheClass::readPasswordExpire() {
    QString m_confFile("kwlanrc.global");
    KConfig *conf= new KConfig(m_confFile,false,false,"config");
    if (!conf) return;
    //read settings
    m_pwexpire = conf->readNumEntry("passwordexpiretimeout", 15);
    delete conf;
}

void PasswordCacheClass::writePasswordExpire() {
    QString m_confFile("kwlanrc.global");
    KConfig *conf= new KConfig(m_confFile,false,false,"config");
    if (!conf) return;
    conf->writeEntry("passwordexpiretimeout", m_pwexpire);
    delete conf;
}

PasswordCacheClass& PasswordCache() {
    static PasswordCacheClass pw;
    return pw;
};

*/
