/*
   
        (c) 2006 by Thomas Michel <tom.michel@arcor.de>

        Kwlan is free software; you can redistribute it and/or modify
        it under the terms of the GNU Library General Public License as
        published by the Free Software Foundation; either version 2 of
        the License, or (at your option) any later version.

        Kwlan is distributed in the hope that it will be useful,
        but WITHOUT ANY WARRANTY; without even the implied warranty of
        MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
        GNU Library General Public License for more details.

        You should have received a copy of the GNU Library General Public License
        along with this library; see the file COPYING.LIB.  If not, write to
        the Free Software Foundation, Inc., 51 Franklin Steet, Fifth Floor,
        Boston, MA 02110-1301, USA.
*/

#include "kdialupconfigdlg.h"
#include "wlanlib.h"
#include "kwlansuprocess.h"
#include "globals.h"
#include "dialup.h"
#include "dialupclass.h"

#include <qfile.h>
#include <kdebug.h>
#include <qstringlist.h>
#include <qlineedit.h>
#include <qcombobox.h>
//#include <crypt.h>
#include <klocale.h>
#include <qregexp.h>
#include <kprocess.h>
#include <kmessagebox.h>
#include <qcheckbox.h>


KDialupConfigDlg::KDialupConfigDlg(QWidget* parent, const char* name, bool modal, WFlags fl)
: dialupConfig(parent,name, modal,fl)
{
    fillInterfaces(cbConnectionType->currentText());
    m_newProfile = TRUE;
    m_data = new dialupClass();
}

KDialupConfigDlg::~KDialupConfigDlg()
{
}

/*$SPECIALIZATION$*/
void KDialupConfigDlg::cancel()
{
    close();
}

void KDialupConfigDlg::ok()
{
    //get username to make him owner of the dialup peer file
    dialupData *data = m_data->getData();
    //check input data
    if (cbConnectionType->currentText() == CONNECT_ANALOG) data->connectionType = dialupData::ANALOG;
    else if (cbConnectionType->currentText() == CONNECT_ISDN) data->connectionType = dialupData::ISDN;
    else data->connectionType=dialupData::PPPOE;
    data->interface = cbInterface->currentText();
    data->initString = leInitString->text();
    data->user = leUsername->text();
    QString profile = leProfileName->text();
    //TODO: add a Messagbox here
    if (profile.isEmpty()) 
    {
        KMessageBox::sorry(0,i18n("You must supply a connection name."));
        return;
    }
    //TODO: Use crypt to encrypt password
    //if (!lePassword->text().isEmpty()) m_data.password=crypt(lePassword->text(),lePassword->text());
    data->password=lePassword->text();
    data->number = lePhoneNumber->text();
    data->scriptAfterConnect=leScriptAfterConnect->text();
    data->scriptBeforeDisconnect = leScriptBeforeDisconnect->text();
    data->scriptAfterConnectRoot = cbScriptAfterConnectRoot->isChecked();
    data->scriptBeforeDisconnectRoot = cbScriptBeforeDisconnectRoot->isChecked();
    data->storepassword = cbStorePassword->isChecked();
    connect (m_data,SIGNAL(dataWritten()),this,SLOT(slotNetworksChanged()));
    m_data->writeData(profile);
    close();
}

void KDialupConfigDlg::fillInterfaces(const QString& networkType)
{
    cbInterface->clear();
    if (debugOutput) kdDebug() << "Filling interfaces for " << networkType << endl;
    if (networkType==CONNECT_PPPOE){
        QStringList interfaces = getWiredInterfaces();
        for (QStringList::iterator it = interfaces.begin(); it != interfaces.end();it++)
        {
            cbInterface->insertItem(*it);
        }
        cbInterface->setEnabled(TRUE);
        cbInterface->setEditable(FALSE);
        lePhoneNumber->setEnabled(FALSE);
        leInitString->setEnabled(FALSE);
    } else if (networkType==CONNECT_ANALOG)
    {
        cbInterface->insertItem("/dev/ttyS0");
        cbInterface->insertItem("/dev/ttyS1");
        cbInterface->insertItem("/dev/ttyS2");
        cbInterface->insertItem("/dev/ttyS3");
        cbInterface->insertItem("/dev/modem");
        cbInterface->setEnabled(TRUE);
        cbInterface->setEditable(TRUE);
        lePhoneNumber->setEnabled(TRUE);
        leInitString->setEnabled(TRUE);
    }
    // else we have isdn
    else{
        cbInterface->setEnabled(FALSE);
        cbInterface->setEditable(FALSE);
        lePhoneNumber->setEnabled(TRUE);
        leInitString->setEnabled(FALSE);
    } 
}

bool KDialupConfigDlg::init(QString profile)
{
    // mofify existing data;
    bool ok;
    m_profile = profile;
    ok = m_data->readData(profile);
    setData();
    leProfileName->setEnabled(FALSE);
    m_newProfile = FALSE;
    return ok;
}

void KDialupConfigDlg::setData()
{
    dialupData *data = m_data->getData();
    leProfileName->setText(m_profile);
    leUsername->setText(data->user);
    lePassword->setText(data->password);
    lePhoneNumber->setText(data->number);
    leInitString->setText(data->initString);
    leScriptAfterConnect->setText(data->scriptAfterConnect);
    leScriptBeforeDisconnect->setText(data->scriptBeforeDisconnect);
    cbScriptAfterConnectRoot->setChecked(data->scriptAfterConnectRoot);
    cbScriptBeforeDisconnectRoot->setChecked(data->scriptBeforeDisconnectRoot);
    switch (data->connectionType) {
        case dialupData::ISDN:
            cbConnectionType->setCurrentText(CONNECT_ISDN);
            fillInterfaces( QString(CONNECT_ISDN));
            break;
        case dialupData::PPPOE:
            cbConnectionType->setCurrentText(CONNECT_PPPOE);
            fillInterfaces( QString(CONNECT_PPPOE));
            break;
        case dialupData::ANALOG:
            cbConnectionType->setCurrentText(CONNECT_ANALOG);
            fillInterfaces( QString(CONNECT_ANALOG));
            break;
    }
    if (!data->interface.isEmpty())
        cbInterface->setCurrentText(data->interface);
    cbStorePassword->setChecked(data->storepassword);
}

void KDialupConfigDlg::slotNetworksChanged()
{
    emit dialupNetworksUpdated();
}

#include "kdialupconfigdlg.moc"

