/*
   
        (c) 2006 by Thomas Michel <tom.michel@arcor.de>

        Kwlan is free software; you can redistribute it and/or modify
        it under the terms of the GNU Library General Public License as
        published by the Free Software Foundation; either version 2 of
        the License, or (at your option) any later version.

        Kwlan is distributed in the hope that it will be useful,
        but WITHOUT ANY WARRANTY; without even the implied warranty of
        MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
        GNU Library General Public License for more details.

        You should have received a copy of the GNU Library General Public License
        along with this library; see the file COPYING.LIB.  If not, write to
        the Free Software Foundation, Inc., 51 Franklin Steet, Fifth Floor,
        Boston, MA 02110-1301, USA.
*/

#include "kwlanapplication.h"
#include "kwlanmainwin.h"
#include "kwlaninterface.h"
#include "kwlansuprocess.h"
#include "dialup.h"
#include "globals.h"

#include <klocale.h>
#include <qstringlist.h>
#include <kprocess.h>
#include <qdir.h>
#include <kdebug.h>
#include <kmessagebox.h>

#include <pwd.h>
#include <grp.h>

bool dialupUser; // defines whether user is member of dialup group

KwlanApplication::KwlanApplication(bool allowStyles, bool GUIenabled, bool configUnique)
    : KUniqueApplication(allowStyles, GUIenabled, configUnique)
{
    KMessageBox::setDontShowAskAgainConfig(mainConfiguration().m_configuration);
}

 KwlanApplication::~KwlanApplication()
{
}

void KwlanApplication::init()
{
    QDir dir;
    KConfig* config = KGlobal::config();
    config->setGroup("super-user-command");
    // Check if user is in dip group to have access to dialup networking
    uid_t uid;
    QString user;
    QStringList groupusers;
    struct passwd *pw;
    struct group *grp;
    uid = geteuid ();
    if (::debugOutput) kdDebug() << "User uid is: " << uid << endl;
    pw = getpwuid (uid);
    bool ok = TRUE;
    QString groupUser,fileUser;
    if (pw)
    {
        user = QString(pw->pw_name);
        if (::debugOutput) kdDebug() << "Your username is: " << user << endl;
        QFileInfo finfo(getPath("pppd"));
        kdDebug() << "pppd Path "<< getPath("pppd") << endl;
        groupUser = finfo.group();
        fileUser = finfo.owner();
        kdDebug() << "Group of pppd: " << groupUser << endl;
        if (fileUser != QString(user))
        {
            // test if user is a member of the group of pppd and if it is group executable
            if (finfo.permission( QFileInfo::ExeGroup))
            {
                grp = getgrnam(groupUser.ascii());
                if (grp)
                {
                    char **actuser = grp->gr_mem;
                    while (*actuser)
                    {
                        groupusers.append(*actuser);
                        actuser++;
                    }
                    if (groupusers.findIndex(user)==-1 )
                    {
                        ok = FALSE;
                    }
                }
                else ok = FALSE;
            }
            else ok = FALSE;
        }
    }
    else ok = FALSE;
    
    dialupUser = ok;
    if (!dialupUser )
    {
        // User not member of pppd group
        QString dontShowAgain="nodialupuserwarning";
        if (KMessageBox::shouldBeShownContinue(dontShowAgain))
        {
            KMessageBox::information(0,QString(i18n("You do not have permissions to start pppd or pppd was not found. Dialup networking will not work.")).arg(groupUser),"Kwlan",dontShowAgain);
        }
    }
    // check for existing directory for dialup networking
    if (dialupUser)
    {
        if (dir.exists("/etc/ppp/peers"))
        {
        // ppp peers directory exists, now check for kwlan dir
            if (!dir.exists(PPP_PEERS))
            {
                KwlanSuProcess *proc = new KwlanSuProcess;
                *proc << "mkdir" << "-m" << "770" << PPP_PEERS;
                proc->start();
            }

        } else kdDebug() <<   i18n("/etc/ppp/peers does not exist. Dialup networking will not work.") << endl;
    }
    KwlanMainWin *mainWin = new KwlanMainWin();
    mainWin->init();
}


