## Specfile for OpenSuSE Build Service

%define packagename  kx11grab-0.1.12

%define _prefix  %(kde4-config --prefix)
%define _bindir  %(kde4-config --install exe)
%define _xdgdir  %(kde4-config --install xdgdata-apps)
%define _icondir %(kde4-config --install icon)
%define _lnsdir  %(kde4-config --install locale)

Name:           kx11grab
Summary:        kde4 applet for recording x11 windows with ffmpeg
Summary(de):    kde4 Programm zum Aufnehmen von X11 Fenstern mit ffmpeg
Version:        0.1.12
Release:        0
License:        GPL 2
Autoreqprov:    on
Source0:        %{_sourcedir}/%packagename.tar.bz2
Group:          System/GUI/KDE
Url:            http://qx11grab.hjcms.de
BuildRoot:      %{_tmppath}/%{name}-%{version}-build
Requires:       ffmpeg desktop-file-utils
%if %{defined suse_version}
BuildRequires:  cmake kdebase4-workspace-devel >= 4.2.0
BuildRequires:  desktop-file-utils update-desktop-files >= 11.0
%endif
Vendor:         Juergen Heinemann (Undefined) http://www.hjcms.de

%description
kde4 applet for recording x11 windows with ffmpeg
this prgramm requires ffmpeg from http://ffmpeg.mplayerhq.hu

before run this application please test with your xterm or console
that ffmpeg installation support this feature:
  ffmpeg -f x11grab -s svga -r 24 -b 6500 -bt 256k -sameq -i :0.0+1,33 /tmp/out.avi

Help: --------------
  http://ffmpeg.mplayerhq.hu/ffmpeg-doc.html#SEC4
  https://lists.mplayerhq.hu/mailman/listinfo

Author: -------------
  Juergen Heinemann (Undefined)
  http://www.hjcms.de

%description -l de
Ein KDe4 Basierendes Programm zum Aufnehmen von X11 Fenstern.
Das Programm verwendet ffmpeg von http://ffmpeg.mplayerhq.hu

Bevor sie das Programm verwenden bitte testen sie zuerst auf dem terminal oder console
ob ihre ffmpeg Installation diese funktion unterstützt:
  ffmpeg -f x11grab -s svga -r 24 -b 6500 -bt 256k -sameq -i :0.0+1,33 /tmp/out.avi

Hilfe: --------------
  http://ffmpeg.mplayerhq.hu/ffmpeg-doc.html#SEC4
  https://lists.mplayerhq.hu/mailman/listinfo

Autor: -------------
  Juergen Heinemann (Undefined)
  http://www.hjcms.de

%prep
%setup -q
%build

%__mkdir_p build
cd build
cmake \
  -DCMAKE_INSTALL_PREFIX:PATH=%{_prefix} \
  -DCMAKE_BUILD_TYPE:STRING=Debug ../

%__make

%install
%__mkdir_p $RPM_BUILD_ROOT

cd build
%makeinstall

%if %{defined suse_version}

%suse_update_desktop_file %{name} Utility X-KDE-Utilities-Desktop

%post
update-desktop-database

%endif

%files
%defattr(-, root, root)
%{_bindir}/%{name}
%{_xdgdir}/%{name}.desktop
%{_icondir}/oxygen/*/apps/%{name}.png
%{_lnsdir}/*/LC_MESSAGES/%{name}.mo

%clean
rm -rf $RPM_BUILD_ROOT

%changelog
* Mon Feb 02 2009 - Heinemann Juergen (Undefined)
- update translation
- add more kde 4 classes
- fix cmake build for locales
- remove qt resource file an replace it by KIconLoader
- add oxygen icons

#eof
