/***
* Author: Juergen Heinemann http://www.hjcms.de, (C) 2007-2008
* Copyright: See COPYING file that comes with this distribution
**/

#ifndef QX11GRAB_H
#define QX11GRAB_H

/* QtCore */
#include <QtCore/QObject>
#include <QtCore/QString>
#include <QtCore/QRect>

/* QtGui */
// #include <QtGui/QSystemTrayIcon>
#include <QtGui/QWidget>
#include <QtGui/QStatusBar>
#include <QtGui/QShowEvent>
#include <QtGui/QHideEvent>
#include <QtGui/QCloseEvent>

/* KDE */
#include <KDE/KMainWindow>
#include <KDE/KLocale>
#include <KDE/KSystemTrayIcon>

#include "config.h"
#include "qx11grabmain.h"

class KAction;
// class QMenu;
class QDBusConnection;
class Settings;
class DesktopInfo;
class RubberBand;
class FFProcess;
class Kx11grabAdaptor;

class QX11Grab : public QX11GrabMain
{
    Q_OBJECT
    Q_CLASSINFO ( "Author", "Juergen Heinemann (Undefined)" )
    Q_CLASSINFO ( "URL", "http://qx11grab.hjcms.de" )

  private:
    int TimeOutMessages;
    Settings *cfg;
    DesktopInfo *m_DesktopInfo;
    RubberBand *m_RubberBand;
    FFProcess *m_FFProcess;
    KAction *grabActionFromWindow,
    *showRubberbandWindow,
    *stopRecordingWindow,
    *startRecordingWindow,
    *minimizeWindowAction,
    *displayWindowAction,
    *quitWindowAction;
    KSystemTrayIcon *systemTrayIcon;
    void createActions();
    void createEnviroment();
    void createSystemTrayIcon();
    void loadStats();
    void saveStats();
    QDBusConnection *rcDBus;
    Kx11grabAdaptor *m_Kx11grabAdaptor;

  public:
    QX11Grab( Settings *settings = 0 );
    ~QX11Grab();

  public Q_SLOTS:
    void start_record();
    void stop_record();
    void swap_rubberband();

  Q_SIGNALS:
    void startMinimized ();

  private Q_SLOTS:
    void showRubber ( bool );
    void swapRubberBand ();
    void toRubber ( int );
    void grabFromWindow();
    void systemTrayWatcher ( QSystemTrayIcon::ActivationReason );
    void openSettings ();
    void showEvent ( QShowEvent * );
    void hideEvent ( QHideEvent * );
    void closeEvent ( QCloseEvent * );
    void pushInfoMessage ( const QString & );
    void pushErrorMessage ( const QString &, const QString & );
    void pushToolTip ( const QString & );
    void startRecord();
    void setActionsBack();
};

#endif
