/***************************************************************************
                          kxmleditorshell.h  -  description
                             -------------------
    begin                : Thu Oct 18 2001
    copyright            : (C) 2001, 2002, 2003 by The KXMLEditor Team
    email                : lvanek@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/
 /**
 @file
 */


#ifndef KXMLEDITORSHELL_H
#define KXMLEDITORSHELL_H

#include <kparts/mainwindow.h>

class KParts::ReadWritePart;
class KXMLEditorShellIface;

/**
 * The shell, which contains our #KXMLEditorPart.
 */
class KXMLEditorShell : public KParts::MainWindow
{
		Q_OBJECT

	public:

		KXMLEditorShell( const char * name = 0L, WFlags f = WDestructiveClose );
		virtual ~KXMLEditorShell();

		bool openURL( const KURL & url ) const;

	public slots:

		void slotActFileNew();
		void slotFileOpen();
		void slotFileSave();
		void slotFileSaveAs();
		void slotFileOpenRecent( const KURL & url );
		void slotToggleToolBar();
		void slotToggleStatusBar();
		void slotConfigureKeys();
		void slotConfigureToolbars();

		virtual void setCaption( const QString & strCaption );
		void mail();

	protected:

		virtual bool queryClose();
		virtual void saveProperties( KConfig * );
		virtual void readProperties( KConfig * );

		KParts::ReadWritePart * m_pPart;

		// the actions
		KRecentFilesAction * m_pActFileOpenRecent;
		KAction *m_pActFileSave;

		/**
		 * DCOP interface pointer (if no such iface pointer == 0)
		 */
		KXMLEditorShellIface * m_pKXEShellIface;

	protected slots:
		/** To enable/disable actions, the way the parts browser extension wishes. */
		void slotEnableBrowserExtActions( const char * pszName, bool bEnabled );
};

#endif
