/***************************************************************************
                          kxmleditorpart.h  -  description
                             -------------------
    begin                : Wed Sep 19 2001
    copyright            : (C) 2001, 2002, 2003 by The KXMLEditor Team
    email                : OleBowle@gmx.de
 ***************************************************************************/
 
/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef KXMLEDITORPART_H
#define KXMLEDITORPART_H

#include <kparts/part.h>
#include <kparts/browserextension.h>

#include <qdom.h>

#include "kxe_treeview.h"

class QTabWidget;
class KXE_ViewElement;
class KXESearchDialog;
class QTextEdit;
class KAction;
class KToolBarPopupAction;
class KXmlEditorComboAction;
class QDomNode;
class QKeyEvent;
class KXMLEditorPartIfaceReadOnly; // DCOP interface
class KCommandHistory;
class KPrinter;
class QSplitter;

/** This is the KPart of KXMLEditor. */
class KXMLEditorPart : public KParts::ReadWritePart
{
		Q_OBJECT

public:
		/** Creates the actions, the view (widgets) and changes to "begin state". */
		KXMLEditorPart( bool fReadWrite, QWidget * pParent, const char * pszName );
		virtual ~KXMLEditorPart();

		/** Changes the behaviour of this part to readonly or readwrite. */
		virtual void setReadWrite( bool fReadWrite = true );

		/** Returns the selected XML object's path or an empty string, if no object is selected. */
		QString getSelectedPath() const { return m_pViewTree->getSelectedPath(); }

		/**
		 * Reimplemented from @ref KParts::KReadWritePart::setModified.
		 *
		 * Alters the window caption according to the given flag and
		 * calls the base functionality.
		 */
		virtual void setModified( bool fModified );

		/** Copy XML node into clipboard */
		QTextDrag * copyNode(QDomNode *);

		/** Paste XML node from clipboard into document */
		bool pasteNode(QDomNode *, QMimeSource *);

    /** Drag&Drop move */
    bool dropMoveNode(QDomElement &, QDomNode &);

		/**    Prepares content of a newly created XML file. */
		virtual void newFile();

		/** Updates tree view after creating new element */
		void updateNodeCreated(const QDomNode & node);

		/** Updates tree view after deleting new element */
		void updateNodeDeleted(const QDomNode & node);

		/** Updates tree view after change element properties */
		void updateNodeChanged( const QDomElement & domElement );

    /** Updates tree view after change char. data properties */
    void updateNodeChanged( const QDomCharacterData & node ) ;

    /** Updates tree view after change proc. instr. properties */
    void updateNodeChanged( const QDomProcessingInstruction &domProcInstr );

		/** Updates tree view after move node */
		void updateNodeMoved( const QDomNode & node );

		/** Attaches stylesheet to current XML file. If file is already attached to stylesheet,
		this attachment will be overriten.
		@param stylesheet url to stylesheet location
		@sa detachStylesheet() */
		virtual void attachStylesheet(const KURL& stylesheet);

    /** Detaches stylesheet from current XML file.
		@sa attachStylesheet()*/
		virtual void detachStylesheet();

    /** Attaches schema to current XML file. If file is already attached to schema,
		this attachment will be overriten.
		@param schema url to schema location
		@sa detachSchema()*/
		virtual void attachSchema(const KURL& schema);

    /** Detaches schema from current XML file.
		@sa attachSchema()*/
		virtual void detachSchema();
		/** Prints the document on specified printer.
			@param pPrinter printer which will be used for printing. */
		virtual void print(KPrinter* pPrinter);
		/** Adds or changes (if already exists) processing instruction. Processing
		instruction will be added as a child in QDomDocument object.
			@param target processing intruction target
			@param data processing intruction data */
		virtual void setSpecProcInstr(const QString& target, const QString& data);

public slots:

		/**
		 * Reimplemented from @ref KParts::KReadWritePart::setModified.
		 */
		virtual void setModified() { setModified(true); updateActions(); }

		/** Cut the marked text/object into the clipboard */
		void slotEditCut();

    /** Copy the marked text/object into the clipboard */
		void slotEditCopy();

    /** Paste the clipboard into the document */
		void slotEditPaste();

    /** Displays search dialog and finds string in this tree view */
		void slotEditFind();

    /** Finds next occurence of string in this tree view */
		void slotEditFindNext();

    /** Deselects currently selected item */
		void slotEditDeselect() { m_pViewTree->editDeselect(); }

    /** Selects the selected item's parent item. */
		void slotViewNodeUp() { m_pViewTree->viewNodeUp(); }

    /** Expands the selected tree item's subtree. */
		void slotViewExpNode() { m_pViewTree->viewExpNode(-1); }

    /** Expands the selected tree item's subtree to the given level. */
		void slotViewExpNode( int nLevel ) { m_pViewTree->viewExpNode(nLevel); }

    /** Collapses the selected tree item's subtree. */
		void slotViewColNode() { m_pViewTree->viewColNode(0); }

    /** Collapses the selected tree item's subtree to the given level. */
		void slotViewColNode( int nLevel ) { m_pViewTree->viewColNode(nLevel); }

    /** Insert XML element into document */
		void slotXmlElementInsert();

    /** Edit XML element */
		void slotXmlElementEdit();

    /** Add attribute to an XML element. */
		void slotXmlAttributesAdd();

    /** Delete all attributes of an XML element. */
		void slotXmlAttributesDel();

    /** Delete an attribute of an XML element. */
		void slotXmlAttributeDel();

    /** Insert proc.instruction into document */
		void slotXmlProcInstrInsert();

    /** Edit proc.instruction */
		void slotXmlProcInstrEdit();

    /** Insert special proc.instruction into document */
		void slotActVersionEncoding();

    /* Insert text into element. */
		void slotActInsertText();
    /* Insert CDATA section. */
		void slotActInsertCDATA();
    /* Insert comment to element. */
		void slotActInsertComment();

    /* Edit character data */
		void slotXmlCharDataEdit();

    /* Moves a node up (change its position with its prev. siblings position) */
		void slotXmlMoveNodeUp();

    /* Moves a node down (change its position with its next siblings position) */
		void slotXmlMoveNodeDown();

    /** toggles bookmark on the selected item */
		void slotBookmarksToggle();

    /** searches for the previous bookmarked item */
		void slotBookmarksPrev() { m_pViewTree->bookmarksPrev(); }

    /** searches for the next bookmarked item */
		void slotBookmarksNext() { m_pViewTree->bookmarksNext(); }

    /** shows configuration dialog (@ref OptionsDialog) */
		void slotConfigure();

		void slotPathSelected( const QString & szPath );
		void slotPathSelected();
		void slotPathClear();
		/**
		 * Called when a tree view items text was changed via inplace-renaming.
		 */
		void slotItemRenamedInplace( QListViewItem * pItem );

    /** Called whan an attributes name was changed via inplace editing. */
		void slotAttributeNameChangedInplace( const QDomAttr &, const QString );

    /** Called whan an attributes value was changed via inplace editing. */
		void slotAttributeValueChangedInplace( const QDomAttr &, const QString );

    /** Called on user's action response. Creates <?xml-stylesheet ...?> processing instruction
		with reference to specified stylesheet URI.
		*/
		void slotActAttachStylesheet();

    /** Called on user's action response. */
		void slotActDetachStylesheet();

    /** Called on user's action response */
		/** Called when File->Print or icon from the toolbar is selected. */
		void slotActPrint();

		void slotActDetachSchema();

		/** Called on user's action response */

		void slotActAttachSchema();

		void slotActProperties();

    void slotActEditRawXml();

		void slotActDelete();

		void slotTreeViewKeyPressed(QKeyEvent *e);

protected:
		/** Opens the file @ref KParts::ReadOnlyPart::m_file. */
		virtual bool openFile();

    /** Saves the file @ref KParts::ReadOnlyPart::m_file. */
		virtual bool saveFile();

    /** Removes spec. processing instruction from XML file.
			@param target name of the proc. instruction target
			@warning Removes processing instruction from DomDocument children node list only (no subnodes are modiified).
		*/
		void removeSpecProcInstr(const QString &target);

    /** Returns processing instruction located in QDomDocument. If specified
		processing intruction is not found, null node is returned.
			@param target name of the processing instruction target. */
		QDomNode getSpecProcInstr(const QString& target);

    /** Updates status of actions (enabled/disabled). Is it automatically invoked everytime content is modified.
		Good place for updating actions which do not depend on current selection, but are file content dependent,
		like #m_pActXmlAttachStylesheet #m_pActXmlAttachSchema.
			@sa setModified()
		*/
		void updateActions();

    /** Draws header for printouts (made of file name).
			@param painter a painter to use for drawing
			@param pageNumber number of currently drawn page counted from 0
			@param ypos y coordinate of upper border of the header
			@sa printPage() @sa printFooter()
		*/
		void printHeader(QPainter* painter, int pageNumber, int ypos, int width);

    /** Draws footer for printouts (page number).
			@param painter a painter to use for drawing
			@param pageNumber number of currently drawn page counted from 0
			@param ypos y coordinate of upper border of the footer
			@sa printHeader() @sa printFooter()
		*/
		void printFooter(QPainter* painter,int pageNumber, int ypos, int width);

    /** Draws page for printing purposes. If there are more pages to print, method
		returns true. Otherwise returns false.
			@param painter a painter to use for srawing
			@param pageNumber number of currently drawn page counted from 0
			@param top y coordinate of upper edge from where page should be drawn
			@param width,height size of the medium (e.g. paper)
			@sa printPage() @sa printHeader()
		*/
		bool printPage(QPainter* painter,int pageNumber, int top, int width, int height);

		/** Used in printing function printPage(). */
		unsigned int m_printLineNumber;
		/** Used in printing function printPage(). */
		QStringList m_printLines;

		// the actions
		KAction * m_pActEditFind;
		KAction * m_pActEditFindNext;
		KAction * m_pActEditDeselect;
		KAction * m_pActViewNodeUp;
		KToolBarPopupAction * m_pActViewExpNode;
		KToolBarPopupAction * m_pActViewColNode;
		KAction * m_pActXmlElementInsert;
		KAction * m_pActXmlAttributesAdd;
		KAction * m_pActXmlAttributesDel;
		KAction * m_pActXmlAttributeDel;
		KAction * m_pActXmlProcInstrInsert;
		KAction * m_pActInsertText;
		KAction * m_pActInsertCDATA;
		KAction * m_pActInsertComment;
		KAction * m_pActXmlMoveNodeUp;
		KAction * m_pActXmlMoveNodeDown;
		KAction * m_pActBookmarksToggle;
		KAction * m_pActBookmarksPrev;
		KAction * m_pActBookmarksNext;
		KXmlEditorComboAction * m_pActPathCombo;

		/** the document */
		QDomDocument * m_pDoc;

	protected slots:
		void started();
		void completed();
		void canceled();

    /** enables/disables actions and changes views  */
		void slotSelectionCleared(bool);

    /** enables/disables actions depending on the given XML element and changes views  */
		void slotSelectionChanged( const QDomElement & );

    /** enables/disables actions and changes views */
		void slotSelectionChanged( const QDomCharacterData & );

    /** enables/disables actions and changes views */
		void slotSelectionChanged( const QDomProcessingInstruction & );

		/** Shows the requested context menu at the given position. */
		void slotContextMenuRequested( const QString & szMenuName, const QPoint & pos );

	private:
		/** this view displays the XML-document's tree structure */
		KXE_TreeView * m_pViewTree;

    /** the tab widget, contains: m_pViewElement, m_pViewContents */
		QTabWidget * m_pTabWidget;

    /** widget to display XML element */
		KXE_ViewElement * m_pViewElement;

    /** edit widget for contents */
		QTextEdit * m_pViewContents;

    /** widget to display a proc.instr. */
		QTextEdit * m_pViewProcInstr;

    /** the search dialog, used for find action */
		KXESearchDialog * m_pDlgSearch;

	protected:
		/** DCOP object having access to XML document. It may by NULL if no DCOP inteface is provided
		* or read only privided by @ref KXMLEditorPartReadOnlyIface or full read-write @ref KXMLEditorPartIface .
		*/
		KXMLEditorPartIfaceReadOnly * m_pDCOPIface;

		bool m_bAlreadyModified;

		/** our browser extension */
		KParts::BrowserExtension * m_pBrowserExt;

		// Indicates, if document is opened from tar.gz
		bool m_bDocIsCompressed;

		/** Name of entry in Tar archive */
		QString m_strCompressedTarEntryName;

    /** Action for changing version and encoding of XM file. */
		KAction* m_pActVersionEncoding;

    /** Action for attaching stylehseets to xml files. */
		KAction* m_pActAttachStylesheet;

    /** Action for detaching stylehseets from xml files. */
		KAction* m_pActDetachStylesheet;

    /** Action for attaching schemas to xml files. */
		KAction* m_pActAttachSchema;

    /** Action for detaching schemas from xml files. */
		KAction* m_pActDetachSchema;

    /** Action for editing properties of currently selected node. */
		KAction* m_pActProperties;

    /** Action for editing raw XML of currently selected node. */
		KAction* m_pActEditRawXml;

    /** Action for deleting currently selected node. */
		KAction* m_pActDelete;

    /** Printer object. */
		KPrinter *m_pPrinter;

    /** Command history used to implement Undo/Redo functionality. */
		KCommandHistory* m_pCmdHistory;

	/* spitter - main widget in the part */
	QSplitter *pSplitter;
};



/**
 * The browser extension for our part (@ref KXMLEditorPart).
 */
class KXMLEditorBrowserExtension : public KParts::BrowserExtension
{
		Q_OBJECT

	public:
		KXMLEditorBrowserExtension( KXMLEditorPart * pParent, const char * pszName = "KXMLEditorBrowserExtension" ) : KParts::BrowserExtension( pParent, pszName ), m_pPart(pParent)
		{ emit enableAction("print",true); }

	public slots:
		void cut() { m_pPart->slotEditCut(); }
		void copy() { m_pPart->slotEditCopy(); }
		void paste() { m_pPart->slotEditPaste(); }
		void print() { m_pPart->slotActPrint(); }

	protected:
		KXMLEditorPart * m_pPart;
};

#endif

