/***************************************************************************
                          dcopiface_part_ro.h  -  description
                             -------------------
    begin                : Tue Oct 23 2001
    copyright            : (C) 2001, 2002, 2003 by The KXMLEditor Team
    email                : lvanek@users.sourceforge.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef DCOPIFACE_PART_RO_H
#define DCOPIFACE_PART_RO_H

#include <dcopobject.h>


class KXMLEditorPart;
	/**
	* Allows perform action on represetntaion of XML file via DCOP protocol.
	* behavies as interface to @ref KXMLEditorPart and to it adresses most of requestests received by DCOP
	*
	*@see KXMLEditorPart
	*
	*@short Read only DCOP interface for XML document Kpart based kxmleditor.
	*
	*@author The KXMLEditor Team (matkor@users.sourceforge.net)
	**/

class KXMLEditorPartIfaceReadOnly
	:virtual public DCOPObject
{
	K_DCOP

protected:
	/** @ref KXMLEditorPart which Iface represensts **/
	KXMLEditorPart * m_pKXEPart;

public:
	/**
	* Default constructor
	*
	* @param kxe_part Specifies on what @ref KXMLEditorPart will interface operate.
	**/
	KXMLEditorPartIfaceReadOnly(KXMLEditorPart * kxe_part,const char * dcop_name = "KXMLEditorPartIface")
		: DCOPObject(dcop_name)
	{
		m_pKXEPart = kxe_part;
	}
	virtual ~KXMLEditorPartIfaceReadOnly()
		{};
k_dcop:
	/**
	* Saves document as file
	*
	* @returns Error description or empty string if file succesfully saved.
	**/

  QString saveAsFile(const QString & path_to_file);

	/** Tries to change current node
	* @param pathToNode Path to new node
	* @returns Empty string if selection OK otherwise error description
	**/
	QString selectNode(const QString & pathToNode);

	/** Returns path to current node
	* @returns If error empty string
	**/
	QString currentNode() const;

};



	/**
	*@short Read/Write DCOP inteface for Kpart based kxmleditor.
	*@author The KXMLEditor Team
	**/
//
class KXMLEditorPartIfaceReadWrite
	:public KXMLEditorPartIfaceReadOnly
{
	K_DCOP
	/**
	* Default constructor
	*
	* @param kxe_part Specifies on what @ref KXMLEditorPart will interface operate.
	**/
public:
	KXMLEditorPartIfaceReadWrite(KXMLEditorPart * kxe_part,const char * dcop_name = "KXMLEditorPartIface")
		: DCOPObject(dcop_name)
		,KXMLEditorPartIfaceReadOnly(kxe_part,dcop_name)
		{}
	virtual ~KXMLEditorPartIfaceReadWrite()
		{};
k_dcop:

	/**
	* Opens given file
	*
	* @returns Error description or empty string if file succesfully loaded.
	**/
	QString openURL(const QString & szURL);

	/**
	* Closes object behind interface.
	* In curent implementation it means closing entire KXMLEditor.
	*
	* @returns Error description or empty string if program closed.
	**/
	QString close();


};


#endif // DCOPIFACE_PART_RO_H
