/***************************************************************************
 *   Copyright (C) 2003 by Stephen Allewell                                *
 *   stephen@mirramar.fsnet.co.uk                                          *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 ***************************************************************************/

#include <qcombobox.h>
#include <kapplication.h>
#include <kconfig.h>
#include "configuration.h"
#include "configurationdialog.h"

Configuration::Configuration()
{
  readSettings();
}

void Configuration::readSettings()
{
  QColor white(Qt::white);
  QColor black(Qt::black);
  QColor gray(Qt::gray);
  KConfig* conf = kapp->config();
  conf->setGroup("NewPattern");
  NewPattern_Units = conf->readEntry("Units","Stitches");
  NewPattern_Width = conf->readNumEntry("Width",100);
  NewPattern_Height = conf->readNumEntry("Height",80);
  NewPattern_ClothCount = conf->readDoubleNumEntry("ClothCount",16.0);
  NewPattern_ClothCountUnits = conf->readEntry("ClothCountUnits","/in");
  NewPattern_Title = conf->readEntry("Title","");
  NewPattern_Author = conf->readEntry("Author","");
  NewPattern_Copyright = conf->readEntry("Copyright","");
  NewPattern_Fabric = conf->readEntry("Fabric","");
  NewPattern_Color = conf->readColorEntry("Color",&white);
  NewPattern_FlossScheme = conf->readEntry("FlossScheme","DMC");
  NewPattern_Instructions = conf->readEntry("Instructions","");

  conf->setGroup("DefaultPath");
  DefaultPath_Patterns = conf->readPathEntry("Patterns","$HOME");
  DefaultPath_Motifs = conf->readPathEntry("Motifs");
  DefaultPath_FlossSchemes = conf->readPathEntry("FlossSchemes");

  conf->setGroup("Import");
  Import_UseMaxColors = conf->readBoolEntry("UseMaxColors",false);
  Import_MaxColors = conf->readNumEntry("MaxColors",50);

  conf->setGroup("Print");
  Print_FrontPage = conf->readBoolEntry("FrontPage",true);
  Print_Instructions = conf->readBoolEntry("Instructions",true);
  Print_SquaresInch = conf->readNumEntry("SquaresInch",10);
  Print_SpillOver = conf->readNumEntry("SpillOver",10);
  Print_Pattern = conf->readBoolEntry("PrintPattern",true);
  Print_FitSingle = conf->readBoolEntry("FitSingle",false);
  Print_SelectedArea = conf->readBoolEntry("SelectedArea",false);
  Print_ColorKey = conf->readBoolEntry("ColorKey",true);
  Print_GridLines = conf->readBoolEntry("GridLines",true);
  Print_Stitches = conf->readBoolEntry("PrintStitches",true);
  Print_StitchesAs = conf->readEntry("StitchesAs","B&W Symbols");
  Print_Backstitches = conf->readBoolEntry("PrintBackstitches",true);
  Print_BackstitchesAs = conf->readEntry("BackstitchesAs","B&W Symbols");
  Print_FlossUsage = conf->readBoolEntry("FlossUsage",true);
  Print_StitchCount = conf->readBoolEntry("StitchCount",true);
  Print_CombineLengths = conf->readBoolEntry("CombineLengths",true);
  Print_CombineFractionals = conf->readBoolEntry("CombineFractionals",true);
  Print_SeperateBackstitching = conf->readBoolEntry("SeperateBackstitching",true);
  Print_StitchTotals = conf->readBoolEntry("StitchTotals",true);
  Print_StitchSummary = conf->readBoolEntry("StitchSummary",false);

  conf->setGroup("Editor");
  Editor_ShowStitches = conf->readBoolEntry("ShowStitches",true);
  Editor_StitchesAs = conf->readEntry("StitchesAs","Regular stitches");
  Editor_ShowBackstitches = conf->readBoolEntry("ShowBackstitches",true);
  Editor_BackstitchesAs = conf->readEntry("BackstitchesAs","Colored lines");
  Editor_ShowGrid = conf->readBoolEntry("ShowGrid",true);
  Editor_CellSize = conf->readNumEntry("CellSize",12);
  Editor_CellGrouping = conf->readNumEntry("CellGrouping",10);
  Editor_GridMajorColor = conf->readColorEntry("GridMajorColor",&black);
  Editor_GridMinorColor = conf->readColorEntry("GridMinorColor",&gray);
  Editor_ShowScales = conf->readBoolEntry("ShowScales",true);
  Editor_ScaleSize = conf->readNumEntry("ScaleSize",30);
  Editor_ScaleFormat = conf->readEntry("ScaleFormat","Stitches");
  Editor_SymbolFont = conf->readEntry("SymbolFont","Charter");

  conf->setGroup("Palette");
  Palette_StitchStrands = conf->readNumEntry("StitchStrands",2);
  Palette_BackstitchStrands = conf->readNumEntry("BackstitchStrands",1);
  Palette_FlossStrands = conf->readNumEntry("FlossStrands",6);
}

void Configuration::writeSettings()
{
  KConfig *conf = kapp->config();

  conf->deleteGroup("NewPattern");
  conf->setGroup("NewPattern");
  conf->writeEntry("Units",NewPattern_Units);
  conf->writeEntry("Width",NewPattern_Width);
  conf->writeEntry("Height",NewPattern_Height);
  conf->writeEntry("ClothCount",NewPattern_ClothCount);
  conf->writeEntry("ClothCountUnits",NewPattern_ClothCountUnits);
  conf->writeEntry("Title",NewPattern_Title);
  conf->writeEntry("Author",NewPattern_Author);
  conf->writeEntry("Copyright",NewPattern_Copyright);
  conf->writeEntry("Fabric",NewPattern_Fabric);
  conf->writeEntry("Color",NewPattern_Color);
  conf->writeEntry("FlossScheme",NewPattern_FlossScheme);
  conf->writeEntry("Instructions",NewPattern_Instructions);

  conf->deleteGroup("DefaultPath");
  conf->setGroup("DefaultPath");
  conf->writePathEntry("Patterns",DefaultPath_Patterns);
  conf->writePathEntry("Motifs",DefaultPath_Motifs);
  conf->writePathEntry("FlossScheme",DefaultPath_FlossSchemes);

  conf->deleteGroup("Import");
  conf->setGroup("Import");
  conf->writeEntry("UseMaxColors",Import_UseMaxColors);
  conf->writeEntry("MaxColors",Import_MaxColors);

  conf->deleteGroup("Print");
  conf->setGroup("Print");
  conf->writeEntry("FrontPage",Print_FrontPage);
  conf->writeEntry("Instructions",Print_Instructions);
  conf->writeEntry("SquaresInch",Print_SquaresInch);
  conf->writeEntry("SpillOver",Print_SpillOver);
  conf->writeEntry("Pattern",Print_Pattern);
  conf->writeEntry("FitSingle",Print_FitSingle);
  conf->writeEntry("SelectedArea",Print_SelectedArea);
  conf->writeEntry("ColorKey",Print_ColorKey);
  conf->writeEntry("GridLines",Print_GridLines);
  conf->writeEntry("Stitches",Print_Stitches);
  conf->writeEntry("StitchesAs",Print_StitchesAs);
  conf->writeEntry("Backstitches",Print_Backstitches);
  conf->writeEntry("BackstitchesAs",Print_BackstitchesAs);
  conf->writeEntry("FlossUsage",Print_FlossUsage);
  conf->writeEntry("StitchCount",Print_StitchCount);
  conf->writeEntry("CombineLengths",Print_CombineLengths);
  conf->writeEntry("CombineFractionals",Print_CombineFractionals);
  conf->writeEntry("SeperateBackstitching",Print_SeperateBackstitching);
  conf->writeEntry("StitchTotals",Print_StitchTotals);
  conf->writeEntry("StitchSummary",Print_StitchSummary);

  conf->deleteGroup("Editor");
  conf->setGroup("Editor");
  conf->writeEntry("ShowStitches",Editor_ShowStitches);
  conf->writeEntry("StitchesAs",Editor_StitchesAs);
  conf->writeEntry("ShowBackstitches",Editor_ShowBackstitches);
  conf->writeEntry("BackstitchesAs",Editor_BackstitchesAs);
  conf->writeEntry("ShowGrid",Editor_ShowGrid);
  conf->writeEntry("CellSize",Editor_CellSize);
  conf->writeEntry("CellGrouping",Editor_CellGrouping);
  conf->writeEntry("GridMajorColor",Editor_GridMajorColor);
  conf->writeEntry("GridMinorColor",Editor_GridMinorColor);
  conf->writeEntry("ShowScales",Editor_ShowScales);
  conf->writeEntry("ScaleSize",Editor_ScaleSize);
  conf->writeEntry("ScaleFormat",Editor_ScaleFormat);
  conf->writeEntry("SymbolFont",Editor_SymbolFont);

  conf->deleteGroup("Palette");
  conf->setGroup("Palette");
  conf->writeEntry("StitchStrands",Palette_StitchStrands);
  conf->writeEntry("BackstitchStrands",Palette_BackstitchStrands);
  conf->writeEntry("FlossStrands",Palette_FlossStrands);
}

void Configuration::configure()
{
  ConfigurationDialog *dialog = new ConfigurationDialog(kapp->mainWidget());
  if (dialog->exec() == QDialog::Accepted)
    writeSettings();

  delete dialog;
}

Configuration& KXSConfig()
{
  static Configuration conf;
  return conf;
}

void Configuration::setComboBoxItem(QComboBox *cb,const QString &s)
{
  for (int i = 0 ; i < cb->count() ; i++)
    if (cb->text(i) == s)
    {
      cb->setCurrentItem(i);
      return;
    }
}
