/***************************************************************************
 *   Copyright (C) 2005 by Roland Weigert                                  *
 *   roweigert@t-online.de                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

#include "settingsdialog.h"

extern rcdatei settingsfile;
extern mysqldatabase *database;

settingsdialog::settingsdialog(QWidget * pointer)
{
  loader=new KIconLoader();
  QPixmap pixmap;
  QString picname;
  settingsgroupbox=new QGroupBox(1,Qt::Horizontal,pointer);
  pathgroupbox=new QGroupBox(2,Qt::Horizontal,settingsgroupbox);
  pathgroupbox->setTitle(i18n("Working directories"));

  filtergroupbox=new QGroupBox(3,Qt::Vertical,settingsgroupbox);
  filtergroupbox->setTitle(i18n("Filter-settings"));

  kyamogroupbox=new QGroupBox(3,Qt::Horizontal,settingsgroupbox);
  kyamogroupbox->setTitle(i18n("Global K-Yamo settings"));
  //Pathsettings
  //readingpath
  readingpathbutton=new QPushButton (i18n("Reading directory"),pathgroupbox);
  picname="folder.png";
  pixmap=loader->loadIcon(picname,KIcon::Desktop);
  QIconSet buttoniconset(pixmap);
  readingpathbutton->setIconSet(buttoniconset);
  readingpathledit=new QLineEdit(pathgroupbox);
  readingpathledit->setText(settingsfile.reading_dir);
  //destinationpath
  destinationpathbutton=new QPushButton (i18n("Destination directory"),pathgroupbox);
  picname="folder_sound.png";
  pixmap=loader->loadIcon(picname,KIcon::Desktop);
  buttoniconset=QIconSet(pixmap);
  destinationpathbutton->setIconSet(buttoniconset);
  destinationpathledit=new QLineEdit(pathgroupbox);
  destinationpathledit->setText(settingsfile.destination_dir);
  //rejectpath
  rejectpathbutton=new QPushButton (i18n("Reject directory"),pathgroupbox);
  picname="folder_txt.png";
  pixmap=loader->loadIcon(picname,KIcon::Desktop);
  buttoniconset=QIconSet(pixmap);
  rejectpathbutton->setIconSet(buttoniconset);
  rejectpathledit=new QLineEdit(pathgroupbox);
  rejectpathledit->setText(settingsfile.reject_dir);
  //temppath
  temppathbutton=new QPushButton (i18n("Temporary directory"),pathgroupbox);
  picname="folder_tar.png";
  pixmap=loader->loadIcon(picname,KIcon::Desktop);
  buttoniconset=QIconSet(pixmap);
  temppathbutton->setIconSet(buttoniconset);
  temppathledit=new QLineEdit(pathgroupbox);
  temppathledit->setText(settingsfile.mp3_dir);
  //Filtersettings
  filterbox=new QComboBox(TRUE,filtergroupbox);
  filterbox->setCurrentText(settingsfile.filter);
  filtergroupbox2=new QGroupBox(4,Qt::Horizontal,filtergroupbox);
  directorybutton=new QPushButton(i18n("Directory"),filtergroupbox2);
  yearbutton=new QPushButton(i18n("Year"),filtergroupbox2);
  artistbutton=new QPushButton(i18n("Artist"),filtergroupbox2);
  songbutton=new QPushButton(i18n("Song"),filtergroupbox2);
  trackbutton=new QPushButton(i18n("Track"),filtergroupbox2);
  albumbutton=new QPushButton(i18n("Album"),filtergroupbox2);
  genrebutton=new QPushButton(i18n("Genre"),filtergroupbox2);

  //Settings for the whole application
  autocompletionbox=new QCheckBox(i18n("autocompletion"),kyamogroupbox);
  mysqlbox=new QCheckBox(i18n("use MySQL"),kyamogroupbox);
  deletebox=new QCheckBox(i18n("Delete original after cleanup"),kyamogroupbox);
  deletebox->setChecked(settingsfile.loeschen);
  overwritebox=new QCheckBox(i18n("Overwrite existing files"),kyamogroupbox);
  overwritebox->setChecked(settingsfile.ueberschreiben);
  betterbox=new QCheckBox(i18n("If bitrate is higher"),kyamogroupbox);
  betterbox->setChecked(settingsfile.besser);
  betterbox->setEnabled(settingsfile.ueberschreiben);

  //Tell aplication,if we want to use autocompletion
  autocompletionbox->setChecked(settingsfile.vervollstaendigen);
  mysqlbox->setChecked(settingsfile.mysql);
  emit vervollstaendigensignal(autocompletionbox->isChecked());
  //Connections for the pathwidgets
  connect(readingpathbutton,SIGNAL(pressed()),SLOT(getreadingpath()));
  connect(readingpathledit,SIGNAL(returnPressed()),SLOT(setreadingpath()));
  connect(destinationpathbutton,SIGNAL(pressed()),SLOT(getdestinationpath()));
  connect(destinationpathledit,SIGNAL(returnPressed()),SLOT(setdestinationpath()));
  connect(rejectpathbutton,SIGNAL(pressed()),SLOT(getrejectpath()));
  connect(rejectpathledit,SIGNAL(returnPressed()),SLOT(setrejectpath()));
  connect(temppathbutton,SIGNAL(pressed()),SLOT(gettemppath()));
  connect(temppathledit,SIGNAL(returnPressed()),SLOT(settemppath()));

  //Connections for the filter
  connect(filterbox,SIGNAL(textChanged(const QString &)),SLOT(savefilter(const QString &)));
  connect(directorybutton,SIGNAL(clicked()),SLOT(dirslashslot()));
  connect(yearbutton,SIGNAL(clicked()),SLOT(yearslot()));
  connect(artistbutton,SIGNAL(clicked()),SLOT(artistslot()));
  connect(songbutton,SIGNAL(clicked()),SLOT(songslot()));
  connect(trackbutton,SIGNAL(clicked()),SLOT(trackslot()));
  connect(albumbutton,SIGNAL(clicked()),SLOT(albumslot()));
  connect(genrebutton,SIGNAL(clicked()),SLOT(genreslot()));


  //Connections for global settings
  connect(autocompletionbox,SIGNAL(clicked()),SLOT(vervollstaendigenwechsel()));
  connect(mysqlbox,SIGNAL(clicked()),SLOT(mysqlwechsel()));
  connect(overwritebox,SIGNAL(toggled(bool)),SLOT(overwriteslot()));
  connect(betterbox,SIGNAL(toggled(bool)),SLOT(betterslot()));
  connect(deletebox,SIGNAL(toggled(bool)),SLOT(deleteslot()));

}

settingsdialog::~settingsdialog()
{
  delete loader;
  delete settingsgroupbox;
  delete pathgroupbox;
  delete readingpathledit;
  delete autocompletionbox;
  delete mysqlbox;
  delete readingpathbutton;
}

void settingsdialog::getreadingpath()
{
  QString pfad;
  if(pfad=QFileDialog::getExistingDirectory(settingsfile.reading_dir,this,i18n("choose directory"),i18n("Please choose reading directory")))
    {
      this->readingpathledit->setText(settingsfile.reading_dir);
    }
  if (pfad.compare("/"))
    {
      QFileInfo *dateiinfo=new QFileInfo(pfad);
      if (dateiinfo->exists())
        {
          settingsfile.reading_dir=pfad;
          this->readingpathledit->setText(settingsfile.reading_dir);
          emit verzeichniswechsel();
          settingsfile.speichern();
        }
      delete dateiinfo;
    }
  else
    {
      //Falls Rootverzeichnisgewhlt, Fehler ausgeben, und alten Wert zurck
      this->readingpathledit->setText(settingsfile.reading_dir);
      QMessageBox::warning(this,i18n("access error"),i18n("You can't use root-directory as reading-directory"),"&Ok",QString::null,QString::null,1);
    }
}

void settingsdialog::setreadingpath()
{
  settingsfile.reading_dir=readingpathledit->text();
  emit verzeichniswechsel();
  settingsfile.speichern();
}

void settingsdialog::getdestinationpath()
{
  QString pfad;
  if(pfad=QFileDialog::getExistingDirectory(settingsfile.destination_dir,this,i18n("choose directory"),i18n("please choose destination-directory")))
    {
      this->destinationpathledit->setText(settingsfile.destination_dir);
    }
  if (pfad.compare("/"))
    {
      QFileInfo *dateiinfo=new QFileInfo(pfad);
      if (dateiinfo->exists())
        {
          settingsfile.destination_dir=pfad;
          this->destinationpathledit->setText(settingsfile.destination_dir);
          settingsfile.speichern();
        }
      delete dateiinfo;
    }
  else
    {
      //Falls Rootverzeichnisgewhlt, Fehler ausgeben, und alten Wert zurck
      this->destinationpathledit->setText(settingsfile.destination_dir);
      QMessageBox::warning(this,i18n("access error"),i18n("You can't copy your files into root-directory"),"&Ok",QString::null,QString::null,1);
    }
}

void settingsdialog::setdestinationpath()
{
  settingsfile.destination_dir=destinationpathledit->text();
  settingsfile.speichern();
}

void settingsdialog::getrejectpath()
{
  QString pfad;
  if(pfad=QFileDialog::getExistingDirectory(settingsfile.reject_dir,this,i18n("choose directory"),i18n("please choose reject-directory")))
    {
      this->rejectpathledit->setText(settingsfile.reject_dir);
    }
  if (pfad.compare("/"))
    {
      QFileInfo *dateiinfo=new QFileInfo(pfad);
      if (dateiinfo->exists())
        {
          settingsfile.reject_dir=pfad;
          this->rejectpathledit->setText(settingsfile.reject_dir);
          settingsfile.speichern();
        }
      delete dateiinfo;
    }
  else
    {
      //Falls Rootverzeichnisgewhlt, Fehler ausgeben, und alten Wert zurck
      this->rejectpathledit->setText(settingsfile.reject_dir);
      QMessageBox::warning(this,i18n("access error"),i18n("You can't move your reject-files to root-directory"),"&Ok",QString::null,QString::null,1);
    }
}

void settingsdialog::setrejectpath()
{
  settingsfile.reject_dir=rejectpathledit->text();
  settingsfile.speichern();
}

void settingsdialog::gettemppath()
{
  QString pfad;
  if(pfad=QFileDialog::getExistingDirectory(settingsfile.reject_dir,this,i18n("choose directory"),i18n("please choose reject-directory")))
    {
      this->temppathledit->setText(settingsfile.mp3_dir);
    }
  if (pfad.compare("/"))
    {
      QFileInfo *dateiinfo=new QFileInfo(pfad);
      if (dateiinfo->exists())
        {
          settingsfile.mp3_dir=pfad;
          this->temppathledit->setText(settingsfile.mp3_dir);
          settingsfile.speichern();
        }
      delete dateiinfo;
    }
  else
    {
      //Falls Rootverzeichnisgewhlt, Fehler ausgeben, und alten Wert zurck
      this->temppathledit->setText(settingsfile.mp3_dir);
      QMessageBox::warning(this,i18n("access error"),i18n("You can't use root-directory as temp"),"&Ok",QString::null,QString::null,1);
    }
}

void settingsdialog::settemppath()
{
  settingsfile.mp3_dir=temppathledit->text();
  settingsfile.speichern();
}

//filter slots
void settingsdialog::albumslot()
{
  QString text=filterbox->currentText();
  if (!text.contains("#ALBUM#"))
    {
      text=QString("%1#ALBUM#").arg(text);
      filterbox->setCurrentText(text);
    }
}

void settingsdialog::artistslot()
{
  QString text=filterbox->currentText();
  if (!text.contains("#BAND#"))
    {
      text=QString("%1#BAND#").arg(text);
      filterbox->setCurrentText(text);
    }
}

void settingsdialog::dirslashslot()
{
  QString text=filterbox->currentText();
  if ((!text.endsWith("/"))&&(!text.isEmpty()))
    {
      text=QString("%1/").arg(text);
      filterbox->setCurrentText(text);
    }
}

void settingsdialog::genreslot()
{
  QString text=filterbox->currentText();
  if (!text.contains("#GENRE#"))
    {
      text=QString("%1#GENRE#").arg(text);
      filterbox->setCurrentText(text);
    }
}

void settingsdialog::songslot()
{
  QString text=filterbox->currentText();
  if (!text.contains("#SONG#"))
    {
      text=QString("%1#SONG#").arg(text);
      filterbox->setCurrentText(text);
    }
}

void settingsdialog::trackslot()
{
  QString text=filterbox->currentText();
  if (!text.contains("#TRACK#"))
    {
      text=QString("%1#TRACK#").arg(text);
      filterbox->setCurrentText(text);
    }
}

void settingsdialog::yearslot()
{
  QString text=filterbox->currentText();
  if (!text.contains("#YEAR#"))
    {
      text=QString("%1#YEAR#").arg(text);
      filterbox->setCurrentText(text);
    }
}

void settingsdialog::savefilter(const QString & string)
{
  settingsfile.filter=filterbox->currentText();
  settingsfile.speichern();
}

//kyamo global settings
void settingsdialog::vervollstaendigenwechsel()
{
  emit vervollstaendigensignal(settingsfile.vervollstaendigen=autocompletionbox->isChecked());
  settingsfile.speichern();
}

void settingsdialog::mysqlwechsel()
{
  settingsfile.mysql=mysqlbox->isChecked();
  //Wenn mysql aktiviert wurde Datenbank ffnen.
  if (settingsfile.mysql)
    {
      database=new mysqldatabase();//database initialisieren, und bei Bedarf erstellen
      if(database->quit)
        {
          settingsfile.mysql=FALSE;
          mysqlbox->setChecked(FALSE);
          delete database;
        }
    }
  else
    {
      delete database;
    }
  settingsfile.speichern();
  emit mysqlsignal();
}

void settingsdialog::deleteslot()
{
settingsfile.loeschen=deletebox->isChecked();
settingsfile.speichern();
}

void settingsdialog::overwriteslot()
{
betterbox->setEnabled(overwritebox->isChecked());
settingsfile.ueberschreiben=overwritebox->isChecked();
settingsfile.speichern();
}

void settingsdialog::betterslot()
{
settingsfile.ueberschreiben=betterbox->isChecked();
settingsfile.speichern();
}

void settingsdialog::start()
{
  emit verzeichniswechsel();
  emit vervollstaendigensignal(settingsfile.vervollstaendigen=autocompletionbox->isChecked());
}

#include "settingsdialog.moc"
