/***************************************************************************
 *   Copyright (C) 2005 by Roland Weigert                                  *
 *   roweigert@t-online.de                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/


using namespace std;

#ifndef _TAGDIALOG_H_
#define _TAGDIALOG_H_

#include <iostream>

#include <qfiledialog.h>
#include <qmessagebox.h>
#include <qgroupbox.h>
#include <qsplitter.h>
#include <qsize.h>
#include <qpixmap.h>
#include <qimage.h>
#include <qlistview.h>
#include <qlabel.h>
#include <qcombobox.h>
#include <qpushbutton.h>
#include <qspinbox.h>
#include <qlayout.h>
#include <qstatusbar.h>
#include <qptrlist.h>
#include <qstring.h>
#include <klocale.h>
#include <kiconloader.h>

#include "verzeichnis.h"
#include "mysqlinterface.h"
#include "rcdatei.h"
#include "progress.h"
#include "cleanup.h"

class tagdialog : public QWidget
  {
    Q_OBJECT
  private:
    KIconLoader *loader;
    QStatusBar *infozeile;
    QBoxLayout *mainlayout;
    QBoxLayout *tagdialoglayout;
    QSplitter *splitteraufteilung;
    QGroupBox *hauptbox;
    QGroupBox *gruppegroupbox;
    QGroupBox *albumgroupbox;
    QGroupBox *titelgroupbox;
    QGroupBox *genregroupbox;
    QGroupBox *jahrgroupbox;
    QGroupBox *covergroupbox;
    QPushButton *coverknopf;
    QLabel *artistlabel;
    QLabel *albumlabel;
    QLabel *tracklabel;
    QLabel *genrelabel;
    QLabel *yearlabel;
    QComboBox *artistbox;
    QComboBox *albumbox;
    QComboBox *trackbox;
    QComboBox *genrebox;
    QListView *auswahlbaum;
    QString aktuelledatei;
    QSpinBox *tracknumberbox;
    QSpinBox *yearbox;
    QPushButton *speichernknopf;
    QPushButton *cleanupbutton;
    //QLabel *coverlabel;
    //QPixmap coverbild;
    //QString coverdatei;
    bool singleselect;
    bool bandabbruch;
    bool albumabbruch;
    bool titelabbruch;
    bool genreabbruch;
    bool jahrabbruch;
    bool nummerabbruch;
    long itemcounter;
    QPtrList<QListViewItem> auswahlliste;
  public:
    tagdialog(QWidget *);
    virtual ~tagdialog();
  public slots:
    void listboxholen();
    void setvervollstaendigen(bool);
    void boxenholen();
  private slots:
    void eingabensperren();
    void eingabenfreigebensingle();
    void eingabenfreigebenmulti();
    void artistChanged();
    void albumChanged();
    void trackChanged();
    void genreChanged();
    void tracknumberChanged(int);
    void tagupdate(QListViewItem *);
    void multitagupdate();
    void rekursivtag(QListViewItem *);
    void tagschreiben();
    void cleanupslot();
    //  void bildladen();
  };

#endif // _TAGDIALOG_H_
