/***************************************************************************
 *   Copyright (C) 2005 by Roland Weigert                                  *
 *   roweigert@t-online.de                                                 *
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   This program is distributed in the hope that it will be useful,       *
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of        *
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the         *
 *   GNU General Public License for more details.                          *
 *                                                                         *
 *   You should have received a copy of the GNU General Public License     *
 *   along with this program; if not, write to the                         *
 *   Free Software Foundation, Inc.,                                       *
 *   59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.             *
 ***************************************************************************/

using namespace std;
#include <iostream>

#include "taglibschnittstelle.h"

musikdatei::musikdatei()
{}

musikdatei::~ musikdatei()
{}

using namespace TagLib;
id3tag * musikdatei::lesenTag(QString dateiname)
{
    id3tag *Song=new id3tag();
    FileRef file(dateiname.local8Bit());
    Song->artist=TStringToQString(file.tag()->artist());
    Song->album=TStringToQString(file.tag()->album());
    Song->titel=TStringToQString(file.tag()->title());
    Song->genre=TStringToQString(file.tag()->genre());
    Song->number=file.tag()->track();
    Song->year=file.tag()->year();
    Song->bitrate=file.audioProperties()->bitrate();
    return Song;
}

using namespace TagLib;
bool musikdatei::schreibenTag(QString dateiname, id3tag *Song)
{
    FileRef file(dateiname.local8Bit());
    QString band2=Song->titel;
    file.tag()->setTrack(Song->number);
    file.tag()->setArtist(QStringToTString(Song->artist));
    file.tag()->setAlbum(QStringToTString(Song->album));
    file.tag()->setYear(Song->year);
    file.tag()->setTitle(QStringToTString(Song->titel));
    file.tag()->setGenre(QStringToTString(Song->genre));
    //file.tag()->setPicture("/home/roland/futile_promo.jpg");
    return (file.save());
}
//#include "taglibschnittstelle.moc"
