//LabPlot : ArrangePlotDialog.h

#ifndef ARRANGEPLOTDIALOG_H
#define ARRANGEPLOTDIALOG_H

#include <qfont.h>
#include <qcheckbox.h>
#include "Worksheet.h"
#include "PlotDialog.h"

class ArrangePlotDialog: public PlotDialog
{
	Q_OBJECT
public:
	ArrangePlotDialog(MainWin *mw, const char *name);
public slots:
	void setX(int x) {xle->setText(QString::number(x)); }		//!< set dimension in x range
	void setY(int y) {yle->setText(QString::number(y)); }		//!< set dimension in y range
	void setGap(double g) { gaple->setText(QString::number(g)); }	//!< set gap between plots
	void ok_clicked() { apply_clicked(); accept(); }
	void apply_clicked();
	void Apply() { apply_clicked(); }
private:
	KLineEdit *xle, *yle, *gaple;
};

#endif //ARRANGEPLOTDIALOG_H
