//LabPlot : AverageListDialog.cc

#include "AverageListDialog.h"
#include "source.h"

using namespace std;

AverageListDialog::AverageListDialog(MainWin *mw, const char *name)
	: ListDialog(mw, name)
{
	setCaption(i18n("Average Dialog"));

	QTabWidget *tw = new QTabWidget(vbox);
	QVBox *tab1 = new QVBox(tw);

	new QLabel(i18n(" Average every n points :"),tab1);
	QHBox *hb = new QHBox(tab1);
	new QLabel(QString(" n = "),hb);
	nle = new KLineEdit(QString("3"),hb);
	nle->setValidator(new QIntValidator(nle));

	Style *style=0;
	Symbol *symbol=0;
	QVBox *styletab;
	if(p && p->getPlot(p->API())->Type() == PSURFACE)
		styletab = surfaceStyle(tw,true);
	else
		styletab = simpleStyle(tw, style, symbol);

	tw->addTab(tab1,i18n("Parameter"));
	tw->addTab(styletab,i18n("Style"));

	QObject::connect(ok,SIGNAL(clicked()),SLOT(ok_clicked()));
        QObject::connect(apply,SIGNAL(clicked()),SLOT(apply_clicked()));
	
	setMinimumWidth(vbox->minimumSizeHint().width());
	setMinimumHeight(gbox->minimumSizeHint().height()+vbox->minimumSizeHint().height());
	resize(minimumSize());
}
 
 int AverageListDialog::apply_clicked() {
	int n = (nle->text()).toInt();
	
	// spreadsheet
	if(s) {
		QTable *table = s->Table();
		int col = table->currentColumn();
		
		if(n >= table->numRows()) {
			KMessageBox::error(this,i18n("n bigger than number of rows!\nPlease use a smaller value."));
			return -1;
		}
		
		// add column if needed
		bool empty=true;
		for(int i=0;i<table->numRows();i++) {
			if(table->text(i,table->numCols()-1).length()>0) {
				empty =false;
			}
		}
		if (!empty)
			s->addColumn();

		int newcol = table->numCols()-1;
		for (int i = 0;i<table->numRows()/n;i++) {
			double sum = 0;
			for (int j=0;j<n;j++) {
				sum+=table->text(n*i+j,col).toDouble();
			}
			sum = sum/n;
			
			// insert into last column
			table->setText(n*i+n/2,newcol,QString::number(sum));
		}
		return 0;
	}
	
	// worksheet
	GraphList *gl = p->getPlot(p->API())->getGraphList();
	if(gl->Number()==0) {
		KMessageBox::error(this,i18n("No graph found!"));
		return -2;
	}
	int item = (int) (lv->itemPos(lv->currentItem())/lv->currentItem()->height());
	GRAPHType st = gl->getStruct(item);

	Style *style=0;
	Symbol *symbol=0;
	if(st != GRAPHM) {
		style = new Style(cb2->currentItem(),color->color(),filled->isChecked(),fcolor->color(),
			widthle->text().toInt(),pencb->currentItem(),brushcb->currentItem());
		symbol = new Symbol((SType)symbolcb->currentItem(),scolor->color(),ssize->text().toInt(),
			(FType)symbolfillcb->currentItem(),sfcolor->color(),sbrushcb->currentItem());
	}

	double xmin=0, xmax=1, ymin=0, ymax=1, zmin=0, zmax=1, tmin=0, tmax=1;
	if (st == GRAPH2D) {
		Graph2D *g = gl->getGraph2D(item);
		int nx = g->Number();
		Point *ptr = new Point[nx];
		Point *a = g->Data();

		if(n >= nx) {
			KMessageBox::error(this,i18n("n bigger than number of points!\nPlease use a smaller value."));
			return -1;
		}

		// do the average
		for (int i = 0;i<nx/n;i++) {
			double x = a[(int) (n*i+n/2)].X();
			double y = 0;
			for (int j=0;j<n;j++) {
				y+=a[n*i+j].Y();
			}
			y = y/n;

			ptr[i].setPoint(x,y);
		}

		mw->calculateRanges2D(ptr,g->Number()/n,&xmin,&xmax,&ymin,&ymax);

		// create the new Graph
		LRange range[2];
		range[0] = LRange(xmin,xmax);
		range[1] = LRange(ymin,ymax);

		QString fun = QString(i18n("average (")+QString::number(n)+i18n(") of ")+g->Label());

		Graph2D *ng = new Graph2D(fun,fun,range,SSPREADSHEET,P2D,style,symbol,ptr,g->Number()/n);
		mw->addGraph2D(ng,sheetcb->currentItem());
	}
	else if (st == GRAPH3D) {
		Graph3D *g = gl->getGraph3D(item);
		int nx = g->Number();
		Point3D *ptr = new Point3D[nx];
		Point3D *a = g->Data();

		if(n >= nx) {
			KMessageBox::error(this,i18n("n bigger than number of points!\nPlease use a smaller value."));
			return -1;
		}

		cout<< "TYPE : "<<(int)type<<endl;

		// do the average
		for (int i = 0;i<nx/n;i++) {
			double x = 0, y = 0, z = 0;
			if (type == P2D) {	// 2derr
				x = a[(int) (n*i+n/2)].X();
				for (int j=0;j<n;j++) {
					y += a[n*i+j].Y();
					z += a[n*i+j].Z();
				}
				y = y/n;
				z = z/n;
			}
			else {		// 3d
				for (int j = 0;j<n;j++) {
					x+=a[(int)(j+n*i)].X();
					y+=a[(int)(j+n*i)].Y();
					z+=a[(int)(j+n*i)].Z();
				}
				x = x/n;
				y = y/n;
				z = z/n;
			}

			ptr[i].setPoint(x,y,z);
		}

		mw->calculateRanges3D(ptr,g->Number()/n,&xmin,&xmax,&ymin,&ymax,&zmin,&zmax);

		// create the new Graph
		LRange range[3];
		range[0] = LRange(xmin,xmax);
		range[1] = LRange(ymin,ymax);
		range[2] = LRange(zmin,zmax);
		
		QString fun = QString(i18n("average (")+QString::number(n)+i18n(") of ")+g->Label());
		
		Graph3D *ng = new Graph3D(fun,fun,range,SSPREADSHEET,type,style,symbol,ptr,g->Number()/n,1);
		ng->setNumberX((int)(g->NX()/n));
		ng->setNumberY((int)(g->NY()));
		mw->addGraph3D(ng,sheetcb->currentItem());

	}
	else if (st == GRAPH4D) {
		Graph4D *g = gl->getGraph4D(item);
		bool gtype = g->Type();
		int nx = g->Number();
		Point4D *ptr = new Point4D[nx];
		Point4D *a = g->Data();

		if(n >= nx) {
			KMessageBox::error(this,i18n("n bigger than number of points!\nPlease use a smaller value."));
			return -1;
		}

		for (int i = 0;i<nx/n;i++) {
			double x=0,y=0,z=0,t=0;

			if (type == P2D) {	// X-Y-DX-DY or X-Y-DY-DY
				x = a[(int) (n*i+n/2)].X();
				for (int j=0;j<n;j++) {
					y += a[n*i+j].Y();
					z += a[n*i+j].Z();
					t += a[n*i+j].T();
				}
				y = y/n;
				z = z/n;
				t = t/n;
			}

			ptr[i].setPoint(x,y,z,t);
		}

		mw->calculateRanges4D(ptr,g->Number()/n,&xmin,&xmax,&ymin,&ymax,&zmin,&zmax,&tmin,&tmax);

		// create the new Graph
		LRange range[4];
		range[0] = LRange(xmin,xmax);
		range[1] = LRange(ymin,ymax);
		range[2] = LRange(zmin,zmax);
		range[3] = LRange(tmin,tmax);
		
		QString fun = QString(i18n("average (")+QString::number(n)+i18n(") of ")+g->Label());
		
		Graph4D *ng = new Graph4D(fun,fun,range,SSPREADSHEET,type,style,symbol,ptr,g->Number()/n,gtype);
		mw->addGraph4D(ng,sheetcb->currentItem());
	}
	else if (st == GRAPHM) {		// PSURFACE and P3D
		GraphM *g = gl->getGraphM(item);
		int N = g->Number();
		int nx = g->NX();
		int ny = g->NY();
		double *ptr = new double[N];
		double *a = g->Data();

		if(n >= nx || n >= ny) {
			KMessageBox::error(this,i18n("n bigger than number of points!\nPlease use a smaller value."));
			return -1;
		}

		// do the average
		for (int i = 0;i<nx/n;i++) {
			for (int j = 0;j<ny/n;j++) {
				double z = 0;
		
				for (int l=0;l<n;l++) {
					int a1 = n*i+l;
					for (int k=0;k<n;k++) {
						int a2 = n*j+k;
						z += a[a2+nx*a1];
					}
				}
				z=z/(n*n);
				// new ranges
				if (i==0) {
					zmin=zmax=z;
				}
				else {
					z<zmin?zmin=z:0;
					z>zmax?zmax=z:0;
				}

				ptr[j+(nx/n)*i]=z;
			}
			cout<<endl;
		}

		// create the new Graph
		LRange range[3];
		range[0] = LRange(1,nx);
		range[1] = LRange(1,ny);
		range[2] = LRange(zmin,zmax);
		
		QString fun = QString(i18n("average (")+QString::number(n)+i18n(") of ")+g->Label());

		GraphM *ng = new GraphM(fun,fun,range,SSPREADSHEET,type,style,symbol,ptr,nx/n,ny/n);
		mw->addGraphM(ng,sheetcb->currentItem());	// type??
	}

	updateList();

	return 0;
}
