//LabPlot : AxesDialog.cc

#include <stdlib.h>
#include <stdio.h>
#include <iostream>
#include <qlabel.h>
#include <qfontdialog.h>
#include <qstringlist.h>
#include <qcolordialog.h>
#include <klocale.h>
#include <kmessagebox.h>
#include <PlotQWT3D.h>
#include "AxesDialog.h"
#include "scaleitems.h"
#include "ticspos.h"
#include "ticsformatitems.h"

using namespace std;

//! Dialog for manipulating the Axis of an 2D or 3D Plot
AxesDialog::AxesDialog(MainWin *mw, const char *name, int axesnr)
	: Dialog(mw, name)
{
	plot = p->getPlot(p->API());
	type = plot->Type();

	if (type == P2D || type == PSURFACE) {
		for (int i=0;i<4;i++)
			axis[i] = plot->getAxis(i);
	}
	else if (type == P3D || type == PQWT3D) {
		for (int i=0;i<12;i++)
			axis[i] = plot->getAxis(i);
	}
	else if (type == PPOLAR) {
		axis[0] = plot->getAxis(0);	// phi
		axis[1] = plot->getAxis(1);	// r
	}
	else if (type == PTERNARY)
		axis[0] = plot->getAxis(0);

	setCaption(i18n("Axes Settings"));
	
	QHBox *hb = new QHBox(vbox);
	new QLabel(i18n("Axes"),hb);
	cb = new QCheckBox(i18n("Axis enabled "),hb);
	cb->setChecked(axis[axesnr]->enabled());
	QObject::connect(cb,SIGNAL(toggled(bool)),this,SLOT(axisEnabled(bool)));

	axeslb = new KListBox(vbox);
	QStringList list;
	double rmin=0, rmax=0;	// axes range
	if (type == P2D || type == PSURFACE) {
		list<<QString("x")<<QString("y")<<QString("y2")<<QString("x2");
		if(axesnr == 0 || axesnr == 3) {
			rmin = plot->ActRanges()[0].rMin();
			rmax = plot->ActRanges()[0].rMax();
		}
		else {
			rmin = plot->ActRanges()[1].rMin();
			rmax = plot->ActRanges()[1].rMax();
		}
	}
	else if (type == P3D || type == PQWT3D){
		list<<QString("x")<<QString("y")<<QString("z")<<QString("x2")<<QString("x3")<<QString("x4");
		list<<QString("y4")<<QString("y3")<<QString("y2")<<QString("z2")<<QString("z4")<<QString("z3");
		if(axesnr == 0 || axesnr == 3 || axesnr == 4 || axesnr == 5) {
			rmin = plot->ActRanges()[0].rMin();
			rmax = plot->ActRanges()[0].rMax();
		}
		else if(axesnr == 1 || axesnr == 6 || axesnr == 7 || axesnr == 8) {
			rmin = plot->ActRanges()[1].rMin();
			rmax = plot->ActRanges()[1].rMax();
		}
		else {
			rmin = plot->ActRanges()[2].rMin();
			rmax = plot->ActRanges()[2].rMax();
		}
	}
	else if (type == PPOLAR) {
		list<<QString("phi")<<QString("r");
		
		rmin = plot->ActRanges()[axesnr].rMin();
		rmax = plot->ActRanges()[axesnr].rMax();
	}
	else if (type == PTERNARY) {
		list<<QString("a");
		
		rmin = plot->ActRanges()[axesnr].rMin();
		rmax = plot->ActRanges()[axesnr].rMax();
	}
	
	axeslb->insertStringList(list);
	axeslb->setCurrentItem(axesnr);
	QObject::connect(axeslb,SIGNAL(selectionChanged()),this,SLOT(updateAxis()));

	QTabWidget *tw = new QTabWidget(vbox);

	QVBox *tab1 = new QVBox(tw);

	hb = new QHBox(tab1);
	new QLabel(i18n("Axis Scale :"),hb);
	ascb = new KComboBox(hb);
	int i=0;
	while(scaleitems[i] != 0) ascb->insertItem(i18n(scaleitems[i++]));
	ascb->setCurrentItem(axis[axesnr]->Scale());
	QObject::connect(ascb,SIGNAL(activated (int)),SLOT(updateScale(int)));

	hb = new QHBox(tab1);
	new QLabel(i18n("Scaling :"),hb);
	scaling = new KLineEdit(QString::number(axis[axesnr]->Scaling()),hb);
	new QLabel(i18n("Shift :"),hb);
	shift = new KLineEdit(QString::number(axis[axesnr]->Shift()),hb);

	new QLabel(i18n("Axis Range :"),tab1);
	hb = new QHBox(tab1);
	new QLabel(i18n("From : "),hb);
	min = new KLineEdit(QString::number(rmin,'g',15),hb);
	new QLabel(i18n("To : "),hb);
	max = new KLineEdit(QString::number(rmax,'g',15),hb);
	
	if (type == PPOLAR) {
		min->setEnabled(false);
		max->setEnabled(false);
	}

	Label *l = axis[axesnr]->label();
	if(mw->activeWorksheet() && mw->activeWorksheet()->getPlot(0) &&
		mw->activeWorksheet()->getPlot(0)->Type() == PQWT3D )
		rtw = new RichTextWidget((QWidget *)tab1,l,0,1);
	else
		rtw = new RichTextWidget((QWidget *)tab1,l,0);

	// "Tics"
	QVBox *tab2 = new QVBox(tw);

	hb = new QHBox(tab2);
	new QLabel(i18n("Tics Position :"),hb);
	ticsposcb = new KComboBox(hb);
	i=0;
	while(ticspositems[i] != 0) ticsposcb->insertItem(i18n(ticspositems[i++]));
        ticsposcb->setCurrentItem(axis[axesnr]->TicsPos());

	hb = new QHBox(tab2);
	cb2 = new QCheckBox(i18n("Major Tics : "),hb);
	cb2->setChecked(axis[axesnr]->MajorTicsEnabled());
	if(axis[axesnr]->MajorTics()==-1)
		major = new KLineEdit(i18n("auto"),hb);
	else
		major = new KLineEdit(QString::number(axis[axesnr]->MajorTics()),hb);
	// allow auto
	//major->setValidator(new QIntValidator(major));
	new QLabel(i18n("Width : "),hb);
	majorticswidthle = new KLineEdit(QString::number(axis[axesnr]->majorTicsWidth()),hb);
	majorticswidthle->setValidator(new QIntValidator(0,100,majorticswidthle));
	if(type == PQWT3D) {
		new QLabel(i18n("Length : "),hb);
		majorticslengthle = new KLineEdit(QString::number(((PlotQWT3D *)plot)->majorTicLength(axesnr)),hb);
		majorticslengthle->setValidator(new QDoubleValidator(0.0,1.0,3,majorticslengthle));
	 }
		
	hb = new QHBox(tab2);
	cb3 = new QCheckBox(i18n("Minor Tics : "),hb);
	cb3->setChecked(axis[axesnr]->MinorTicsEnabled());
	minor = new KLineEdit(QString::number(axis[axesnr]->MinorTics()),hb);
	minor->setValidator(new QIntValidator(minor));
	new QLabel(i18n("Width : "),hb);
	minorticswidthle = new KLineEdit(QString::number(axis[axesnr]->minorTicsWidth()),hb);
	minorticswidthle->setValidator(new QIntValidator(0,100,minorticswidthle));
	if(type == PQWT3D) {
		new QLabel(i18n("Length : "),hb);
		minorticslengthle = new KLineEdit(QString::number(((PlotQWT3D *)plot)->minorTicLength(axesnr)),hb);
		minorticslengthle->setValidator(new QDoubleValidator(0.0,1.0,3,minorticslengthle));
	}
		
	hb = new QHBox(tab2);
	new QLabel(i18n("Tics Label Font : "),hb);
	tf = axis[axesnr]->TicsFont();
	ticsfont = new KLineEdit(tf.family() + tr(" ") +
			QString::number(tf.pointSize()),hb);
	KPushButton *newticsfont = new KPushButton(i18n("New"),hb);
	QObject::connect(newticsfont,SIGNAL(clicked()),SLOT(selectTicsFont()));

	hb = new QHBox(tab2);
	new QLabel(i18n("Tics Label Format : "),hb);
	atlfcb = new KComboBox(hb);
	i=0;
	while(ticsformatitems[i] != 0) atlfcb->insertItem(i18n(ticsformatitems[i++]));
	atlfcb->setCurrentItem(axis[axesnr]->TicsLabelFormat());
	QObject::connect(atlfcb,SIGNAL(activated(int)),this,SLOT(update_timeformat()));

	hb = new QHBox(tab2);
	new QLabel(i18n("date/time/datetime format (dd.MM.yyyy hh:mm:ss.zzz) : "),hb);
	timeformat = new KLineEdit(axis[axesnr]->DateTimeFormat(),hb);
	if (atlfcb->currentText() != i18n("time") && atlfcb->currentText() != i18n("date")
		&& atlfcb->currentText() != i18n("datetime"))
		timeformat->setDisabled("true");

	hb = new QHBox(tab2);
	new QLabel(i18n("Tics Label Precision : "),hb);
	tlple = new KLineEdit(QString::number(axis[axesnr]->TicsLabelPrecision()),hb);
	QObject::connect(tlple,SIGNAL(textChanged(const QString &)),this,SLOT(update_timeformat()));
	new QLabel(i18n("Tics Label Position : "),hb);
	tlgle = new KLineEdit(QString::number(axis[axesnr]->TicsLabelGap()),hb);

	hb = new QHBox(tab2);
	new QLabel(i18n("Prefix : "),hb);
	tlprefix = new KLineEdit(axis[axesnr]->TicsLabelPrefix(),hb);
	new QLabel(i18n("Suffix : "),hb);
	tlsuffix = new KLineEdit(axis[axesnr]->TicsLabelSuffix(),hb);

	hb = new QHBox(tab2);
	new QLabel(i18n("Tics Label Rotation : "),hb);
	tlrotation = new KLineEdit(QString::number(axis[axesnr]->TicsLabelRotation()),hb);
	tlrotation->setValidator(new QDoubleValidator(tlrotation));
	
	hb = new QHBox(tab2);
	new QLabel(i18n("Tics Color : "),hb);
        tcb = new KColorButton(axis[axesnr]->TicsColor(),hb);

	hb = new QHBox(tab2);
        new QLabel(i18n("Tics Label Color : "),hb);
        tlcb = new KColorButton(axis[axesnr]->TicsLabelColor(),hb);

	// grid & border
	QVBox *tab3 = new QVBox(tw);

	QGroupBox *gb = new QGroupBox(1,QGroupBox::Horizontal,QString("Grid"),tab3);
	hb = new QHBox(gb);
	cb4 = new QCheckBox(i18n("Major Grid"),hb);
	cb4->setChecked(plot->gridEnabled(2*axesnr));
	new QLabel(i18n("Width : "),hb);
	majorgridwidthle = new KLineEdit(QString::number(axis[axesnr]->majorGridWidth()),hb);
	majorgridwidthle->setValidator(new QDoubleValidator(majorgridwidthle));
	majorgridstylecb = new KComboBox(hb);

	hb = new QHBox(gb);
	cb5 = new QCheckBox(i18n("Minor Grid"),hb);
	cb5->setChecked(plot->gridEnabled(2*axesnr+1));
	new QLabel(i18n("Width : "),hb);
	minorgridwidthle = new KLineEdit(QString::number(axis[axesnr]->minorGridWidth()),hb);
	minorgridwidthle->setValidator(new QDoubleValidator(minorgridwidthle));
	minorgridstylecb = new KComboBox(hb);

	majorgridstylecb->clear();
	minorgridstylecb->clear();
	for (int i=0;i<6;i++) {	// major grid
		QPainter pa;
		QPixmap pm( 100, 30 );
		pm.fill(Qt::white);
        	pa.begin( &pm );
		
		pa.setPen(QPen(axis[axesnr]->majorGridColor(),axis[axesnr]->majorGridWidth(),(PenStyle)i));
		pa.drawLine(5,15,95,15);
		pa.end();
		
		majorgridstylecb->insertItem(pm);
	}
	for (int i=0;i<6;i++) {	// minor grid
		QPainter pa;
		QPixmap pm( 100, 30 );
		pm.fill(Qt::white);
        	pa.begin( &pm );
		
		pa.setPen(QPen(axis[axesnr]->minorGridColor(),axis[axesnr]->minorGridWidth(),(PenStyle)i));
		pa.drawLine(5,15,95,15);
		pa.end();
		
		minorgridstylecb->insertItem(pm);
	}
	majorgridstylecb->setCurrentItem(axis[axesnr]->MajorGridType());
	minorgridstylecb->setCurrentItem(axis[axesnr]->MinorGridType());
	
	hb = new QHBox(gb);
        new QLabel(i18n("Major Grid Color : "),hb);
        majorgridcolorcb = new KColorButton(axis[axesnr]->majorGridColor(),hb);
	hb = new QHBox(gb);
        new QLabel(i18n("Minor Grid Color : "),hb);
        minorgridcolorcb = new KColorButton(axis[axesnr]->minorGridColor(),hb);

	gb = new QGroupBox(1,QGroupBox::Horizontal,QString("Border"),tab3);
	cb6 = new QCheckBox(i18n("Border enabled"),gb);
	hb = new QHBox(gb);
	cb6->setChecked(plot->borderEnabled(axesnr));
	new QLabel(i18n("Border Color : "),hb);
        bcb = new KColorButton(axis[axesnr]->BorderColor(),hb);
	hb = new QHBox(gb);
	new QLabel(i18n("Width : "),hb);
	borderwidthle = new KLineEdit(QString::number(axis[axesnr]->borderWidth()),hb);
	borderwidthle->setValidator(new QIntValidator(0,100,borderwidthle));

	tw->addTab(tab1,i18n("Main"));
	tw->addTab(tab2,i18n("Tics"));
	tw->addTab(tab3,i18n("Grid + Border"));

	update_timeformat();
	
	QObject::connect(ok,SIGNAL(clicked()),SLOT(ok_clicked()));
	QObject::connect(apply,SIGNAL(clicked()),SLOT(apply_clicked()));

	setMinimumWidth(vbox->minimumSizeHint().width());
	setMinimumHeight(gbox->minimumSizeHint().height()+vbox->minimumSizeHint().height());
	resize((int)(1.2*minimumSize().width()),minimumSize().height());
}

//! update values if scale changed
void AxesDialog::updateScale(int i) {
	if(i==LINEAR)
		minor->setText(QString("3"));
	else if (i==LOG10)
		minor->setText(QString("8"));
	else
		minor->setText(QString("0"));
}

//! called when axis tic format is changed : update format line edit & ranges
void AxesDialog::update_timeformat() {
	int item = axeslb->currentItem();
	kdDebug()<<"ATLF = "<<atlfcb->currentText()<<endl;
	if (atlfcb->currentText() == i18n("time") || atlfcb->currentText() == i18n("date")
		|| atlfcb->currentText() == i18n("datetime") )
		timeformat->setEnabled("true");
	else
		timeformat->setDisabled("true");
	
	// update range here
	TFormat atlf = (TFormat) atlfcb->currentItem();
	// dont use richtext formats here
	if(atlf==POWER10 || atlf == POWER2 || atlf == POWERE || atlf == FSQRT)
		atlf = AUTO;
	QString dtf;
	if(atlf == TIME)
		dtf = QString("hh:mm:ss");
	else if (atlf == DATE)
		dtf = QString("yyyy-MM-dd");
	else if (atlf == DATETIME)
		dtf = QString("yyyy-MM-ddThh:mm:ss");
	int prec = tlple->text().toInt();
	
	double rmin=0, rmax=1;
	if (type == P2D || type == PSURFACE || type == PPOLAR) {
		if(item == 0 || item == 3) {
			rmin = plot->ActRanges()[0].rMin();
			rmax = plot->ActRanges()[0].rMax();
		}
		else if (item == 1 || item == 2) {
			rmin = plot->ActRanges()[1].rMin();
			rmax = plot->ActRanges()[1].rMax();
		}
	}
	else if (type == P3D || type == PQWT3D){
		if(item == 0 || item == 3 || item == 6 || item == 9) {
			rmin = plot->ActRanges()[0].rMin();
			rmax = plot->ActRanges()[0].rMax();
		}
		else if (item == 1 || item == 4 || item == 7 || item == 10) {
			rmin = plot->ActRanges()[1].rMin();
			rmax = plot->ActRanges()[1].rMax();
		}
		else if (item == 2 || item == 5 || item == 8 || item == 11) {
			rmin = plot->ActRanges()[2].rMin();
			rmax = plot->ActRanges()[2].rMax();
		}
	}

	QString mintext = plot->TicLabel(atlf,prec,dtf,rmin);
	QString maxtext = plot->TicLabel(atlf,prec,dtf,rmax);
	
	min->setText(mintext);
	max->setText(maxtext);
}

void AxesDialog::axisEnabled(bool on) {
	kdDebug()<<"AxesDialog::axisEnabled() : "<<on<<endl;
	int item = axeslb->currentItem();
	if (on) {	// axis should be enabled
		plot->enableBorder(item,true);
		cb6->setChecked(true);
		// TODO : show the label position in richtext widget (rtw)
		rtw->setLabel(axis[item]->label());
	}
}

//! update the selected axis
void AxesDialog::updateAxis() {
	kdDebug()<<"AxesDialog::updateAxis()"<<endl;
	int item = axeslb->currentItem();
	cb->setChecked(axis[item]->enabled());

	rtw->setLabel(axis[item]->label());

	scaling->setText(QString::number(axis[item]->Scaling()));
	shift->setText(QString::number(axis[item]->Shift()));

	double rmin=0, rmax=1;
	if (type == P2D || type == PSURFACE || type == PPOLAR) {
		if(item == 0 || item == 3) {
			rmin = plot->ActRanges()[0].rMin();
			rmax = plot->ActRanges()[0].rMax();

			ascb->setCurrentItem(axis[0]->Scale());
			if (type == PPOLAR) {
				max->setEnabled(false);
			}
		}
		else if (item == 1 || item == 2) {
			rmin = plot->ActRanges()[1].rMin();
			rmax = plot->ActRanges()[1].rMax();

			ascb->setCurrentItem(axis[1]->Scale());
			if (type == PPOLAR) {
				max->setEnabled(true);
			}
		}
	}
	else if (type == P3D || type == PQWT3D){
		if(item == 0 || item == 3 || item == 6 || item == 9) {
			rmin = plot->ActRanges()[0].rMin();
			rmax = plot->ActRanges()[0].rMax();
			ascb->setCurrentItem(axis[0]->Scale());
		}
		else if (item == 1 || item == 4 || item == 7 || item == 10) {
			rmin = plot->ActRanges()[1].rMin();
			rmax = plot->ActRanges()[1].rMax();
			ascb->setCurrentItem(axis[1]->Scale());
		}
		else if (item == 2 || item == 5 || item == 8 || item == 11) {
			rmin = plot->ActRanges()[2].rMin();
			rmax = plot->ActRanges()[2].rMax();
			ascb->setCurrentItem(axis[2]->Scale());
		}
	}
	// set text of range line edits
	TFormat atlf=axis[item]->TicsLabelFormat();
	// dont use richtext formats here
	if(atlf==POWER10 || atlf == POWER2 || atlf == POWERE || atlf == FSQRT)
		atlf = AUTO;
	QString dtf;
	if(atlf == TIME)
		dtf = QString("hh:mm:ss");
	else if (atlf == DATE)
		dtf = QString("yyyy-MM-dd");
	else if (atlf == DATETIME)
		dtf = QString("yyyy-MM-ddThh:mm:ss");
	QString mintext = plot->TicLabel(atlf,axis[item]->TicsLabelPrecision(),dtf,rmin);
	QString maxtext = plot->TicLabel(atlf,axis[item]->TicsLabelPrecision(),dtf,rmax);
	
	min->setText(mintext);
	max->setText(maxtext);

	// tics
	cb2->setChecked(axis[item]->MajorTicsEnabled());
	cb3->setChecked(axis[item]->MinorTicsEnabled());
	if(axis[item]->MajorTics()==-1)
		major->setText(i18n("auto"));
	else
		major->setText(QString::number(axis[item]->MajorTics()));
	minor->setText(QString::number(axis[item]->MinorTics()));
	majorticswidthle->setText(QString::number(axis[item]->majorTicsWidth()));
	minorticswidthle->setText(QString::number(axis[item]->minorTicsWidth()));
	if(type == PQWT3D) {
		majorticslengthle->setText(QString::number(((PlotQWT3D *)plot)->majorTicLength(item)));
		minorticslengthle->setText(QString::number(((PlotQWT3D *)plot)->minorTicLength(item)));
	}
	majorgridwidthle->setText(QString::number(axis[item]->majorGridWidth()));
	minorgridwidthle->setText(QString::number(axis[item]->minorGridWidth()));
	
	tf = axis[item]->TicsFont();
	ticsfont->setText(tf.family() + tr(" ") + QString::number(tf.pointSize()));

	tlprefix->setText(axis[item]->TicsLabelPrefix());
	tlsuffix->setText(axis[item]->TicsLabelSuffix());

	tcb->setColor(axis[item]->TicsColor());
	tlcb->setColor(axis[item]->TicsLabelColor());

	ticsposcb->setCurrentItem(axis[item]->TicsPos());
	atlfcb->setCurrentItem(axis[item]->TicsLabelFormat());
	tlple->setText(QString::number(axis[item]->TicsLabelPrecision()));
	tlgle->setText(QString::number(axis[item]->TicsLabelGap()));
	timeformat->setText(axis[item]->DateTimeFormat());
	if (atlfcb->currentText() == i18n("time"))
		timeformat->setEnabled("true");
	tlrotation->setText(QString::number(axis[item]->TicsLabelRotation()));

	// grid
	cb4->setChecked(plot->gridEnabled(2*item));
	cb5->setChecked(plot->gridEnabled(2*item+1));
	majorgridcolorcb->setColor(axis[item]->majorGridColor());
	minorgridcolorcb->setColor(axis[item]->minorGridColor());
	bcb->setColor(axis[item]->BorderColor());
	majorgridstylecb->setCurrentItem(axis[item]->MajorGridType());
	minorgridstylecb->setCurrentItem(axis[item]->MinorGridType());
	
	cb6->setChecked(plot->borderEnabled(item));
	borderwidthle->setText(QString::number(axis[item]->borderWidth()));

	majorgridstylecb->clear();
	minorgridstylecb->clear();
	for (int i=0;i<6;i++) {	// major grid
		QPainter pa;
		QPixmap pm( 100, 30 );
		pm.fill(Qt::white);
        	pa.begin( &pm );
		
		pa.setPen(QPen(axis[item]->majorGridColor(),axis[item]->majorGridWidth(),(PenStyle)i));
		pa.drawLine(5,15,95,15);
		pa.end();
		
		majorgridstylecb->insertItem(pm);
	}
	for (int i=0;i<6;i++) {	// minor grid
		QPainter pa;
		QPixmap pm( 100, 30 );
		pm.fill(Qt::white);
        	pa.begin( &pm );
		
		pa.setPen(QPen(axis[item]->minorGridColor(),axis[item]->minorGridWidth(),(PenStyle)i));
		pa.drawLine(5,15,95,15);
		pa.end();
		
		minorgridstylecb->insertItem(pm);
	}
	majorgridstylecb->setCurrentItem(axis[item]->MajorGridType());
	minorgridstylecb->setCurrentItem(axis[item]->MinorGridType());
}

void AxesDialog::selectTicsFont() {
    bool ok;
    QFont font = QFontDialog::getFont( &ok,
		    axis[axeslb->currentItem()]->TicsFont(), this );
    if ( ok ) {
	tf = font;
	ticsfont->setText(tf.family() + tr(" ") + QString::number(tf.pointSize()));
    }
}

void AxesDialog::apply_clicked() {
	kdDebug()<<"AxesDialog::apply_clicked()"<<endl;
	int item = axeslb->currentItem();

	// change xmin,etc. if somethings changed
	if(cb->isChecked() != axis[item]->enabled())
		plot->setBorder(item,cb->isChecked());
	axis[item]->enable(cb->isChecked());

	axis[item]->setLabel(rtw->label());

	axis[item]->setScaling(scaling->text().toDouble());
	axis[item]->setShift(shift->text().toDouble());

	axis[item]->setMajorTicsWidth(majorticswidthle->text().toInt());
	axis[item]->setMinorTicsWidth(minorticswidthle->text().toInt());
	if(type == PQWT3D) {
		((PlotQWT3D *)plot)->setMajorTicLength(item,majorticslengthle->text().toDouble());
		((PlotQWT3D *)plot)->setMinorTicLength(item,minorticslengthle->text().toDouble());
	}
	axis[item]->setTicsLabelPrefix(tlprefix->text());
	axis[item]->setTicsLabelSuffix(tlsuffix->text());

	axis[item]->setTicsFont(tf);
	axis[item]->setTicsColor(tcb->color());
	axis[item]->setTicsLabelColor(tlcb->color());
	axis[item]->setMajorGridColor(majorgridcolorcb->color());
	axis[item]->setMinorGridColor(minorgridcolorcb->color());
	axis[item]->setBorderColor(bcb->color());
	axis[item]->setMajorGridType((Qt::PenStyle) majorgridstylecb->currentItem());
	axis[item]->setMinorGridType((Qt::PenStyle) minorgridstylecb->currentItem());
	axis[item]->setMajorGridWidth(majorgridwidthle->text().toInt());
	axis[item]->setMinorGridWidth(minorgridwidthle->text().toInt());
	
	axis[item]->setTicsPos(ticsposcb->currentItem());
	axis[item]->setTicsLabelFormat((TFormat)atlfcb->currentItem());
	axis[item]->setTicsLabelPrecision(tlple->text().toInt());
	axis[item]->setTicsLabelGap(tlgle->text().toInt());
	axis[item]->setDateTimeFormat(timeformat->text());
	axis[item]->setTicsLabelRotation(tlrotation->text().toDouble());
	axis[item]->setBorderWidth(borderwidthle->text().toInt());

	double ret = parse((char *) (min->text()).latin1());
	switch((TScale)(ascb->currentItem()) ) {
	case LOG10: case LOG2: case LN:
		if(ret <= 0) {
			KMessageBox::warningContinueCancel(this,
				i18n("The axes range has negative values!\nResetting minimum value."));
			min->setText(QString("0.01"));
		}
		break;
	case SQRT:
		if(ret < 0) {
			KMessageBox::warningContinueCancel(this,
				i18n("The axes range has negative values!\nResetting minimum value."));
			min->setText(QString("0"));
		}
		break;
	default: break;
	}

	// TODO : read range line edits with format !
	TFormat atlf = axis[item]->TicsLabelFormat();
	double rmin = plot->TicLabelValue(atlf,min->text());
	double rmax = plot->TicLabelValue(atlf,max->text());
	kdDebug()<<"	TYPE = "<<type<<endl;
	if (type == P2D || type == PSURFACE || type == PPOLAR) {
		if (item == 0 || item == 3 ) {
			plot->setXRange(rmin, rmax);
			axis[item]->enableMajorTics(cb2->isChecked());
			axis[item]->enableMinorTics(cb3->isChecked());
			if(major->text()==i18n("auto"))
				axis[item]->setMajorTics(-1);
			else
				axis[item]->setMajorTics(major->text().toInt());
			axis[item]->setMinorTics(minor->text().toInt());

			axis[0]->setScale((TScale)ascb->currentItem());
			if (type != PPOLAR) {
				if (item == 0) {
					axis[3]->setMajorGridColor(axis[0]->majorGridColor());
					axis[3]->setMinorGridColor(axis[0]->minorGridColor());
				}
				else {
					axis[0]->setMajorGridColor(axis[3]->majorGridColor());
					axis[0]->setMinorGridColor(axis[3]->minorGridColor());
				}
				axis[3]->setScale((TScale)ascb->currentItem());
			}
		}
		else if (item == 1 || item == 2){
			plot->setYRange(rmin, rmax);
			axis[item]->enableMajorTics(cb2->isChecked());
			axis[item]->enableMinorTics(cb3->isChecked());
			if(major->text()==i18n("auto"))
				axis[item]->setMajorTics(-1);
			else
				axis[item]->setMajorTics(major->text().toInt());
			axis[item]->setMinorTics(minor->text().toInt());

			axis[1]->setScale((TScale)ascb->currentItem());

			if (type != PPOLAR) {
				if (item == 1) {
					axis[2]->setMajorGridColor(axis[1]->majorGridColor());
					axis[2]->setMinorGridColor(axis[1]->minorGridColor());
				}
				else {
					axis[1]->setMajorGridColor(axis[2]->majorGridColor());
					axis[1]->setMinorGridColor(axis[2]->minorGridColor());
				}
				axis[2]->setScale((TScale)ascb->currentItem());
			}
		}
		plot->enableGrid(2*item,cb4->isChecked());
		plot->enableGrid(2*item+1,cb5->isChecked());
	}
	else if (type == P3D || type == PQWT3D) {
		kdDebug()<<"	P3D or PQWT3D"<<endl;
		plot->enableGrid(2*item,cb4->isChecked());
		plot->enableGrid(2*item+1,cb5->isChecked());

		if (item == 0 || item == 3 || item == 6 || item == 9) {
			kdDebug()<<"	X"<<endl;
			plot->setXRange(rmin,rmax);

			axis[0]->setScale((TScale)ascb->currentItem());
			
			axis[item]->enableMajorTics(cb2->isChecked());
			axis[item]->enableMinorTics(cb3->isChecked());
			if(major->text()==i18n("auto"))
				axis[item]->setMajorTics(-1);
			else
				axis[item]->setMajorTics(major->text().toInt());
			axis[item]->setMinorTics(minor->text().toInt());
		}
		else if (item == 1 || item == 4 || item == 7 || item == 10) {
			kdDebug()<<"	Y"<<endl;
			plot->setYRange(rmin,rmax);

			axis[1]->setScale((TScale)ascb->currentItem());
			
			axis[item]->enableMajorTics(cb2->isChecked());
			axis[item]->enableMinorTics(cb3->isChecked());
			if(major->text()==i18n("auto"))
				axis[item]->setMajorTics(-1);
			else
				axis[item]->setMajorTics(major->text().toInt());
			axis[item]->setMinorTics(minor->text().toInt());
		}
		else if (item == 2 || item == 5 || item == 8 || item == 11) {
			kdDebug()<<"	Z"<<endl;
			plot->setZRange(rmin,rmax);

			axis[2]->setScale((TScale)ascb->currentItem());

			axis[item]->enableMajorTics(cb2->isChecked());
			axis[item]->enableMinorTics(cb3->isChecked());
			if(major->text()==i18n("auto"))
				axis[item]->setMajorTics(-1);
			else
				axis[item]->setMajorTics(major->text().toInt());
			axis[item]->setMinorTics(minor->text().toInt());
		}
	}

	plot->enableBorder(item,cb6->isChecked());
	p->updatePixmap();
}

