//LabPlot : AxesDialog.h

#ifndef AXESDIALOG_H
#define AXESDIALOG_H

#include <qfont.h>
#include <qcheckbox.h>
#include <qtoolbutton.h>
#include <klistbox.h>
#include "MainWin.h"
#include "Dialog.h"
#include "RichTextWidget.h"

class AxesDialog: public Dialog
{
	Q_OBJECT
public:
	AxesDialog(MainWin *mw, const char *name, int axesnr);
public slots:
	void selectTicsFont();
	void updateAxis();
	void update_timeformat();
	void updateScale(int i);
	void axisEnabled(bool on);
	void ok_clicked() { apply_clicked(); accept(); }
	void apply_clicked();
private:
	Plot *plot;
	Axis *axis[12];
	int type;
	RichTextWidget *rtw;
	KLineEdit *scaling, *shift, *ticsfont, *min, *max, *major, *minor, *tlple, *tlgle;
	KLineEdit *tlprefix, *tlsuffix, *timeformat, *tlrotation;
	KListBox *axeslb;
	QCheckBox *cb, *cb2, *cb3, *cb4, *cb5, *cb6;
	KLineEdit *majorticswidthle, *minorticswidthle, *borderwidthle, *majorgridwidthle, *minorgridwidthle;
	KLineEdit *majorticslengthle, *minorticslengthle;
	KColorButton *tcb, *tlcb, *gcb, *bcb;
	KComboBox *atlfcb, *ascb, *ticsposcb;
	QFont tf;
	KComboBox *majorgridstylecb, *minorgridstylecb;
	KColorButton *majorgridcolorcb, *minorgridcolorcb;
};
#endif //AXESDIALOG_H
