//LabPlot : DataDialog.h

#ifndef DATADIALOG_H
#define DATADIALOG_H

#include <qtoolbutton.h>
#include <qcheckbox.h>
#include "Dialog.h"
#include "GraphListDialog.h"
#include "FilterNETCDF.h"
#include "FilterCDF.h"
#include "FilterAUDIOFILE.h"

/*! Main class for Data Dialog*/
class DataDialog: public Dialog
{
	Q_OBJECT
public:
	DataDialog(MainWin *mw, const char *name,class ListDialog *l,int item,PType newtype);
public slots:
	void applyStyle();
	void setLabel(){ labelle->setText(filele->text()); }
	void setX(int i) { readxle->setText(QString::number(i)); }
	void setY(int i) { readyle->setText(QString::number(i)); }
	void setZ(int i) { readzle->setText(QString::number(i)); }
	void setT(int i) { readtle->setText(QString::number(i)); }
	void setInterpretX(int i) { interpretxcb->setCurrentItem(i); }
	void setInterpretY(int i) { interpretycb->setCurrentItem(i); }
	void setInterpretZ(int i) { interpretzcb->setCurrentItem(i); }
	void setInterpretT(int i) { interprettcb->setCurrentItem(i); }
	int Apply() { return apply_clicked(); }
private slots :
	void checkData();
	void updateRead();
	int addData();
	int addDataIMAGEXY(QImage image, QString filename);
	int addDataIMAGEXYZ(QImage image, QString filename);
	int addDataIMAGEMATRIX(QImage image, QString filename);
	int addDataIMAGEIMAGE(QImage image, QPixmap pm, QString filename);
	int addDataXY(QIODevice *file, QTextStream *t, QDataStream *d, QString filename,int startRow,int endRow);
	int addDataXYZ(QIODevice *file, QTextStream *t, QDataStream *d, QString filename,int startRow,int endRow);
	int addDataXYZT(QIODevice *file, QTextStream *t, QDataStream *d, QString filename,int startRow,int endRow);
	int addDataMATRIX(QIODevice *file, QTextStream *t, QDataStream *d, QString filename,int startRow,int endRow);
	int apply_clicked();
	void ok_clicked() { if (!apply_clicked()) accept(); }
private:
	void findPlot();
	double getValue(FilterAUDIOFILE auf,int var, int i,double *data, int startRow);
	PType type;
	QLabel *readx, *ready, *readz, *readt;
	KLineEdit *readxle, *readyle, *readzle, *readtle;
	KLineEdit *labelle;
	KComboBox *interpretxcb, *interpretycb, *interpretzcb, *interprettcb;
	KComboBox *cbi;	// Graph Type, Input
	QCheckBox *reread;
	ListDialog *l;
	int item;
	Graph *graph;
};
#endif //DATADIALOG_H
