//LabPlot : FilterKexiDB.cc

#include <klocale.h>
#include <kdebug.h>

#ifdef HAVE_KEXIDB
#include <kexidb/cursor.h>
#include <kexidb/field.h>
#include <kexidb/tableschema.h>
#include <kexidb/queryschema.h>
#include <kexidb/indexschema.h>
#include <kexidb/parser.h>
#endif

#include "FilterKexiDB.h"

FilterKexiDB::FilterKexiDB(QString driver)
	: driver(driver)
{
#ifdef HAVE_KEXIDB
	kexidriver=0;
	conn=0;
	schema=0;
	cursor=0;
#endif
}

QStringList FilterKexiDB::Driver() {
#ifdef HAVE_KEXIDB
	QStringList names = manager.driverNames();
	
	if (manager.error() || names.isEmpty()) {
		kdDebug()<<"FilterKexiDB :  Driver error"<<endl;
		manager.debugError();
	}
	
	return names;
#endif
	return 0;
}

QStringList FilterKexiDB::Databases() {
#ifdef HAVE_KEXIDB
	kdDebug()<<"FilterKexiDB::DataBases()"<<endl;
	QStringList l;
	
	if(conn) {
		if(!conn->isConnected()) {
			kdDebug()<<"NOT CONNECTED!"<<endl;
			return 0;
		}
		kdDebug()<<"connection OK. calling databaseNames()."<<endl;
		// CRASH !
		l=conn->databaseNames();
		kdDebug()<<"OK."<<endl;
	}
	else {
		kdDebug()<<" NO connection"<<endl;
		return 0;
	}
		
	if (l.isEmpty()) {
		kdDebug()<<"no databases found!"<<endl;
		kdDebug()<<conn->errorMsg()<<endl;
	}
	kdDebug()<<"DATABASES :"<<endl;
	for (QStringList::ConstIterator it = l.constBegin(); it != l.constEnd() ; ++it)
		kdDebug() <<"	"<< *it << endl;
	kdDebug()<<"***************************"<<endl;
	
	return l;
#endif
	return 0;
}

QStringList FilterKexiDB::Tables() {
#ifdef HAVE_KEXIDB
	QStringList l = conn->tableNames();
	if (l.isEmpty()) kdDebug()<<conn->errorMsg()<<endl;
	kdDebug()<<"TABLES :"<<endl;
	for (QStringList::ConstIterator it = l.constBegin(); it != l.constEnd() ; ++it)
		kdDebug() <<"	"<< *it << endl;
	kdDebug()<<"***************************"<<endl;
	return l;
#endif
	return 0;
}

int FilterKexiDB::connectDriver(QString d) {
	kdDebug()<<"FilterKexiDB::connectDriver("<<d<<")"<<endl;
#ifdef HAVE_KEXIDB
	driver = d;

	kexidriver = manager.driver(d);
	if (!kexidriver || manager.error()) {
		kdDebug()<<"FilterKexiDB :  Connection error"<<endl;
		manager.debugError();
		return 1;
	}
	kdDebug() << "MIME type for '" << kexidriver->name() << "': " << kexidriver->fileDBDriverMimeType() << endl;
	
#endif
	return 0;
}

int FilterKexiDB::connect(QString host, QString user, QString password) {
	kdDebug()<<"FilterKexiDB::connect() : "<<host<<' '<<user<<' '<<password<<endl;
#ifdef HAVE_KEXIDB
	conn_data.hostName=host;
	conn_data.userName=user;
	conn_data.password=password;

	kdDebug()<<"calling createConnection(conn_data)"<<endl;
	conn = kexidriver->createConnection(conn_data);
	kdDebug()<<"called createConnection(conn_data)"<<endl;
	if(!conn) {
		kdDebug()<<"connection == 0"<<endl;
		return 1;
	}
	if(conn->error()) {
		kdDebug()<<"conn error"<<endl;
		return 2;
	}
	if (kexidriver->error()) {
		kdDebug()<<"DRIVER ERROR"<<endl;
		kdDebug() << kexidriver->errorMsg() << endl;
		return 3;
	}
	if (!conn->connect()) {
		kdDebug()<<"CONNECTION ERROR"<<endl;
		kdDebug() << conn->errorMsg() << endl;
		return 4;
	}

	kdDebug()<<" connect() OK : returning 0"<<endl;

#endif
	return 0;
}

int FilterKexiDB::connectDatabase(QString d) {
	kdDebug()<<"FilterKexiDB::connectDatabase() : "<<d<<endl;
#ifdef HAVE_KEXIDB
	if (!conn->useDatabase(d)) {
		kdDebug()<<"	Creating new DATABASE"<<endl;
		conn->createDatabase(d);
		if (!conn->useDatabase(d)) {
			kdDebug()<<"Database creation error"<<endl;
			kdDebug() <<"new db:"<< conn->errorMsg() << endl;
			return 1;
		}
	}
#endif
	return 0;
}

int FilterKexiDB::Fields() {
#ifdef HAVE_KEXIDB
	return cursor->fieldCount();
#endif
	return 0;
}

int FilterKexiDB::Rows() {
#ifdef HAVE_KEXIDB
	int i=0;

	if (cursor) {
		cursor->open();
		while (cursor->moveNext())
			i++;
		return i;
	}

#endif
	return 0;
}

int FilterKexiDB::initialize(QString table) {
	kdDebug()<<"FilterKexiDB::initialize() : "<<table<<endl;
#ifdef HAVE_KEXIDB
	schema = conn->tableSchema(table );
	if (!schema) {
		conn->debugError();
		kdDebug() << "!schema" <<endl;
		return 1;
	}

	cursor = conn->prepareQuery( *schema );
	if (!cursor) {
		conn->debugError();
		kdDebug() << "!cursor" <<endl;
		return 1;
	}
	
#endif
	return 0;
}

int FilterKexiDB::initWrite() {
#ifdef HAVE_KEXIDB
	conn->setAutoCommit(false);
	KexiDB::Transaction t = conn->beginTransaction();	
#endif
	return 0;
}

int FilterKexiDB::createTable( QString tablename, QStringList fieldlist ) {
#if KDE_VERSION > 0x030104
	kdDebug()<<"FilterKexiDB::createTable() : "<<tablename<<' '<<fieldlist<<endl;
#else
	kdDebug()<<"FilterKexiDB::createTable() : "<<tablename<<endl;
#endif
#ifdef HAVE_KEXIDB
	KexiDB::Field *f;
	schema = new KexiDB::TableSchema(tablename);
	schema->setCaption("LabPlot");

	// add fields
	for ( QStringList::Iterator it = fieldlist.begin(); it != fieldlist.end(); ++it ) {
		schema->addField( f=new KexiDB::Field(*it, KexiDB::Field::Double) );
		f->setCaption(*it);
	}

	if (!conn->createTable( schema )) {
		kdDebug() << " CREATE TABLE ERROR" << endl;
		conn->debugError();
		return 1;
	}
	kdDebug() << "-- Table "<<tablename<<"created --" << endl;
	schema->debug();

#endif
	return 0;
}

int FilterKexiDB::writeData(QString *data, int cols, int rows) {
	kdDebug()<<"FilterKexiDB::writeData() : "<<&data<<' '<<cols<<' '<<rows<<endl;
#ifdef HAVE_KEXIDB
	for(int i=0;i<rows;i++) {
		QValueList<QVariant> list;
		for(int j=0;j<cols;j++)
			list.append(QVariant(data[cols*i+j]));
		conn->insertRecord(*schema, list);
	}
	kdDebug() << "-- Table data created --" << endl;
#endif
	return 0;
}

QString *FilterKexiDB::Data() {
#ifdef HAVE_KEXIDB
	QString *data = new QString[Fields()*Rows()];

	int i=0;
	if (cursor) {
		cursor->open();
		while (cursor->moveNext()) {
			for (int j=0;j<Fields();j++) {
				QString value = cursor->value(j).asString();
				data[Fields()*i+j]=value;
			}
			i++;
		}
//		kdDebug()<<"Cursor error:"<<cursor->errorMsg()<<endl;
	}

	return data;
#endif
	return 0;
}

QString FilterKexiDB::fieldName(int col) {
	kdDebug()<<"FilterKexiDB::fieldName() : "<<col<<endl;
#ifdef HAVE_KEXIDB
	// TODO : type of field ?
	KexiDB::Field::ListIterator iter = schema->fieldsIterator();
	iter +=col;
/*
	for (;iter.current();++iter) {
		kdDebug() << "FIELD = " << iter.current()->name()<<endl;
		kdDebug()<<" type = "<< iter.current()->typeName(iter.current()->type())<< endl;
	}
*/
//	kdDebug()<<"fieldName("<<col<<")="<<iter.current()->name()<<endl;
	
	return iter.current()->name();
#endif
	return 0;
}
