//LabPlot : Graph.cc

#include <iostream>
#include <kdebug.h>
#include "Graph.h"

Graph::Graph(QString n, QString l, LSource src, PType t, Style *st, Symbol *sy, int nr,bool s)
{
	name = n;
	label = l;
	source = src;
	type = t;
	style = st;
	if(style == 0)
		style = new Style();
	symbol = sy;
	if(symbol == 0)
		symbol = new Symbol();
	number = nr;
	shown = s;
	readas = 0;
	fitfunction = QString("a*x+b");
}

void Graph::saveGraph(QTextStream *t) {
	*t<<name<<endl;
	*t<<label<<endl;
	*t<<shown<<endl;
	*t<<(int)source<<endl;
	*t<<readas<<endl;
	av.save(t);
	*t<<fitfunction<<endl;
}

// open Graph specfic things
void Graph::openGraph(QTextStream *t,int version) {
	if (version > 2) {
		t->readLine();
		name = t->readLine();
		label = t->readLine();
		if(version>14) {
			int tmp;
			*t>>tmp;
			shown = (bool) tmp;
			if(version>17) {
				*t>>tmp;
				source = (LSource) tmp;
				if(version>18)
					*t>>readas;
			}
			av.open(t, version);
			if(version>18) {
				t->readLine();
				fitfunction = t->readLine();
				//kdDebug()<<"FIT FUNCTION : "<<fitfunction<<endl;
			}
		}
	}
}
