//LabPlot : Graph2D.cc

#include <iostream>
#include <qstringlist.h>
#include <kdebug.h>
#include "Graph2D.h"

using namespace std;

Graph2D::Graph2D(QString n, QString l,LRange r[2], LSource src, PType t, Style *st,
		Symbol *sy, Point *p, int nr,bool b)
	: Graph(n,l,src,t,st,sy,nr,b)
{
	range = new LRange[2];
	if (r) {
		for (int i=0;i<2;i++) {
			range[i].setMin(r[i].rMin());
			range[i].setMax(r[i].rMax());
		}
	}

	ptr = new Point[nr];
	for(int i=0;i<nr;i++)
		ptr[i] = p[i];
}

QStringList Graph2D::Info() 
{
	QStringList s;
	QString t;
	if(type==P2D)
		t=i18n("2D");
	else if (type==PSURFACE)
		t=i18n("Surface");
	else if (type==P3D)
		t=i18n("3D");
	else if (type==PGRASS)
		t=i18n("GRASS");
	else if (type==PPIE)
		t=i18n("Pie");
	else if (type==PPOLAR)
		t=i18n("Polar");

	QString sh=i18n("NO");
	if (shown)
		sh=i18n("YES");
	
	s << name << t << sh;
	s << QString::number(number);
	s << QString(" 1 ");		// only 1 column
	s << QString::number(range[0].rMin()) + " .. " + QString::number(range[0].rMax());
	s << QString::number(range[1].rMin())+ " .. " + QString::number(range[1].rMax());
/*	s << QString::number(style.Type()) << (style.Color()).name();
	s << QString::number(style.isFilled()) << (style.FillColor()).name();
	s << QString::number(symbol.getType()) << (symbol.getColor()).name();
	s << QString::number(symbol.getSize());
	s << QString::number(symbol.getFill()) << (symbol.getFillColor()).name() ;
*/
	return s;
}

void Graph2D::save(QTextStream *t, QProgressDialog *progress) {
	saveGraph(t);
	*t<<number<<endl;
       	*t<<range[0].rMin()<<' '<<range[0].rMax()<<' '<<range[1].rMin()<<' '<<range[1].rMax()<<endl;
	*t<<type<<' ';
	style->save(t);
	symbol->save(t);

	//dump data
	progress->setTotalSteps(number);
	for (int i=0;i< number;i++) {
		if(i%1000 == 0) progress->setProgress(i);
		*t<<ptr[i].X()<<' '<<ptr[i].Y()<<' '<<ptr[i].Masked()<<endl;
	}
	progress->cancel();
}

void Graph2D::open(QTextStream *t, int version, QProgressDialog *progress) {
	openGraph(t,version);
	
	if (version > 2)
		*t>>number;
	else if (version > 1 )
		*t>>name>>label>>number;
	else	// version == 0
		*t>>name>>number;

	double xmin, xmax, ymin, ymax;
	*t>>xmin>>xmax>>ymin>>ymax;
	range[0].setMin(xmin);
	range[0].setMax(xmax);
	range[1].setMin(ymin);
	range[1].setMax(ymax);

	// this belongs to openGraph() but the ranges are in between :-( 
	type = (PType) (style->open(t,version));
	symbol->open(t,version);

	// read data
	double x, y;
	int m;
	ptr = new Point[number];
	
	progress->setTotalSteps(number);
	for (int i=0;i< number;i++) {
		if(i%1000 == 0) progress->setProgress(i);

		if (version>18) {
			*t>>x>>y>>m;
			ptr[i].setMasked(m);
		}
		else
			*t>>x>>y;

		ptr[i].setPoint(x,y);
		//kdebug()<<x<<' '<<y<<endl;
	}
	progress->cancel();
}
