//LabPlot : Graph3D.h

#ifndef GRAPH3D_H
#define GRAPH3D_H

#include <qtextstream.h>
#include <qprogressdialog.h>
#include "Graph.h"
#include "LRange.h"
#include "Point3D.h"

class Graph3D: public Graph
{
public:
	Graph3D(QString n=QString(""), QString l=QString(""), LRange r[3]=0, LSource src=SFUNCTION, PType t=P3D, 
		Style *st=0, Symbol *sy=0, Point3D *p=0, int nrx=0, int nry=0, bool s=true);
	Point3D *Data() { return ptr; }
	LRange Range(int i) { return range[i]; }
	void setRange(LRange *r) { range[0]=r[0];range[1]=r[1];range[2]=r[2]; }
	int NX() { return numberx; }
	int NY() { return numbery; }
	void setNumber(int n) { number = n; }
	void setNumberX(int n) { numberx = n; }
	void setNumberY(int n) { numbery = n; }
	void save(QTextStream *t, QProgressDialog *progress);
	void open(QTextStream *t,int version, QProgressDialog *progress);
	QStringList Info();
	LRange ErrorDYRange();
private:
	int numberx, numbery;
	Point3D *ptr;
	LRange *range;
};

#endif // GRAPH3D_H
