//LabPlot : ImageListDialog.h

#ifndef IMAGELISTDIALOG_H
#define IMAGELISTDIALOG_H

#include "ListDialog.h"

#ifdef HAVE_MAGICK
#include <list>
#include "Magick++.h"
using namespace Magick;
#endif


class ImageListDialog : public ListDialog
{
	Q_OBJECT
public:
	ImageListDialog(MainWin *mw, const char *name);
public slots:
	void setType(int t) { typecb->setCurrentItem(t); }		//!< set type of manipulation
	void setNoise(int n) {noisecb->setCurrentItem(n); }	//!< set noise type
	void setX(double v) { xle->setText(QString::number(v)); }	//!< set value of parameter 1
	void setY(double v) { yle->setText(QString::number(v)); }	//!< set value of parameter 2
	void setZ(double v) { zle->setText(QString::number(v)); }	//!< set value of parameter 3
private:
#ifdef HAVE_MAGICK
	Color getColor(QColor c);
#endif
	KComboBox *typecb, *noisecb;
	QLabel *xlabel, *ylabel, *zlabel;
	KLineEdit *xle, *yle, *zle;
	KColorButton *kcb;
private slots:
	void updateOptions(int item);
	int apply_clicked();
};

#endif // IMAGELISTDIALOG_H
