//LabPlot : ImportDialog.cc

#include <stdlib.h>
#include <stdio.h>
#include <math.h>
#include <iostream>
#include <qlabel.h>
#include <qhbox.h>
#include <qfiledialog.h>
#include <qprogressdialog.h>
#include <qwizard.h>

#include <klocale.h>
#include <kdebug.h>
#include <kfilterdev.h>
#include <kmessagebox.h>
#include "ImportDialog.h"
#include "FilterCDF.h"
#include "FilterNETCDF.h"
#include "FilterAUDIOFILE.h"
#include "FilterMAGICK.h"
#include "defs.h"
#include "import.h"
#include "inputfilter.h"

using namespace std;

/* Dialog for importing data into spreadsheet */
ImportDialog::ImportDialog(MainWin *mw, QString filename, InputFilter filter, const char *name)
	: Dialog(mw, name)
{
	kdDebug()<<"ImportDialog::ImportDialog()"<<endl;
	setCaption(i18n("Import Data"));

	QVBox *vb = new QVBox(vbox);
	if(filename.length()<1)
		filename = mw->last_filename;
	importWidget(vb, filename,filter);

	QObject::connect(ok,SIGNAL(clicked()),SLOT(Apply()));
	QObject::connect(apply,SIGNAL(clicked()),SLOT(apply_clicked()));
	QObject::connect(cancel,SIGNAL(clicked()),SLOT(accept()));

	// gbox > vbox here !
	setMinimumWidth((int)(1.5*vbox->minimumSizeHint().width()));
	setMinimumHeight(gbox->minimumSizeHint().height()+vbox->minimumSizeHint().height());
	resize(minimumSize());
}

void ImportDialog::wizardKexiDB(const QString &name) {
	kdDebug()<<"ImportDialog::wizardKexiDB()"<<endl;

	int res;
	if(name == i18n("Driver")) {	
		kdDebug()<<"	TAB Driver"<<endl;
	}
	else if(name == i18n("Connection")) {
		kdDebug()<<"	TAB Connection : connecting to "<<driver->currentText()<<endl;
		connectionlabel->setText(i18n("Connecting to Driver ")+driver->currentText()+i18n(" ... "));
		res = kexi->connectDriver(driver->currentText());
		if (res) {
			KMessageBox::error(this, i18n("Sorry. Could not connect to driver!"));
			return;
		}
	}
	else if(name == i18n("Database")) {
		kdDebug()<<"	TAB Database"<<endl;
		res = kexi->connect(host->text(),user->text(),password->text());
		if (res) {
			KMessageBox::error(this, i18n("Sorry. Could not connect to database!"));
			return;
		}
		databases->clear();
		kdDebug()<<"	calling Databases()"<<endl;
		if((kexi->Databases()).empty()) {
			KMessageBox::error(this, i18n("Sorry. No databases found!"));
			return;
		}
		databases->insertStringList(kexi->Databases());
	}
	else if(name == i18n("Table")) {
		kdDebug()<<"	TAB Database"<<endl;
		tablelabel->setText(i18n("Using Database ")+databases->currentText()+i18n(" ... "));
		res = kexi->connectDatabase(databases->currentText());
		if (res) {
			KMessageBox::error(this, i18n("Sorry. Could not connect to database!"));
			return;
		}
		tables->clear();
		tables->insertStringList(kexi->Tables());
	}
}

void ImportDialog::finishKexiDB() {
	QString tablename = tables->currentText();
	
	QTable *table = mw->activeSpreadsheet()->Table();
	
	int res = kexi->initialize(tablename);
	if(res) {
		KMessageBox::error(this, i18n("Sorry. Could not read table from database!"));
		return;
	}

	int cols = kexi->Fields(), rows = kexi->Rows();
	table->setNumCols(cols);
	table->setNumRows(rows);

	QString *data = kexi->Data();
	for (int i=0;i<rows;i++) {
		for (int j=0;j<cols;j++) {
			table->setText(i,j,data[cols*i+j]);
		}
	}
	
	//set column names
	for (int i=0;i<table->numCols();i++) {
		QString fieldname = kexi->fieldName(i);
		if(i==0)
			table->horizontalHeader()->setLabel( i, fieldname+' '+i18n("{double}")+" [X]");
		else
			table->horizontalHeader()->setLabel( i, fieldname+' '+i18n("{double}")+" [Y]");
	}
	table->setUpdatesEnabled(true);
	table->repaintContents();
}

int ImportDialog::apply_clicked() {
	mw->last_filename = filele->text();
	QStringList fns = QStringList::split(";",filele->text());
	 for ( QStringList::Iterator it = fns.begin(); it != fns.end(); ++it ) {
		QString filename = *it;
		kdDebug()<<"Opening "<<filename<<endl;

		Spreadsheet *s=0;
		if(it==fns.begin())
			s = mw->activeSpreadsheet();
	
		if(!s) {
//			kdDebug()<<"No active spreadsheet. Adding a new one."<<endl;
			s = mw->newSpreadsheet();
		}

		QTable *table = s->Table();
		table->setUpdatesEnabled(false);	// for fast processing
//		LTable *table = s->Table();

		// individual filters
		if(filtercb->currentItem() == FKEXIDB) {
#ifdef HAVE_KEXIDB
			kexi = new FilterKexiDB(0);

			QWizard *wizard = new QWizard(this);
			QObject::connect(wizard,SIGNAL(selected(const QString &)),this,SLOT(wizardKexiDB(const QString&))); 
			QObject::connect(wizard->finishButton(),SIGNAL(clicked()),this,SLOT(finishKexiDB())); 
			
			QVBox *page1 = new QVBox(wizard);
			new QLabel(i18n("Please select driver : "),page1);
			driver= new KComboBox(page1);
			driver->insertStringList(kexi->Driver());

			wizard->addPage(page1,i18n("Driver"));
			wizard->setHelpEnabled(page1,false);
			
			QVBox *page2 = new QVBox(wizard);
			
			connectionlabel = new QLabel("",page2);
			new QLabel(i18n("Please provide connection informations  : "),page2);
			QHBox *hb = new QHBox(page2);
			new QLabel(i18n("Hostname : "),hb);
			host = new KLineEdit(i18n("localhost"),hb);
			hb = new QHBox(page2);
			new QLabel(i18n("User : "),hb);
			user = new KLineEdit(i18n("root"),hb);
			hb = new QHBox(page2);
			new QLabel(i18n("Password : "),hb);
			password = new KLineEdit(i18n("mysql"),hb);
			password->setEchoMode(QLineEdit::Password);
			
			wizard->addPage(page2,i18n("Connection"));
			wizard->setHelpEnabled(page2,false);
			
			QVBox *page3 = new QVBox(wizard);
			new QLabel(i18n("Please select database  : "),page3);
			databases = new KComboBox(page3);
			wizard->addPage(page3,i18n("Database"));
			wizard->setHelpEnabled(page3,false);
			
			QVBox *page4 = new QVBox(wizard);
			tablelabel = new QLabel("",page4);
			new QLabel(i18n("Please select table : "),page4);
			tables = new KComboBox(page4);
			wizard->addPage(page4,i18n("Table"));
			wizard->setHelpEnabled(page4,false);
			wizard->setFinishEnabled(page4,true);

			wizard->show();
#endif
			return 0;
		}
		
		if (!filename.isEmpty()) {
			QIODevice *file = KFilterDev::deviceForFile(filename,QString::null,true);
			if(file==0) file = new QFile(filename);
	
			// HP41XX filter
			if(filtercb->currentItem() == FHP41XX) {
				if ( ! file->open( IO_ReadOnly )) {
					KMessageBox::error(this, i18n("Sorry. Could not open specified data file for reading!"));
					return 2;
				}
				QTextStream t(file);
				QString line=0;
				kdDebug()<<"Reading HP41XX file"<<filename<<endl;
				
				kdDebug()<<" Title : "<<t.readLine()<<endl;
				int sets=0, lines[255];
				do {
					QString tmp;
					double min,max,step;
					t>>tmp>>min>>tmp>>max>>tmp>>step;
					t.readLine();
					line = t.readLine();
					lines[sets] = (int) (rint((max-min)/step)+1);
					kdDebug()<<"RANGE : "<<min<<'/'<<max<<" in steps : "<<step<<"	-> nr="<<lines[sets]<<endl;
					sets++;
				} while (line.contains(" Append "));
				kdDebug()<<"found "<<sets<<" sets"<<endl;
				
				double x,y,z;
				int linenr;
				for(int i=0;i<sets;i++) {
					if(i>0) {
						t.readLine();	// /* Append X */
						line = t.readLine();	// No. VF IF L
						s = mw->newSpreadsheet();
						table = s->Table();
					}
					table->setNumRows(lines[i]);
					table->setNumCols(3);
					// column names
					QStringList names = QStringList::split(' ', line);
					s->setColumnTitle(0,names[1]);
					s->setColumnTitle(1,names[2]);
					table->horizontalHeader()->setLabel( 2, names[3]+' '+i18n("{double}")+" [Y]");
					
					line=t.readLine();
					kdDebug()<<" Set "<<i+1<<" : "<<line<<endl;
					int j=0;
					while(line.length()>0) {
						if(j<lines[i]) {
							t>>linenr>>x>>y>>z;
							t.readLine();		// until new line
							//kdDebug()<<" DATA  : "<<linenr<<" / "<<x<<' '<<y<<' '<<z<<endl;
							table->setText(j,0,QString::number(x));
							table->setText(j,1,QString::number(y));
							table->setText(j,2,QString::number(z));
							j++;
						}
						else
							line=t.readLine();	// empty line
					}
					
					table->setUpdatesEnabled(true);
					table->repaintContents();	// resizing remains
				}
				return 0;
			}
			
			FilterMAGICK mf = FilterMAGICK(filename);
			
			// reading image (dont handle binary data with ImageMagick)
			QString format;
	#ifdef HAVE_MAGICK
			if ((filtercb->currentItem() != FBINARY) && 
				(((format = QString(QImageIO::imageFormat(filename))) != 0 ) || mf.fileOK())) {
	#else
			if ((filtercb->currentItem() != FBINARY) && (format = QString(QImageIO::imageFormat(filename))) != 0) {
	#endif
				QPixmap pm;
	#ifdef HAVE_MAGICK
				if(mf.fileOK())
					pm = mf.Pixmap();
				else
	#endif
					pm.load(filename);
				kdDebug()<<"reading IMAGE DATA format = "<<format<<endl;
				
				QImage image = pm.convertToImage();
				int width = image.width();
				int height = image.height();
				kdDebug() <<" Width/Height : "<<width<<' '<<height<<endl;
				kdDebug() <<" Depth : "<<image.depth()<<endl;
				
				table->setNumCols(width);
				table->setNumRows(height);
				
				for (int i=0;i<width;i++) {
					for (int j=0;j<height;j++) {
						table->setText(j,i,QString::number(qGray(image.pixel(i,j))));
					}
				}
				table->horizontalHeader()->setLabel( 0, QString( "A ")+i18n("{double}")+" [Y]");
			}
			else if ( file->open( IO_ReadOnly )) {		// reading normal data (not image)
				int startRow = startle->text().toInt()-1;
				int endRow;
				if(endle->text() == i18n("END"))
					endRow = INF;
				else
					endRow = endle->text().toInt()-1;
				kdDebug()<<"END = "<<endRow<<endl;

				QDataStream d(file);
				QTextStream t(file);
				
				FilterAUDIOFILE auf = FilterAUDIOFILE(filename);
				FilterNETCDF ncf = FilterNETCDF(filename);
				FilterCDF cdf = FilterCDF(filename);
	
				if (auf.fileOK()) {		// audiofile file
					kdDebug()<<"reading Audio DATA"<<endl;
					double *data = auf.Data();
					table->setNumRows(auf.frameCount());
					table->setNumCols(auf.channelCount()+1);
					
					QProgressDialog progress( i18n("Reading data ..."), i18n("Cancel"), auf.frameCount(), this, "progress", true );
					for (int i=startRow;i<auf.frameCount();i++) {
						if(i%1000 == 0) progress.setProgress(i);
						qApp->processEvents();
						table->setText(i,0,QString::number(i/auf.sampleRate()));
						if(auf.channelCount() == 1) 
							table->setText(i,1,QString::number(data[i]));
						else if (auf.channelCount() == 2) {
							table->setText(i,1,QString::number(data[2*i]));
							table->setText(i,2,QString::number(data[2*i+1]));
						}
						if (i>endRow)
							break;
					}
				}
				else if (ncf.fileOK()) {		// netcdf file
					table->setNumCols(ncf.NVars());
	
					//QProgressDialog progress( i18n("Reading data ..."), i18n("Cancel"), ncf.VarLen(xname), this, "progress", true );
					kdDebug()<<"Reading NETCDF data"<<endl;
					kdDebug()<<" nvars = "<<ncf.NVars()<<endl;
					for (int j=startRow;j<ncf.NVars();j++) {
						QString name = ncf.VarName(j);
						int rows = ncf.VarLen(name);
						kdDebug()<<" var / varid / len = "<<name<<' '<<j<<' '<<rows<<endl;
	
						// TODO : BUG : set column label to name
						s->setColumnTitle( j, name );
	
						if (table->numRows()<rows)
							table->setNumRows(rows);
						for (int i=0;i<rows;i++) {
							//if(i%1000 == 0) progress.setProgress(i);
							table->setText(i,j,QString::number(ncf.Data(name,i)));
						}
						if (j>endRow)
							break;
					}
				}
	#ifdef HAVE_CDF
				else if (cdf.fileOK()) {		// cdf file
					table->setNumCols(cdf.NVars());
					table->setNumRows(cdf.MaxRec());
					
					QProgressDialog progress( i18n("Reading data ..."), i18n("Cancel"), cdf.MaxRec(), this, 
						"progress", true );
					kdDebug()<<"Reading CDF data"<<endl;
					kdDebug()<<" nvars = "<<cdf.NVars()<<endl;
					for (int j=startRow;j<cdf.NVars();j++) {
						QString name = cdf.VarName(j);
						int rows = cdf.VarLen(name);
						kdDebug()<<" var / varid / len = "<<name<<' '<<j<<' '<<rows<<endl;
	
						// TODO : BUG : set column label to name
						s->setColumnTitle( j, name );
	
						for (int i=0;i<rows;i++) {
							if(i%1000 == 0) progress.setProgress(i);
							table->setText(i,j,QString::number(cdf.Data(name,i)));
						}
						if (j>endRow)
							break;
					}
				}
#endif	// HAVE_CDF
				else {
					QProgressDialog progress( i18n("Reading data ..."), i18n("Cancel"), file->size(),this, 
						"progress", true );
					int row=0;
					table->setNumCols(1);		// set initial number of cols
					
					int header = 0;
					if (headercb->isChecked())
						header = 1;
					
					if(filtercb->currentItem() == FBINARY) {
						kdDebug()<<"reading BINARY DATA"<<endl;

						// offset
						int nvars = varle->text().toInt();
						for (int j=0;j<nvars*startRow;j++) {
							getBinaryValue(&d,binarytypecb->currentItem());
						}
						row+=startRow;
						
						if(nvars > table->numCols())
							table->setNumCols(nvars);
						
						while(!d.eof()) {
							if (row%1000==0) {
								progress.setProgress(file->at() );
								table->setNumRows(row+1000);
							}
							qApp->processEvents();

							// read data
							for (int j=0;j<nvars;j++) {
								table->setText(row-startRow,j,
									QString::number(getBinaryValue(&d,binarytypecb->currentItem())));
							}

							row++;
							if ( progress.wasCancelled() ) {
								table->setUpdatesEnabled(true);
								return 1;
							}
							if (row>endRow)
								break;
						}
					} 
					else {	// ascii data
						kdDebug()<<"	reading ASCII DATA"<<endl;
						while (!t.eof()) {
						//	kdDebug()<<"	reading row "<<row<<endl;
							if (row%1000==0) {
						//		kdDebug()<<"	row%100==0"<<endl;
						//		kdDebug()<<"	setProgress"<<endl;
								progress.setProgress(file->at() );
						//		kdDebug()<<"	setNumRows to "<<row+100<<endl;
								table->setNumRows(row+1000);
						//		kdDebug()<<"	OK"<<endl;
							}
							qApp->processEvents();
	
							while(row<startRow) {
								t.readLine();
								row++;
							}

							// read a line
							QString line = t.readLine();
		
							if(simplifycb->isChecked())
								line = line.simplifyWhiteSpace();
							// ignore comment lines
							if(line.find(QRegExp(commcb->currentText()))==0)
								continue;
							
							QString sep = sccb->currentText();
							QStringList oneline = splitLine(line,sep,emptycb->isChecked());
							
							// handle empty lines correct
							if(oneline.count()==0)
								continue;
							
							if(oneline.count() > (unsigned int) table->numCols())
								table->setNumCols(oneline.count());

							int j=0;
							if(row==startRow && headercb->isChecked()) {
								for ( QStringList::Iterator it = oneline.begin();it != oneline.end(); ++it ) {
									if (j==0)
										table->horizontalHeader()->setLabel( j++, *it+' '+i18n("{double}")+" [X]");
									else
										table->horizontalHeader()->setLabel( j++, *it+' '+i18n("{double}")+" [Y]");
								}
							}
							else {
								for ( QStringList::Iterator it = oneline.begin();it != oneline.end(); ++it ) {
									table->setText(row-startRow-header,j,(*it));
									j++;
								}
							}
							
							row++;
							if ( progress.wasCancelled() ) {
								table->setUpdatesEnabled(true);
								table->setNumRows(row-startRow-header);
								// set label for all columns (see below)
								if(!headercb->isChecked()) {
									for (int i=1;i<table->numCols();i++) {
										if(i<26)
											table->horizontalHeader()->setLabel( i, 
												QChar(i+65)+' '+i18n("{double}")+" [Y]");
										else
											table->horizontalHeader()->setLabel( i, 
												QChar(84)+' '+i18n("{double}")+" [Y]");
									}
								}
								return 1;
							}
							if (row>endRow)
								break;
							//kdDebug()<<"	OK "<<row<<endl;
						}
					}

					table->setNumRows(row-startRow-header);
				}
			}
			else {
				KMessageBox::error(this, i18n("Sorry. Could not open specified data file for reading!"));
				return 2;
			}

			// set label for all columns
			if(!headercb->isChecked()) {
				for (int i=1;i<table->numCols();i++) {
					if(i<26)
						table->horizontalHeader()->setLabel( i, QChar(i+65)+' '+i18n("{double}")+" [Y]");
					else
						table->horizontalHeader()->setLabel( i, QChar(84)+' '+i18n("{double}")+" [Y]");
				}
			}
		}

		table->setUpdatesEnabled(true);
		table->repaintContents();	// resizing remains
	}

	return 0;
}
