//LabPlot : InterpolationListDialog.h

#ifndef INTERPOLATIONLISTDIALOG_H
#define INTERPOLATIONLISTDIALOG_H

#include "ListDialog.h"

class InterpolationListDialog : public ListDialog
{
	Q_OBJECT
public:
	InterpolationListDialog(MainWin *mw, const char *name);
public slots:
	void setType(int type) {typecb->setCurrentItem(type); }		//!< set type of interpolation
	void setRange(double a, double b) {						//!< set range for interpolation
		ale->setText(QString::number(a)); ble->setText(QString::number(b)); }
	void setNumber(int nr) { nrle->setText(QString::number(nr)); }	//!< set number of interpolating points
private:
	KComboBox *typecb;
	KLineEdit *nrle;
private slots:
	int apply_clicked();
};

#endif // INTERPOLATIONLISTDIALOG_H
