//LabPlot : LegendDialog.cc

#include <stdlib.h>
#include <stdio.h>
#include <iostream>
#include <math.h>
#include <qlabel.h>
#include <qhbox.h>
#include <qfontdialog.h>
#include <klocale.h>
#include "LegendDialog.h"

LegendDialog::LegendDialog(MainWin *mw, const char *name)
	: Dialog(mw, name)
{
	legend = p->getPlot(p->API())->getLegend();
	lf = legend->Font();

	setCaption(i18n("Legend Settings")+i18n(" : ")+QString(name));
	
	QHBox *hb = new QHBox(vbox);
	cb = new QCheckBox(i18n("Legend enabled "),hb);
	cb->setChecked(legend->enabled());
	cb2 = new QCheckBox(i18n("Border "),hb);
	cb2->setChecked(legend->borderEnabled());

	new QLabel(i18n("Position : "),vbox); 
	hb = new QHBox(vbox);
	new QLabel(i18n("x : "),hb);
        xle = new KLineEdit(QString::number(legend->X()),hb);
	xle->setValidator(new QDoubleValidator(0.0,1.0,3,xle));
        new QLabel(i18n(" y : "),hb);
	yle = new KLineEdit(QString::number(legend->Y()),hb);
	yle->setValidator(new QDoubleValidator(0.0,1.0,3,yle));
	
	new QLabel(i18n("Legend Font : "),vbox);
	hb = new QHBox(vbox);
	fontle = new KLineEdit(lf.family() + " " + 
		QString::number(lf.pointSize()),hb);
	KPushButton *newFont = new KPushButton(i18n("New"),hb);
	QObject::connect(newFont,SIGNAL(clicked()),SLOT(selectFont()));

	hb = new QHBox(vbox);
	new QLabel(i18n("Orientation :"),hb);
	orientcb = new KComboBox(hb);
	QStringList olist;
	olist << i18n("BottomTop");
	olist << i18n("LeftRight");
	orientcb->insertStringList(olist);
	orientcb->setCurrentItem(legend->getOrientation());

	QObject::connect(ok,SIGNAL(clicked()),SLOT(ok_clicked()));
	QObject::connect(apply,SIGNAL(clicked()),SLOT(apply_clicked()));
	
	// gbox>vbox here !
	setMinimumWidth(2*vbox->minimumSizeHint().width());
	setMinimumHeight(gbox->minimumSizeHint().height()+vbox->minimumSizeHint().height());
	resize(minimumSize());
}

void LegendDialog::selectFont() {
    bool ok;
    QFont f = QFontDialog::getFont( &ok, legend->Font(), this );
    if ( ok ) {
	lf = f;
	fontle->setText(f.family());
    }
}

void LegendDialog::apply_clicked() {
	legend->enable(cb->isChecked());
	legend->enableBorder(cb2->isChecked());
	legend->setFont(lf);
	legend->setPosition(xle->text().toDouble(),yle->text().toDouble());
	legend->setOrientation(orientcb->currentItem());
	QFont tmp(legend->Font());
	fontle->setText(tmp.family() + tr(" ") + QString::number(tmp.pointSize()));
	p->updatePixmap();
}
