//LabPlot : OverlayPlotDialog.cc

#include <stdlib.h>
#include <stdio.h>
#include <iostream>
#include <math.h>
#include <qlabel.h>
#include <qhbox.h>
#include <qfontdialog.h>
#include <klocale.h>
#include <kmessagebox.h>
#include "OverlayPlotDialog.h"

OverlayPlotDialog::OverlayPlotDialog(MainWin *mw, const char *name)
	: PlotDialog(mw, name)
{
	setCaption(i18n("Overlay Plots"));

	//TODO : i and j
	QHBox* hb = new QHBox(vbox);
	new QLabel(i18n("Overlay Plot "),hb);
	ale = new KLineEdit(QString("2"),hb);
	ale->setValidator(new QIntValidator(1,p->NrPlots(),ale));
	new QLabel(i18n(" onto Plot "),hb);
	ble = new KLineEdit(QString("1"),hb);
	ble->setValidator(new QIntValidator(1,p->NrPlots(),ble));

	QObject::connect(ok,SIGNAL(clicked()),SLOT(ok_clicked()));
	QObject::connect(apply,SIGNAL(clicked()),SLOT(apply_clicked()));

	setMinimumWidth(vbox->minimumSizeHint().width());
	setMinimumHeight(gbox->minimumSizeHint().height()+vbox->minimumSizeHint().height());
	resize(minimumSize());
}

void OverlayPlotDialog::apply_clicked() {
	int a = ale->text().toInt()-1;
	int b = ble->text().toInt()-1;
	Plot *plota = p->getPlot(a);
	Plot *plotb = p->getPlot(b);

	int nr = p->NrPlots();
	if(a<0 || b<0)
		KMessageBox::error(this, i18n("Sorry. Thats not possible!"));
	else if (a > nr || b > nr)
		KMessageBox::error(this, i18n("Sorry. This Plot doesnt exist!"));
	else {
		plota->setTransparent(true);
		plota->setPosition(plotb->Position());
		plota->setSize(plotb->Size());
		plota->setP1(plotb->P1());
		plota->setP2(plotb->P2());
	}
	
	p->updatePixmap();
}
