//LabPlot : Plot.h

#ifndef PLOT_H
#define PLOT_H

#include <math.h>
#include "Worksheet.h"
#include "Legend.h"
#include "Label.h"
#include "Axis.h"

class Legend;

class Plot {
public:
	Plot(class Worksheet *p);
	virtual ~Plot() {}
	GraphList *getGraphList() { return graphlist; }
	void clear() {graphlist->clear();}
	void save(QTextStream *t);
	virtual void saveAxes(QTextStream *t) = 0;
	void saveAxis(QTextStream *t,Axis *axis,int gridenabled, int borderenabled, int minorgridenabled);
	void open(QTextStream *t, int version);
	void openAxis(QTextStream *t,int version, Axis *axis,bool *gridenabled,bool *borderenabled, bool *minorgridenabled);
	virtual void openAxes(QTextStream *t, int version) = 0;

	QString TicLabel(int atlf, int prec, QString dtf, double value);
	double TicLabelValue(int atlf, QString string);
	
	virtual Axis *getAxis(int i) = 0;
	Legend* getLegend() { return &legend; }
	void setType(PType i) { type = i; }
	PType Type() { return type; }
	Label* Title() { return title; }
	virtual void setRange(LRange *,int i) = 0;
	LRange* Range(int i) { return &range[i];}
	virtual void setActRange(LRange *,int i) = 0;
	LRange* ActRange(int i) { return &actrange[i];}
	virtual void setRanges(LRange *) = 0;
	LRange* Ranges() { return range;}
	virtual void setActRanges(LRange *) = 0;
	LRange* ActRanges() { return actrange;}
	void setRegionMin(double min) {region->setMin(min);}
	void setRegionMax(double max) {region->setMax(max);}
	void setRegion(double min, double max) {region->setMin(min); region->setMax(max);}
	void setRegion(LRange *r) {region->setMin(r->rMin()); region->setMax(r->rMax());}
	double RegionMin() {return region->rMin();}
	double RegionMax() {return region->rMax();}
	LRange *Region() { return region; }
	bool regionEnabled() { return region_enabled; }
	void setRegionEnabled(bool e=true) { region_enabled = e; }
	void setTransparent(bool t) { transparent = t; }
	bool Transparent() { return transparent; }
	void setClipOffset(int c) { clipoffset=c;}
	int ClipOffset() { return clipoffset;}

	virtual void enableGrid(int index,bool b=true) = 0;
	virtual bool gridEnabled(int index) = 0;
	virtual void enableBorder(int index,bool b=true) = 0;
	virtual bool borderEnabled(int index) = 0;
	bool baselineEnabled() { return baseline_enabled; }
	void setBaselineEnabled(bool e=true) { baseline_enabled = e; }
	double Baseline() { return baseline; }
	void setBaseline(double b) { baseline = b; }
	double XBaseline() { return xbaseline; }
	void setXBaseline(double b) { xbaseline = b; }
	bool xbaselineEnabled() { return xbaseline_enabled; }
	void setXBaselineEnabled(bool e=true) { xbaseline_enabled = e; }

	bool marksEnabled() { return marks_enabled; }
	void setMarksEnabled(bool m=true) { marks_enabled=m; }
	LRange *markX() { return markx; }
	void setMarkX(LRange *l) { markx=l; }
	LRange *markY() { return marky; }
	void setMarkY(LRange *l) { marky=l; }

	virtual void draw(QPainter *p, int w, int h) = 0;
	void drawStyle(QPainter *p, Style *s, Symbol *symbol, QPointArray pa, int xmin, int xmax, int ymin, int ymax);
	void drawErrorBar(QPainter *p, QPointArray pa, QPointArray hpa, QPointArray vpa);
	virtual void setBorder(int,bool) = 0;
	bool inside(double x, double y) {
		if(x>position.X() && x<position.X()+size.X() && y>position.Y() && y<position.Y()+size.Y())
			return true;
		else
			return false;
	}
	bool insideLegend(int x,int y) { if (legend.inside(x,y)) return true; return false;}
	bool insidePlottingArea(double x,double y) {
		if (x>p1.X() && x<p2.X() && y>p1.Y() && y<p2.Y()) return true; return false;
	}
	bool insideF1Corner(double x, double y) {
		if(fabs(x-position.X()) < 0.01 && fabs(y-position.Y())<0.01)
			return true;
		return false;
	}
	bool insideF2Corner(double x, double y) {
		if(fabs(x-position.X()-size.X()) < 0.01 && fabs(y-position.Y()-size.Y())<0.01)
			return true;
		return false;
	}
	bool insideB1Corner(double x, double y) {
		if(fabs(x-position.X()) < 0.01 && fabs(y-position.Y()-size.Y())<0.01)
			return true;
		return false;
	}
	bool insideB2Corner(double x, double y) {
		if(fabs(x-position.X()-size.X()) < 0.01 && fabs(y-position.Y())<0.01)
			return true;
		return false;
	}
	bool insideX1Border(double x, double y) {
		if(x >position.X() && x<position.X()+size.X() && fabs(y-position.Y()-size.Y())<0.01)
			return true;
		return false;
	}
	bool insideX2Border(double x, double y) {
		if(x >position.X() && x<position.X()+size.X() && fabs(y-position.Y())<0.01)
			return true;
		return false;
	}
	bool insideY1Border(double x, double y) {
		if(y >position.Y() && y<position.Y()+size.Y() && fabs(x-position.X())<0.01)
			return true;
		return false;
	}
	bool insideY2Border(double x, double y) {
		if(y >position.Y() && y<position.Y()+size.Y() && fabs(x-position.X()-size.X())<0.01)
			return true;
		return false;
	}
	bool insideCenter(double x, double y) {
		if(fabs(x-position.X()-size.X()/2.0)<0.01 && fabs(y-position.Y()-size.Y()/2.0)<0.01)
			return true;
		return false;
	}
	void setPosition(Point p) { position = p; }
	void setPosition(double x, double y) { position = Point(x,y); }
	Point Position() { return position; }
	void setSize(Point s) { size = s; }
	void setSize(double x, double y) { size = Point(x,y); }
	Point Size() { return size; }
	QColor Background() { return bgcolor; }
	void setBackground(QColor c) { bgcolor = c; }
	void setBackground(QString c) { bgcolor = QColor(c); }
	QColor graphBackground() { return gbgcolor; }
	void setGraphBackground(QColor c) { gbgcolor = c;}
	void setGraphBackground(QString c) { gbgcolor = QColor(c);}
	void autoScaleX();
	void autoScaleY();
	void autoScaleZ();
	void setXRange(double x1, double x2) {actrange[0].setMin(x1); actrange[0].setMax(x2); }
	void setYRange(double y1, double y2) {actrange[1].setMin(y1); actrange[1].setMax(y2); }
	void setZRange(double z1, double z2) {actrange[2].setMin(z1); actrange[2].setMax(z2); }

	Point P1() { return p1;}
	Point P2() { return p2;}
	void setP1(Point p) { p1=p;}
	void setP2(Point p) { p2=p;}

	void setXMin(int xmin,int X) { p1.setPoint((xmin/(double)X-position.X())/size.X(),p1.Y()); }
	void setXMax(int xmax,int X) { p2.setPoint((xmax/(double)X-position.X())/size.X(),p2.Y()); }
	void setYMin(int ymin,int Y) { p1.setPoint(p1.X(),(ymin/(double)Y-position.Y())/size.Y()); }
	void setYMax(int ymax,int Y) { p2.setPoint(p2.X(),(ymax/(double)Y-position.Y())/size.Y()); }

	void shiftRight();
	void shiftLeft();
	void shiftUp();
	void shiftDown();
	void scaleXUp();
	void scaleXDown();
	void scaleYUp();
	void scaleYDown();
	void scaleZUp();
	void scaleZDown();
	void zoomIn();
	void zoomOut();

	Point dataValue(double x);
protected:
	int autoTics(double min, double max);	// calcuate tic number for auto tics
	Worksheet *worksheet;			// parent worksheet
	PType type;				// type of the plot
	GraphList *graphlist;			// list of graphs
	Point position, size;				// position and size (0..1)
	Label *title;					// Title
	Legend legend;				// Legend
	QColor bgcolor, gbgcolor;		// background & graph background color
	Point p1, p2;					// plotting area	(0..1)
	LRange range[3];				// graph ranges	(x,y,z)
	LRange actrange[3];			// actual plotting range (x,y,z)
	double baseline;				// baseline
	bool baseline_enabled;			// draw it ?
	double xbaseline;				// x baseline
	bool xbaseline_enabled;			// draw it ?
	LRange *region;				// region
	bool region_enabled;			// draw it ?
	bool transparent;				// draw bgcolor & gbgcolor ?
	int clipoffset;					// offset for clipping area drawing (Symbols->full drawn, line section->limited)
	bool marks_enabled;
	LRange *markx, *marky;			// marker
};

#ifndef HAVE_LOG2
inline double log2(double x) {return log(x)/log(2.0);}
#endif

#endif // PLOT_H
