// LabPlot : PlotPie.cc

#include <iostream>
#include <klocale.h>
#include <kdebug.h>
#include "PlotPie.h"

#include "colors.h"

using namespace std;

//! general pie Plot class
PlotPie::PlotPie(Worksheet *p)
	: Plot(p)
{
	title = new Label(i18n("Pie Plot"),p->getMainWin()->defaultFont(),QColor(Qt::black));
	title->setPosition(0.4,0.04);
}

QStringList PlotPie::Info() {
	QStringList s;
	s<<"Pie";
	s<<QString::number(position.X())+QString(" , ")+QString::number(position.Y());
	s<<QString::number(size.X())+QString(" X ")+QString::number(size.Y());
	if (transparent)
		s<<QString("yes");
	else
		s<<QString("no");
	s<<bgcolor.name();
	s<<gbgcolor.name();

	return s;
}

void PlotPie::draw(QPainter *p, int w, int h) {
	//int w = worksheet->width(), h = worksheet->height();

	kdDebug()<<"PlotPie::draw() w/h : "<<w<<' '<<h<<endl;
	int xmin = (int)(w*(size.X()*p1.X()+position.X()));
	int xmax = (int)(w*(size.X()*p2.X()+position.X()));
	int ymin = (int)(h*(size.Y()*p1.Y()+position.Y()));
	int ymax = (int)(h*(size.Y()*p2.Y()+position.Y()));

	// 3d perspective
	xmax -= (xmax-xmin)/3;
	ymin += (ymax-ymin)/3;

	kdDebug()<<"XMIN/MXAX/YMIN/YMAX = "<<xmin<<','<<xmax<<','<<ymin<<','<<ymax<<endl;
	kdDebug()<<"p1 = "<<p1.X()<<'/'<<p1.Y()<<" p2 = "<<p2.X()<<'/'<<p2.Y()<<endl;

	if (!transparent) {
		// background color
		p->setBrush(bgcolor);
		p->setPen(Qt::NoPen);
		p->drawRect((int)(w*position.X()),(int)(h*position.Y()),(int)(w*size.X()),(int)(h*size.Y()));

		// graph background color
		p->setBrush(gbgcolor);
		//TEST : p->setBrush(Qt::green);
		p->setPen(Qt::NoPen);
	}

	//draw circle ?

	kdDebug()<<"PlotPie : title->draw() pos:"<<position.X()<<' '<<position.Y()<<endl;
	kdDebug()<<" 			size:"<<size.X()<<' '<<size.Y()<<endl;
	title->draw(worksheet,p,position,size,w,h,0);

	drawCurves(p, w, h);

	if(legend.enabled())
		legend.draw(p,type,graphlist,position,size,w,h);

	p->setPen(Qt::NoPen);
}


void PlotPie::drawCurves(QPainter *p, int w, int h) {
	kdDebug()<<"PlotPie::drawCurves()"<<endl;
	int xmin = (int)(w*(size.X()*p1.X()+position.X()));
	int xmax = (int)(w*(size.X()*p2.X()+position.X()));
	int ymin = (int)(h*(size.Y()*p1.Y()+position.Y()));
	int ymax = (int)(h*(size.Y()*p2.Y()+position.Y()));

	// space for legend
	xmax -=(int)(120*size.X());

	kdDebug()<<"xmin/xmax ymin/ymax : "<<xmin<<'/'<<xmax<<' '<<ymin<<'/'<<ymax<<endl;
	kdDebug()<<"width/height : "<<w<<'/'<<h<<endl;
		
	// TODO : only one graph allowed
	if(graphlist->getGraph(0)->isShown() == false)
		return;

	int N=0;
	Style *style;
	Symbol *symbol;
	GRAPHType s = graphlist->getStruct(0);
	Point *d=0;
	if (s == GRAPH2D) {
		Graph2D *g = graphlist->getGraph2D(0);

		d = g->Data();
		N = g->Number();
		style =  g->getStyle();
		symbol = g->getSymbol();
		
		kdDebug()<<"GRAPH2D / 2D number = "<<N<<endl;
	}

	// TODO : use style
	p->setPen(Qt::black);

	double sum=0;
	for (int i=0;i<N;i++)
		sum += d[i].Y();

	double a=0;
	for (int i=0;i<N;i++) {
		if(d[i].Masked())
			continue;

		double  part = d[i].Y();
		if(sum>1.0)
			part /= sum;

		// angle
		double alpha = 5.0*a/80.0 + part*180.0;
		kdDebug()<<" alpha = "<<alpha<<endl;
		// TODO : rotation
		
		// scale font size with plot
		QFont f = worksheet->getMainWin()->defaultFont();
		f.setPointSize((int)(0.7*f.pointSize()));
	
		f.setPointSize((int)(f.pointSize()*size.X()));	// resize tic label
		p->setFont(f);

		p->drawText((int)(cos(alpha*M_PI/180.0)*(xmax-xmin+60)/2.0+(xmax-xmin)/2+xmin-20),
			(int)(- sin(alpha*M_PI/180.0)*(ymax-ymin+60)/2.0+(ymax-ymin)/2+ymin),
			QString::number(part*100)+QString(" % "));

		p->setBrush(colortable[i%15+1]);
		part *= 16*360;
		p->drawPie(xmin,ymin,xmax-xmin,ymax-ymin,(int)(a),(int)(part));

		// TODO : draw label

		a += part;
	}
	kdDebug()<<"PlotPie::drawCurves() OK"<<endl;
	
	//TODO : make legend from all points
}
