//LabPlot : PlotSettingsDialog.cc

#include <stdlib.h>
#include <stdio.h>
#include <iostream>
#include <qlabel.h>
#include <qhbox.h>
#include <qlayout.h>
#include <qcolordialog.h>
#include <qbuttongroup.h>
#include <klocale.h>
#include "PlotSettingsDialog.h"
#include "Plot2DSurface.h"
#include "PlotQWT3D.h"
#include "ColormapReader.h"

#include "qwt3d.h"

//! class for general plot settings
PlotSettingsDialog::PlotSettingsDialog(MainWin *mw, const char *name)
	: Dialog(mw, name)
{
	plot = p->getPlot(p->API());
	type = plot->Type();
	setCaption(i18n("Plot Settings")+i18n(" : ")+QString(name));

	QTabWidget *tw;
	QHBox *hb;
	tw = new QTabWidget(vbox);
	if(type != PQWT3D) {
		QVBox *tab1 = new QVBox(tw);
		hb = new QHBox(tab1);
		new QLabel(i18n("Plot Position : "),hb);
		posx = new KLineEdit(QString::number(plot->Position().X()),hb);
		posx->setValidator(new QDoubleValidator(0,1,3,posx));
		new QLabel(i18n(" , "),hb);
		posy = new KLineEdit(QString::number(plot->Position().Y()),hb);
		posy->setValidator(new QDoubleValidator(0,1,3,posy));
		hb = new QHBox(tab1);
		new QLabel(i18n("Plot Size : "),hb);
		sizex = new KLineEdit(QString::number(plot->Size().X()),hb);
		sizex->setValidator(new QDoubleValidator(0,1,3,sizex));
		new QLabel(i18n(" , "),hb);
		sizey = new KLineEdit(QString::number(plot->Size().Y()),hb);
		sizey->setValidator(new QDoubleValidator(0,1,3,sizey));
		tw->addTab(tab1,i18n("Main"));
		
		QVBox *tab2 = new QVBox(tw);
		hb = new QHBox(tab2);
		KPushButton *asx = new KPushButton(i18n("Autoscale x"),hb);
		QObject::connect(asx,SIGNAL(clicked()),SLOT(autoscalex()));
		KPushButton *asy = new KPushButton(i18n("Autoscale y"),hb);
		QObject::connect(asy,SIGNAL(clicked()),SLOT(autoscaley()));
		if (type == P3D) {
			KPushButton *asz = new KPushButton(i18n("Autoscale z"),hb);
			QObject::connect(asz,SIGNAL(clicked()),SLOT(autoscalez()));
		}
		LRange *r = plot->ActRanges();
		hb = new QHBox(tab2);
		new QLabel(i18n("x = "),hb);
		xmin = new KLineEdit(QString::number(r[0].rMin()),hb);
		xmin->setValidator(new QDoubleValidator(xmin));
		new QLabel(i18n(" .. "),hb);
		xmax = new KLineEdit(QString::number(r[0].rMax()),hb);
		xmax->setValidator(new QDoubleValidator(xmax));
		hb = new QHBox(tab2);
		new QLabel(i18n("y = "),hb);
		ymin = new KLineEdit(QString::number(r[1].rMin()),hb);
		ymin->setValidator(new QDoubleValidator(ymin));
		new QLabel(i18n(" .. "),hb);
		ymax = new KLineEdit(QString::number(r[1].rMax()),hb);
		ymax->setValidator(new QDoubleValidator(ymax));

		if (type == P3D) {
			hb = new QHBox(tab2);
			new QLabel(i18n("z = "),hb);
			zmin = new KLineEdit(QString::number(r[2].rMin()),hb);
			zmin->setValidator(new QDoubleValidator(zmin));
			new QLabel(i18n(" .. "),hb);
			zmax = new KLineEdit(QString::number(r[2].rMax()),hb);
			zmax->setValidator(new QDoubleValidator(zmax));
		}

		hb = new QHBox(tab2);
		new QLabel(i18n("clipping offset : "),hb);
		cliple = new KLineEdit(QString::number(plot->ClipOffset()),hb);
		cliple->setValidator(new QIntValidator(cliple));
		tw->addTab(tab2,i18n("Ranges"));
	}
	
	QVBox *tab3 = new QVBox(tw);
	hb = new QHBox(tab3);
	transparentcb = new QCheckBox(i18n("transparent plot"),hb);
	transparentcb->setChecked(plot->Transparent());

	hb = new QHBox(tab3);
	new QLabel(i18n("Background Color : "),hb);
	bgcolor = new KColorButton(plot->Background(),hb);

	hb = new QHBox(tab3);
	new QLabel(i18n("Graph Background Color : "),hb);
	gbgcolor = new KColorButton(plot->graphBackground(),hb);
	tw->addTab(tab3,i18n("Background"));

	if(type != PQWT3D) {
		QVBox *tab4 = new QVBox(tw);
		hb = new QHBox(tab4);
		xbaselinecb = new QCheckBox(i18n("draw X Baseline "),hb);
		xbaselinecb->setChecked(plot->xbaselineEnabled());
		new QLabel(i18n("Baseline @ x = "),hb);
		xbaselinele = new KLineEdit(QString::number(plot->XBaseline()),hb);
		xbaselinele->setValidator(new QDoubleValidator(xbaselinele));

		hb = new QHBox(tab4);
		baselinecb = new QCheckBox(i18n("draw Y Baseline "),hb);
		baselinecb->setChecked(plot->baselineEnabled());
		new QLabel(i18n("Baseline @ y = "),hb);
		baselinele = new KLineEdit(QString::number(plot->Baseline()),hb);
		baselinele->setValidator(new QDoubleValidator(baselinele));

		hb = new QHBox(tab4);
		regioncb = new QCheckBox(i18n("draw Region "),hb);
		regioncb->setChecked(plot->regionEnabled());
		new QLabel(i18n("x = "),hb);
		regionminle = new KLineEdit(QString::number(plot->RegionMin()),hb);
		regionminle->setValidator(new QDoubleValidator(regionminle));
		new QLabel(i18n(" .. "),hb);
		regionmaxle = new KLineEdit(QString::number(plot->RegionMax()),hb);
		regionmaxle->setValidator(new QDoubleValidator(regionmaxle));
		tw->addTab(tab4,i18n("Baseline/Region"));
	
		QVBox *tab5 = new QVBox(tw);
		hb = new QHBox(tab5);
		markercb = new QCheckBox(i18n("show Marker "),hb);
		markercb->setChecked(plot->marksEnabled());
		hb = new QHBox(tab5);
		new QLabel(i18n("x1 = "),hb);
		markminxle = new KLineEdit(QString::number(plot->markX()->rMin()),hb);
		markminxle->setValidator(new QDoubleValidator(markminxle));
		new QLabel(i18n(" x2 = "),hb);
		markmaxxle = new KLineEdit(QString::number(plot->markX()->rMax()),hb);
		markmaxxle->setValidator(new QDoubleValidator(markmaxxle));
		hb = new QHBox(tab5);
		new QLabel(i18n("y1 = "),hb);
		markminyle = new KLineEdit(QString::number(plot->markY()->rMin()),hb);
		markminyle->setValidator(new QDoubleValidator(markminyle));
		new QLabel(i18n(" y2 = "),hb);
		markmaxyle = new KLineEdit(QString::number(plot->markY()->rMax()),hb);
		markmaxyle->setValidator(new QDoubleValidator(markmaxyle));
		tw->addTab(tab5,i18n("Marker"));
	}
#ifdef HAVE_GL
	else {
		int i=0;
		
		QVBox *tab4 = new QVBox(tw);

		hb = new QHBox(tab4);
		disablemousecb = new QCheckBox(i18n("disable mouse"),hb);
		disablemousecb->setChecked(((PlotQWT3D *)plot)->mouseDisabled());
		new QLabel(i18n(" resolution = "),hb);
		resolutionle = new KLineEdit(QString::number(((PlotQWT3D *)plot)->Resolution()),hb);
		resolutionle->setValidator(new QIntValidator(1,1000,resolutionle));
		
		hb = new QHBox(tab4);
		new QLabel(i18n("Aspect ration "),hb);
		aspectcb = new KComboBox(hb);
		while(aspectRatio[i] != 0) aspectcb->insertItem(i18n(aspectRatio[i++]));
		aspectcb->setCurrentItem(((PlotQWT3D *) plot)->aspectRatio());

		hb = new QHBox(tab4);
		new QLabel(i18n("Plot Style : "),hb);
		plotstyle = new KComboBox(hb);
		i=0;
		while(plotStyle[i] != 0) plotstyle->insertItem(i18n(plotStyle[i++]));
		plotstyle->setCurrentItem(((PlotQWT3D *) plot)->PlotStyle());
		
		hb = new QHBox(tab4);
		new QLabel(i18n("Coordinate Style : "),hb);
		coordinatestyle = new KComboBox(hb);
		i=0;
		while(coordinateStyle[i] != 0) coordinatestyle->insertItem(i18n(coordinateStyle[i++]));
		coordinatestyle->setCurrentItem(((PlotQWT3D *) plot)->CoordinateStyle());
		
		hb = new QHBox(tab4);
		new QLabel(i18n("Floor Style : "),hb);
		floorstyle = new KComboBox(hb);
		i=0;
		while(floorStyle[i] != 0) floorstyle->insertItem(i18n(floorStyle[i++]));
		floorstyle->setCurrentItem(((PlotQWT3D *) plot)->FloorStyle());
		
		hb = new QHBox(tab4);
		new QLabel(i18n("isolines = "),hb);
		isolines = new KLineEdit(QString::number(((PlotQWT3D *) plot)->isolines()),hb);
		isolines->setValidator(new QIntValidator(isolines));
		
		hb = new QHBox(tab4);
		KPushButton *colormap = new KPushButton(i18n("Colormap"),hb);
		QObject::connect(colormap,SIGNAL(clicked()),SLOT(selectColormap()));
		tw->addTab(tab4,i18n("Style"));
	}
#endif
	
	if (type == PSURFACE) {
		QVBox *styletab = surfaceStyle(tw,true);
		tw->addTab(styletab,i18n("Style"));
	}

	QObject::connect(ok,SIGNAL(clicked()),SLOT(ok_clicked()));
	QObject::connect(apply,SIGNAL(clicked()),SLOT(apply_clicked()));

	setMinimumWidth((int)(1.8*tw->minimumSizeHint().width()));
	setMinimumHeight(gbox->minimumSizeHint().height()+vbox->minimumSizeHint().height());
	resize(minimumSize());
}

void PlotSettingsDialog::selectColormap() {
	ColorMapPreview *colormap = new ColorMapPreview;
	QFileDialog *datacolor = new QFileDialog(this);

	QString cmdir = locate("data","LabPlot/colormaps/");
	datacolor->setDir(cmdir);
	datacolor->setFilter("Colormap files (*.map;*.MAP)");
	datacolor->setContentsPreviewEnabled( true );
	datacolor->setContentsPreview( colormap, colormap);
	datacolor->setPreviewMode( QFileDialog::Contents );

	connect(datacolor, SIGNAL(fileHighlighted(const QString&)), this, SLOT(adaptDataColors(const QString&)));
	datacolor->show();
}

void PlotSettingsDialog::adaptDataColors(const QString& fn) {
#ifdef HAVE_GL
	if (!openColorMap(fn))
		return;

	Qwt3D::StandardColor *col = new Qwt3D::StandardColor((PlotQWT3D *)plot);
	col->setColorVector(cv);

	((PlotQWT3D *) plot)->setColorVector(cv);
#endif
}

bool PlotSettingsDialog::openColorMap(QString fn) {
#ifdef HAVE_GL
	kdDebug()<<"openColorMap("<<fn<<")"<<endl;
	ifstream file((const char*)fn.local8Bit());

	if (!file) return false;

	Qwt3D::RGBA rgb;
	cv.clear();

	while ( file ) {
		file >> rgb.r >> rgb.g >> rgb.b;
		file.ignore(1000,'\n');
		if (!file.good())
			break;
		else {
			rgb.a = 1;
			rgb.r /= 255;
			rgb.g /= 255;
			rgb.b /= 255;
			cv.push_back(rgb);
		}
	}

	return true;
#endif
}

void PlotSettingsDialog::apply_clicked() {
	plot->setBackground(bgcolor->color());
	plot->setGraphBackground(gbgcolor->color());
	plot->setTransparent(transparentcb->isChecked());
	
	if(type != PQWT3D) {
		plot->setPosition(posx->text().toDouble(),posy->text().toDouble());
		plot->setSize(sizex->text().toDouble(),sizey->text().toDouble());
	
		plot->setClipOffset(cliple->text().toInt());
		plot->setXRange(xmin->text().toDouble(),xmax->text().toDouble());
		plot->setYRange(ymin->text().toDouble(),ymax->text().toDouble());
		if (type == P3D)
			plot->setZRange(zmin->text().toDouble(),zmax->text().toDouble());
	
		if (type == PSURFACE) {
			((Plot2DSurface* )plot)->enableDensity(dcb->isChecked());
			((Plot2DSurface* )plot)->enableContour(ccb->isChecked());
			((Plot2DSurface* )plot)->setNumber(numberle->text().toInt());
			((Plot2DSurface* )plot)->setPalette(pcb->currentItem());
			((Plot2DSurface* )plot)->setContourColor(contourcolor->color());
			((Plot2DSurface* )plot)->setColoredContour(coloredcb->isChecked());
			((Plot2DSurface* )plot)->setMesh(meshcb->isChecked());
			((Plot2DSurface* )plot)->setRelative(relativecb->isChecked());
			((Plot2DSurface* )plot)->setBrush(dbrushcb->currentItem());
			((Plot2DSurface* )plot)->setThreshold(thresholdle->text().toDouble());
		}
	
	kdDebug()<<"OK"<<endl;
		plot->setBaseline(baselinele->text().toDouble());
		plot->setBaselineEnabled(baselinecb->isChecked());
		plot->setXBaseline(xbaselinele->text().toDouble());
		plot->setXBaselineEnabled(xbaselinecb->isChecked());
		
		plot->setRegionMin(regionminle->text().toDouble());
		plot->setRegionMax(regionmaxle->text().toDouble());
		plot->setRegionEnabled(regioncb->isChecked());
		
		plot->setMarksEnabled(markercb->isChecked());
		LRange *xrange = new LRange(markminxle->text().toDouble(),markmaxxle->text().toDouble());
		LRange *yrange = new LRange(markminyle->text().toDouble(),markmaxyle->text().toDouble());
		plot->setMarkX(xrange);
		plot->setMarkY(yrange);
	kdDebug()<<"OK"<<endl;
	}
#ifdef HAVE_GL
	else {	// PQWT3D
		((PlotQWT3D *) plot)->setPlotStyle((Qwt3D::PLOTSTYLE) plotstyle->currentItem());
		((PlotQWT3D *) plot)->setCoordinateStyle((Qwt3D::COORDSTYLE) coordinatestyle->currentItem());
		((PlotQWT3D *) plot)->setFloorStyle((Qwt3D::FLOORSTYLE) floorstyle->currentItem());
		((PlotQWT3D *) plot)->setIsolines(isolines->text().toInt());
		((PlotQWT3D *) plot)->setAspectRatio(aspectcb->currentItem());
		((PlotQWT3D *) plot)->disableMouse(disablemousecb->isChecked());
		((PlotQWT3D *) plot)->setDataResolution(resolutionle->text().toInt());
	}
#endif
	
	p->updatePixmap();
}

void PlotSettingsDialog::autoscalex() { 
	plot->autoScaleX();
	LRange *r = plot->Ranges();
	xmin->setText(QString::number(r[0].rMin()));
	xmax->setText(QString::number(r[0].rMax()));
	p->updatePixmap();
}
void PlotSettingsDialog::autoscaley() { 
	plot->autoScaleY();
	LRange *r = plot->Ranges();
	ymin->setText(QString::number(r[1].rMin()));
	ymax->setText(QString::number(r[1].rMax()));
	p->updatePixmap();
}
void PlotSettingsDialog::autoscalez() { 
	plot->autoScaleZ();
	LRange *r = plot->Ranges();
	zmin->setText(QString::number(r[2].rMin()));
	zmax->setText(QString::number(r[2].rMax()));
	p->updatePixmap();
}
