//LabPlot : PlotSettingsDialog.h

#ifndef PLOTSETTINGSDIALOG_H
#define PLOTSETTINGSDIALOG_H

#include <qtoolbutton.h>
#include <qcolor.h>
#include <qcheckbox.h>
#include "Worksheet.h"
#include "Dialog.h"

#ifdef HAVE_GL
#include "qwt3d_surfaceplot.h"
#endif

class PlotSettingsDialog: public Dialog
{
	Q_OBJECT
public:
	PlotSettingsDialog(MainWin *mw, const char *name);
public slots:
	void selectColormap();
	void adaptDataColors(const QString&);
	void ok_clicked() {apply_clicked(); accept(); }
	void apply_clicked();
	void autoscalex();
	void autoscaley();
	void autoscalez();
private:
	bool openColorMap(QString fn);
	Plot *plot;
	int type;
	KLineEdit *posx, *posy, *sizex, *sizey;
	KLineEdit *borderwidth, *baselinele, *xbaselinele;
	KColorButton *bgcolor, *gbgcolor;
	KLineEdit *xmin, *xmax, *ymin, *ymax, *zmin, *zmax, *cliple;
	QCheckBox *baselinecb, *xbaselinecb, *regioncb, *transparentcb;
	KLineEdit *regionminle, *regionmaxle;
	QCheckBox *markercb;
	KLineEdit *markminxle, *markmaxxle, *markminyle, *markmaxyle;
	KComboBox *aspectcb;
	KComboBox *plotstyle, *coordinatestyle, *floorstyle;
	KLineEdit *isolines, *resolutionle;
	QCheckBox *disablemousecb;
#ifdef HAVE_GL
	Qwt3D::ColorVector cv;
#endif
};

#endif //PLOTSETTINGSDIALOG_H
